/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.api;

import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.tools.JavaFileObject;
import javax.tools.SimpleJavaFileObject;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class JavaIoFile
extends SimpleJavaFileObject {
    private final File myFile;
    @Nullable
    private final String myEncoding;

    JavaIoFile(@NotNull File file, @NotNull JavaFileObject.Kind kind, @Nullable String encoding) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/api/JavaIoFile", "<init>"));
        }
        if (kind == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/compiler/impl/javaCompiler/api/JavaIoFile", "<init>"));
        }
        super(JavaIoFile.convertToURI(file.getPath()), kind);
        this.myFile = file;
        this.myEncoding = encoding;
    }

    @NotNull
    private static URI convertToURI(@NotNull String path) {
        URI uRI;
        block6: {
            if (path == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/api/JavaIoFile", "convertToURI"));
            }
            if (File.separatorChar != '/') {
                path = path.replace(File.separatorChar, '/');
            }
            if (!StringUtil.startsWithChar((CharSequence)path, (char)'/')) {
                path = "/" + path;
            }
            if (path.startsWith("//")) {
                path = "//" + path;
            }
            try {
                uRI = new URI("file", null, path, null);
                if (uRI != null) break block6;
            }
            catch (URISyntaxException e) {
                throw new RuntimeException(e);
            }
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/api/JavaIoFile", "convertToURI"));
        }
        return uRI;
    }

    @Override
    public CharSequence getCharContent(boolean ignoreEncodingErrors) throws IOException {
        return FileUtil.loadFile((File)this.myFile, (String)this.myEncoding);
    }

    @Override
    public InputStream openInputStream() throws IOException {
        return new BufferedInputStream(new FileInputStream(this.myFile));
    }

    @Override
    public OutputStream openOutputStream() throws IOException {
        return new BufferedOutputStream(new FileOutputStream(this.myFile));
    }

    @Override
    public String toString() {
        return this.toUri().toString();
    }

    public int hashCode() {
        return this.toUri().hashCode();
    }

    public boolean equals(Object obj) {
        return obj instanceof JavaFileObject && this.toUri().equals(((JavaFileObject)obj).toUri());
    }
}

