/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.api;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileStatusNotification;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.project.Project;
import com.intellij.util.containers.ContainerUtil;
import java.util.List;
import java.util.concurrent.TimeUnit;

public class CompilerPerfTestAction
extends AnAction {
    public void update(AnActionEvent e) {
        Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        e.getPresentation().setEnabled(project != null);
    }

    public void actionPerformed(AnActionEvent e) {
        final Project project = (Project)e.getData(CommonDataKeys.PROJECT);
        final CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
        final CompilerConfigurationImpl configuration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project);
        List compilers = (List)configuration.getRegisteredJavaCompilers();
        final List allCompilers = ContainerUtil.concat((List[])new List[]{compilers, compilers, compilers, compilers, compilers, compilers, compilers});
        final int[] i = new int[1];
        CompileStatusNotification callback = new CompileStatusNotification(){
            volatile long start;
            BackendCompiler compiler;

            public void finished(boolean aborted, int errors, int warnings, CompileContext compileContext) {
                if (this.compiler == null) {
                    this.next();
                    return;
                }
                long finish = System.currentTimeMillis();
                System.out.println("Compiled with '" + this.compiler.getPresentableName() + "' " + " in " + TimeUnit.MILLISECONDS.toMinutes(finish - this.start) + "m" + TimeUnit.MILLISECONDS.toSeconds((finish - this.start) % 60000L) + "s" + " with " + errors + " errors, " + warnings + " warnings, aborted=" + aborted + "; free memory=" + Runtime.getRuntime().freeMemory() + " bytes");
                this.next();
            }

            void next() {
                if (i[0] >= allCompilers.size()) {
                    return;
                }
                int n = i[0];
                i[0] = n + 1;
                this.compiler = (BackendCompiler)allCompilers.get(n);
                if (this.compiler.getId().equals("Jikes") || this.compiler.getId().contains("Eclipse")) {
                    this.next();
                    return;
                }
                boolean success = this.compiler.checkCompiler(compilerManager.createProjectCompileScope(project));
                if (!success) {
                    this.next();
                    return;
                }
                configuration.setDefaultCompiler(this.compiler);
                this.start = System.currentTimeMillis();
                compilerManager.rebuild((CompileStatusNotification)this);
            }
        };
        callback.finished(false, 0, 0, null);
    }
}

