/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.api;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.ModuleChunk;
import com.intellij.compiler.impl.javaCompiler.api.CompAPIDriver;
import com.intellij.compiler.impl.javaCompiler.api.CompilerAPIConfiguration;
import com.intellij.compiler.impl.javaCompiler.javac.JavacCompiler;
import com.intellij.compiler.impl.javaCompiler.javac.JavacConfigurable;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileType;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.JavaSdkVersion;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompilerAPICompiler
implements BackendCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.api.CompilerAPICompiler");
    private final Project myProject;
    private static final Set<FileType> COMPILABLE_TYPES = Collections.singleton(StdFileTypes.JAVA);

    public CompilerAPICompiler(Project project) {
        this.myProject = project;
    }

    @Override
    public boolean checkCompiler(CompileScope scope) {
        return true;
    }

    @Override
    @NotNull
    @NonNls
    public String getId() {
        if ("compAPI" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/api/CompilerAPICompiler", "getId"));
        }
        return "compAPI";
    }

    @Override
    @NotNull
    public String getPresentableName() {
        if ("Javac in-process (Java6+ only)" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/api/CompilerAPICompiler", "getPresentableName"));
        }
        return "Javac in-process (Java6+ only)";
    }

    @Override
    @NotNull
    public Configurable createConfigurable() {
        JavacConfigurable javacConfigurable = new JavacConfigurable(CompilerAPIConfiguration.getOptions(this.myProject, CompilerAPIConfiguration.class));
        if (javacConfigurable == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/api/CompilerAPICompiler", "createConfigurable"));
        }
        return javacConfigurable;
    }

    @Override
    @NotNull
    public Set<FileType> getCompilableFileTypes() {
        Set<FileType> set = COMPILABLE_TYPES;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/api/CompilerAPICompiler", "getCompilableFileTypes"));
        }
        return set;
    }

    @Override
    @Nullable
    public OutputParser createErrorParser(@NotNull String outputDir, final Process process) {
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/api/CompilerAPICompiler", "createErrorParser"));
        }
        return new OutputParser(){

            @Override
            public boolean processMessageLine(OutputParser.Callback callback) {
                ((MyProcess)process).myCompAPIDriver.processAll(callback);
                return false;
            }
        };
    }

    @Override
    @Nullable
    public OutputParser createOutputParser(@NotNull String outputDir) {
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/api/CompilerAPICompiler", "createOutputParser"));
        }
        return null;
    }

    @Override
    public void compileFinished() {
    }

    @Override
    @NotNull
    public Process launchProcess(final @NotNull ModuleChunk chunk, final @NotNull String outputDir, final @NotNull CompileContext compileContext) throws IOException {
        if (chunk == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/api/CompilerAPICompiler", "launchProcess"));
        }
        if (outputDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/compiler/impl/javaCompiler/api/CompilerAPICompiler", "launchProcess"));
        }
        if (compileContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/compiler/impl/javaCompiler/api/CompilerAPICompiler", "launchProcess"));
        }
        final IOException[] ex = new IOException[]{null};
        List commandLine = (List)ApplicationManager.getApplication().runReadAction((Computable)new Computable<List<String>>(){

            public List<String> compute() {
                try {
                    ArrayList<String> commandLine = new ArrayList<String>();
                    List<String> additionalOptions = JavacCompiler.addAdditionalSettings(commandLine, CompilerAPIConfiguration.getOptions(CompilerAPICompiler.this.myProject, CompilerAPIConfiguration.class), false, JavaSdkVersion.JDK_1_6, chunk, compileContext.isAnnotationProcessorsEnabled());
                    JavacCompiler.addCommandLineOptions(chunk, commandLine, outputDir, chunk.getJdk(), false, false, null, false, false, false);
                    commandLine.addAll(additionalOptions);
                    return commandLine;
                }
                catch (IOException e) {
                    ex[0] = e;
                    return null;
                }
            }
        });
        if (ex[0] != null) {
            throw ex[0];
        }
        MyProcess myProcess = new MyProcess(commandLine, chunk, outputDir, compileContext);
        if (myProcess == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/api/CompilerAPICompiler", "launchProcess"));
        }
        return myProcess;
    }

    private static void compile(List<String> commandLine, ModuleChunk chunk, String outputDir, CompAPIDriver myCompAPIDriver) {
        List<VirtualFile> filesToCompile = chunk.getFilesToCompile();
        ArrayList<File> paths = new ArrayList<File>(filesToCompile.size());
        for (VirtualFile file : filesToCompile) {
            paths.add(new File(file.getPresentableUrl()));
        }
        myCompAPIDriver.compile(commandLine, paths, outputDir);
    }

    private static class MyProcess
    extends Process {
        private final List<String> myCommandLine;
        private final ModuleChunk myChunk;
        private final String myOutputDir;
        private final CompileContext myCompileContext;
        private final CompAPIDriver myCompAPIDriver;
        private int myExitCode;

        private MyProcess(List<String> commandLine, ModuleChunk chunk, String outputDir, CompileContext compileContext) {
            this.myCommandLine = commandLine;
            this.myChunk = chunk;
            this.myOutputDir = outputDir;
            this.myCompileContext = compileContext;
            this.myCompAPIDriver = new CompAPIDriver(MyProcess.findEncodingValue(commandLine));
        }

        private static String findEncodingValue(List<String> commandLine) {
            boolean found = false;
            for (String param : commandLine) {
                if (found) {
                    return param;
                }
                if (!"-encoding".equalsIgnoreCase(param)) continue;
                found = true;
            }
            return null;
        }

        @Override
        public OutputStream getOutputStream() {
            throw new UnsupportedOperationException();
        }

        @Override
        public InputStream getInputStream() {
            return null;
        }

        @Override
        public InputStream getErrorStream() {
            return null;
        }

        @Override
        public void destroy() {
            this.myCompAPIDriver.finish();
        }

        @Override
        public int waitFor() {
            try {
                this.myCommandLine.remove("-verbose");
                CompilerAPICompiler.compile(this.myCommandLine, this.myChunk, this.myOutputDir, this.myCompAPIDriver);
                this.myExitCode = 0;
                return this.myExitCode;
            }
            catch (Exception e) {
                this.myCompileContext.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
                LOG.info((Throwable)e);
                this.myExitCode = -1;
                return -1;
            }
        }

        @Override
        public int exitValue() {
            return this.myExitCode;
        }

        public String toString() {
            return this.myChunk.toString();
        }
    }
}

