/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.api;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.javaCompiler.FileObject;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VfsUtil;
import java.io.File;
import java.net.URI;
import javax.tools.Diagnostic;
import javax.tools.JavaFileObject;
import org.jetbrains.annotations.NonNls;

abstract class CompilationEvent {
    private static final CompilationEvent FILE_PROCESSED = new CompilationEvent(){

        @Override
        protected void process(OutputParser.Callback callback) {
            callback.fileProcessed(null);
        }

        @NonNls
        public String toString() {
            return "Processed";
        }
    };

    CompilationEvent() {
    }

    protected abstract void process(OutputParser.Callback var1);

    static CompilationEvent progress(final String title, final JavaFileObject fileObject) {
        return new CompilationEvent(){

            @Override
            protected void process(OutputParser.Callback callback) {
                CompilationEvent.showProgressFor(title, fileObject.toUri(), callback);
            }

            @NonNls
            public String toString() {
                return "Progress: " + title + " " + fileObject.toUri();
            }
        };
    }

    private static void showProgressFor(String title, URI uri, OutputParser.Callback callback) {
        String normalizedPath;
        try {
            normalizedPath = new File(uri).getPath();
        }
        catch (IllegalArgumentException e) {
            normalizedPath = uri.toString();
        }
        callback.setProgressText(title + StringUtil.last((CharSequence)normalizedPath, (int)100, (boolean)true));
    }

    static CompilationEvent generateClass(final URI uri, final byte[] bytes) {
        return new CompilationEvent(){

            @Override
            protected void process(OutputParser.Callback callback) {
                CompilationEvent.showProgressFor("Writing ", uri, callback);
                File file = new File(uri);
                callback.fileGenerated(new FileObject(file, bytes));
            }

            @NonNls
            public String toString() {
                return "Write: " + uri;
            }
        };
    }

    static CompilationEvent diagnostic(final Diagnostic<? extends JavaFileObject> diagnostic) {
        return new CompilationEvent(){

            @Override
            protected void process(OutputParser.Callback callback) {
                URI uri;
                JavaFileObject fileObject = (JavaFileObject)diagnostic.getSource();
                String message = diagnostic.getMessage(null);
                String url = fileObject == null ? null : ((uri = fileObject.toUri()).getScheme().equals("file") ? VfsUtil.pathToUrl((String)FileUtil.toSystemIndependentName((String)uri.getPath())) : fileObject.toString());
                CompilerMessageCategory category = diagnostic.getKind() == Diagnostic.Kind.ERROR ? CompilerMessageCategory.ERROR : (diagnostic.getKind() == Diagnostic.Kind.WARNING || diagnostic.getKind() == Diagnostic.Kind.MANDATORY_WARNING ? CompilerMessageCategory.WARNING : CompilerMessageCategory.INFORMATION);
                callback.message(category, message, url, (int)diagnostic.getLineNumber(), (int)diagnostic.getColumnNumber());
            }

            @NonNls
            public String toString() {
                return "Diagnostic: " + diagnostic;
            }
        };
    }

    public static CompilationEvent fileProcessed() {
        return FILE_PROCESSED;
    }
}

