/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler.api;

import com.intellij.compiler.OutputParser;
import com.intellij.compiler.impl.javaCompiler.api.CompilationEvent;
import com.intellij.compiler.impl.javaCompiler.api.MyFileManager;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.sun.source.util.JavacTask;
import com.sun.source.util.TaskEvent;
import com.sun.source.util.TaskListener;
import com.sun.tools.javac.api.JavacTool;
import com.sun.tools.javac.util.List;
import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.io.Writer;
import java.lang.reflect.Field;
import java.net.URI;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import javax.tools.Diagnostic;
import javax.tools.DiagnosticListener;
import javax.tools.JavaCompiler;
import javax.tools.JavaFileManager;
import javax.tools.JavaFileObject;
import javax.tools.StandardJavaFileManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CompAPIDriver {
    private final BlockingQueue<CompilationEvent> myCompilationResults = new LinkedBlockingQueue<CompilationEvent>();
    private static final CompilationEvent GUARD = new CompilationEvent(){

        @Override
        protected void process(OutputParser.Callback callback) {
        }

        public String toString() {
            return "FINISH";
        }
    };
    private String myOutputDir;
    private volatile boolean compiling;
    private static final PrintWriter COMPILER_ERRORS = new PrintWriter(System.err);
    @Nullable
    private final String mySourcesEncoding;
    private volatile boolean processing;

    CompAPIDriver(@Nullable String sourcesEncoding) {
        this.mySourcesEncoding = sourcesEncoding;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void compile(java.util.List<String> commandLine, java.util.List<File> paths, String outputDir) {
        this.myOutputDir = outputDir;
        this.compiling = true;
        assert (this.myCompilationResults.isEmpty());
        JavacTool compiler = JavacTool.create();
        StandardJavaFileManager standardFileManager = compiler.getStandardFileManager(null, null, null);
        MyFileManager manager = new MyFileManager(this, outputDir, standardFileManager, this.mySourcesEncoding);
        Iterable<? extends JavaFileObject> input = manager.getJavaFileObjectsFromFiles(paths);
        DiagnosticListener<JavaFileObject> listener = new DiagnosticListener<JavaFileObject>(){

            @Override
            public void report(Diagnostic<? extends JavaFileObject> diagnostic) {
                CompilationEvent event = CompilationEvent.diagnostic(diagnostic);
                CompAPIDriver.this.myCompilationResults.offer(event);
            }
        };
        try {
            JavaCompiler.CompilationTask task = compiler.getTask((Writer)COMPILER_ERRORS, (JavaFileManager)manager, (DiagnosticListener<? super JavaFileObject>)listener, commandLine, null, input);
            ((JavacTask)task).setTaskListener(new TaskListener(){

                @Override
                public void started(TaskEvent taskEvent) {
                    CompilationEvent event;
                    JavaFileObject sourceFile = taskEvent.getSourceFile();
                    switch (taskEvent.getKind()) {
                        case ANALYZE: {
                            event = CompilationEvent.progress("Analyzing ", sourceFile);
                            break;
                        }
                        case PARSE: {
                            event = CompilationEvent.progress("Parsing ", sourceFile);
                            break;
                        }
                        default: {
                            event = null;
                        }
                    }
                    if (event != null) {
                        CompAPIDriver.this.myCompilationResults.offer(event);
                    }
                }

                @Override
                public void finished(TaskEvent taskEvent) {
                    CompilationEvent event;
                    switch (taskEvent.getKind()) {
                        case ENTER: {
                            event = CompilationEvent.fileProcessed();
                            break;
                        }
                        default: {
                            event = null;
                        }
                    }
                    if (event != null) {
                        CompAPIDriver.this.myCompilationResults.offer(event);
                    }
                }
            });
            task.call();
        }
        catch (IllegalArgumentException e) {
            final String message = "Javac in-process compiler error: " + e.getMessage();
            this.myCompilationResults.offer(new CompilationEvent(){

                @Override
                protected void process(OutputParser.Callback callback) {
                    callback.message(CompilerMessageCategory.ERROR, message, null, -1, -1);
                }
            });
        }
        finally {
            this.compiling = false;
            this.myCompilationResults.offer(GUARD);
            try {
                manager.close();
            }
            catch (IOException ignored) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processAll(@NotNull OutputParser.Callback callback) {
        if (callback == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/javaCompiler/api/CompAPIDriver", "processAll"));
        }
        try {
            CompilationEvent event;
            this.processing = true;
            while ((event = this.myCompilationResults.take()) != GUARD) {
                event.process(callback);
            }
        }
        catch (InterruptedException interruptedException) {
        }
        finally {
            this.processing = false;
        }
    }

    public void finish() {
        assert (!this.compiling) : "still compiling to " + this.myOutputDir;
        assert (!this.processing);
        this.myCompilationResults.clear();
        CompAPIDriver.cleanupInternalFields();
    }

    private static void cleanupInternalFields() {
        try {
            Field freelist = Class.forName("com.sun.tools.javac.util.SharedNameTable").getDeclaredField("freelist");
            freelist.setAccessible(true);
            freelist.set(null, List.nil());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void offerClassFile(URI uri, byte[] bytes) {
        CompilationEvent event = CompilationEvent.generateClass(uri, bytes);
        this.myCompilationResults.offer(event);
    }
}

