/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.module.EffectiveLanguageLevelUtil;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.projectRoots.Sdk;
import com.intellij.openapi.roots.JdkOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.roots.OrderEnumerator;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.util.Chunk;
import com.intellij.util.PathsList;
import com.intellij.util.StringBuilderSpinAllocator;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.OrderedSet;
import gnu.trove.THashMap;
import java.io.File;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class ModuleChunk
extends Chunk<Module> {
    private final CompileContextEx myContext;
    private final Map<Module, List<VirtualFile>> myModuleToFilesMap = new THashMap();
    private final Map<VirtualFile, VirtualFile> myTransformedToOriginalMap = new THashMap();
    private int mySourcesFilter = 3;
    public static final int SOURCES = 1;
    public static final int TEST_SOURCES = 2;
    public static final int ALL_SOURCES = 3;

    public ModuleChunk(CompileContextEx context, Chunk<Module> chunk, Map<Module, List<VirtualFile>> moduleToFilesMap) {
        super(chunk.getNodes());
        this.myContext = context;
        Iterator i$ = chunk.getNodes().iterator();
        while (i$.hasNext()) {
            Module module;
            List<VirtualFile> files = moduleToFilesMap.get(module = (Module)i$.next());
            this.myModuleToFilesMap.put(module, (List<VirtualFile>)(files == null ? Collections.emptyList() : new ArrayList<VirtualFile>(files)));
        }
    }

    public void setSourcesFilter(int filter) {
        this.mySourcesFilter = filter;
    }

    public int getSourcesFilter() {
        return this.mySourcesFilter;
    }

    public void substituteWithTransformedVersion(Module module, int fileIndex, VirtualFile transformedFile) {
        List<VirtualFile> moduleFiles = this.getFilesToCompile(module);
        VirtualFile currentFile = moduleFiles.get(fileIndex);
        moduleFiles.set(fileIndex, transformedFile);
        VirtualFile originalFile = this.myTransformedToOriginalMap.remove(currentFile);
        if (originalFile == null) {
            originalFile = currentFile;
        }
        this.myTransformedToOriginalMap.put(transformedFile, originalFile);
    }

    public VirtualFile getOriginalFile(VirtualFile file) {
        VirtualFile original = this.myTransformedToOriginalMap.get(file);
        return original != null ? original : file;
    }

    @NotNull
    public List<VirtualFile> getFilesToCompile(Module forModule) {
        List<VirtualFile> list = this.myModuleToFilesMap.get(forModule);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/ModuleChunk", "getFilesToCompile"));
        }
        return list;
    }

    @NotNull
    public List<VirtualFile> getFilesToCompile() {
        if (this.getModuleCount() == 0) {
            List<VirtualFile> list = Collections.emptyList();
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/ModuleChunk", "getFilesToCompile"));
            }
            return list;
        }
        Set modules = this.getNodes();
        ArrayList<VirtualFile> filesToCompile = new ArrayList<VirtualFile>();
        for (Module module : modules) {
            List<VirtualFile> moduleCompilableFiles = this.getFilesToCompile(module);
            if (this.mySourcesFilter == 3) {
                filesToCompile.addAll(moduleCompilableFiles);
                continue;
            }
            for (VirtualFile file : moduleCompilableFiles) {
                VirtualFile originalFile = this.myTransformedToOriginalMap.get(file);
                if (originalFile == null) {
                    originalFile = file;
                }
                if (this.mySourcesFilter == 2) {
                    if (!this.myContext.isInTestSourceContent(originalFile)) continue;
                    filesToCompile.add(file);
                    continue;
                }
                if (this.myContext.isInTestSourceContent(originalFile)) continue;
                filesToCompile.add(file);
            }
        }
        ArrayList<VirtualFile> arrayList = filesToCompile;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/ModuleChunk", "getFilesToCompile"));
        }
        return arrayList;
    }

    public Sdk getJdk() {
        Module module = (Module)this.getNodes().iterator().next();
        return ModuleRootManager.getInstance((Module)module).getSdk();
    }

    public VirtualFile[] getSourceRoots() {
        return this.getSourceRoots(this.mySourcesFilter);
    }

    private VirtualFile[] getSourceRoots(final int sourcesFilter) {
        return (VirtualFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile[]>(){

            public VirtualFile[] compute() {
                return ModuleChunk.this.filterRoots(ModuleChunk.this.getAllSourceRoots(), ((Module)ModuleChunk.this.getNodes().iterator().next()).getProject(), sourcesFilter);
            }
        });
    }

    public VirtualFile[] getSourceRoots(final Module module) {
        if (!this.getNodes().contains(module)) {
            return VirtualFile.EMPTY_ARRAY;
        }
        return (VirtualFile[])ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile[]>(){

            public VirtualFile[] compute() {
                return ModuleChunk.this.filterRoots(ModuleChunk.this.myContext.getSourceRoots(module), module.getProject(), ModuleChunk.this.mySourcesFilter);
            }
        });
    }

    private VirtualFile[] filterRoots(VirtualFile[] roots, Project project, int sourcesFilter) {
        ArrayList<VirtualFile> filteredRoots = new ArrayList<VirtualFile>(roots.length);
        CompilerConfigurationImpl compilerConfiguration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)project);
        for (VirtualFile root : roots) {
            if (sourcesFilter != 3 && (!this.myContext.isInTestSourceContent(root) ? (sourcesFilter & 1) == 0 : (sourcesFilter & 2) == 0) || compilerConfiguration.isExcludedFromCompilation(root)) continue;
            filteredRoots.add(root);
        }
        return VfsUtil.toVirtualFileArray(filteredRoots);
    }

    private VirtualFile[] getAllSourceRoots() {
        Set modules = this.getNodes();
        HashSet roots = new HashSet();
        for (Module module : modules) {
            ContainerUtil.addAll(roots, (Object[])this.myContext.getSourceRoots(module));
        }
        return VfsUtil.toVirtualFileArray(roots);
    }

    public String getCompilationClasspath() {
        OrderedSet<VirtualFile> cpFiles = this.getCompilationClasspathFiles();
        return ModuleChunk.convertToStringPath(cpFiles);
    }

    public OrderedSet<VirtualFile> getCompilationClasspathFiles() {
        return this.getCompilationClasspathFiles(true);
    }

    public OrderedSet<VirtualFile> getCompilationClasspathFiles(boolean exportedOnly) {
        Set modules = this.getNodes();
        OrderedSet cpFiles = new OrderedSet();
        for (Module module : modules) {
            Collections.addAll(cpFiles, this.orderEnumerator(module, exportedOnly, new AfterJdkOrderEntryCondition()).getClassesRoots());
        }
        return cpFiles;
    }

    private OrderEnumerator orderEnumerator(Module module, boolean exportedOnly, Condition<OrderEntry> condition) {
        OrderEnumerator enumerator = OrderEnumerator.orderEntries((Module)module).compileOnly().satisfying(condition);
        if ((this.mySourcesFilter & 2) == 0) {
            enumerator = enumerator.productionOnly();
        }
        enumerator = enumerator.recursively();
        return exportedOnly ? enumerator.exportedOnly() : enumerator;
    }

    public String getCompilationBootClasspath() {
        return ModuleChunk.convertToStringPath(this.getCompilationBootClasspathFiles());
    }

    public OrderedSet<VirtualFile> getCompilationBootClasspathFiles() {
        return this.getCompilationBootClasspathFiles(true);
    }

    public OrderedSet<VirtualFile> getCompilationBootClasspathFiles(boolean exportedOnly) {
        Set modules = this.getNodes();
        OrderedSet cpFiles = new OrderedSet();
        OrderedSet jdkFiles = new OrderedSet();
        for (Module module : modules) {
            Collections.addAll(cpFiles, this.orderEnumerator(module, exportedOnly, new BeforeJdkOrderEntryCondition(module)).getClassesRoots());
            Collections.addAll(jdkFiles, OrderEnumerator.orderEntries((Module)module).sdkOnly().getClassesRoots());
        }
        cpFiles.addAll((Collection)jdkFiles);
        return cpFiles;
    }

    private static String convertToStringPath(OrderedSet<VirtualFile> cpFiles) {
        PathsList classpath = new PathsList();
        classpath.addVirtualFiles(cpFiles);
        return classpath.getPathsString();
    }

    public int getModuleCount() {
        return this.getNodes().size();
    }

    public Module[] getModules() {
        Set nodes = this.getNodes();
        return nodes.toArray(new Module[nodes.size()]);
    }

    public String getSourcePath() {
        return this.getSourcePath(this.mySourcesFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public String getSourcePath(int sourcesFilter) {
        if (this.getModuleCount() == 0) {
            return "";
        }
        final VirtualFile[] filteredRoots = this.getSourceRoots(sourcesFilter);
        final StringBuilder buffer = StringBuilderSpinAllocator.alloc();
        try {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    for (VirtualFile root : filteredRoots) {
                        if (buffer.length() > 0) {
                            buffer.append(File.pathSeparatorChar);
                        }
                        buffer.append(root.getPath().replace('/', File.separatorChar));
                    }
                }
            });
            String string = buffer.toString();
            return string;
        }
        finally {
            StringBuilderSpinAllocator.dispose((StringBuilder)buffer);
        }
    }

    public LanguageLevel getLanguageLevel() {
        return EffectiveLanguageLevelUtil.getEffectiveLanguageLevel((Module)((Module)this.getNodes().iterator().next()));
    }

    public Project getProject() {
        return this.myContext.getProject();
    }

    private static class AfterJdkOrderEntryCondition
    implements Condition<OrderEntry> {
        private boolean myJdkFound;

        private AfterJdkOrderEntryCondition() {
        }

        public boolean value(OrderEntry orderEntry) {
            if (orderEntry instanceof JdkOrderEntry) {
                this.myJdkFound = true;
                return false;
            }
            return this.myJdkFound;
        }
    }

    private static class BeforeJdkOrderEntryCondition
    implements Condition<OrderEntry> {
        private boolean myJdkFound;
        private final Module myOwnerModule;

        private BeforeJdkOrderEntryCondition(Module ownerModule) {
            this.myOwnerModule = ownerModule;
        }

        public boolean value(OrderEntry orderEntry) {
            if (orderEntry instanceof JdkOrderEntry && this.myOwnerModule.equals(orderEntry.getOwnerModule())) {
                this.myJdkFound = true;
            }
            return !this.myJdkFound;
        }
    }
}

