/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl.javaCompiler;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerConfigurationImpl;
import com.intellij.compiler.CompilerException;
import com.intellij.compiler.impl.CompileDriver;
import com.intellij.compiler.impl.javaCompiler.BackendCompiler;
import com.intellij.compiler.impl.javaCompiler.BackendCompilerWrapper;
import com.intellij.compiler.impl.javaCompiler.ExternalCompiler;
import com.intellij.compiler.make.CacheCorruptedException;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.util.Chunk;
import java.util.Arrays;
import org.jetbrains.annotations.NotNull;

public class JavaCompiler
implements TranslatingCompiler {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.javaCompiler.JavaCompiler");
    private final Project myProject;

    public JavaCompiler(Project project) {
        this.myProject = project;
    }

    @NotNull
    public String getDescription() {
        String string = CompilerBundle.message((String)"java.compiler.description", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/javaCompiler/JavaCompiler", "getDescription"));
        }
        return string;
    }

    public boolean isCompilableFile(VirtualFile file, CompileContext context) {
        BackendCompiler backEndCompiler = this.getBackEndCompiler();
        if (backEndCompiler instanceof ExternalCompiler) {
            return ((ExternalCompiler)backEndCompiler).isCompilableFile(file, context);
        }
        return backEndCompiler.getCompilableFileTypes().contains(file.getFileType());
    }

    public void compile(CompileContext context, Chunk<Module> moduleChunk, VirtualFile[] files, TranslatingCompiler.OutputSink sink) {
        BackendCompiler backEndCompiler = this.getBackEndCompiler();
        BackendCompilerWrapper wrapper = new BackendCompilerWrapper(moduleChunk, this.myProject, Arrays.asList(files), (CompileContextEx)context, backEndCompiler, sink);
        try {
            if (CompileDriver.ourDebugMode) {
                System.out.println("Starting java compiler; with backend compiler: " + backEndCompiler.getClass().getName());
            }
            wrapper.compile();
        }
        catch (CompilerException e) {
            if (CompileDriver.ourDebugMode) {
                e.printStackTrace();
            }
            context.addMessage(CompilerMessageCategory.ERROR, e.getMessage(), null, -1, -1);
            LOG.info((Throwable)e);
        }
        catch (CacheCorruptedException e) {
            if (CompileDriver.ourDebugMode) {
                e.printStackTrace();
            }
            LOG.info((Throwable)e);
            context.requestRebuildNextTime(e.getMessage());
        }
    }

    public boolean validateConfiguration(CompileScope scope) {
        return this.getBackEndCompiler().checkCompiler(scope);
    }

    private BackendCompiler getBackEndCompiler() {
        CompilerConfigurationImpl configuration = (CompilerConfigurationImpl)CompilerConfiguration.getInstance((Project)this.myProject);
        return configuration.getDefaultCompiler();
    }
}

