/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.ProjectTopics;
import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerIOUtil;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.impl.SourceUrlClassNamePair;
import com.intellij.compiler.make.MakeUtil;
import com.intellij.compiler.server.BuildManager;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.ModalityState;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompilerBundle;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.DummyCompileContext;
import com.intellij.openapi.compiler.IntermediateOutputCompiler;
import com.intellij.openapi.compiler.TranslatingCompiler;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.components.ApplicationComponent;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileTypes.FileTypeManager;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectManager;
import com.intellij.openapi.project.ProjectManagerAdapter;
import com.intellij.openapi.project.ProjectManagerListener;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ContentIterator;
import com.intellij.openapi.roots.ModuleRootEvent;
import com.intellij.openapi.roots.ModuleRootListener;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.startup.StartupManager;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.Trinity;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.LocalFileSystem;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileAdapter;
import com.intellij.openapi.vfs.VirtualFileCopyEvent;
import com.intellij.openapi.vfs.VirtualFileEvent;
import com.intellij.openapi.vfs.VirtualFileListener;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.openapi.vfs.VirtualFileMoveEvent;
import com.intellij.openapi.vfs.VirtualFilePropertyEvent;
import com.intellij.openapi.vfs.VirtualFileVisitor;
import com.intellij.openapi.vfs.newvfs.FileAttribute;
import com.intellij.openapi.vfs.newvfs.ManagingFS;
import com.intellij.openapi.vfs.newvfs.NewVirtualFile;
import com.intellij.openapi.vfs.newvfs.persistent.FSRecords;
import com.intellij.openapi.vfs.newvfs.persistent.PersistentFS;
import com.intellij.util.Alarm;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.SLRUCache;
import com.intellij.util.indexing.FileBasedIndex;
import com.intellij.util.indexing.IndexInfrastructure;
import com.intellij.util.io.DataExternalizer;
import com.intellij.util.io.DataInputOutputUtil;
import com.intellij.util.io.EnumeratorIntegerDescriptor;
import com.intellij.util.io.KeyDescriptor;
import com.intellij.util.io.PersistentHashMap;
import com.intellij.util.io.PersistentStringEnumerator;
import com.intellij.util.messages.MessageBusConnection;
import gnu.trove.THashSet;
import gnu.trove.TIntArrayList;
import gnu.trove.TIntHashSet;
import gnu.trove.TIntIntHashMap;
import gnu.trove.TIntLongHashMap;
import gnu.trove.TIntObjectHashMap;
import gnu.trove.TIntObjectIterator;
import gnu.trove.TIntProcedure;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.DataInput;
import java.io.DataInputStream;
import java.io.DataOutput;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicInteger;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class TranslatingCompilerFilesMonitor
implements ApplicationComponent {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.TranslatingCompilerFilesMonitor");
    public static boolean ourDebugMode = false;
    private static final FileAttribute ourSourceFileAttribute = new FileAttribute("_make_source_file_info_", 3);
    private static final FileAttribute ourOutputFileAttribute = new FileAttribute("_make_output_file_info_", 3);
    private static final Key<Map<String, VirtualFile>> SOURCE_FILES_CACHE = Key.create((String)"_source_url_to_vfile_cache_");
    private final Object myDataLock = new Object();
    private final TIntHashSet mySuspendedProjects = new TIntHashSet();
    private final TIntObjectHashMap<TIntHashSet> mySourcesToRecompile = new TIntObjectHashMap();
    private PersistentHashMap<Integer, TIntObjectHashMap<Pair<Integer, Integer>>> myOutputRootsStorage;
    private final SLRUCache<Integer, Outputs> myOutputsToDelete = new SLRUCache<Integer, Outputs>(3, 3){

        public Outputs getIfCached(Integer key) {
            Outputs value = (Outputs)super.getIfCached((Object)key);
            if (value != null) {
                value.allocate();
            }
            return value;
        }

        @NotNull
        public Outputs get(Integer key) {
            Outputs value = (Outputs)super.get((Object)key);
            value.allocate();
            Outputs outputs = value;
            if (outputs == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1", "get"));
            }
            return outputs;
        }

        @NotNull
        public Outputs createValue(Integer key) {
            Outputs outputs;
            block3: {
                try {
                    File compilerCacheDir;
                    String dirName = FSRecords.getNames().valueOf(key.intValue());
                    File storeFile = StringUtil.isEmpty((String)dirName) ? null : ((compilerCacheDir = CompilerPaths.getCacheStoreDirectory((String)dirName)).exists() ? new File(compilerCacheDir, "paths_to_delete.dat") : null);
                    outputs = new Outputs(storeFile, TranslatingCompilerFilesMonitor.loadPathsToDelete(storeFile));
                    if (outputs != null) break block3;
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                    Outputs outputs2 = new Outputs(null, new HashMap<String, SourceUrlClassNamePair>());
                    if (outputs2 == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1", "createValue"));
                    }
                    return outputs2;
                }
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$1", "createValue"));
            }
            return outputs;
        }

        protected void onDropFromCache(Integer key, Outputs value) {
            value.release();
        }
    };
    private final SLRUCache<Project, File> myGeneratedDataPaths = new SLRUCache<Project, File>(8, 8){

        @NotNull
        public File createValue(final Project project) {
            Disposer.register((Disposable)project, (Disposable)new Disposable(){

                public void dispose() {
                    TranslatingCompilerFilesMonitor.this.myGeneratedDataPaths.remove((Object)project);
                }
            });
            File file = CompilerPaths.getGeneratedDataDirectory((Project)project);
            if (file == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$2", "createValue"));
            }
            return file;
        }
    };
    private final SLRUCache<Integer, TIntObjectHashMap<Pair<Integer, Integer>>> myProjectOutputRoots = new SLRUCache<Integer, TIntObjectHashMap<Pair<Integer, Integer>>>(2, 2){

        protected void onDropFromCache(Integer key, TIntObjectHashMap<Pair<Integer, Integer>> value) {
            try {
                TranslatingCompilerFilesMonitor.this.myOutputRootsStorage.put((Object)key, value);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }

        @NotNull
        public TIntObjectHashMap<Pair<Integer, Integer>> createValue(Integer key) {
            TIntObjectHashMap map = null;
            try {
                TranslatingCompilerFilesMonitor.this.ensureOutputStorageInitialized();
                map = (TIntObjectHashMap)TranslatingCompilerFilesMonitor.this.myOutputRootsStorage.get((Object)key);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
            TIntObjectHashMap tIntObjectHashMap = map != null ? map : new TIntObjectHashMap();
            if (tIntObjectHashMap == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$3", "createValue"));
            }
            return tIntObjectHashMap;
        }
    };
    private final ProjectManager myProjectManager;
    private final TIntIntHashMap myInitInProgress = new TIntIntHashMap();
    private final Object myAsyncScanLock = new Object();

    public TranslatingCompilerFilesMonitor(VirtualFileManager vfsManager, ProjectManager projectManager, Application application) {
        this.myProjectManager = projectManager;
        projectManager.addProjectManagerListener((ProjectManagerListener)new MyProjectManagerListener());
        vfsManager.addVirtualFileListener((VirtualFileListener)new MyVfsListener(), (Disposable)application);
    }

    public static TranslatingCompilerFilesMonitor getInstance() {
        return (TranslatingCompilerFilesMonitor)ApplicationManager.getApplication().getComponent(TranslatingCompilerFilesMonitor.class);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void suspendProject(Project project) {
        int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
        SLRUCache<Integer, TIntObjectHashMap<Pair<Integer, Integer>>> sLRUCache = this.myDataLock;
        synchronized (sLRUCache) {
            if (!this.mySuspendedProjects.add(projectId)) {
                return;
            }
            FileUtil.createIfDoesntExist((File)CompilerPaths.getRebuildMarkerFile((Project)project));
            this.mySourcesToRecompile.remove(projectId);
            this.myOutputsToDelete.remove((Object)projectId);
            this.myGeneratedDataPaths.remove((Object)project);
        }
        sLRUCache = this.myProjectOutputRoots;
        synchronized (sLRUCache) {
            this.ensureOutputStorageInitialized();
            this.myProjectOutputRoots.remove((Object)projectId);
            try {
                this.myOutputRootsStorage.remove((Object)projectId);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void watchProject(Project project) {
        Object object = this.myDataLock;
        synchronized (object) {
            int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
            this.mySuspendedProjects.remove(projectId);
        }
    }

    public boolean isSuspended(Project project) {
        return this.isSuspended(TranslatingCompilerFilesMonitor.getProjectId(project));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean isSuspended(int projectId) {
        Object object = this.myDataLock;
        synchronized (object) {
            return this.mySuspendedProjects.contains(projectId);
        }
    }

    @Nullable
    public static VirtualFile getSourceFileByOutput(VirtualFile outputFile) {
        String path;
        OutputFileInfo outputFileInfo = TranslatingCompilerFilesMonitor.loadOutputInfo(outputFile);
        if (outputFileInfo != null && (path = outputFileInfo.getSourceFilePath()) != null) {
            return LocalFileSystem.getInstance().findFileByPath(path);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void collectFiles(CompileContext context, TranslatingCompiler compiler, Iterator<VirtualFile> scopeSrcIterator, boolean forceCompile, boolean isRebuild, Collection<VirtualFile> toCompile, Collection<Trinity<File, String, Boolean>> toDelete) {
        Project project = context.getProject();
        int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
        CompilerConfiguration configuration = CompilerConfiguration.getInstance((Project)project);
        boolean _forceCompile = forceCompile || isRebuild;
        HashSet<VirtualFile> selectedForRecompilation = new HashSet<VirtualFile>();
        Object object = this.myDataLock;
        synchronized (object) {
            TIntHashSet pathsToRecompile = (TIntHashSet)this.mySourcesToRecompile.get(projectId);
            if (_forceCompile || pathsToRecompile != null && !pathsToRecompile.isEmpty()) {
                if (ourDebugMode) {
                    System.out.println("Analysing potentially recompilable files for " + compiler.getDescription());
                }
                while (scopeSrcIterator.hasNext()) {
                    VirtualFile file = scopeSrcIterator.next();
                    if (!file.isValid()) {
                        if (!LOG.isDebugEnabled() && !ourDebugMode) continue;
                        LOG.debug("Skipping invalid file " + file.getPresentableUrl());
                        if (!ourDebugMode) continue;
                        System.out.println("\t SKIPPED(INVALID) " + file.getPresentableUrl());
                        continue;
                    }
                    int fileId = TranslatingCompilerFilesMonitor.getFileId(file);
                    if (_forceCompile) {
                        if (compiler.isCompilableFile(file, context) && !configuration.isExcludedFromCompilation(file)) {
                            toCompile.add(file);
                            if (ourDebugMode) {
                                System.out.println("\t INCLUDED " + file.getPresentableUrl());
                            }
                            selectedForRecompilation.add(file);
                            if (pathsToRecompile != null && pathsToRecompile.contains(fileId)) continue;
                            this.loadInfoAndAddSourceForRecompilation(projectId, file);
                            continue;
                        }
                        if (!ourDebugMode) continue;
                        System.out.println("\t NOT COMPILABLE OR EXCLUDED " + file.getPresentableUrl());
                        continue;
                    }
                    if (pathsToRecompile.contains(fileId)) {
                        if (compiler.isCompilableFile(file, context) && !configuration.isExcludedFromCompilation(file)) {
                            toCompile.add(file);
                            if (ourDebugMode) {
                                System.out.println("\t INCLUDED " + file.getPresentableUrl());
                            }
                            selectedForRecompilation.add(file);
                            continue;
                        }
                        if (!ourDebugMode) continue;
                        System.out.println("\t NOT COMPILABLE OR EXCLUDED " + file.getPresentableUrl());
                        continue;
                    }
                    if (!ourDebugMode) continue;
                    System.out.println("\t NOT INCLUDED " + file.getPresentableUrl());
                }
            }
            if (!isRebuild) {
                Outputs outputs = (Outputs)this.myOutputsToDelete.get((Object)projectId);
                try {
                    VirtualFileManager vfm = VirtualFileManager.getInstance();
                    LocalFileSystem lfs = LocalFileSystem.getInstance();
                    ArrayList<String> zombieEntries = new ArrayList<String>();
                    Map<String, VirtualFile> srcFileCache = TranslatingCompilerFilesMonitor.getFileCache(context);
                    for (Map.Entry<String, SourceUrlClassNamePair> entry : outputs.getEntries()) {
                        String message;
                        boolean sourcePresent;
                        VirtualFile srcFile;
                        String outputPath = entry.getKey();
                        SourceUrlClassNamePair classNamePair = entry.getValue();
                        String sourceUrl = classNamePair.getSourceUrl();
                        if (srcFileCache.containsKey(sourceUrl)) {
                            srcFile = srcFileCache.get(sourceUrl);
                        } else {
                            srcFile = vfm.findFileByUrl(sourceUrl);
                            srcFileCache.put(sourceUrl, srcFile);
                        }
                        boolean bl = sourcePresent = srcFile != null;
                        if (sourcePresent) {
                            if (!compiler.isCompilableFile(srcFile, context)) continue;
                            if (!selectedForRecompilation.contains(srcFile)) {
                                if (this.isMarkedForRecompilation(projectId, TranslatingCompilerFilesMonitor.getFileId(srcFile))) continue;
                                if (LOG.isDebugEnabled() || ourDebugMode) {
                                    message = "Found zombie entry (output is marked, but source is present and up-to-date): " + outputPath;
                                    LOG.debug(message);
                                    if (ourDebugMode) {
                                        System.out.println(message);
                                    }
                                }
                                zombieEntries.add(outputPath);
                                continue;
                            }
                        }
                        if (lfs.findFileByPath(outputPath) != null) {
                            File file = new File(outputPath);
                            toDelete.add((Trinity<File, String, Boolean>)new Trinity((Object)file, (Object)classNamePair.getClassName(), (Object)sourcePresent));
                            if (!LOG.isDebugEnabled() && !ourDebugMode) continue;
                            String message2 = "Found file to delete: " + file;
                            LOG.debug(message2);
                            if (!ourDebugMode) continue;
                            System.out.println(message2);
                            continue;
                        }
                        if (LOG.isDebugEnabled() || ourDebugMode) {
                            message = "Found zombie entry marked for deletion: " + outputPath;
                            LOG.debug(message);
                            if (ourDebugMode) {
                                System.out.println(message);
                            }
                        }
                        zombieEntries.add(outputPath);
                    }
                    for (String path : zombieEntries) {
                        this.unmarkOutputPathForDeletion(projectId, path);
                    }
                }
                finally {
                    outputs.release();
                }
            }
        }
    }

    private static Map<String, VirtualFile> getFileCache(CompileContext context) {
        HashMap cache = (HashMap)context.getUserData(SOURCE_FILES_CACHE);
        if (cache == null) {
            cache = new HashMap();
            context.putUserData(SOURCE_FILES_CACHE, cache);
        }
        return cache;
    }

    private static int getFileId(VirtualFile file) {
        return FileBasedIndex.getFileId((VirtualFile)file);
    }

    private static VirtualFile findFileById(int id) {
        return IndexInfrastructure.findFileById((PersistentFS)ManagingFS.getInstance(), id);
    }

    public void update(final CompileContext context, final @Nullable String outputRoot, final Collection<TranslatingCompiler.OutputItem> successfullyCompiled, final VirtualFile[] filesToRecompile) throws IOException {
        Project project = context.getProject();
        final int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
        if (!successfullyCompiled.isEmpty()) {
            final LocalFileSystem lfs = LocalFileSystem.getInstance();
            final IOException[] exceptions = new IOException[]{null};
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    try {
                        HashMap<VirtualFile, SourceFileInfo> compiledSources = new HashMap<VirtualFile, SourceFileInfo>();
                        HashSet<VirtualFile> forceRecompile = new HashSet<VirtualFile>();
                        for (TranslatingCompiler.OutputItem item : successfullyCompiled) {
                            String outputPath;
                            VirtualFile sourceFile = item.getSourceFile();
                            boolean isSourceValid = sourceFile.isValid();
                            SourceFileInfo srcInfo = (SourceFileInfo)compiledSources.get(sourceFile);
                            if (isSourceValid && srcInfo == null) {
                                srcInfo = TranslatingCompilerFilesMonitor.loadSourceInfo(sourceFile);
                                if (srcInfo != null) {
                                    srcInfo.clearPaths(projectId);
                                } else {
                                    srcInfo = new SourceFileInfo();
                                }
                                compiledSources.put(sourceFile, srcInfo);
                            }
                            if ((outputPath = item.getOutputPath()) == null) continue;
                            VirtualFile outputFile = lfs.findFileByPath(outputPath);
                            if (outputFile != null) {
                                String className;
                                if (sourceFile.equals(outputFile)) continue;
                                String string = className = outputRoot == null ? null : MakeUtil.relativeClassPathToQName(outputPath.substring(outputRoot.length()), '/');
                                if (isSourceValid) {
                                    srcInfo.addOutputPath(projectId, outputPath);
                                    TranslatingCompilerFilesMonitor.saveOutputInfo(outputFile, new OutputFileInfo(sourceFile.getPath(), className));
                                    continue;
                                }
                                TranslatingCompilerFilesMonitor.this.markOutputPathForDeletion(projectId, outputPath, className, sourceFile.getUrl());
                                continue;
                            }
                            LOG.warn("TranslatingCompilerFilesMonitor.update():  Virtual file was not found for \"" + outputPath + "\"");
                            if (!isSourceValid) continue;
                            forceRecompile.add(sourceFile);
                        }
                        long compilationStartStamp = ((CompileContextEx)context).getStartCompilationStamp();
                        for (Map.Entry entry : compiledSources.entrySet()) {
                            SourceFileInfo info = (SourceFileInfo)entry.getValue();
                            VirtualFile file = (VirtualFile)entry.getKey();
                            long fileStamp = file.getTimeStamp();
                            info.updateTimestamp(projectId, fileStamp);
                            TranslatingCompilerFilesMonitor.saveSourceInfo(file, info);
                            if (LOG.isDebugEnabled() || ourDebugMode) {
                                String message = "Unschedule recompilation (successfully compiled) " + file.getPresentableUrl();
                                LOG.debug(message);
                                if (ourDebugMode) {
                                    System.out.println(message);
                                }
                            }
                            TranslatingCompilerFilesMonitor.this.removeSourceForRecompilation(projectId, Math.abs(TranslatingCompilerFilesMonitor.getFileId(file)));
                            if ((fileStamp <= compilationStartStamp || ((CompileContextEx)context).isGenerated(file)) && !forceRecompile.contains(file)) continue;
                            TranslatingCompilerFilesMonitor.this.addSourceForRecompilation(projectId, file, info);
                        }
                    }
                    catch (IOException e) {
                        exceptions[0] = e;
                    }
                }
            });
            if (exceptions[0] != null) {
                throw exceptions[0];
            }
        }
        if (filesToRecompile.length > 0) {
            ApplicationManager.getApplication().runReadAction(new Runnable(){

                @Override
                public void run() {
                    for (VirtualFile file : filesToRecompile) {
                        if (!file.isValid()) continue;
                        TranslatingCompilerFilesMonitor.this.loadInfoAndAddSourceForRecompilation(projectId, file);
                    }
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateOutputRootsLayout(Project project) {
        TIntObjectHashMap<Pair<Integer, Integer>> map = this.buildOutputRootsLayout(new ProjectRef(project));
        int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
        SLRUCache<Integer, TIntObjectHashMap<Pair<Integer, Integer>>> sLRUCache = this.myProjectOutputRoots;
        synchronized (sLRUCache) {
            this.myProjectOutputRoots.put((Object)projectId, map);
        }
    }

    @NotNull
    public String getComponentName() {
        if ("TranslatingCompilerFilesMonitor" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor", "getComponentName"));
        }
        return "TranslatingCompilerFilesMonitor";
    }

    public void initComponent() {
        this.ensureOutputStorageInitialized();
    }

    private static File getOutputRootsFile() {
        return new File(CompilerPaths.getCompilerSystemDirectory(), "output_roots.dat");
    }

    private static void deleteStorageFiles(File tableFile) {
        File[] files = tableFile.getParentFile().listFiles();
        if (files != null) {
            String name = tableFile.getName();
            for (File file : files) {
                if (!file.getName().startsWith(name)) continue;
                FileUtil.delete((File)file);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Map<String, SourceUrlClassNamePair> loadPathsToDelete(@Nullable File file) {
        HashMap<String, SourceUrlClassNamePair> map;
        block7: {
            map = new HashMap<String, SourceUrlClassNamePair>();
            try {
                if (file == null || file.length() <= 0L) break block7;
                DataInputStream is = new DataInputStream(new BufferedInputStream(new FileInputStream(file)));
                try {
                    int size = is.readInt();
                    for (int i = 0; i < size; ++i) {
                        String _outputPath = CompilerIOUtil.readString(is);
                        String srcUrl = CompilerIOUtil.readString(is);
                        String className = CompilerIOUtil.readString(is);
                        map.put(FileUtil.toSystemIndependentName((String)_outputPath), new SourceUrlClassNamePair(srcUrl, className));
                    }
                }
                finally {
                    is.close();
                }
            }
            catch (FileNotFoundException ignored) {
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }
        return map;
    }

    private void ensureOutputStorageInitialized() {
        if (this.myOutputRootsStorage != null) {
            return;
        }
        File rootsFile = TranslatingCompilerFilesMonitor.getOutputRootsFile();
        try {
            this.initOutputRootsFile(rootsFile);
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            TranslatingCompilerFilesMonitor.deleteStorageFiles(rootsFile);
            try {
                this.initOutputRootsFile(rootsFile);
            }
            catch (IOException e1) {
                LOG.error((Throwable)e1);
            }
        }
    }

    private TIntObjectHashMap<Pair<Integer, Integer>> buildOutputRootsLayout(ProjectRef projRef) {
        TIntObjectHashMap map = new TIntObjectHashMap();
        for (Module module : ModuleManager.getInstance((Project)projRef.get()).getModules()) {
            CompilerModuleExtension manager = CompilerModuleExtension.getInstance((Module)module);
            if (manager == null) continue;
            VirtualFile output = manager.getCompilerOutputPath();
            int first = output != null ? Math.abs(TranslatingCompilerFilesMonitor.getFileId(output)) : -1;
            VirtualFile testsOutput = manager.getCompilerOutputPathForTests();
            int second = testsOutput != null ? Math.abs(TranslatingCompilerFilesMonitor.getFileId(testsOutput)) : -1;
            map.put(TranslatingCompilerFilesMonitor.getModuleId(module), (Object)new Pair((Object)first, (Object)second));
        }
        return map;
    }

    private void initOutputRootsFile(File rootsFile) throws IOException {
        this.myOutputRootsStorage = new PersistentHashMap(rootsFile, (KeyDescriptor)EnumeratorIntegerDescriptor.INSTANCE, (DataExternalizer)new DataExternalizer<TIntObjectHashMap<Pair<Integer, Integer>>>(){

            public void save(@NotNull DataOutput out, TIntObjectHashMap<Pair<Integer, Integer>> value) throws IOException {
                if (out == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$6", "save"));
                }
                TIntObjectIterator it = value.iterator();
                while (it.hasNext()) {
                    it.advance();
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)it.key());
                    Pair pair = (Pair)it.value();
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)((Integer)pair.first));
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)((Integer)pair.second));
                }
            }

            public TIntObjectHashMap<Pair<Integer, Integer>> read(@NotNull DataInput in) throws IOException {
                if (in == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$6", "read"));
                }
                DataInputStream _in = (DataInputStream)in;
                TIntObjectHashMap map = new TIntObjectHashMap();
                while (_in.available() > 0) {
                    int key = DataInputOutputUtil.readINT((DataInput)_in);
                    int first = DataInputOutputUtil.readINT((DataInput)_in);
                    int second = DataInputOutputUtil.readINT((DataInput)_in);
                    map.put(key, (Object)new Pair((Object)first, (Object)second));
                }
                return map;
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void disposeComponent() {
        Object object;
        try {
            object = this.myProjectOutputRoots;
            synchronized (object) {
                this.myProjectOutputRoots.clear();
            }
        }
        finally {
            object = this.myDataLock;
            synchronized (object) {
                this.myOutputsToDelete.clear();
            }
        }
        try {
            PersistentHashMap<Integer, TIntObjectHashMap<Pair<Integer, Integer>>> storage = this.myOutputRootsStorage;
            if (storage != null) {
                storage.close();
            }
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            TranslatingCompilerFilesMonitor.deleteStorageFiles(TranslatingCompilerFilesMonitor.getOutputRootsFile());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void savePathsToDelete(File file, Map<String, SourceUrlClassNamePair> outputs) {
        try {
            FileUtil.createParentDirs((File)file);
            com.intellij.util.io.DataOutputStream os = new com.intellij.util.io.DataOutputStream((OutputStream)new BufferedOutputStream(new FileOutputStream(file)));
            try {
                if (outputs != null) {
                    os.writeInt(outputs.size());
                    for (Map.Entry<String, SourceUrlClassNamePair> entry : outputs.entrySet()) {
                        CompilerIOUtil.writeString(entry.getKey(), (DataOutput)os);
                        SourceUrlClassNamePair pair = entry.getValue();
                        CompilerIOUtil.writeString(pair.getSourceUrl(), (DataOutput)os);
                        CompilerIOUtil.writeString(pair.getClassName(), (DataOutput)os);
                    }
                } else {
                    os.writeInt(0);
                }
            }
            finally {
                os.close();
            }
        }
        catch (IOException e) {
            LOG.error((Throwable)e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static SourceFileInfo loadSourceInfo(VirtualFile file) {
        block7: {
            SourceFileInfo sourceFileInfo;
            DataInputStream is = ourSourceFileAttribute.readAttribute(file);
            if (is == null) break block7;
            try {
                sourceFileInfo = new SourceFileInfo(is);
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        LOG.info((Throwable)e);
                        break block7;
                    }
                    throw e;
                }
                catch (IOException ignored) {
                    LOG.info((Throwable)ignored);
                }
            }
            is.close();
            return sourceFileInfo;
        }
        return null;
    }

    public static void removeSourceInfo(VirtualFile file) {
        TranslatingCompilerFilesMonitor.saveSourceInfo(file, new SourceFileInfo());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveSourceInfo(VirtualFile file, SourceFileInfo descriptor) {
        DataOutputStream out = ourSourceFileAttribute.writeAttribute(file);
        try {
            try {
                descriptor.save(out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException ignored) {
            LOG.info((Throwable)ignored);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Nullable
    private static OutputFileInfo loadOutputInfo(VirtualFile file) {
        block7: {
            OutputFileInfo outputFileInfo;
            DataInputStream is = ourOutputFileAttribute.readAttribute(file);
            if (is == null) break block7;
            try {
                outputFileInfo = new OutputFileInfo(is);
            }
            catch (Throwable throwable) {
                try {
                    is.close();
                    throw throwable;
                }
                catch (RuntimeException e) {
                    Throwable cause = e.getCause();
                    if (cause instanceof IOException) {
                        LOG.info((Throwable)e);
                        break block7;
                    }
                    throw e;
                }
                catch (IOException ignored) {
                    LOG.info((Throwable)ignored);
                }
            }
            is.close();
            return outputFileInfo;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void saveOutputInfo(VirtualFile file, OutputFileInfo descriptor) {
        DataOutputStream out = ourOutputFileAttribute.writeAttribute(file);
        try {
            try {
                descriptor.save(out);
            }
            finally {
                out.close();
            }
        }
        catch (IOException ignored) {
            LOG.info((Throwable)ignored);
        }
    }

    private static int getProjectId(Project project) {
        try {
            return FSRecords.getNames().enumerate(CompilerPaths.getCompilerSystemDirectoryName((Project)project));
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return -1;
        }
    }

    private static int getModuleId(Module module) {
        try {
            return FSRecords.getNames().enumerate(module.getName().toLowerCase(Locale.US));
        }
        catch (IOException e) {
            LOG.info((Throwable)e);
            return -1;
        }
    }

    public List<String> getCompiledClassNames(VirtualFile srcFile, Project project) {
        SourceFileInfo info = TranslatingCompilerFilesMonitor.loadSourceInfo(srcFile);
        if (info == null) {
            return Collections.emptyList();
        }
        final ArrayList<String> result = new ArrayList<String>();
        info.processOutputPaths(TranslatingCompilerFilesMonitor.getProjectId(project), new Proc(){

            @Override
            public boolean execute(int projectId, String outputPath) {
                OutputFileInfo outputInfo;
                VirtualFile clsFile = LocalFileSystem.getInstance().findFileByPath(outputPath);
                if (clsFile != null && (outputInfo = TranslatingCompilerFilesMonitor.loadOutputInfo(clsFile)) != null) {
                    ContainerUtil.addIfNotNull((Collection)result, (Object)outputInfo.getClassName());
                }
                return true;
            }
        });
        return result;
    }

    private static void processRecursively(final VirtualFile fromFile, final boolean dbOnly, final boolean needReadAction, final FileProcessor processor) {
        if (!(fromFile.getFileSystem() instanceof LocalFileSystem)) {
            return;
        }
        final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        VfsUtilCore.visitChildrenRecursively((VirtualFile)fromFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            @NotNull
            public VirtualFileVisitor.Result visitFileEx(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$8", "visitFileEx"));
                }
                if (fileTypeManager.isFileIgnored(file)) {
                    VirtualFileVisitor.Result result = SKIP_CHILDREN;
                    if (result == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$8", "visitFileEx"));
                    }
                    return result;
                }
                if (!file.isDirectory()) {
                    processor.execute(file);
                }
                VirtualFileVisitor.Result result = CONTINUE;
                if (result == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$8", "visitFileEx"));
                }
                return result;
            }

            @Nullable
            public Iterable<VirtualFile> getChildrenIterable(@NotNull VirtualFile file) {
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$8", "getChildrenIterable"));
                }
                if (dbOnly) {
                    return file.isDirectory() ? ((NewVirtualFile)file).iterInDbChildren() : null;
                }
                if (file.equals(fromFile) || !file.isDirectory()) {
                    return null;
                }
                return TranslatingCompilerFilesMonitor.isInContentOfOpenedProject(file, needReadAction) ? null : ((NewVirtualFile)file).iterInDbChildren();
            }
        });
    }

    private static boolean isInContentOfOpenedProject(final @NotNull VirtualFile file, boolean needReadAction) {
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor", "isInContentOfOpenedProject"));
        }
        Computable<Boolean> computation = new Computable<Boolean>(){

            public Boolean compute() {
                for (Project project : ProjectManager.getInstance().getOpenProjects()) {
                    if (!project.isInitialized() || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file)) continue;
                    return Boolean.TRUE;
                }
                return Boolean.FALSE;
            }
        };
        return needReadAction ? (Boolean)ApplicationManager.getApplication().runReadAction((Computable)computation) : (Boolean)computation.compute();
    }

    public void scanSourceContent(final ProjectRef projRef, Collection<VirtualFile> roots, int totalRootCount, boolean isNewRoots) {
        if (roots.isEmpty()) {
            return;
        }
        final int projectId = TranslatingCompilerFilesMonitor.getProjectId(projRef.get());
        if (LOG.isDebugEnabled()) {
            LOG.debug("Scanning source content for project projectId=" + projectId + "; url=" + projRef.get().getPresentableUrl());
        }
        ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)projRef.get()).getFileIndex();
        ProgressIndicator indicator = ProgressManager.getInstance().getProgressIndicator();
        int processed = 0;
        for (VirtualFile srcRoot : roots) {
            if (indicator != null) {
                projRef.get();
                indicator.setText2(srcRoot.getPresentableUrl());
                indicator.setFraction((double)(++processed) / (double)totalRootCount);
            }
            if (isNewRoots) {
                fileIndex.iterateContentUnderDirectory(srcRoot, new ContentIterator(){

                    public boolean processFile(VirtualFile file) {
                        if (!file.isDirectory()) {
                            SourceFileInfo srcInfo;
                            if (!(TranslatingCompilerFilesMonitor.this.isMarkedForRecompilation(projectId, Math.abs(TranslatingCompilerFilesMonitor.getFileId(file))) || (srcInfo = TranslatingCompilerFilesMonitor.loadSourceInfo(file)) != null && srcInfo.getTimestamp(projectId) == file.getTimeStamp())) {
                                TranslatingCompilerFilesMonitor.this.addSourceForRecompilation(projectId, file, srcInfo);
                            }
                        } else {
                            projRef.get();
                        }
                        return true;
                    }
                });
                continue;
            }
            final FileTypeManager fileTypeManager = FileTypeManager.getInstance();
            VfsUtilCore.visitChildrenRecursively((VirtualFile)srcRoot, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

                public boolean visitFile(@NotNull VirtualFile file) {
                    if (file == null) {
                        throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$11", "visitFile"));
                    }
                    if (fileTypeManager.isFileIgnored(file)) {
                        return false;
                    }
                    int fileId = TranslatingCompilerFilesMonitor.getFileId(file);
                    if (fileId > 0) {
                        SourceFileInfo srcInfo;
                        if (file.isDirectory()) {
                            projRef.get();
                        } else if (!TranslatingCompilerFilesMonitor.this.isMarkedForRecompilation(projectId, fileId) && (srcInfo = TranslatingCompilerFilesMonitor.loadSourceInfo(file)) != null) {
                            TranslatingCompilerFilesMonitor.this.addSourceForRecompilation(projectId, file, srcInfo);
                        }
                    }
                    return true;
                }
            });
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void ensureInitializationCompleted(Project project, ProgressIndicator indicator) {
        int id = TranslatingCompilerFilesMonitor.getProjectId(project);
        Object object = this.myAsyncScanLock;
        synchronized (object) {
            while (this.myInitInProgress.containsKey(id) && project.isOpen() && !project.isDisposed() && (indicator == null || !indicator.isCanceled())) {
                try {
                    this.myAsyncScanLock.wait(500L);
                }
                catch (InterruptedException ignored) {
                    // empty catch block
                    break;
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markOldOutputRoots(ProjectRef projRef, TIntObjectHashMap<Pair<Integer, Integer>> currentLayout) {
        int projectId = TranslatingCompilerFilesMonitor.getProjectId(projRef.get());
        TIntHashSet rootsToMark = new TIntHashSet();
        SLRUCache<Integer, TIntObjectHashMap<Pair<Integer, Integer>>> sLRUCache = this.myProjectOutputRoots;
        synchronized (sLRUCache) {
            TIntObjectHashMap oldLayout = (TIntObjectHashMap)this.myProjectOutputRoots.get((Object)projectId);
            TIntObjectIterator it = oldLayout.iterator();
            while (it.hasNext()) {
                it.advance();
                Pair currentRoots = (Pair)currentLayout.get(it.key());
                Pair oldRoots = (Pair)it.value();
                if (TranslatingCompilerFilesMonitor.shouldMark((Integer)oldRoots.first, currentRoots != null ? (Integer)currentRoots.first : -1)) {
                    rootsToMark.add(((Integer)oldRoots.first).intValue());
                }
                if (!TranslatingCompilerFilesMonitor.shouldMark((Integer)oldRoots.second, currentRoots != null ? (Integer)currentRoots.second : -1)) continue;
                rootsToMark.add(((Integer)oldRoots.second).intValue());
            }
        }
        for (int id : rootsToMark) {
            VirtualFile outputRoot = TranslatingCompilerFilesMonitor.findFileById(id);
            if (outputRoot == null) continue;
            this.processOldOutputRoot(projectId, outputRoot);
        }
    }

    private static boolean shouldMark(Integer oldOutputRoot, Integer currentOutputRoot) {
        return oldOutputRoot != null && oldOutputRoot > 0 && !Comparing.equal((Object)oldOutputRoot, (Object)currentOutputRoot);
    }

    private void processOldOutputRoot(final int projectId, VirtualFile outputRoot) {
        VfsUtilCore.visitChildrenRecursively((VirtualFile)outputRoot, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0]){

            public boolean visitFile(@NotNull VirtualFile file) {
                OutputFileInfo outputInfo;
                if (file == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$12", "visitFile"));
                }
                if (!file.isDirectory() && (outputInfo = TranslatingCompilerFilesMonitor.loadOutputInfo(file)) != null) {
                    VirtualFile srcFile;
                    String srcPath = outputInfo.getSourceFilePath();
                    VirtualFile virtualFile = srcFile = srcPath != null ? LocalFileSystem.getInstance().findFileByPath(srcPath) : null;
                    if (srcFile != null) {
                        TranslatingCompilerFilesMonitor.this.loadInfoAndAddSourceForRecompilation(projectId, srcFile);
                    }
                }
                return true;
            }
        });
    }

    public void scanSourcesForCompilableFiles(final Project project) {
        final int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
        if (this.isSuspended(projectId)) {
            return;
        }
        this.startAsyncScan(projectId);
        StartupManager.getInstance((Project)project).runWhenProjectIsInitialized(new Runnable(){

            @Override
            public void run() {
                new Task.Backgroundable(project, CompilerBundle.message((String)"compiler.initial.scanning.progress.text", (Object[])new Object[0]), false){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void run(@NotNull ProgressIndicator indicator) {
                        if (indicator == null) {
                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$13$1", "run"));
                        }
                        ProjectRef projRef = new ProjectRef(project);
                        if (LOG.isDebugEnabled()) {
                            LOG.debug("Initial sources scan for project hash=" + projectId + "; url=" + projRef.get().getPresentableUrl());
                        }
                        try {
                            IntermediateOutputCompiler[] compilers = (IntermediateOutputCompiler[])CompilerManager.getInstance((Project)projRef.get()).getCompilers(IntermediateOutputCompiler.class);
                            HashSet<VirtualFile> intermediateRoots = new HashSet<VirtualFile>();
                            if (compilers.length > 0) {
                                Module[] modules = ModuleManager.getInstance((Project)projRef.get()).getModules();
                                for (IntermediateOutputCompiler compiler : compilers) {
                                    for (Module module : modules) {
                                        VirtualFile testsOutputRoot;
                                        if (module.isDisposed()) continue;
                                        VirtualFile outputRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)compiler, (Module)module, (boolean)false));
                                        if (outputRoot != null) {
                                            intermediateRoots.add(outputRoot);
                                        }
                                        if ((testsOutputRoot = LocalFileSystem.getInstance().refreshAndFindFileByPath(CompilerPaths.getGenerationOutputPath((IntermediateOutputCompiler)compiler, (Module)module, (boolean)true))) == null) continue;
                                        intermediateRoots.add(testsOutputRoot);
                                    }
                                }
                            }
                            List<VirtualFile> projectRoots = Arrays.asList(ProjectRootManager.getInstance((Project)projRef.get()).getContentSourceRoots());
                            int totalRootsCount = projectRoots.size() + intermediateRoots.size();
                            TranslatingCompilerFilesMonitor.this.scanSourceContent(projRef, projectRoots, totalRootsCount, true);
                            if (!intermediateRoots.isEmpty()) {
                                FileProcessor processor = new FileProcessor(){

                                    @Override
                                    public void execute(VirtualFile file) {
                                        SourceFileInfo srcInfo;
                                        if (!(TranslatingCompilerFilesMonitor.this.isMarkedForRecompilation(projectId, Math.abs(TranslatingCompilerFilesMonitor.getFileId(file))) || (srcInfo = TranslatingCompilerFilesMonitor.loadSourceInfo(file)) != null && srcInfo.getTimestamp(projectId) == file.getTimeStamp())) {
                                            TranslatingCompilerFilesMonitor.this.addSourceForRecompilation(projectId, file, srcInfo);
                                        }
                                    }
                                };
                                int processed = projectRoots.size();
                                for (VirtualFile root : intermediateRoots) {
                                    projRef.get();
                                    indicator.setText2(root.getPresentableUrl());
                                    indicator.setFraction((double)(++processed) / (double)totalRootsCount);
                                    TranslatingCompilerFilesMonitor.processRecursively(root, false, true, processor);
                                }
                            }
                            TranslatingCompilerFilesMonitor.this.markOldOutputRoots(projRef, (TIntObjectHashMap<Pair<Integer, Integer>>)TranslatingCompilerFilesMonitor.this.buildOutputRootsLayout(projRef));
                        }
                        catch (ProjectRef.ProjectClosedException projectClosedException) {
                        }
                        finally {
                            TranslatingCompilerFilesMonitor.this.terminateAsyncScan(projectId, false);
                        }
                    }
                }.queue();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void terminateAsyncScan(int projectId, boolean clearCounter) {
        Object object = this.myAsyncScanLock;
        synchronized (object) {
            int counter = this.myInitInProgress.remove(projectId);
            if (clearCounter) {
                this.myAsyncScanLock.notifyAll();
            } else if (--counter > 0) {
                this.myInitInProgress.put(projectId, counter);
            } else {
                this.myAsyncScanLock.notifyAll();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void startAsyncScan(int projectId) {
        Object object = this.myAsyncScanLock;
        synchronized (object) {
            int counter = this.myInitInProgress.get(projectId);
            counter = counter > 0 ? counter + 1 : 1;
            this.myInitInProgress.put(projectId, counter);
            this.myAsyncScanLock.notifyAll();
        }
    }

    private boolean isIgnoredOrUnderIgnoredDirectory(final VirtualFile file) {
        FileTypeManager fileTypeManager = FileTypeManager.getInstance();
        if (fileTypeManager.isFileIgnored(file)) {
            return true;
        }
        boolean isInContent = (Boolean)ApplicationManager.getApplication().runReadAction((Computable)new Computable<Boolean>(){

            public Boolean compute() {
                for (Project project : TranslatingCompilerFilesMonitor.this.myProjectManager.getOpenProjects()) {
                    if (!project.isInitialized() || !ProjectRootManager.getInstance((Project)project).getFileIndex().isInContent(file)) continue;
                    return true;
                }
                return false;
            }
        });
        if (isInContent) {
            return false;
        }
        for (VirtualFile current = file.getParent(); current != null; current = current.getParent()) {
            if (!fileTypeManager.isFileIgnored(current)) continue;
            return true;
        }
        return false;
    }

    private static void notifyFilesChanged(Collection<File> paths) {
        if (!paths.isEmpty()) {
            BuildManager.getInstance().notifyFilesChanged(paths);
        }
    }

    private static void notifyFilesDeleted(Collection<File> paths) {
        if (!paths.isEmpty()) {
            BuildManager.getInstance().notifyFilesDeleted(paths);
        }
    }

    private boolean belongsToIntermediateSources(VirtualFile file, Project project) {
        return FileUtil.isAncestor((File)((File)this.myGeneratedDataPaths.get((Object)project)), (File)new File(file.getPath()), (boolean)true);
    }

    private void loadInfoAndAddSourceForRecompilation(int projectId, VirtualFile srcFile) {
        this.addSourceForRecompilation(projectId, srcFile, TranslatingCompilerFilesMonitor.loadSourceInfo(srcFile));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addSourceForRecompilation(int projectId, VirtualFile srcFile, @Nullable SourceFileInfo srcInfo) {
        boolean alreadyMarked;
        Object object = this.myDataLock;
        synchronized (object) {
            TIntHashSet set = (TIntHashSet)this.mySourcesToRecompile.get(projectId);
            if (set == null) {
                set = new TIntHashSet();
                this.mySourcesToRecompile.put(projectId, (Object)set);
            }
            boolean bl = alreadyMarked = !set.add(Math.abs(TranslatingCompilerFilesMonitor.getFileId(srcFile)));
            if (!alreadyMarked && (LOG.isDebugEnabled() || ourDebugMode)) {
                String message = "Scheduled recompilation " + srcFile.getPresentableUrl();
                LOG.debug(message);
                if (ourDebugMode) {
                    System.out.println(message);
                }
            }
        }
        if (!alreadyMarked && srcInfo != null) {
            srcInfo.updateTimestamp(projectId, -1L);
            srcInfo.processOutputPaths(projectId, new ScheduleOutputsForDeletionProc(srcFile.getUrl()));
            TranslatingCompilerFilesMonitor.saveSourceInfo(srcFile, srcInfo);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeSourceForRecompilation(int projectId, int srcId) {
        Object object = this.myDataLock;
        synchronized (object) {
            TIntHashSet set = (TIntHashSet)this.mySourcesToRecompile.get(projectId);
            if (set != null) {
                set.remove(srcId);
                if (set.isEmpty()) {
                    this.mySourcesToRecompile.remove(projectId);
                }
            }
        }
    }

    public boolean isMarkedForCompilation(Project project, VirtualFile file) {
        if (CompilerWorkspaceConfiguration.getInstance((Project)project).useOutOfProcessBuild()) {
            CompilerManager compilerManager = CompilerManager.getInstance((Project)project);
            return !compilerManager.isUpToDate(compilerManager.createFilesCompileScope(new VirtualFile[]{file}));
        }
        return this.isMarkedForRecompilation(TranslatingCompilerFilesMonitor.getProjectId(project), TranslatingCompilerFilesMonitor.getFileId(file));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean isMarkedForRecompilation(int projectId, int srcId) {
        Object object = this.myDataLock;
        synchronized (object) {
            TIntHashSet set = (TIntHashSet)this.mySourcesToRecompile.get(projectId);
            return set != null && set.contains(srcId);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void markOutputPathForDeletion(int projectId, String outputPath, String classname, String srcUrl) {
        SourceUrlClassNamePair pair = new SourceUrlClassNamePair(srcUrl, classname);
        Object object = this.myDataLock;
        synchronized (object) {
            Outputs outputs = (Outputs)this.myOutputsToDelete.get((Object)projectId);
            try {
                outputs.put(outputPath, pair);
                if (LOG.isDebugEnabled() || ourDebugMode) {
                    String message = "ADD path to delete: " + outputPath + "; source: " + srcUrl;
                    LOG.debug(message);
                    if (ourDebugMode) {
                        System.out.println(message);
                    }
                }
            }
            finally {
                outputs.release();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void unmarkOutputPathForDeletion(int projectId, String outputPath) {
        Object object = this.myDataLock;
        synchronized (object) {
            Outputs outputs = (Outputs)this.myOutputsToDelete.get((Object)projectId);
            try {
                SourceUrlClassNamePair val = outputs.remove(outputPath);
                if (val != null && (LOG.isDebugEnabled() || ourDebugMode)) {
                    String message = "REMOVE path to delete: " + outputPath;
                    LOG.debug(message);
                    if (ourDebugMode) {
                        System.out.println(message);
                    }
                }
            }
            finally {
                outputs.release();
            }
        }
    }

    private static class Outputs {
        private boolean myIsDirty = false;
        @Nullable
        private final File myStoreFile;
        private final Map<String, SourceUrlClassNamePair> myMap;
        private final AtomicInteger myRefCount = new AtomicInteger(1);

        Outputs(@Nullable File storeFile, Map<String, SourceUrlClassNamePair> map) {
            this.myStoreFile = storeFile;
            this.myMap = map;
        }

        public Set<Map.Entry<String, SourceUrlClassNamePair>> getEntries() {
            return Collections.unmodifiableSet(this.myMap.entrySet());
        }

        public void put(String outputPath, SourceUrlClassNamePair pair) {
            if (this.myStoreFile == null) {
                return;
            }
            if (pair == null) {
                this.remove(outputPath);
            } else {
                this.myMap.put(outputPath, pair);
                this.myIsDirty = true;
            }
        }

        public SourceUrlClassNamePair remove(String outputPath) {
            if (this.myStoreFile == null) {
                return null;
            }
            SourceUrlClassNamePair removed = this.myMap.remove(outputPath);
            this.myIsDirty |= removed != null;
            return removed;
        }

        void allocate() {
            this.myRefCount.incrementAndGet();
        }

        public void release() {
            if (this.myRefCount.decrementAndGet() == 0 && this.myIsDirty && this.myStoreFile != null) {
                TranslatingCompilerFilesMonitor.savePathsToDelete(this.myStoreFile, this.myMap);
            }
        }
    }

    public static final class ProjectRef
    extends Ref<Project> {
        public ProjectRef(Project project) {
            super((Object)project);
        }

        public Project get() {
            Project project = (Project)super.get();
            if (project != null && project.isDisposed()) {
                throw new ProjectClosedException();
            }
            return project;
        }

        static class ProjectClosedException
        extends RuntimeException {
            ProjectClosedException() {
            }
        }
    }

    private class ScheduleOutputsForDeletionProc
    implements Proc {
        private final String mySrcUrl;
        private final LocalFileSystem myFileSystem;
        @Nullable
        private VirtualFile myRootBeingDeleted;

        private ScheduleOutputsForDeletionProc(String srcUrl) {
            this.mySrcUrl = srcUrl;
            this.myFileSystem = LocalFileSystem.getInstance();
        }

        public void setRootBeingDeleted(@Nullable VirtualFile rootBeingDeleted) {
            this.myRootBeingDeleted = rootBeingDeleted;
        }

        @Override
        public boolean execute(int projectId, String outputPath) {
            VirtualFile outFile = this.myFileSystem.findFileByPath(outputPath);
            if (outFile != null) {
                if (this.myRootBeingDeleted != null && VfsUtil.isAncestor((VirtualFile)this.myRootBeingDeleted, (VirtualFile)outFile, (boolean)false)) {
                    TranslatingCompilerFilesMonitor.this.unmarkOutputPathForDeletion(projectId, outputPath);
                } else {
                    OutputFileInfo outputInfo = TranslatingCompilerFilesMonitor.loadOutputInfo(outFile);
                    String classname = outputInfo != null ? outputInfo.getClassName() : null;
                    TranslatingCompilerFilesMonitor.this.markOutputPathForDeletion(projectId, outputPath, classname, this.mySrcUrl);
                }
            }
            return true;
        }
    }

    private static interface Proc {
        public boolean execute(int var1, String var2);
    }

    private class MyVfsListener
    extends VirtualFileAdapter {
        private MyVfsListener() {
        }

        public void propertyChanged(@NotNull VirtualFilePropertyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener", "propertyChanged"));
            }
            if ("name".equals(event.getPropertyName())) {
                final VirtualFile eventFile = event.getFile();
                VirtualFile parent = event.getParent();
                if (parent != null) {
                    String oldName = (String)event.getOldValue();
                    final String root = parent.getPath() + "/" + oldName;
                    THashSet toMark = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                    if (eventFile.isDirectory()) {
                        VfsUtilCore.visitChildrenRecursively((VirtualFile)eventFile, (VirtualFileVisitor)new VirtualFileVisitor(new VirtualFileVisitor.Option[0], (Set)toMark){
                            private StringBuilder filePath;
                            final /* synthetic */ Set val$toMark;
                            {
                                this.val$toMark = set;
                                super(x0);
                                this.filePath = new StringBuilder(root);
                            }

                            public boolean visitFile(@NotNull VirtualFile child) {
                                if (child == null) {
                                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener$1", "visitFile"));
                                }
                                if (child.isDirectory()) {
                                    if (!Comparing.equal((Object)child, (Object)eventFile)) {
                                        this.filePath.append("/").append(child.getName());
                                    }
                                } else {
                                    String childPath = this.filePath.toString();
                                    if (!Comparing.equal((Object)child, (Object)eventFile)) {
                                        childPath = childPath + "/" + child.getName();
                                    }
                                    this.val$toMark.add(new File(childPath));
                                }
                                return true;
                            }

                            public void afterChildrenVisited(@NotNull VirtualFile file) {
                                if (file == null) {
                                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener$1", "afterChildrenVisited"));
                                }
                                if (file.isDirectory() && !Comparing.equal((Object)file, (Object)eventFile)) {
                                    this.filePath.delete(this.filePath.length() - file.getName().length() - 1, this.filePath.length());
                                }
                            }
                        });
                    } else {
                        toMark.add(new File(root));
                    }
                    TranslatingCompilerFilesMonitor.notifyFilesDeleted((Collection)toMark);
                }
                this.markDirtyIfSource(eventFile, false);
            }
        }

        public void contentsChanged(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener", "contentsChanged"));
            }
            this.markDirtyIfSource(event.getFile(), false);
        }

        public void fileCreated(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener", "fileCreated"));
            }
            this.processNewFile(event.getFile(), true);
        }

        public void fileCopied(@NotNull VirtualFileCopyEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener", "fileCopied"));
            }
            this.processNewFile(event.getFile(), true);
        }

        public void fileMoved(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener", "fileMoved"));
            }
            this.processNewFile(event.getFile(), true);
        }

        public void beforeFileDeletion(@NotNull VirtualFileEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener", "beforeFileDeletion"));
            }
            VirtualFile eventFile = event.getFile();
            if (LOG.isDebugEnabled() && eventFile.isDirectory() || ourDebugMode) {
                String message = "Processing file deletion: " + eventFile.getPresentableUrl();
                LOG.debug(message);
                if (ourDebugMode) {
                    System.out.println(message);
                }
            }
            THashSet pathsToMark = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            TranslatingCompilerFilesMonitor.processRecursively(eventFile, true, false, new FileProcessor((Set)pathsToMark, eventFile){
                private final TIntArrayList myAssociatedProjectIds = new TIntArrayList();
                final /* synthetic */ Set val$pathsToMark;
                final /* synthetic */ VirtualFile val$eventFile;
                {
                    this.val$pathsToMark = set;
                    this.val$eventFile = virtualFile;
                }

                /*
                 * WARNING - Removed try catching itself - possible behaviour change.
                 */
                @Override
                public void execute(VirtualFile file) {
                    String filePath = file.getPath();
                    this.val$pathsToMark.add(new File(filePath));
                    this.myAssociatedProjectIds.clear();
                    try {
                        TIntHashSet projects;
                        SourceFileInfo srcInfo;
                        String message;
                        OutputFileInfo outputInfo = TranslatingCompilerFilesMonitor.loadOutputInfo(file);
                        if (outputInfo != null) {
                            SourceFileInfo srcInfo2;
                            VirtualFile srcFile;
                            String srcPath = outputInfo.getSourceFilePath();
                            VirtualFile virtualFile = srcFile = srcPath != null ? LocalFileSystem.getInstance().findFileByPath(srcPath) : null;
                            if (srcFile != null && (srcInfo2 = TranslatingCompilerFilesMonitor.loadSourceInfo(srcFile)) != null) {
                                boolean srcWillBeDeleted = VfsUtil.isAncestor((VirtualFile)this.val$eventFile, (VirtualFile)srcFile, (boolean)false);
                                for (int projectId : srcInfo2.getProjectIds().toArray()) {
                                    if (TranslatingCompilerFilesMonitor.this.isSuspended(projectId) || !srcInfo2.isAssociated(projectId, filePath)) continue;
                                    this.myAssociatedProjectIds.add(projectId);
                                    if (srcWillBeDeleted) {
                                        if (LOG.isDebugEnabled() || ourDebugMode) {
                                            message = "Unschedule recompilation because of deletion " + srcFile.getPresentableUrl();
                                            LOG.debug(message);
                                            if (ourDebugMode) {
                                                System.out.println(message);
                                            }
                                        }
                                        TranslatingCompilerFilesMonitor.this.removeSourceForRecompilation(projectId, Math.abs(TranslatingCompilerFilesMonitor.getFileId(srcFile)));
                                        continue;
                                    }
                                    TranslatingCompilerFilesMonitor.this.addSourceForRecompilation(projectId, srcFile, srcInfo2);
                                }
                            }
                        }
                        if ((srcInfo = TranslatingCompilerFilesMonitor.loadSourceInfo(file)) != null && !(projects = srcInfo.getProjectIds()).isEmpty()) {
                            ScheduleOutputsForDeletionProc deletionProc = new ScheduleOutputsForDeletionProc(file.getUrl());
                            deletionProc.setRootBeingDeleted(this.val$eventFile);
                            int sourceFileId = Math.abs(TranslatingCompilerFilesMonitor.getFileId(file));
                            for (int projectId : projects.toArray()) {
                                if (TranslatingCompilerFilesMonitor.this.isSuspended(projectId)) continue;
                                if (srcInfo.isAssociated(projectId, filePath)) {
                                    this.myAssociatedProjectIds.add(projectId);
                                }
                                srcInfo.processOutputPaths(projectId, deletionProc);
                                if (LOG.isDebugEnabled() || ourDebugMode) {
                                    message = "Unschedule recompilation because of deletion " + file.getPresentableUrl();
                                    LOG.debug(message);
                                    if (ourDebugMode) {
                                        System.out.println(message);
                                    }
                                }
                                TranslatingCompilerFilesMonitor.this.removeSourceForRecompilation(projectId, sourceFileId);
                            }
                        }
                    }
                    catch (Throwable throwable) {
                        this.myAssociatedProjectIds.forEach(new TIntProcedure(filePath){
                            final /* synthetic */ String val$filePath;
                            {
                                this.val$filePath = string;
                            }

                            public boolean execute(int projectId) {
                                TranslatingCompilerFilesMonitor.this.unmarkOutputPathForDeletion(projectId, this.val$filePath);
                                return true;
                            }
                        });
                        throw throwable;
                    }
                    this.myAssociatedProjectIds.forEach(new /* invalid duplicate definition of identical inner class */);
                }
            });
            TranslatingCompilerFilesMonitor.notifyFilesDeleted((Collection)pathsToMark);
        }

        public void beforeFileMovement(@NotNull VirtualFileMoveEvent event) {
            if (event == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyVfsListener", "beforeFileMovement"));
            }
            this.markDirtyIfSource(event.getFile(), true);
        }

        private void markDirtyIfSource(VirtualFile file, boolean fromMove) {
            THashSet pathsToMark = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
            TranslatingCompilerFilesMonitor.processRecursively(file, false, false, new FileProcessor((Set)pathsToMark, fromMove){
                final /* synthetic */ Set val$pathsToMark;
                final /* synthetic */ boolean val$fromMove;
                {
                    this.val$pathsToMark = set;
                    this.val$fromMove = bl;
                }

                @Override
                public void execute(VirtualFile file) {
                    SourceFileInfo srcInfo;
                    this.val$pathsToMark.add(new File(file.getPath()));
                    SourceFileInfo sourceFileInfo = srcInfo = file.isValid() ? TranslatingCompilerFilesMonitor.loadSourceInfo(file) : null;
                    if (srcInfo != null) {
                        for (int projectId : srcInfo.getProjectIds().toArray()) {
                            if (TranslatingCompilerFilesMonitor.this.isSuspended(projectId)) {
                                if (!srcInfo.clearPaths(projectId)) continue;
                                srcInfo.updateTimestamp(projectId, -1L);
                                TranslatingCompilerFilesMonitor.saveSourceInfo(file, srcInfo);
                                continue;
                            }
                            TranslatingCompilerFilesMonitor.this.addSourceForRecompilation(projectId, file, srcInfo);
                            if (!this.val$fromMove || !srcInfo.clearPaths(projectId)) continue;
                            TranslatingCompilerFilesMonitor.saveSourceInfo(file, srcInfo);
                        }
                    } else {
                        MyVfsListener.this.processNewFile(file, false);
                    }
                }
            });
            if (fromMove) {
                TranslatingCompilerFilesMonitor.notifyFilesDeleted((Collection)pathsToMark);
            } else if (!TranslatingCompilerFilesMonitor.this.isIgnoredOrUnderIgnoredDirectory(file)) {
                TranslatingCompilerFilesMonitor.notifyFilesChanged((Collection)pathsToMark);
            }
        }

        private void processNewFile(VirtualFile file, boolean notifyServer) {
            boolean isInContent = false;
            for (Project project : TranslatingCompilerFilesMonitor.this.myProjectManager.getOpenProjects()) {
                if (!project.isInitialized()) continue;
                final int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
                ProjectFileIndex fileIndex = ProjectRootManager.getInstance((Project)project).getFileIndex();
                if (fileIndex.isInContent(file)) {
                    isInContent = true;
                }
                if (TranslatingCompilerFilesMonitor.this.isSuspended(projectId)) continue;
                if (fileIndex.isInSourceContent(file)) {
                    final TranslatingCompiler[] translators = (TranslatingCompiler[])CompilerManager.getInstance((Project)project).getCompilers(TranslatingCompiler.class);
                    TranslatingCompilerFilesMonitor.processRecursively(file, false, false, new FileProcessor(){

                        @Override
                        public void execute(VirtualFile file) {
                            if (this.isCompilable(file)) {
                                TranslatingCompilerFilesMonitor.this.loadInfoAndAddSourceForRecompilation(projectId, file);
                            }
                        }

                        boolean isCompilable(VirtualFile file) {
                            for (TranslatingCompiler translator : translators) {
                                if (!translator.isCompilableFile(file, (CompileContext)DummyCompileContext.getInstance())) continue;
                                return true;
                            }
                            return false;
                        }
                    });
                    continue;
                }
                if (!TranslatingCompilerFilesMonitor.this.belongsToIntermediateSources(file, project)) continue;
                TranslatingCompilerFilesMonitor.processRecursively(file, false, false, new FileProcessor(){

                    @Override
                    public void execute(VirtualFile file) {
                        TranslatingCompilerFilesMonitor.this.loadInfoAndAddSourceForRecompilation(projectId, file);
                    }
                });
            }
            if (notifyServer && !TranslatingCompilerFilesMonitor.this.isIgnoredOrUnderIgnoredDirectory(file)) {
                THashSet pathsToMark = new THashSet(FileUtil.FILE_HASHING_STRATEGY);
                boolean dbOnly = !isInContent;
                TranslatingCompilerFilesMonitor.processRecursively(file, dbOnly, false, new FileProcessor((Set)pathsToMark){
                    final /* synthetic */ Set val$pathsToMark;
                    {
                        this.val$pathsToMark = set;
                    }

                    @Override
                    public void execute(VirtualFile file) {
                        this.val$pathsToMark.add(new File(file.getPath()));
                    }
                });
                TranslatingCompilerFilesMonitor.notifyFilesChanged((Collection)pathsToMark);
            }
        }
    }

    private class MyProjectManagerListener
    extends ProjectManagerAdapter {
        final Map<Project, MessageBusConnection> myConnections = new HashMap<Project, MessageBusConnection>();

        private MyProjectManagerListener() {
        }

        public void projectOpened(final Project project) {
            MessageBusConnection conn = project.getMessageBus().connect();
            this.myConnections.put(project, conn);
            final ProjectRef projRef = new ProjectRef(project);
            final int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
            if (CompilerWorkspaceConfiguration.getInstance((Project)project).useOutOfProcessBuild()) {
                TranslatingCompilerFilesMonitor.this.suspendProject(project);
            } else {
                TranslatingCompilerFilesMonitor.this.watchProject(project);
            }
            conn.subscribe(ProjectTopics.PROJECT_ROOTS, (Object)new ModuleRootListener(){
                private VirtualFile[] myRootsBefore;
                private Alarm myAlarm;
                {
                    this.myAlarm = new Alarm(Alarm.ThreadToUse.SWING_THREAD, (Disposable)project);
                }

                public void beforeRootsChange(ModuleRootEvent event) {
                    if (TranslatingCompilerFilesMonitor.this.isSuspended(projectId)) {
                        return;
                    }
                    try {
                        this.myRootsBefore = ProjectRootManager.getInstance((Project)projRef.get()).getContentSourceRoots();
                    }
                    catch (ProjectRef.ProjectClosedException e) {
                        this.myRootsBefore = null;
                    }
                }

                public void rootsChanged(ModuleRootEvent event) {
                    if (TranslatingCompilerFilesMonitor.this.isSuspended(projectId)) {
                        return;
                    }
                    if (LOG.isDebugEnabled()) {
                        LOG.debug("Before roots changed for projectId=" + projectId + "; url=" + project.getPresentableUrl());
                    }
                    try {
                        Object[] rootsBefore = this.myRootsBefore;
                        this.myRootsBefore = null;
                        Object[] rootsAfter = ProjectRootManager.getInstance((Project)projRef.get()).getContentSourceRoots();
                        final HashSet newRoots = new HashSet();
                        final HashSet oldRoots = new HashSet();
                        if (rootsAfter.length > 0) {
                            ContainerUtil.addAll(newRoots, (Object[])rootsAfter);
                        }
                        if (rootsBefore != null) {
                            newRoots.removeAll(Arrays.asList(rootsBefore));
                        }
                        if (rootsBefore != null) {
                            ContainerUtil.addAll(oldRoots, (Object[])rootsBefore);
                        }
                        if (!oldRoots.isEmpty() && rootsAfter.length > 0) {
                            oldRoots.removeAll(Arrays.asList(rootsAfter));
                        }
                        this.myAlarm.cancelAllRequests();
                        this.myAlarm.addRequest(new Runnable(){

                            @Override
                            public void run() {
                                TranslatingCompilerFilesMonitor.this.startAsyncScan(projectId);
                                new Task.Backgroundable(project, CompilerBundle.message((String)"compiler.initial.scanning.progress.text", (Object[])new Object[0]), false){

                                    /*
                                     * WARNING - Removed try catching itself - possible behaviour change.
                                     */
                                    public void run(@NotNull ProgressIndicator indicator) {
                                        if (indicator == null) {
                                            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$MyProjectManagerListener$1$1$1", "run"));
                                        }
                                        try {
                                            if (newRoots.size() > 0) {
                                                TranslatingCompilerFilesMonitor.this.scanSourceContent(projRef, newRoots, newRoots.size(), true);
                                            }
                                            if (oldRoots.size() > 0) {
                                                TranslatingCompilerFilesMonitor.this.scanSourceContent(projRef, oldRoots, oldRoots.size(), false);
                                            }
                                            TranslatingCompilerFilesMonitor.this.markOldOutputRoots(projRef, (TIntObjectHashMap<Pair<Integer, Integer>>)TranslatingCompilerFilesMonitor.this.buildOutputRootsLayout(projRef));
                                        }
                                        catch (ProjectRef.ProjectClosedException projectClosedException) {
                                        }
                                        finally {
                                            TranslatingCompilerFilesMonitor.this.terminateAsyncScan(projectId, false);
                                        }
                                    }
                                }.queue();
                            }
                        }, 500, ModalityState.NON_MODAL);
                    }
                    catch (ProjectRef.ProjectClosedException e) {
                        LOG.info((Throwable)e);
                    }
                }
            });
            TranslatingCompilerFilesMonitor.this.scanSourcesForCompilableFiles(project);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void projectClosed(Project project) {
            int projectId = TranslatingCompilerFilesMonitor.getProjectId(project);
            TranslatingCompilerFilesMonitor.this.terminateAsyncScan(projectId, true);
            MessageBusConnection connection = this.myConnections.remove(project);
            if (connection != null) {
                connection.disconnect();
            }
            Object object = TranslatingCompilerFilesMonitor.this.myDataLock;
            synchronized (object) {
                TranslatingCompilerFilesMonitor.this.mySourcesToRecompile.remove(projectId);
                TranslatingCompilerFilesMonitor.this.myOutputsToDelete.remove((Object)projectId);
            }
        }
    }

    private static interface FileProcessor {
        public void execute(VirtualFile var1);
    }

    private static class SourceFileInfo {
        private TIntLongHashMap myTimestamps;
        private TIntObjectHashMap<Serializable> myProjectToOutputPathMap;

        private SourceFileInfo() {
        }

        private SourceFileInfo(@NotNull DataInput in) throws IOException {
            if (in == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$SourceFileInfo", "<init>"));
            }
            int projCount = DataInputOutputUtil.readINT((DataInput)in);
            for (int idx = 0; idx < projCount; ++idx) {
                int projectId = DataInputOutputUtil.readINT((DataInput)in);
                long stamp = DataInputOutputUtil.readTIME((DataInput)in);
                this.updateTimestamp(projectId, stamp);
                int pathsCount = DataInputOutputUtil.readINT((DataInput)in);
                for (int i = 0; i < pathsCount; ++i) {
                    int path = in.readInt();
                    this.addOutputPath(projectId, path);
                }
            }
        }

        public void save(final @NotNull DataOutput out) throws IOException {
            if (out == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/TranslatingCompilerFilesMonitor$SourceFileInfo", "save"));
            }
            int[] projects = this.getProjectIds().toArray();
            DataInputOutputUtil.writeINT((DataOutput)out, (int)projects.length);
            for (int projectId : projects) {
                Serializable value;
                DataInputOutputUtil.writeINT((DataOutput)out, (int)projectId);
                DataInputOutputUtil.writeTIME((DataOutput)out, (long)this.getTimestamp(projectId));
                Serializable serializable = value = this.myProjectToOutputPathMap != null ? (Serializable)this.myProjectToOutputPathMap.get(projectId) : null;
                if (value instanceof Integer) {
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)1);
                    out.writeInt((Integer)value);
                    continue;
                }
                if (value instanceof TIntHashSet) {
                    TIntHashSet set = (TIntHashSet)value;
                    DataInputOutputUtil.writeINT((DataOutput)out, (int)set.size());
                    final IOException[] ex = new IOException[]{null};
                    set.forEach(new TIntProcedure(){

                        public boolean execute(int value) {
                            try {
                                out.writeInt(value);
                                return true;
                            }
                            catch (IOException e) {
                                ex[0] = e;
                                return false;
                            }
                        }
                    });
                    if (ex[0] == null) continue;
                    throw ex[0];
                }
                DataInputOutputUtil.writeINT((DataOutput)out, (int)0);
            }
        }

        private void updateTimestamp(int projectId, long stamp) {
            if (stamp > 0L) {
                if (this.myTimestamps == null) {
                    this.myTimestamps = new TIntLongHashMap(1, 0.98f);
                }
                this.myTimestamps.put(projectId, stamp);
            } else if (this.myTimestamps != null) {
                this.myTimestamps.remove(projectId);
            }
        }

        TIntHashSet getProjectIds() {
            TIntHashSet result = new TIntHashSet();
            if (this.myTimestamps != null) {
                result.addAll(this.myTimestamps.keys());
            }
            if (this.myProjectToOutputPathMap != null) {
                result.addAll(this.myProjectToOutputPathMap.keys());
            }
            return result;
        }

        private void addOutputPath(int projectId, String outputPath) {
            try {
                this.addOutputPath(projectId, FSRecords.getNames().enumerate(outputPath));
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
            }
        }

        private void addOutputPath(int projectId, int outputPath) {
            if (this.myProjectToOutputPathMap == null) {
                this.myProjectToOutputPathMap = new TIntObjectHashMap(1, 0.98f);
                this.myProjectToOutputPathMap.put(projectId, (Object)outputPath);
            } else {
                Object val = this.myProjectToOutputPathMap.get(projectId);
                if (val == null) {
                    this.myProjectToOutputPathMap.put(projectId, (Object)outputPath);
                } else {
                    TIntHashSet set;
                    if (val instanceof Integer) {
                        set = new TIntHashSet();
                        set.add(((Integer)val).intValue());
                        this.myProjectToOutputPathMap.put(projectId, (Object)set);
                    } else {
                        assert (val instanceof TIntHashSet);
                        set = (TIntHashSet)val;
                    }
                    set.add(outputPath);
                }
            }
        }

        public boolean clearPaths(int projectId) {
            if (this.myProjectToOutputPathMap != null) {
                Serializable removed = (Serializable)this.myProjectToOutputPathMap.remove(projectId);
                return removed != null;
            }
            return false;
        }

        long getTimestamp(int projectId) {
            return this.myTimestamps == null ? -1L : this.myTimestamps.get(projectId);
        }

        void processOutputPaths(final int projectId, final Proc proc) {
            if (this.myProjectToOutputPathMap != null) {
                try {
                    final PersistentStringEnumerator symtable = FSRecords.getNames();
                    Object val = this.myProjectToOutputPathMap.get(projectId);
                    if (val instanceof Integer) {
                        proc.execute(projectId, symtable.valueOf(((Integer)val).intValue()));
                    } else if (val instanceof TIntHashSet) {
                        ((TIntHashSet)val).forEach(new TIntProcedure(){

                            public boolean execute(int value) {
                                try {
                                    proc.execute(projectId, symtable.valueOf(value));
                                    return true;
                                }
                                catch (IOException e) {
                                    LOG.info((Throwable)e);
                                    return false;
                                }
                            }
                        });
                    }
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
        }

        boolean isAssociated(int projectId, String outputPath) {
            if (this.myProjectToOutputPathMap != null) {
                try {
                    Object val = this.myProjectToOutputPathMap.get(projectId);
                    if (val instanceof Integer) {
                        return FileUtil.pathsEqual((String)outputPath, (String)FSRecords.getNames().valueOf(((Integer)val).intValue()));
                    }
                    if (val instanceof TIntHashSet) {
                        int _outputPath = FSRecords.getNames().enumerate(outputPath);
                        return ((TIntHashSet)val).contains(_outputPath);
                    }
                }
                catch (IOException e) {
                    LOG.info((Throwable)e);
                }
            }
            return false;
        }
    }

    private static class OutputFileInfo {
        private final int mySourcePath;
        private final int myClassName;

        OutputFileInfo(String sourcePath, @Nullable String className) throws IOException {
            PersistentStringEnumerator symtable = FSRecords.getNames();
            this.mySourcePath = symtable.enumerate(sourcePath);
            this.myClassName = className != null ? symtable.enumerate(className) : -1;
        }

        OutputFileInfo(DataInput in) throws IOException {
            this.mySourcePath = in.readInt();
            this.myClassName = in.readInt();
        }

        String getSourceFilePath() {
            try {
                return FSRecords.getNames().valueOf(this.mySourcePath);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }

        @Nullable
        public String getClassName() {
            try {
                return this.myClassName < 0 ? null : FSRecords.getNames().valueOf(this.myClassName);
            }
            catch (IOException e) {
                LOG.info((Throwable)e);
                return null;
            }
        }

        public void save(DataOutput out) throws IOException {
            out.writeInt(this.mySourcePath);
            out.writeInt(this.myClassName);
        }
    }
}

