/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.impl.FileIndexCompileScope;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.FileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.io.FileUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import org.jetbrains.annotations.NotNull;

public class ProjectCompileScope
extends FileIndexCompileScope {
    private final Project myProject;

    public ProjectCompileScope(Project project) {
        this.myProject = project;
    }

    @Override
    protected FileIndex[] getFileIndices() {
        return new FileIndex[]{ProjectRootManager.getInstance((Project)this.myProject).getFileIndex()};
    }

    public boolean belongs(String url) {
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file != null) {
            for (FileIndex index : this.getFileIndices()) {
                if (!index.isInSourceContent(file)) continue;
                return true;
            }
        } else {
            for (VirtualFile root : ProjectRootManager.getInstance((Project)this.myProject).getContentSourceRoots()) {
                String rootUrl = root.getUrl();
                if (!FileUtil.startsWith((String)url, (String)(rootUrl.endsWith("/") ? rootUrl : rootUrl + "/"))) continue;
                return true;
            }
        }
        return false;
    }

    @NotNull
    public Module[] getAffectedModules() {
        Module[] moduleArray = ModuleManager.getInstance((Project)this.myProject).getModules();
        if (moduleArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/ProjectCompileScope", "getAffectedModules"));
        }
        return moduleArray;
    }
}

