/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.CompilerConfiguration;
import com.intellij.compiler.CompilerMessageImpl;
import com.intellij.compiler.CompilerWorkspaceConfiguration;
import com.intellij.compiler.ProblemsView;
import com.intellij.compiler.impl.CompositeScope;
import com.intellij.compiler.impl.ProjectCompileScope;
import com.intellij.compiler.impl.TranslatingCompilerFilesMonitor;
import com.intellij.compiler.make.DependencyCache;
import com.intellij.compiler.progress.CompilerTask;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.compiler.CompileContext;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerManager;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.CompilerPaths;
import com.intellij.openapi.compiler.SourceGeneratingCompiler;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleManager;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.CompilerModuleExtension;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.ProjectFileIndex;
import com.intellij.openapi.roots.ProjectRootManager;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.Pair;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.openapi.vfs.VfsUtil;
import com.intellij.openapi.vfs.VfsUtilCore;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.openapi.vfs.VirtualFileManager;
import com.intellij.pom.Navigatable;
import com.intellij.util.containers.HashMap;
import com.intellij.util.containers.OrderedSet;
import com.intellij.util.indexing.FileBasedIndex;
import gnu.trove.TIntHashSet;
import java.io.File;
import java.util.Collection;
import java.util.Collections;
import java.util.EnumMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompileContextImpl
extends UserDataHolderBase
implements CompileContextEx {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.compiler.impl.CompileContextImpl");
    private final Project myProject;
    private final CompilerTask myTask;
    private final Map<CompilerMessageCategory, Collection<CompilerMessage>> myMessages = new EnumMap<CompilerMessageCategory, Collection<CompilerMessage>>(CompilerMessageCategory.class);
    private final boolean myShouldUpdateProblemsView;
    private CompileScope myCompileScope;
    private final DependencyCache myDependencyCache;
    private final boolean myMake;
    private final boolean myIsRebuild;
    private final boolean myIsAnnotationProcessorsEnabled;
    private boolean myRebuildRequested = false;
    private String myRebuildReason;
    private final Map<VirtualFile, Module> myRootToModuleMap = new HashMap();
    private final Map<Module, Set<VirtualFile>> myModuleToRootsMap = new HashMap();
    private final Map<VirtualFile, Pair<SourceGeneratingCompiler, Module>> myOutputRootToSourceGeneratorMap = new HashMap();
    private final Set<VirtualFile> myGeneratedTestRoots = new HashSet<VirtualFile>();
    private VirtualFile[] myOutputDirectories;
    private Set<VirtualFile> myTestOutputDirectories;
    private final TIntHashSet myGeneratedSources = new TIntHashSet();
    private final ProjectFileIndex myProjectFileIndex;
    private final ProjectCompileScope myProjectCompileScope;
    private final long myStartCompilationStamp;
    private final UUID mySessionId = UUID.randomUUID();
    private final Map<Module, VirtualFile[]> myModuleToRootsCache = new HashMap();

    public CompileContextImpl(Project project, CompilerTask compilerSession, CompileScope compileScope, DependencyCache dependencyCache, boolean isMake, boolean isRebuild) {
        this.myProject = project;
        this.myTask = compilerSession;
        this.myCompileScope = compileScope;
        this.myDependencyCache = dependencyCache;
        this.myMake = isMake;
        this.myIsRebuild = isRebuild;
        this.myStartCompilationStamp = System.currentTimeMillis();
        this.myProjectFileIndex = ProjectRootManager.getInstance((Project)this.myProject).getFileIndex();
        this.myProjectCompileScope = new ProjectCompileScope(this.myProject);
        this.myIsAnnotationProcessorsEnabled = CompilerConfiguration.getInstance((Project)project).isAnnotationProcessorsEnabled();
        if (compilerSession != null) {
            compilerSession.setContentIdKey((Key)compileScope.getUserData(CompilerManager.CONTENT_ID_KEY));
        }
        this.recalculateOutputDirs();
        CompilerWorkspaceConfiguration workspaceConfig = CompilerWorkspaceConfiguration.getInstance((Project)this.myProject);
        this.myShouldUpdateProblemsView = workspaceConfig.useOutOfProcessBuild() && workspaceConfig.MAKE_PROJECT_ON_SAVE;
    }

    public boolean shouldUpdateProblemsView() {
        return this.myShouldUpdateProblemsView;
    }

    @Override
    public void recalculateOutputDirs() {
        Module[] allModules = ModuleManager.getInstance((Project)this.myProject).getModules();
        OrderedSet allDirs = new OrderedSet();
        HashSet<VirtualFile> testOutputDirs = new HashSet<VirtualFile>();
        HashSet<VirtualFile> productionOutputDirs = new HashSet<VirtualFile>();
        for (Module module : allModules) {
            VirtualFile testsOutput;
            CompilerModuleExtension manager = CompilerModuleExtension.getInstance((Module)module);
            VirtualFile output = manager.getCompilerOutputPath();
            if (output != null && output.isValid()) {
                allDirs.add(output);
                productionOutputDirs.add(output);
            }
            if ((testsOutput = manager.getCompilerOutputPathForTests()) == null || !testsOutput.isValid()) continue;
            allDirs.add(testsOutput);
            testOutputDirs.add(testsOutput);
        }
        this.myOutputDirectories = VfsUtil.toVirtualFileArray((Collection)allDirs);
        testOutputDirs.removeAll(productionOutputDirs);
        this.myTestOutputDirectories = Collections.unmodifiableSet(testOutputDirs);
    }

    @Override
    public void markGenerated(Collection<VirtualFile> files) {
        for (VirtualFile file : files) {
            this.myGeneratedSources.add(FileBasedIndex.getFileId((VirtualFile)file));
        }
    }

    @Override
    public long getStartCompilationStamp() {
        return this.myStartCompilationStamp;
    }

    @Override
    public boolean isGenerated(VirtualFile file) {
        String procGenRoot;
        if (this.myGeneratedSources.contains(FileBasedIndex.getFileId((VirtualFile)file))) {
            return true;
        }
        if (VfsUtilCore.isUnder((VirtualFile)file, this.myRootToModuleMap.keySet())) {
            return true;
        }
        Module module = this.getModuleByFile(file);
        return module != null && (procGenRoot = CompilerPaths.getAnnotationProcessorsGenerationPath((Module)module)) != null && VfsUtil.isAncestor((File)new File(procGenRoot), (File)new File(file.getPath()), (boolean)true);
    }

    public Project getProject() {
        return this.myProject;
    }

    @Override
    public DependencyCache getDependencyCache() {
        return this.myDependencyCache;
    }

    public CompilerMessage[] getMessages(CompilerMessageCategory category) {
        Collection<CompilerMessage> collection = this.myMessages.get(category);
        if (collection == null) {
            return CompilerMessage.EMPTY_ARRAY;
        }
        return collection.toArray(new CompilerMessage[collection.size()]);
    }

    public void addMessage(CompilerMessageCategory category, String message, String url, int lineNum, int columnNum) {
        CompilerMessageImpl msg = new CompilerMessageImpl(this.myProject, category, message, this.findPresentableFileForMessage(url), lineNum, columnNum, null);
        this.addMessage(msg);
    }

    public void addMessage(CompilerMessageCategory category, String message, String url, int lineNum, int columnNum, Navigatable navigatable) {
        CompilerMessageImpl msg = new CompilerMessageImpl(this.myProject, category, message, this.findPresentableFileForMessage(url), lineNum, columnNum, navigatable);
        this.addMessage(msg);
    }

    @Nullable
    private VirtualFile findPresentableFileForMessage(@Nullable String url) {
        final VirtualFile file = CompileContextImpl.findFileByUrl(url);
        if (file == null) {
            return null;
        }
        return (VirtualFile)ApplicationManager.getApplication().runReadAction((Computable)new Computable<VirtualFile>(){

            public VirtualFile compute() {
                if (file.isValid()) {
                    for (Map.Entry entry : CompileContextImpl.this.myOutputRootToSourceGeneratorMap.entrySet()) {
                        VirtualFile root = (VirtualFile)entry.getKey();
                        if (!VfsUtilCore.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
                        Pair pair = (Pair)entry.getValue();
                        VirtualFile presentableFile = ((SourceGeneratingCompiler)pair.getFirst()).getPresentableFile((CompileContext)CompileContextImpl.this, (Module)pair.getSecond(), root, file);
                        return presentableFile != null ? presentableFile : file;
                    }
                }
                return file;
            }
        });
    }

    @Nullable
    private static VirtualFile findFileByUrl(@Nullable String url) {
        if (url == null) {
            return null;
        }
        VirtualFile file = VirtualFileManager.getInstance().findFileByUrl(url);
        if (file == null) {
            return VirtualFileManager.getInstance().refreshAndFindFileByUrl(url);
        }
        return file;
    }

    @Override
    public void addMessage(CompilerMessage msg) {
        Collection<CompilerMessage> messages;
        if (ApplicationManager.getApplication().isUnitTestMode()) {
            LOG.info("addMessage: " + msg + " this=" + this);
        }
        if ((messages = this.myMessages.get(msg.getCategory())) == null) {
            messages = new LinkedHashSet<CompilerMessage>();
            this.myMessages.put(msg.getCategory(), messages);
        }
        if (messages.add(msg)) {
            this.myTask.addMessage(msg);
        }
        if (this.myShouldUpdateProblemsView && msg.getCategory() == CompilerMessageCategory.ERROR) {
            ProblemsView.SERVICE.getInstance(this.myProject).addMessage(msg, this.mySessionId);
        }
    }

    public int getMessageCount(CompilerMessageCategory category) {
        if (category != null) {
            Collection<CompilerMessage> collection = this.myMessages.get(category);
            return collection != null ? collection.size() : 0;
        }
        int count = 0;
        for (Collection<CompilerMessage> collection : this.myMessages.values()) {
            if (collection == null) continue;
            count += collection.size();
        }
        return count;
    }

    public CompileScope getCompileScope() {
        return this.myCompileScope;
    }

    public CompileScope getProjectCompileScope() {
        return this.myProjectCompileScope;
    }

    public void requestRebuildNextTime(String message) {
        if (!this.myRebuildRequested) {
            boolean isOutOfProcessBuild;
            this.myRebuildRequested = true;
            this.myRebuildReason = message;
            boolean bl = isOutOfProcessBuild = this.myDependencyCache == null;
            if (!isOutOfProcessBuild) {
                this.addMessage(CompilerMessageCategory.ERROR, message, null, -1, -1);
            }
        }
    }

    public boolean isRebuildRequested() {
        return this.myRebuildRequested;
    }

    @Nullable
    public String getRebuildReason() {
        return this.myRebuildReason;
    }

    public ProgressIndicator getProgressIndicator() {
        return this.myTask.getIndicator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void assignModule(@NotNull VirtualFile root, @NotNull Module module, boolean isTestSource, @Nullable Compiler compiler) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompileContextImpl", "assignModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/compiler/impl/CompileContextImpl", "assignModule"));
        }
        try {
            this.myRootToModuleMap.put(root, module);
            com.intellij.util.containers.HashSet set = this.myModuleToRootsMap.get(module);
            if (set == null) {
                set = new com.intellij.util.containers.HashSet();
                this.myModuleToRootsMap.put(module, (Set<VirtualFile>)set);
            }
            set.add((VirtualFile)root);
            if (isTestSource) {
                this.myGeneratedTestRoots.add(root);
            }
            if (compiler instanceof SourceGeneratingCompiler) {
                this.myOutputRootToSourceGeneratorMap.put(root, (Pair<SourceGeneratingCompiler, Module>)new Pair((Object)((SourceGeneratingCompiler)compiler), (Object)module));
            }
        }
        finally {
            this.myModuleToRootsCache.remove(module);
        }
    }

    @Override
    @Nullable
    public VirtualFile getSourceFileByOutputFile(VirtualFile outputFile) {
        return TranslatingCompilerFilesMonitor.getSourceFileByOutput(outputFile);
    }

    public Module getModuleByFile(VirtualFile file) {
        Module module = this.myProjectFileIndex.getModuleForFile(file);
        if (module != null) {
            LOG.assertTrue(!module.isDisposed());
            return module;
        }
        for (VirtualFile root : this.myRootToModuleMap.keySet()) {
            if (!VfsUtil.isAncestor((VirtualFile)root, (VirtualFile)file, (boolean)false)) continue;
            Module mod = this.myRootToModuleMap.get(root);
            if (mod != null) {
                LOG.assertTrue(!mod.isDisposed());
            }
            return mod;
        }
        return null;
    }

    public VirtualFile[] getSourceRoots(Module module) {
        VirtualFile[] cachedRoots = this.myModuleToRootsCache.get(module);
        if (cachedRoots != null) {
            if (CompileContextImpl.areFilesValid(cachedRoots)) {
                return cachedRoots;
            }
            this.myModuleToRootsCache.remove(module);
        }
        Set<VirtualFile> additionalRoots = this.myModuleToRootsMap.get(module);
        VirtualFile[] moduleRoots = ModuleRootManager.getInstance((Module)module).getSourceRoots();
        if (additionalRoots == null || additionalRoots.isEmpty()) {
            this.myModuleToRootsCache.put(module, moduleRoots);
            return moduleRoots;
        }
        VirtualFile[] allRoots = new VirtualFile[additionalRoots.size() + moduleRoots.length];
        System.arraycopy(moduleRoots, 0, allRoots, 0, moduleRoots.length);
        int index = moduleRoots.length;
        for (VirtualFile additionalRoot : additionalRoots) {
            allRoots[index++] = additionalRoot;
        }
        this.myModuleToRootsCache.put(module, allRoots);
        return allRoots;
    }

    private static boolean areFilesValid(VirtualFile[] files) {
        for (VirtualFile file : files) {
            if (file.isValid()) continue;
            return false;
        }
        return true;
    }

    public VirtualFile[] getAllOutputDirectories() {
        return this.myOutputDirectories;
    }

    @Override
    @NotNull
    public Set<VirtualFile> getTestOutputDirectories() {
        Set<VirtualFile> set = this.myTestOutputDirectories;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompileContextImpl", "getTestOutputDirectories"));
        }
        return set;
    }

    public VirtualFile getModuleOutputDirectory(Module module) {
        return CompilerPaths.getModuleOutputDirectory((Module)module, (boolean)false);
    }

    public VirtualFile getModuleOutputDirectoryForTests(Module module) {
        return CompilerPaths.getModuleOutputDirectory((Module)module, (boolean)true);
    }

    public boolean isMake() {
        return this.myMake;
    }

    public boolean isRebuild() {
        return this.myIsRebuild;
    }

    public boolean isAnnotationProcessorsEnabled() {
        return this.myIsAnnotationProcessorsEnabled;
    }

    @Override
    public void addScope(CompileScope additionalScope) {
        this.myCompileScope = new CompositeScope(this.myCompileScope, additionalScope);
    }

    @Override
    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompileContextImpl", "isInTestSourceContent"));
        }
        if (this.myProjectFileIndex.isInTestSourceContent(fileOrDir)) {
            return true;
        }
        return VfsUtilCore.isUnder((VirtualFile)fileOrDir, this.myGeneratedTestRoots);
    }

    @Override
    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompileContextImpl", "isInSourceContent"));
        }
        if (this.myProjectFileIndex.isInSourceContent(fileOrDir)) {
            return true;
        }
        return VfsUtilCore.isUnder((VirtualFile)fileOrDir, this.myRootToModuleMap.keySet());
    }

    public UUID getSessionId() {
        return this.mySessionId;
    }
}

