/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.impl;

import com.intellij.compiler.make.DependencyCache;
import com.intellij.openapi.compiler.CompileScope;
import com.intellij.openapi.compiler.Compiler;
import com.intellij.openapi.compiler.CompilerMessage;
import com.intellij.openapi.compiler.CompilerMessageCategory;
import com.intellij.openapi.compiler.ex.CompileContextEx;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.Navigatable;
import java.util.Collection;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CompileContextExProxy
implements CompileContextEx {
    private final CompileContextEx myDelegate;

    public CompileContextExProxy(CompileContextEx delegate) {
        this.myDelegate = delegate;
    }

    public Project getProject() {
        return this.myDelegate.getProject();
    }

    @Override
    public DependencyCache getDependencyCache() {
        return this.myDelegate.getDependencyCache();
    }

    @Override
    public VirtualFile getSourceFileByOutputFile(VirtualFile outputFile) {
        return this.myDelegate.getSourceFileByOutputFile(outputFile);
    }

    @Override
    public void addMessage(CompilerMessage message) {
        this.myDelegate.addMessage(message);
    }

    @Override
    @NotNull
    public Set<VirtualFile> getTestOutputDirectories() {
        Set<VirtualFile> set = this.myDelegate.getTestOutputDirectories();
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/compiler/impl/CompileContextExProxy", "getTestOutputDirectories"));
        }
        return set;
    }

    @Override
    public boolean isInTestSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompileContextExProxy", "isInTestSourceContent"));
        }
        return this.myDelegate.isInTestSourceContent(fileOrDir);
    }

    @Override
    public boolean isInSourceContent(@NotNull VirtualFile fileOrDir) {
        if (fileOrDir == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompileContextExProxy", "isInSourceContent"));
        }
        return this.myDelegate.isInSourceContent(fileOrDir);
    }

    @Override
    public void addScope(CompileScope additionalScope) {
        this.myDelegate.addScope(additionalScope);
    }

    public void addMessage(CompilerMessageCategory category, String message, @Nullable String url, int lineNum, int columnNum) {
        this.myDelegate.addMessage(category, message, url, lineNum, columnNum);
    }

    public void addMessage(CompilerMessageCategory category, String message, @Nullable String url, int lineNum, int columnNum, Navigatable navigatable) {
        this.myDelegate.addMessage(category, message, url, lineNum, columnNum, navigatable);
    }

    public CompilerMessage[] getMessages(CompilerMessageCategory category) {
        return this.myDelegate.getMessages(category);
    }

    public int getMessageCount(CompilerMessageCategory category) {
        return this.myDelegate.getMessageCount(category);
    }

    public ProgressIndicator getProgressIndicator() {
        return this.myDelegate.getProgressIndicator();
    }

    public CompileScope getCompileScope() {
        return this.myDelegate.getCompileScope();
    }

    public CompileScope getProjectCompileScope() {
        return this.myDelegate.getProjectCompileScope();
    }

    public void requestRebuildNextTime(String message) {
        this.myDelegate.requestRebuildNextTime(message);
    }

    public boolean isRebuildRequested() {
        return this.myDelegate.isRebuildRequested();
    }

    @Nullable
    public String getRebuildReason() {
        return this.myDelegate.getRebuildReason();
    }

    public Module getModuleByFile(VirtualFile file) {
        return this.myDelegate.getModuleByFile(file);
    }

    public VirtualFile[] getSourceRoots(Module module) {
        return this.myDelegate.getSourceRoots(module);
    }

    public VirtualFile[] getAllOutputDirectories() {
        return this.myDelegate.getAllOutputDirectories();
    }

    public VirtualFile getModuleOutputDirectory(Module module) {
        return this.myDelegate.getModuleOutputDirectory(module);
    }

    public VirtualFile getModuleOutputDirectoryForTests(Module module) {
        return this.myDelegate.getModuleOutputDirectoryForTests(module);
    }

    public boolean isMake() {
        return this.myDelegate.isMake();
    }

    public boolean isAnnotationProcessorsEnabled() {
        return this.myDelegate.isAnnotationProcessorsEnabled();
    }

    public boolean isRebuild() {
        return this.myDelegate.isRebuild();
    }

    public <T> T getUserData(@NotNull Key<T> key) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompileContextExProxy", "getUserData"));
        }
        return (T)this.myDelegate.getUserData(key);
    }

    public <T> void putUserData(@NotNull Key<T> key, T value) {
        if (key == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompileContextExProxy", "putUserData"));
        }
        this.myDelegate.putUserData(key, value);
    }

    @Override
    public void recalculateOutputDirs() {
        this.myDelegate.recalculateOutputDirs();
    }

    @Override
    public void markGenerated(Collection<VirtualFile> files) {
        this.myDelegate.markGenerated(files);
    }

    @Override
    public boolean isGenerated(VirtualFile file) {
        return this.myDelegate.isGenerated(file);
    }

    @Override
    public long getStartCompilationStamp() {
        return this.myDelegate.getStartCompilationStamp();
    }

    @Override
    public void assignModule(@NotNull VirtualFile root, @NotNull Module module, boolean isTestSource, Compiler compiler) {
        if (root == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/compiler/impl/CompileContextExProxy", "assignModule"));
        }
        if (module == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/compiler/impl/CompileContextExProxy", "assignModule"));
        }
        this.myDelegate.assignModule(root, module, isTestSource, compiler);
    }
}

