/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classParsing;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import org.jetbrains.annotations.NonNls;

public class ReferenceInfo {
    private final int myClassName;

    public ReferenceInfo(int declaringClassName) {
        this.myClassName = declaringClassName;
    }

    public ReferenceInfo(DataInput in) throws IOException {
        this(in.readInt());
    }

    @NonNls
    public String toString() {
        return "Class reference[class name=" + String.valueOf(this.getClassName()) + "]";
    }

    public void save(DataOutput out) throws IOException {
        out.writeInt(this.myClassName);
    }

    public int getClassName() {
        return this.myClassName;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferenceInfo that = (ReferenceInfo)o;
        return this.myClassName == that.myClassName;
    }

    public int hashCode() {
        return this.myClassName;
    }
}

