/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.compiler.classParsing;

import com.intellij.compiler.classParsing.AnnotationNameValuePair;
import com.intellij.compiler.classParsing.ConstantValue;
import com.intellij.compiler.classParsing.MemberInfoExternalizer;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;

public class AnnotationConstantValue
extends ConstantValue {
    public static final AnnotationConstantValue[] EMPTY_ARRAY = new AnnotationConstantValue[0];
    public static final AnnotationConstantValue[][] EMPTY_ARRAY_ARRAY = new AnnotationConstantValue[0][];
    public final int myQName;
    public final AnnotationNameValuePair[] myMemberValues;

    public AnnotationConstantValue(int qName, AnnotationNameValuePair[] memberValues) {
        this.myQName = qName;
        this.myMemberValues = memberValues;
    }

    public int getAnnotationQName() {
        return this.myQName;
    }

    public AnnotationNameValuePair[] getMemberValues() {
        return this.myMemberValues;
    }

    public AnnotationConstantValue(DataInput in) throws IOException {
        this.myQName = in.readInt();
        int size = in.readInt();
        this.myMemberValues = new AnnotationNameValuePair[size];
        for (int idx = 0; idx < this.myMemberValues.length; ++idx) {
            int name = in.readInt();
            ConstantValue constantValue = MemberInfoExternalizer.loadConstantValue(in);
            this.myMemberValues[idx] = new AnnotationNameValuePair(name, constantValue);
        }
    }

    @Override
    public void save(DataOutput out) throws IOException {
        out.writeInt(this.myQName);
        out.writeInt(this.myMemberValues.length);
        for (int idx = 0; idx < this.myMemberValues.length; ++idx) {
            AnnotationNameValuePair nameValuePair = this.myMemberValues[idx];
            out.writeInt(nameValuePair.getName());
            MemberInfoExternalizer.saveConstantValue(out, nameValuePair.getValue());
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof AnnotationConstantValue)) {
            return false;
        }
        AnnotationConstantValue annotationConstantValue = (AnnotationConstantValue)o;
        if (this.myQName != annotationConstantValue.myQName) {
            return false;
        }
        return Arrays.equals(this.myMemberValues, annotationConstantValue.myMemberValues);
    }

    public int hashCode() {
        return this.myQName;
    }
}

