/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.wrongPackageStatement;

import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaDirectoryService;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDirectory;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiPackage;
import com.intellij.psi.PsiPackageStatement;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;

public class AdjustPackageNameFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.wrongPackageStatement.AdjustPackageNameFix");
    private final String myName;

    public AdjustPackageNameFix(String targetPackage) {
        this.myName = targetPackage;
    }

    @NotNull
    public String getName() {
        String string = QuickFixBundle.message("adjust.package.text", this.myName);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/wrongPackageStatement/AdjustPackageNameFix", "getName"));
        }
        return string;
    }

    @NotNull
    public String getFamilyName() {
        String string = QuickFixBundle.message("adjust.package.family", new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/wrongPackageStatement/AdjustPackageNameFix", "getFamilyName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/wrongPackageStatement/AdjustPackageNameFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/wrongPackageStatement/AdjustPackageNameFix", "applyFix"));
        }
        PsiElement element = descriptor.getPsiElement();
        if (element == null) {
            return;
        }
        PsiFile myFile = element.getContainingFile();
        if (!FileModificationService.getInstance().prepareFileForWrite(myFile)) {
            return;
        }
        PsiDirectory directory = myFile.getContainingDirectory();
        if (directory == null) {
            return;
        }
        PsiPackage myTargetPackage = JavaDirectoryService.getInstance().getPackage(directory);
        if (myTargetPackage == null) {
            return;
        }
        try {
            PsiElementFactory factory = JavaPsiFacade.getInstance((Project)myFile.getProject()).getElementFactory();
            PsiPackageStatement myStatement = ((PsiJavaFile)myFile).getPackageStatement();
            if (myTargetPackage.getQualifiedName().length() == 0) {
                if (myStatement != null) {
                    myStatement.delete();
                }
            } else {
                PsiPackageStatement packageStatement = factory.createPackageStatement(myTargetPackage.getQualifiedName());
                if (myStatement != null) {
                    myStatement.getPackageReference().replace((PsiElement)packageStatement.getPackageReference());
                } else {
                    myFile.addAfter((PsiElement)packageStatement, null);
                }
            }
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

