/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.util;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.util.Processor;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class SpecialAnnotationsUtilBase {
    public static LocalQuickFix createAddToSpecialAnnotationsListQuickFix(final @NotNull String text, final @NotNull String family, final @NotNull List<String> targetList, final @NotNull String qualifiedName, PsiElement context) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "createAddToSpecialAnnotationsListQuickFix"));
        }
        if (family == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "createAddToSpecialAnnotationsListQuickFix"));
        }
        if (targetList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "createAddToSpecialAnnotationsListQuickFix"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "createAddToSpecialAnnotationsListQuickFix"));
        }
        return new LocalQuickFix(){

            @NotNull
            public String getName() {
                String string = text;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase$1", "getName"));
                }
                return string;
            }

            @NotNull
            public String getFamilyName() {
                String string = family;
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase$1", "getFamilyName"));
                }
                return string;
            }

            public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
                if (project == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase$1", "applyFix"));
                }
                if (descriptor == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase$1", "applyFix"));
                }
                SpecialAnnotationsUtilBase.doQuickFixInternal(project, targetList, qualifiedName);
            }
        };
    }

    static void doQuickFixInternal(@NotNull Project project, @NotNull List<String> targetList, @NotNull String qualifiedName) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "doQuickFixInternal"));
        }
        if (targetList == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "doQuickFixInternal"));
        }
        if (qualifiedName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "doQuickFixInternal"));
        }
        targetList.add(qualifiedName);
        Collections.sort(targetList);
        InspectionProfile inspectionProfile = InspectionProjectProfileManager.getInstance(project).getInspectionProfile();
        InspectionProfileManager.getInstance().fireProfileChanged((Profile)inspectionProfile);
    }

    public static void createAddToSpecialAnnotationFixes(@NotNull PsiModifierListOwner owner, @NotNull Processor<String> processor) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "createAddToSpecialAnnotationFixes"));
        }
        if (processor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/util/SpecialAnnotationsUtilBase", "createAddToSpecialAnnotationFixes"));
        }
        PsiModifierList modifierList = owner.getModifierList();
        if (modifierList != null) {
            PsiAnnotation psiAnnotation;
            String name;
            PsiAnnotation[] psiAnnotations;
            PsiAnnotation[] arr$ = psiAnnotations = modifierList.getAnnotations();
            int len$ = arr$.length;
            for (int i$ = 0; i$ < len$ && ((name = (psiAnnotation = arr$[i$]).getQualifiedName()) == null || name.startsWith("java.") || name.startsWith("javax.") || name.startsWith("org.jetbrains.") && AnnotationUtil.isJetbrainsAnnotation((String)StringUtil.getShortName((String)name)) || processor.process((Object)name)); ++i$) {
            }
        }
    }
}

