/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.unnecessaryModuleDependency;

import com.intellij.analysis.AnalysisScope;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.GlobalInspectionContext;
import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.QuickFix;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefGraphAnnotator;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefModule;
import com.intellij.codeInspection.unnecessaryModuleDependency.UnnecessaryModuleDependencyAnnotator;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.roots.ModifiableRootModel;
import com.intellij.openapi.roots.ModuleOrderEntry;
import com.intellij.openapi.roots.ModuleRootManager;
import com.intellij.openapi.roots.OrderEntry;
import com.intellij.openapi.util.Comparing;
import java.util.ArrayList;
import java.util.Set;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class UnnecessaryModuleDependencyInspection
extends GlobalInspectionTool {
    public RefGraphAnnotator getAnnotator(@NotNull RefManager refManager) {
        if (refManager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "getAnnotator"));
        }
        return new UnnecessaryModuleDependencyAnnotator(refManager);
    }

    public CommonProblemDescriptor[] checkElement(@NotNull RefEntity refEntity, @NotNull AnalysisScope scope, @NotNull InspectionManager manager, @NotNull GlobalInspectionContext globalContext) {
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "checkElement"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "checkElement"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "checkElement"));
        }
        if (globalContext == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "checkElement"));
        }
        if (refEntity instanceof RefModule) {
            RefModule refModule = (RefModule)refEntity;
            Module module = refModule.getModule();
            if (module.isDisposed()) {
                return CommonProblemDescriptor.EMPTY_ARRAY;
            }
            Module[] declaredDependencies = ModuleRootManager.getInstance((Module)module).getDependencies();
            ArrayList<CommonProblemDescriptor> descriptors = new ArrayList<CommonProblemDescriptor>();
            Set modules = (Set)refModule.getUserData(UnnecessaryModuleDependencyAnnotator.DEPENDENCIES);
            for (Module dependency : declaredDependencies) {
                CommonProblemDescriptor problemDescriptor;
                if (modules != null && modules.contains(dependency)) continue;
                if (scope.containsModule(dependency)) {
                    problemDescriptor = manager.createProblemDescriptor(InspectionsBundle.message((String)"unnecessary.module.dependency.problem.descriptor", (Object[])new Object[]{module.getName(), dependency.getName()}), new QuickFix[]{new RemoveModuleDependencyFix(module, dependency)});
                } else {
                    String message = InspectionsBundle.message((String)"suspected.module.dependency.problem.descriptor", (Object[])new Object[]{module.getName(), dependency.getName(), scope.getDisplayName(), dependency.getName()});
                    problemDescriptor = manager.createProblemDescriptor(message, new QuickFix[0]);
                }
                descriptors.add(problemDescriptor);
            }
            return descriptors.isEmpty() ? null : descriptors.toArray(new CommonProblemDescriptor[descriptors.size()]);
        }
        return null;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.DECLARATION_REDUNDANCY;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"unnecessary.module.dependency.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("UnnecessaryModuleDependencyInspection" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection", "getShortName"));
        }
        return "UnnecessaryModuleDependencyInspection";
    }

    public static class RemoveModuleDependencyFix
    implements QuickFix {
        private final Module myModule;
        private final Module myDependency;

        public RemoveModuleDependencyFix(Module module, Module dependency) {
            this.myModule = module;
            this.myDependency = dependency;
        }

        @NotNull
        public String getName() {
            if ("Remove dependency" == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection$RemoveModuleDependencyFix", "getName"));
            }
            return "Remove dependency";
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection$RemoveModuleDependencyFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(@NotNull Project project, @NotNull CommonProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection$RemoveModuleDependencyFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/unnecessaryModuleDependency/UnnecessaryModuleDependencyInspection$RemoveModuleDependencyFix", "applyFix"));
            }
            ModifiableRootModel model = ModuleRootManager.getInstance((Module)this.myModule).getModifiableModel();
            for (OrderEntry entry : model.getOrderEntries()) {
                Module mDependency;
                if (!(entry instanceof ModuleOrderEntry) || !Comparing.equal((Object)(mDependency = ((ModuleOrderEntry)entry).getModule()), (Object)this.myDependency)) continue;
                model.removeOrderEntry(entry);
                break;
            }
            model.commit();
        }
    }
}

