/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ui;

import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemDescriptorBase;
import com.intellij.codeInspection.ProblemDescriptorUtil;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.ui.InspectionToolPresentation;
import com.intellij.codeInspection.ui.InspectionTreeNode;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.vcs.FileStatus;
import com.intellij.psi.PsiElement;
import com.intellij.xml.util.XmlStringUtil;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ProblemDescriptionNode
extends InspectionTreeNode {
    protected RefEntity myElement;
    private final CommonProblemDescriptor myDescriptor;
    protected final InspectionToolWrapper myToolWrapper;
    @NotNull
    protected final InspectionToolPresentation myPresentation;

    public ProblemDescriptionNode(@NotNull Object userObject, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation) {
        if (userObject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ui/ProblemDescriptionNode", "<init>"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ui/ProblemDescriptionNode", "<init>"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/ui/ProblemDescriptionNode", "<init>"));
        }
        this(userObject, null, null, toolWrapper, presentation);
    }

    public ProblemDescriptionNode(@NotNull RefEntity element, @NotNull CommonProblemDescriptor descriptor, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ui/ProblemDescriptionNode", "<init>"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ui/ProblemDescriptionNode", "<init>"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/ui/ProblemDescriptionNode", "<init>"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/ui/ProblemDescriptionNode", "<init>"));
        }
        this(descriptor, element, descriptor, toolWrapper, presentation);
    }

    private ProblemDescriptionNode(@NotNull Object userObject, RefEntity element, CommonProblemDescriptor descriptor, @NotNull InspectionToolWrapper toolWrapper, @NotNull InspectionToolPresentation presentation) {
        if (userObject == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ui/ProblemDescriptionNode", "<init>"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/ui/ProblemDescriptionNode", "<init>"));
        }
        if (presentation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "4", "com/intellij/codeInspection/ui/ProblemDescriptionNode", "<init>"));
        }
        super(userObject);
        this.myElement = element;
        this.myDescriptor = descriptor;
        this.myToolWrapper = toolWrapper;
        this.myPresentation = presentation;
    }

    @Nullable
    public RefEntity getElement() {
        return this.myElement;
    }

    @Nullable
    public CommonProblemDescriptor getDescriptor() {
        return this.myDescriptor;
    }

    @Override
    public Icon getIcon(boolean expanded) {
        if (this.myDescriptor instanceof ProblemDescriptorBase) {
            ProblemHighlightType problemHighlightType = ((ProblemDescriptorBase)this.myDescriptor).getHighlightType();
            if (problemHighlightType == ProblemHighlightType.ERROR) {
                return AllIcons.General.Error;
            }
            if (problemHighlightType == ProblemHighlightType.GENERIC_ERROR_OR_WARNING) {
                return AllIcons.General.Warning;
            }
        }
        return AllIcons.General.Information;
    }

    @Override
    public int getProblemCount() {
        return 1;
    }

    @Override
    public boolean isValid() {
        if (this.myElement instanceof RefElement && !this.myElement.isValid()) {
            return false;
        }
        CommonProblemDescriptor descriptor = this.getDescriptor();
        if (descriptor instanceof ProblemDescriptor) {
            PsiElement psiElement = ((ProblemDescriptor)descriptor).getPsiElement();
            return psiElement != null && psiElement.isValid();
        }
        return true;
    }

    @Override
    public boolean isResolved() {
        return this.myElement instanceof RefElement && this.getPresentation().isProblemResolved(this.myElement, this.getDescriptor());
    }

    @Override
    public void ignoreElement() {
        InspectionToolPresentation presentation = this.getPresentation();
        presentation.ignoreCurrentElementProblem(this.getElement(), this.getDescriptor());
    }

    @Override
    public void amnesty() {
        InspectionToolPresentation presentation = this.getPresentation();
        presentation.amnesty(this.getElement());
    }

    @NotNull
    private InspectionToolPresentation getPresentation() {
        InspectionToolPresentation inspectionToolPresentation = this.myPresentation;
        if (inspectionToolPresentation == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ui/ProblemDescriptionNode", "getPresentation"));
        }
        return inspectionToolPresentation;
    }

    @Override
    public FileStatus getNodeStatus() {
        if (this.myElement instanceof RefElement) {
            return this.getPresentation().getProblemStatus(this.myDescriptor);
        }
        return FileStatus.NOT_CHANGED;
    }

    @Override
    public String toString() {
        CommonProblemDescriptor descriptor = this.getDescriptor();
        if (descriptor == null) {
            return "";
        }
        PsiElement element = descriptor instanceof ProblemDescriptor ? ((ProblemDescriptor)descriptor).getPsiElement() : null;
        return XmlStringUtil.stripHtml((String)ProblemDescriptorUtil.renderDescriptionMessage(descriptor, element, 5));
    }
}

