/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.sillyAssignment;

import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.openapi.util.Comparing;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SillyAssignmentInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        if ("" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection", "getGroupDisplayName"));
        }
        return "";
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.variable.assigned.to.itself.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("SillyAssignment" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection", "getShortName"));
        }
        return "SillyAssignment";
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitAssignmentExpression(PsiAssignmentExpression expression) {
                SillyAssignmentInspection.checkSillyAssignment(expression, holder);
            }

            public void visitReferenceExpression(PsiReferenceExpression expression) {
                this.visitElement((PsiElement)expression);
            }

            public void visitVariable(PsiVariable variable) {
                PsiExpression initializer = PsiUtil.deparenthesizeExpression((PsiExpression)variable.getInitializer());
                if (initializer instanceof PsiAssignmentExpression) {
                    PsiExpression lExpr = PsiUtil.deparenthesizeExpression((PsiExpression)((PsiAssignmentExpression)initializer).getLExpression());
                    this.checkExpression(variable, lExpr);
                } else {
                    this.checkExpression(variable, initializer);
                }
            }

            private void checkExpression(PsiVariable variable, PsiExpression expression) {
                if (!(expression instanceof PsiReferenceExpression)) {
                    return;
                }
                PsiReferenceExpression refExpr = (PsiReferenceExpression)expression;
                PsiExpression qualifier = refExpr.getQualifierExpression();
                if ((qualifier == null || qualifier instanceof PsiThisExpression || qualifier instanceof PsiSuperExpression || variable.hasModifierProperty("static")) && refExpr.isReferenceTo((PsiElement)variable)) {
                    holder.registerProblem((PsiElement)expression, InspectionsBundle.message((String)"assignment.to.declared.variable.problem.descriptor", (Object[])new Object[]{variable.getName()}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
                }
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/sillyAssignment/SillyAssignmentInspection", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    private static void checkSillyAssignment(PsiAssignmentExpression assignment, ProblemsHolder holder) {
        PsiReferenceExpression rRef;
        if (assignment.getOperationTokenType() != JavaTokenType.EQ) {
            return;
        }
        PsiExpression lExpression = assignment.getLExpression();
        PsiExpression rExpression = assignment.getRExpression();
        if (rExpression == null) {
            return;
        }
        lExpression = PsiUtil.deparenthesizeExpression((PsiExpression)lExpression);
        rExpression = PsiUtil.deparenthesizeExpression((PsiExpression)rExpression);
        if (!(lExpression instanceof PsiReferenceExpression)) {
            return;
        }
        if (!(rExpression instanceof PsiReferenceExpression)) {
            if (!(rExpression instanceof PsiAssignmentExpression)) {
                return;
            }
            PsiAssignmentExpression rAssignmentExpression = (PsiAssignmentExpression)rExpression;
            PsiExpression assignee = PsiUtil.deparenthesizeExpression((PsiExpression)rAssignmentExpression.getLExpression());
            if (!(assignee instanceof PsiReferenceExpression)) {
                return;
            }
            rRef = (PsiReferenceExpression)assignee;
        } else {
            rRef = (PsiReferenceExpression)rExpression;
        }
        PsiReferenceExpression lRef = (PsiReferenceExpression)lExpression;
        PsiManager manager = assignment.getManager();
        if (!SillyAssignmentInspection.sameInstanceReferences((PsiJavaCodeReferenceElement)lRef, (PsiJavaCodeReferenceElement)rRef, manager)) {
            return;
        }
        PsiVariable variable = (PsiVariable)lRef.resolve();
        if (variable == null) {
            return;
        }
        holder.registerProblem((PsiElement)assignment, InspectionsBundle.message((String)"assignment.to.itself.problem.descriptor", (Object[])new Object[]{variable.getName()}), ProblemHighlightType.LIKE_UNUSED_SYMBOL, new LocalQuickFix[0]);
    }

    private static boolean sameInstanceReferences(@Nullable PsiJavaCodeReferenceElement lRef, @Nullable PsiJavaCodeReferenceElement rRef, PsiManager manager) {
        boolean rThis;
        PsiElement rResolved;
        if (lRef == null && rRef == null) {
            return true;
        }
        if (lRef == null || rRef == null) {
            return false;
        }
        PsiElement lResolved = lRef.resolve();
        if (!manager.areElementsEquivalent(lResolved, rResolved = rRef.resolve())) {
            return false;
        }
        if (!(lResolved instanceof PsiVariable)) {
            return false;
        }
        PsiVariable variable = (PsiVariable)lResolved;
        if (variable.hasModifierProperty("static")) {
            return true;
        }
        PsiElement lQualifier = lRef.getQualifier();
        PsiElement rQualifier = rRef.getQualifier();
        if (lQualifier instanceof PsiJavaCodeReferenceElement && rQualifier instanceof PsiJavaCodeReferenceElement) {
            return SillyAssignmentInspection.sameInstanceReferences((PsiJavaCodeReferenceElement)lQualifier, (PsiJavaCodeReferenceElement)rQualifier, manager);
        }
        if (Comparing.equal((Object)lQualifier, (Object)rQualifier)) {
            return true;
        }
        boolean lThis = lQualifier == null || lQualifier instanceof PsiThisExpression || lQualifier instanceof PsiSuperExpression;
        boolean bl = rThis = rQualifier == null || rQualifier instanceof PsiThisExpression || rQualifier instanceof PsiSuperExpression;
        if (lThis && rThis) {
            PsiJavaCodeReferenceElement llQualifier = SillyAssignmentInspection.getQualifier(lQualifier);
            PsiJavaCodeReferenceElement rrQualifier = SillyAssignmentInspection.getQualifier(rQualifier);
            return SillyAssignmentInspection.sameInstanceReferences(llQualifier, rrQualifier, manager);
        }
        return false;
    }

    private static PsiJavaCodeReferenceElement getQualifier(PsiElement qualifier) {
        if (qualifier instanceof PsiThisExpression) {
            PsiClass innerMostClass;
            PsiJavaCodeReferenceElement thisQualifier = ((PsiThisExpression)qualifier).getQualifier();
            if (thisQualifier != null && (innerMostClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)thisQualifier, PsiClass.class)) == thisQualifier.resolve()) {
                return null;
            }
            return thisQualifier;
        }
        if (qualifier != null) {
            return ((PsiSuperExpression)qualifier).getQualifier();
        }
        return null;
    }
}

