/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaElement;
import com.intellij.codeInspection.reference.RefJavaElementImpl;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefProject;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.PsiAnonymousClass;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierList;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.MethodSignatureUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.util.VisibilityUtil;
import org.jetbrains.annotations.Nullable;

public class RefJavaUtilImpl
extends RefJavaUtil {
    public void addReferences(final PsiModifierListOwner psiFrom, RefJavaElement ref, @Nullable PsiElement findIn) {
        final RefJavaElementImpl refFrom = (RefJavaElementImpl)ref;
        if (findIn != null) {
            findIn.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
                    PsiElement target = reference.resolve();
                    if (target instanceof PsiClass) {
                        PsiClass aClass = (PsiClass)target;
                        RefClassImpl refClass = (RefClassImpl)refFrom.getRefManager().getReference((PsiElement)aClass);
                        refFrom.addReference(refClass, (PsiElement)aClass, (PsiElement)psiFrom, false, true, null);
                    }
                    if (target instanceof PsiModifierListOwner && RefJavaUtil.isDeprecated((PsiElement)target)) {
                        refFrom.setUsesDeprecatedApi(true);
                    }
                }

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    this.visitElement((PsiElement)expression);
                    PsiElement psiResolved = expression.resolve();
                    if (psiResolved instanceof PsiModifierListOwner && RefJavaUtil.isDeprecated((PsiElement)psiResolved)) {
                        refFrom.setUsesDeprecatedApi(true);
                    }
                    RefElement refResolved = refFrom.getRefManager().getReference(psiResolved);
                    refFrom.addReference(refResolved, psiResolved, (PsiElement)psiFrom, PsiUtil.isAccessedForWriting((PsiExpression)expression), PsiUtil.isAccessedForReading((PsiExpression)expression), expression);
                    if (refResolved instanceof RefMethod) {
                        RefJavaUtilImpl.this.updateRefMethod(psiResolved, refResolved, (PsiElement)expression, (PsiElement)psiFrom, refFrom);
                    }
                }

                public void visitEnumConstant(PsiEnumConstant enumConstant) {
                    super.visitEnumConstant(enumConstant);
                    this.processNewLikeConstruct(enumConstant.resolveConstructor(), enumConstant.getArgumentList());
                }

                public void visitNewExpression(PsiNewExpression newExpr) {
                    PsiType newType;
                    super.visitNewExpression(newExpr);
                    PsiMethod psiConstructor = newExpr.resolveConstructor();
                    PsiExpressionList argumentList = newExpr.getArgumentList();
                    RefMethod refConstructor = this.processNewLikeConstruct(psiConstructor, argumentList);
                    if (refConstructor == null && (newType = newExpr.getType()) instanceof PsiClassType) {
                        this.processClassReference(PsiUtil.resolveClassInType((PsiType)newType), refFrom, psiFrom, true);
                    }
                }

                @Nullable
                private RefMethod processNewLikeConstruct(PsiMethod psiConstructor, PsiExpressionList argumentList) {
                    if (psiConstructor != null && RefJavaUtil.isDeprecated((PsiElement)psiConstructor)) {
                        refFrom.setUsesDeprecatedApi(true);
                    }
                    RefMethodImpl refConstructor = (RefMethodImpl)refFrom.getRefManager().getReference((PsiElement)psiConstructor);
                    refFrom.addReference(refConstructor, (PsiElement)psiConstructor, (PsiElement)psiFrom, false, true, null);
                    if (argumentList != null) {
                        PsiExpression[] psiParams;
                        for (PsiExpression param : psiParams = argumentList.getExpressions()) {
                            param.accept((PsiElementVisitor)this);
                        }
                        if (refConstructor != null) {
                            refConstructor.updateParameterValues(psiParams);
                        }
                    }
                    return refConstructor;
                }

                public void visitAnonymousClass(PsiAnonymousClass psiClass) {
                    super.visitAnonymousClass(psiClass);
                    RefClassImpl refClass = (RefClassImpl)refFrom.getRefManager().getReference((PsiElement)psiClass);
                    refFrom.addReference(refClass, (PsiElement)psiClass, (PsiElement)psiFrom, false, true, null);
                }

                public void visitReturnStatement(PsiReturnStatement statement) {
                    super.visitReturnStatement(statement);
                    if (refFrom instanceof RefMethodImpl) {
                        RefMethodImpl refMethod = (RefMethodImpl)refFrom;
                        refMethod.updateReturnValueTemplate(statement.getReturnValue());
                    }
                }

                public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
                    super.visitClassObjectAccessExpression(expression);
                    PsiTypeElement operand = expression.getOperand();
                    PsiType type = operand.getType();
                    if (type instanceof PsiClassType) {
                        this.processClassReference(((PsiClassType)type).resolve(), refFrom, psiFrom, false);
                    }
                }

                private void processClassReference(PsiClass psiClass, RefJavaElementImpl refFrom2, PsiModifierListOwner psiFrom2, boolean defaultConstructorOnly) {
                    RefClassImpl refClass;
                    if (psiClass != null && (refClass = (RefClassImpl)refFrom2.getRefManager().getReference((PsiElement)psiClass)) != null) {
                        boolean hasConstructorsMarked = false;
                        if (defaultConstructorOnly) {
                            RefMethodImpl refDefaultConstructor = (RefMethodImpl)refClass.getDefaultConstructor();
                            if (refDefaultConstructor != null && !(refDefaultConstructor instanceof RefImplicitConstructor)) {
                                refDefaultConstructor.addInReference(refFrom2);
                                refFrom2.addOutReference(refDefaultConstructor);
                                hasConstructorsMarked = true;
                            }
                        } else {
                            for (RefMethod cons : refClass.getConstructors()) {
                                if (cons instanceof RefImplicitConstructor) continue;
                                ((RefMethodImpl)cons).addInReference(refFrom2);
                                refFrom2.addOutReference((RefElement)cons);
                                hasConstructorsMarked = true;
                            }
                        }
                        if (!hasConstructorsMarked) {
                            refFrom2.addReference(refClass, (PsiElement)psiClass, (PsiElement)psiFrom2, false, true, null);
                        }
                    }
                }
            });
        }
    }

    private void updateRefMethod(PsiElement psiResolved, RefElement refResolved, PsiElement refExpression, PsiElement psiFrom, RefElement refFrom) {
        PsiMethod psiMethod = (PsiMethod)psiResolved;
        RefMethodImpl refMethod = (RefMethodImpl)refResolved;
        PsiMethodCallExpression call = (PsiMethodCallExpression)PsiTreeUtil.getParentOfType((PsiElement)refExpression, PsiMethodCallExpression.class);
        if (call != null) {
            PsiClassType methodOwnerType;
            String fqName;
            PsiType usedType;
            PsiExpression psiExpression;
            PsiExpressionList argumentList;
            PsiType returnType = psiMethod.getReturnType();
            if (!psiMethod.isConstructor() && returnType != PsiType.VOID) {
                if (!(call.getParent() instanceof PsiExpressionStatement)) {
                    refMethod.setReturnValueUsed(true);
                }
                this.addTypeReference(psiFrom, returnType, refFrom.getRefManager());
            }
            if ((argumentList = call.getArgumentList()).getExpressions().length > 0) {
                refMethod.updateParameterValues(argumentList.getExpressions());
            }
            if ((psiExpression = call.getMethodExpression().getQualifierExpression()) != null && (usedType = psiExpression.getType()) != null && (fqName = psiMethod.getContainingClass().getQualifiedName()) != null && !usedType.equals(methodOwnerType = JavaPsiFacade.getInstance((Project)call.getProject()).getElementFactory().createTypeByFQClassName(fqName, GlobalSearchScope.allScope((Project)psiMethod.getProject())))) {
                refMethod.setCalledOnSubClass(true);
            }
        }
    }

    public RefClass getTopLevelClass(RefElement refElement) {
        for (RefEntity refParent = refElement.getOwner(); refParent != null && refParent instanceof RefElement && !(refParent instanceof RefFile); refParent = refParent.getOwner()) {
            refElement = (RefElementImpl)refParent;
        }
        return refElement instanceof RefClass ? (RefClass)refElement : null;
    }

    public boolean isInheritor(RefClass subClass, RefClass superClass) {
        if (subClass == superClass) {
            return true;
        }
        for (RefClass baseClass : subClass.getBaseClasses()) {
            if (!this.isInheritor(baseClass, superClass)) continue;
            return true;
        }
        return false;
    }

    @Nullable
    public String getPackageName(RefEntity refEntity) {
        if (refEntity instanceof RefProject) {
            return null;
        }
        RefPackage refPackage = RefJavaUtilImpl.getPackage((RefEntity)refEntity);
        return refPackage == null ? InspectionsBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]) : refPackage.getQualifiedName();
    }

    public String getAccessModifier(PsiModifierListOwner psiElement) {
        if (psiElement instanceof PsiParameter) {
            return "packageLocal";
        }
        PsiModifierList list = psiElement.getModifierList();
        String result = "packageLocal";
        if (list != null) {
            if (list.hasModifierProperty("private")) {
                result = "private";
            } else if (list.hasModifierProperty("protected")) {
                result = "protected";
            } else if (list.hasModifierProperty("public")) {
                result = "public";
            } else if (psiElement.getParent() instanceof PsiClass) {
                PsiClass ownerClass = (PsiClass)psiElement.getParent();
                if (ownerClass.isInterface()) {
                    result = "public";
                }
                if (ownerClass.isEnum() && result.equals("packageLocal")) {
                    result = "private";
                }
            }
        }
        return result;
    }

    @Nullable
    public RefClass getOwnerClass(RefManager refManager, PsiElement psiElement) {
        while (psiElement != null && !(psiElement instanceof PsiClass)) {
            psiElement = psiElement.getParent();
        }
        return psiElement != null ? (RefClass)refManager.getReference(psiElement) : null;
    }

    @Nullable
    public RefClass getOwnerClass(RefElement refElement) {
        RefEntity parent = refElement.getOwner();
        while (!(parent instanceof RefClass) && parent instanceof RefElement) {
            parent = parent.getOwner();
        }
        if (parent instanceof RefClass) {
            return (RefClass)parent;
        }
        return null;
    }

    public boolean isMethodOnlyCallsSuper(PsiMethod method) {
        boolean hasStatements = false;
        PsiCodeBlock body = method.getBody();
        if (body != null) {
            PsiStatement[] statements;
            for (PsiStatement psiStatement : statements = body.getStatements()) {
                boolean isCallToSameSuper = false;
                if (psiStatement instanceof PsiExpressionStatement) {
                    isCallToSameSuper = this.isCallToSuperMethod(((PsiExpressionStatement)psiStatement).getExpression(), method);
                } else if (psiStatement instanceof PsiReturnStatement) {
                    PsiExpression expression = ((PsiReturnStatement)psiStatement).getReturnValue();
                    isCallToSameSuper = expression == null || this.isCallToSuperMethod(expression, method);
                }
                hasStatements = true;
                if (isCallToSameSuper) continue;
                return false;
            }
        }
        if (hasStatements) {
            PsiMethod[] superMethods = method.findSuperMethods();
            for (PsiStatement psiStatement : superMethods) {
                if (VisibilityUtil.compare((String)VisibilityUtil.getVisibilityModifier((PsiModifierList)psiStatement.getModifierList()), (String)VisibilityUtil.getVisibilityModifier((PsiModifierList)method.getModifierList())) <= 0) continue;
                return false;
            }
        }
        return hasStatements;
    }

    public boolean isCallToSuperMethod(PsiExpression expression, PsiMethod method) {
        PsiMethodCallExpression methodCall;
        if (expression instanceof PsiMethodCallExpression && (methodCall = (PsiMethodCallExpression)expression).getMethodExpression().getQualifierExpression() instanceof PsiSuperExpression) {
            PsiMethod superMethod = (PsiMethod)methodCall.getMethodExpression().resolve();
            if (superMethod == null || !MethodSignatureUtil.areSignaturesEqual((PsiMethod)method, (PsiMethod)superMethod)) {
                return false;
            }
            PsiExpression[] args = methodCall.getArgumentList().getExpressions();
            PsiParameter[] parms = method.getParameterList().getParameters();
            for (int i = 0; i < args.length; ++i) {
                PsiExpression arg = args[i];
                if (!(arg instanceof PsiReferenceExpression)) {
                    return false;
                }
                if (parms[i].equals(((PsiReferenceExpression)arg).resolve())) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int compareAccess(String a1, String a2) {
        int i2;
        int i1 = RefJavaUtilImpl.getAccessNumber(a1);
        if (i1 == (i2 = RefJavaUtilImpl.getAccessNumber(a2))) {
            return 0;
        }
        if (i1 < i2) {
            return -1;
        }
        return 1;
    }

    private static int getAccessNumber(String a) {
        if (a == "private") {
            return 0;
        }
        if (a == "packageLocal") {
            return 1;
        }
        if (a == "protected") {
            return 2;
        }
        if (a == "public") {
            return 3;
        }
        return -1;
    }

    public void setAccessModifier(RefJavaElement refElement, String newAccess) {
        ((RefJavaElementImpl)refElement).setAccessModifier(newAccess);
    }

    public void setIsStatic(RefJavaElement refElement, boolean isStatic) {
        ((RefJavaElementImpl)refElement).setIsStatic(isStatic);
    }

    public void setIsFinal(RefJavaElement refElement, boolean isFinal) {
        ((RefJavaElementImpl)refElement).setIsFinal(isFinal);
    }

    public void addTypeReference(PsiElement psiElement, PsiType psiType, RefManager refManager) {
        RefClassImpl refClass;
        PsiClass psiClass;
        RefClass ownerClass = this.getOwnerClass(refManager, psiElement);
        if (ownerClass != null && (psiType = psiType.getDeepComponentType()) instanceof PsiClassType && (psiClass = PsiUtil.resolveClassInType((PsiType)psiType)) != null && refManager.belongsToScope((PsiElement)psiClass) && (refClass = (RefClassImpl)refManager.getReference((PsiElement)psiClass)) != null) {
            refClass.addTypeReference((RefJavaElement)ownerClass);
        }
    }
}

