/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.reference;

import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.deadCode.UnusedDeclarationInspection;
import com.intellij.codeInspection.ex.EntryPointsManager;
import com.intellij.codeInspection.ex.EntryPointsManagerBase;
import com.intellij.codeInspection.ex.EntryPointsManagerImpl;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefEntity;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefFile;
import com.intellij.codeInspection.reference.RefImplicitConstructor;
import com.intellij.codeInspection.reference.RefJavaFileImpl;
import com.intellij.codeInspection.reference.RefJavaManager;
import com.intellij.codeInspection.reference.RefJavaUtil;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.codeInspection.reference.RefPackage;
import com.intellij.codeInspection.reference.RefPackageImpl;
import com.intellij.codeInspection.reference.RefParameter;
import com.intellij.codeInspection.reference.RefParameterImpl;
import com.intellij.codeInspection.reference.RefProjectImpl;
import com.intellij.codeInspection.reference.RefVisitor;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.Ref;
import com.intellij.openapi.util.UserDataCache;
import com.intellij.openapi.util.UserDataHolder;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiReferenceParameterList;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiTypeParameter;
import com.intellij.psi.PsiTypeParameterListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.SmartPsiElementPointer;
import com.intellij.psi.javadoc.PsiDocComment;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import gnu.trove.THashMap;
import org.jdom.Element;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RefJavaManagerImpl
extends RefJavaManager {
    private static final Logger LOG = Logger.getInstance((String)("#" + RefJavaManagerImpl.class.getName()));
    private PsiMethod myAppMainPattern;
    private PsiMethod myAppPremainPattern;
    private PsiMethod myAppAgentmainPattern;
    private PsiClass myApplet;
    private PsiClass myServlet;
    private RefPackage myDefaultPackage;
    private THashMap<String, RefPackage> myPackages;
    private final RefManagerImpl myRefManager;
    private PsiElementVisitor myProjectIterator;
    private EntryPointsManager myEntryPointsManager;
    private static final UserDataCache<Ref<UnusedDeclarationInspection>, PsiFile, RefManagerImpl> DEAD_CODE_TOOL = new UserDataCache<Ref<UnusedDeclarationInspection>, PsiFile, RefManagerImpl>("DEAD_CODE_TOOL"){

        protected Ref<UnusedDeclarationInspection> compute(PsiFile file, RefManagerImpl refManager) {
            Tools tools = ((GlobalInspectionContextImpl)refManager.getContext()).getTools().get("UnusedDeclaration");
            InspectionToolWrapper toolWrapper = tools == null ? null : tools.getEnabledTool((PsiElement)file);
            InspectionProfileEntry tool = toolWrapper == null ? null : toolWrapper.getTool();
            return Ref.create((Object)((Object)(tool instanceof UnusedDeclarationInspection ? (UnusedDeclarationInspection)tool : null)));
        }
    };

    public RefJavaManagerImpl(@NotNull RefManagerImpl manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/reference/RefJavaManagerImpl", "<init>"));
        }
        this.myRefManager = manager;
        Project project = manager.getProject();
        PsiManager psiManager = PsiManager.getInstance((Project)project);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)psiManager.getProject()).getElementFactory();
        try {
            this.myAppMainPattern = factory.createMethodFromText("void main(String[] args);", null);
            this.myAppPremainPattern = factory.createMethodFromText("void premain(String[] args, java.lang.instrument.Instrumentation i);", null);
            this.myAppAgentmainPattern = factory.createMethodFromText("void agentmain(String[] args, java.lang.instrument.Instrumentation i);", null);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
        this.myApplet = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("java.applet.Applet", GlobalSearchScope.allScope((Project)project));
        this.myServlet = JavaPsiFacade.getInstance((Project)psiManager.getProject()).findClass("javax.servlet.Servlet", GlobalSearchScope.allScope((Project)project));
    }

    public RefPackage getPackage(String packageName) {
        RefPackage refPackage;
        if (this.myPackages == null) {
            this.myPackages = new THashMap();
        }
        if ((refPackage = (RefPackage)this.myPackages.get((Object)packageName)) == null) {
            refPackage = new RefPackageImpl(packageName, this.myRefManager);
            this.myPackages.put((Object)packageName, (Object)refPackage);
            int dotIndex = packageName.lastIndexOf(46);
            if (dotIndex >= 0) {
                ((RefPackageImpl)this.getPackage(packageName.substring(0, dotIndex))).add((RefEntity)refPackage);
            } else {
                ((RefProjectImpl)this.myRefManager.getRefProject()).add((RefEntity)refPackage);
            }
        }
        return refPackage;
    }

    public boolean isEntryPoint(RefElement element) {
        UnusedDeclarationInspection tool = this.getDeadCodeTool(element);
        return tool != null && tool.isEntryPoint(element);
    }

    @Nullable
    private UnusedDeclarationInspection getDeadCodeTool(RefElement element) {
        PsiFile file = ((RefElementImpl)element).getContainingFile();
        if (file == null) {
            return null;
        }
        return this.getDeadCodeTool((PsiElement)file);
    }

    @Nullable
    private UnusedDeclarationInspection getDeadCodeTool(PsiElement element) {
        PsiFile file = element.getContainingFile();
        return file != null ? (UnusedDeclarationInspection)((Object)((Ref)DEAD_CODE_TOOL.get((UserDataHolder)file, (Object)this.myRefManager)).get()) : null;
    }

    public RefPackage getDefaultPackage() {
        if (this.myDefaultPackage == null) {
            this.myDefaultPackage = this.getPackage(InspectionsBundle.message((String)"inspection.reference.default.package", (Object[])new Object[0]));
        }
        return this.myDefaultPackage;
    }

    public PsiMethod getAppMainPattern() {
        return this.myAppMainPattern;
    }

    public PsiMethod getAppPremainPattern() {
        return this.myAppPremainPattern;
    }

    public PsiMethod getAppAgentmainPattern() {
        return this.myAppAgentmainPattern;
    }

    public PsiClass getApplet() {
        return this.myApplet;
    }

    public PsiClass getServlet() {
        return this.myServlet;
    }

    public RefParameter getParameterReference(PsiParameter param, int index) {
        LOG.assertTrue(this.myRefManager.isValidPointForReference(), (Object)"References may become invalid after process is finished");
        RefElement ref = this.myRefManager.getFromRefTable((PsiElement)param);
        if (ref == null) {
            ref = new RefParameterImpl(param, index, (RefManager)this.myRefManager);
            ((RefParameterImpl)ref).initialize();
            this.myRefManager.putToRefTable((PsiElement)param, ref);
        }
        return (RefParameter)ref;
    }

    public void iterate(@NotNull RefVisitor visitor) {
        if (visitor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/reference/RefJavaManagerImpl", "iterate"));
        }
        if (this.myPackages != null) {
            for (RefPackage refPackage : this.myPackages.values()) {
                refPackage.accept(visitor);
            }
        }
        for (RefElement refElement : this.myRefManager.getSortedElements()) {
            RefClass refClass;
            RefMethod refDefaultConstructor;
            if (!(refElement instanceof RefClass) || !((refDefaultConstructor = (refClass = (RefClass)refElement).getDefaultConstructor()) instanceof RefImplicitConstructor)) continue;
            refClass.getDefaultConstructor().accept(visitor);
        }
    }

    public void cleanup() {
        if (this.myEntryPointsManager != null) {
            Disposer.dispose((Disposable)this.myEntryPointsManager);
            this.myEntryPointsManager = null;
        }
        this.myPackages = null;
        this.myApplet = null;
        this.myAppMainPattern = null;
        this.myAppPremainPattern = null;
        this.myAppAgentmainPattern = null;
        this.myServlet = null;
        this.myDefaultPackage = null;
        this.myProjectIterator = null;
    }

    public void removeReference(RefElement refElement) {
        if (refElement instanceof RefMethod) {
            RefParameter[] params;
            RefMethod refMethod = (RefMethod)refElement;
            for (RefParameter param : params = refMethod.getParameters()) {
                this.myRefManager.removeReference((RefElement)param);
            }
        }
    }

    @Nullable
    public RefElement createRefElement(PsiElement elem) {
        if (elem instanceof PsiClass) {
            return new RefClassImpl((PsiClass)elem, (RefManager)this.myRefManager);
        }
        if (elem instanceof PsiMethod) {
            PsiMethod method = (PsiMethod)elem;
            RefElement ref = this.myRefManager.getReference((PsiElement)method.getContainingClass(), true);
            if (ref instanceof RefClass) {
                return new RefMethodImpl((RefClass)ref, method, (RefManager)this.myRefManager);
            }
        } else if (elem instanceof PsiField) {
            PsiField field = (PsiField)elem;
            RefElement ref = this.myRefManager.getReference((PsiElement)field.getContainingClass(), true);
            if (ref instanceof RefClass) {
                return new RefFieldImpl((RefClass)ref, field, (RefManager)this.myRefManager);
            }
        } else if (elem instanceof PsiJavaFile) {
            return new RefJavaFileImpl((PsiJavaFile)elem, (RefManager)this.myRefManager);
        }
        return null;
    }

    @Nullable
    public RefEntity getReference(String type, String fqName) {
        if ("method".equals(type)) {
            return RefMethodImpl.methodFromExternalName(this.myRefManager, fqName);
        }
        if ("class".equals(type)) {
            return RefClassImpl.classFromExternalName(this.myRefManager, fqName);
        }
        if ("field".equals(type)) {
            return RefFieldImpl.fieldFromExternalName(this.myRefManager, fqName);
        }
        if ("parameter".equals(type)) {
            return RefParameterImpl.parameterFromExternalName(this.myRefManager, fqName);
        }
        if ("package".equals(type)) {
            return RefPackageImpl.packageFromFQName(this.myRefManager, fqName);
        }
        return null;
    }

    @Nullable
    public String getType(RefEntity ref) {
        if (ref instanceof RefMethod) {
            return "method";
        }
        if (ref instanceof RefClass) {
            return "class";
        }
        if (ref instanceof RefField) {
            return "field";
        }
        if (ref instanceof RefParameter) {
            return "parameter";
        }
        if (ref instanceof RefPackage) {
            return "package";
        }
        return null;
    }

    @NotNull
    public RefEntity getRefinedElement(@NotNull RefEntity ref) {
        if (ref == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/reference/RefJavaManagerImpl", "getRefinedElement"));
        }
        if (ref instanceof RefImplicitConstructor) {
            RefClass refClass = ((RefImplicitConstructor)ref).getOwnerClass();
            if (refClass == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefJavaManagerImpl", "getRefinedElement"));
            }
            return refClass;
        }
        RefEntity refEntity = ref;
        if (refEntity == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/reference/RefJavaManagerImpl", "getRefinedElement"));
        }
        return refEntity;
    }

    public void visitElement(PsiElement element) {
        if (this.myProjectIterator == null) {
            this.myProjectIterator = new MyJavaElementVisitor();
        }
        element.accept(this.myProjectIterator);
    }

    @Nullable
    public String getGroupName(RefEntity entity) {
        if (entity instanceof RefFile && !(entity instanceof RefJavaFileImpl)) {
            return null;
        }
        return RefJavaUtil.getInstance().getPackageName(entity);
    }

    public boolean belongsToScope(PsiElement psiElement) {
        return !(psiElement instanceof PsiTypeParameter);
    }

    public void export(@NotNull RefEntity refEntity, @NotNull Element element) {
        PsiFile psiFile;
        SmartPsiElementPointer pointer;
        if (refEntity == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/reference/RefJavaManagerImpl", "export"));
        }
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/reference/RefJavaManagerImpl", "export"));
        }
        if (refEntity instanceof RefElement && (pointer = ((RefElement)refEntity).getPointer()) != null && (psiFile = pointer.getContainingFile()) instanceof PsiJavaFile) {
            RefJavaManagerImpl.appendPackageElement(element, ((PsiJavaFile)psiFile).getPackageName());
        }
    }

    public void onEntityInitialized(RefElement refElement, PsiElement psiElement) {
        if (this.isEntryPoint(refElement)) {
            this.getEntryPointsManager().addEntryPoint(refElement, false);
        }
        if (psiElement instanceof PsiClass) {
            PsiClass psiClass = (PsiClass)psiElement;
            EntryPointsManager entryPointsManager = this.getEntryPointsManager();
            if (psiClass.isAnnotationType()) {
                entryPointsManager.addEntryPoint(refElement, false);
                for (PsiMethod psiMethod : psiClass.getMethods()) {
                    entryPointsManager.addEntryPoint(this.myRefManager.getReference((PsiElement)psiMethod), false);
                }
            } else if (psiClass.isEnum()) {
                entryPointsManager.addEntryPoint(refElement, false);
            }
        }
    }

    private static void appendPackageElement(Element element, String packageName) {
        Element packageElement = new Element("package");
        packageElement.addContent(packageName.isEmpty() ? InspectionsBundle.message((String)"inspection.export.results.default", (Object[])new Object[0]) : packageName);
        element.addContent(packageElement);
    }

    public EntryPointsManager getEntryPointsManager() {
        if (this.myEntryPointsManager == null) {
            Project project = this.myRefManager.getProject();
            this.myEntryPointsManager = new EntryPointsManagerImpl(project);
            ((EntryPointsManagerBase)this.myEntryPointsManager).addAllPersistentEntries(EntryPointsManagerBase.getInstance(project));
        }
        return this.myEntryPointsManager;
    }

    private class MyJavaElementVisitor
    extends JavaElementVisitor {
        private final RefJavaUtil myRefUtil = RefJavaUtil.getInstance();

        public void visitReferenceExpression(PsiReferenceExpression expression) {
            this.visitElement((PsiElement)expression);
        }

        public void visitReferenceElement(PsiJavaCodeReferenceElement reference) {
        }

        public void visitReferenceParameterList(PsiReferenceParameterList list) {
            PsiType[] typeArguments;
            PsiTypeParameterListOwner owner;
            super.visitReferenceParameterList(list);
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)list, PsiMember.class);
            if (member instanceof PsiTypeParameter && (owner = ((PsiTypeParameter)member).getOwner()) != null) {
                for (PsiType psiType : ((PsiTypeParameter)member).getExtendsListTypes()) {
                    this.myRefUtil.addTypeReference((PsiElement)owner, psiType, (RefManager)RefJavaManagerImpl.this.myRefManager);
                }
            }
            for (PsiType psiType : typeArguments = list.getTypeArguments()) {
                this.myRefUtil.addTypeReference((PsiElement)member, psiType, (RefManager)RefJavaManagerImpl.this.myRefManager);
            }
        }

        public void visitClass(PsiClass aClass) {
            if (!(aClass instanceof PsiTypeParameter)) {
                super.visitClass(aClass);
                RefElement refClass = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)aClass);
                if (refClass != null) {
                    ((RefClassImpl)refClass).buildReferences();
                }
            }
        }

        public void visitMethod(PsiMethod method) {
            super.visitMethod(method);
            RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)method);
            if (refElement instanceof RefMethodImpl) {
                ((RefMethodImpl)refElement).buildReferences();
            }
        }

        public void visitField(PsiField field) {
            super.visitField(field);
            RefElement refElement = RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)field);
            if (refElement instanceof RefFieldImpl) {
                ((RefFieldImpl)refElement).buildReferences();
            }
        }

        public void visitDocComment(PsiDocComment comment) {
            PsiDocTag[] tags;
            super.visitDocComment(comment);
            for (PsiDocTag tag : tags = comment.getTags()) {
                RefElementImpl element;
                PsiModifierListOwner listOwner;
                PsiElement[] dataElements;
                if (!Comparing.strEqual((String)tag.getName(), (String)"noinspection") || (dataElements = tag.getDataElements()) == null || dataElements.length <= 0 || (listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)comment, PsiModifierListOwner.class)) == null || (element = (RefElementImpl)RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)listOwner)) == null) continue;
                String suppression = "";
                for (PsiElement dataElement : dataElements) {
                    suppression = suppression + "," + dataElement.getText();
                }
                element.addSuppression(suppression);
            }
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            RefElementImpl element;
            PsiModifierListOwner listOwner;
            super.visitAnnotation(annotation);
            if (Comparing.strEqual((String)annotation.getQualifiedName(), (String)"java.lang.SuppressWarnings") && (listOwner = (PsiModifierListOwner)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiModifierListOwner.class)) != null && (element = (RefElementImpl)RefJavaManagerImpl.this.myRefManager.getReference((PsiElement)listOwner)) != null) {
                PsiNameValuePair[] nameValuePairs;
                StringBuilder buf = new StringBuilder();
                for (PsiNameValuePair nameValuePair : nameValuePairs = annotation.getParameterList().getAttributes()) {
                    buf.append(",").append(nameValuePair.getText().replaceAll("[{}\"\"]", ""));
                }
                if (buf.length() > 0) {
                    element.addSuppression(buf.substring(1));
                }
            }
        }

        public void visitVariable(PsiVariable variable) {
            super.visitVariable(variable);
            this.myRefUtil.addTypeReference((PsiElement)variable, variable.getType(), (RefManager)RefJavaManagerImpl.this.myRefManager);
        }

        public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
            super.visitInstanceOfExpression(expression);
            PsiTypeElement typeElement = expression.getCheckType();
            if (typeElement != null) {
                this.myRefUtil.addTypeReference((PsiElement)expression, typeElement.getType(), (RefManager)RefJavaManagerImpl.this.myRefManager);
            }
        }

        public void visitThisExpression(PsiThisExpression expression) {
            super.visitThisExpression(expression);
            PsiJavaCodeReferenceElement qualifier = expression.getQualifier();
            if (qualifier != null) {
                RefClassImpl refClass;
                this.myRefUtil.addTypeReference((PsiElement)expression, expression.getType(), (RefManager)RefJavaManagerImpl.this.myRefManager);
                RefClass ownerClass = this.myRefUtil.getOwnerClass((RefManager)RefJavaManagerImpl.this.myRefManager, (PsiElement)expression);
                if (ownerClass != null && (refClass = (RefClassImpl)RefJavaManagerImpl.this.myRefManager.getReference(qualifier.resolve())) != null) {
                    refClass.addInstanceReference((RefElement)ownerClass);
                }
            }
        }
    }
}

