/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.nullable;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInsight.intention.impl.AddNotNullAnnotationFix;
import com.intellij.codeInspection.AnnotateMethodFix;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.RemoveAnnotationQuickFix;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.nullable.AnnotateOverriddenMethodParameterFix;
import com.intellij.codeInspection.nullable.ChangeNullableDefaultsFix;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiJavaCodeReferenceElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiReference;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.codeStyle.JavaCodeStyleManager;
import com.intellij.psi.codeStyle.VariableKind;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.search.searches.ReferencesSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.ArrayUtil;
import com.intellij.util.Processor;
import java.util.Collection;
import java.util.List;
import javax.swing.JComponent;
import org.jetbrains.annotations.NotNull;

public class NullableStuffInspectionBase
extends BaseJavaBatchLocalInspectionTool {
    @Deprecated
    public boolean REPORT_NULLABLE_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE = true;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_PARAMETER_OVERRIDES_NOTNULL = true;
    public boolean REPORT_NOT_ANNOTATED_GETTER = true;
    @Deprecated
    public boolean REPORT_NOT_ANNOTATED_SETTER_PARAMETER = true;
    @Deprecated
    public boolean REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS = true;
    public boolean REPORT_NULLS_PASSED_TO_NON_ANNOTATED_METHOD = true;
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.nullable.NullableStuffInspectionBase");

    @NotNull
    public PsiElementVisitor buildVisitor(final @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "buildVisitor"));
        }
        JavaElementVisitor javaElementVisitor = new JavaElementVisitor(){

            public void visitMethod(PsiMethod method) {
                if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)method)) {
                    return;
                }
                NullableStuffInspectionBase.this.checkNullableStuffForMethod(method, holder);
            }

            public void visitField(PsiField field) {
                if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)field)) {
                    return;
                }
                PsiType type = field.getType();
                Annotated annotated = NullableStuffInspectionBase.check((PsiModifierListOwner)field, holder, type);
                if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)type)) {
                    return;
                }
                Project project = holder.getProject();
                NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)project);
                if (annotated.isDeclaredNotNull ^ annotated.isDeclaredNullable) {
                    PsiClass containingClass;
                    PsiMethod setter;
                    PsiIdentifier nameIdentifier;
                    List annoToRemove;
                    String anno = annotated.isDeclaredNotNull ? manager.getDefaultNotNull() : manager.getDefaultNullable();
                    List list = annoToRemove = annotated.isDeclaredNotNull ? manager.getNullables() : manager.getNotNulls();
                    if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)field, (String)anno)) {
                        PsiAnnotation annotation;
                        PsiAnnotation notNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, (Collection)manager.getNotNulls());
                        PsiAnnotation nullable = AnnotationUtil.findAnnotation((PsiModifierListOwner)field, (Collection)manager.getNullables());
                        String message = "Not '";
                        if (annotated.isDeclaredNullable) {
                            message = message + nullable.getQualifiedName();
                            annotation = nullable;
                        } else {
                            message = message + notNull.getQualifiedName();
                            annotation = notNull;
                        }
                        message = message + "' but '" + anno + "' would be used for code generation.";
                        PsiJavaCodeReferenceElement annotationNameReferenceElement = annotation.getNameReferenceElement();
                        holder.registerProblem((PsiElement)(annotationNameReferenceElement != null ? annotationNameReferenceElement : field.getNameIdentifier()), message, ProblemHighlightType.WEAK_WARNING, new LocalQuickFix[]{new ChangeNullableDefaultsFix(notNull, nullable, manager)});
                        return;
                    }
                    String propName = JavaCodeStyleManager.getInstance((Project)project).variableNameToPropertyName(field.getName(), VariableKind.FIELD);
                    boolean isStatic = field.hasModifierProperty("static");
                    PsiMethod getter = PropertyUtil.findPropertyGetter((PsiClass)field.getContainingClass(), (String)propName, (boolean)isStatic, (boolean)false);
                    PsiIdentifier psiIdentifier = nameIdentifier = getter == null ? null : getter.getNameIdentifier();
                    if (nameIdentifier != null && nameIdentifier.isPhysical() && PropertyUtil.isSimpleGetter((PsiMethod)getter)) {
                        AnnotateMethodFix getterAnnoFix = new AnnotateMethodFix(anno, ArrayUtil.toStringArray((Collection)annoToRemove)){

                            @Override
                            public int shouldAnnotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project) {
                                return 1;
                            }
                        };
                        if (NullableStuffInspectionBase.this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability((PsiModifierListOwner)getter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)getter.getReturnType())) {
                            holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.getter.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{getterAnnoFix});
                        }
                        if (annotated.isDeclaredNotNull && manager.isNullable((PsiModifierListOwner)getter, false) || annotated.isDeclaredNullable && manager.isNotNull((PsiModifierListOwner)getter, false)) {
                            holder.registerProblem((PsiElement)nameIdentifier, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.getter.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)getter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{getterAnnoFix});
                        }
                    }
                    if ((setter = PropertyUtil.findPropertySetter((PsiClass)(containingClass = field.getContainingClass()), (String)propName, (boolean)isStatic, (boolean)false)) != null && setter.isPhysical()) {
                        PsiIdentifier nameIdentifier1;
                        PsiParameter[] parameters = setter.getParameterList().getParameters();
                        assert (parameters.length == 1) : setter.getText();
                        PsiParameter parameter = parameters[0];
                        LOG.assertTrue(parameter != null, (Object)setter.getText());
                        AddAnnotationPsiFix addAnnoFix = new AddAnnotationPsiFix(anno, (PsiModifierListOwner)parameter, PsiNameValuePair.EMPTY_ARRAY, ArrayUtil.toStringArray((Collection)annoToRemove));
                        if (NullableStuffInspectionBase.this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability((PsiModifierListOwner)parameter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)parameter.getType())) {
                            nameIdentifier1 = parameter.getNameIdentifier();
                            this.assertValidElement(setter, parameter, nameIdentifier1);
                            holder.registerProblem((PsiElement)nameIdentifier1, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.setter.parameter.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{addAnnoFix});
                        }
                        if (PropertyUtil.isSimpleSetter((PsiMethod)setter) && (annotated.isDeclaredNotNull && manager.isNullable((PsiModifierListOwner)parameter, false) || annotated.isDeclaredNullable && manager.isNotNull((PsiModifierListOwner)parameter, false))) {
                            nameIdentifier1 = parameter.getNameIdentifier();
                            this.assertValidElement(setter, parameter, nameIdentifier1);
                            holder.registerProblem((PsiElement)nameIdentifier1, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.setter.parameter.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{addAnnoFix});
                        }
                    }
                    for (PsiExpression rhs : DfaPsiUtil.findAllConstructorInitializers(field)) {
                        boolean usedAsQualifier;
                        PsiElement target;
                        if (!(rhs instanceof PsiReferenceExpression) || !((target = ((PsiReferenceExpression)rhs).resolve()) instanceof PsiParameter)) continue;
                        PsiParameter parameter = (PsiParameter)target;
                        AddAnnotationPsiFix fix = new AddAnnotationPsiFix(anno, (PsiModifierListOwner)parameter, PsiNameValuePair.EMPTY_ARRAY, ArrayUtil.toStringArray((Collection)annoToRemove));
                        if (NullableStuffInspectionBase.this.REPORT_NOT_ANNOTATED_GETTER && !manager.hasNullability((PsiModifierListOwner)parameter) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)parameter.getType())) {
                            PsiIdentifier nameIdentifier2 = parameter.getNameIdentifier();
                            assert (nameIdentifier2 != null) : parameter;
                            holder.registerProblem((PsiElement)nameIdentifier2, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.constructor.parameter.not.annotated", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                            continue;
                        }
                        if (!annotated.isDeclaredNullable || !manager.isNotNull((PsiModifierListOwner)parameter, false) || (usedAsQualifier = !ReferencesSearch.search((PsiElement)parameter).forEach((Processor)new Processor<PsiReference>(){

                            public boolean process(PsiReference reference) {
                                PsiElement element = reference.getElement();
                                return !(element instanceof PsiReferenceExpression) || !(element.getParent() instanceof PsiReferenceExpression);
                            }
                        }))) continue;
                        PsiIdentifier nameIdentifier2 = parameter.getNameIdentifier();
                        assert (nameIdentifier2 != null) : parameter;
                        holder.registerProblem((PsiElement)nameIdentifier2, InspectionsBundle.message((String)"inspection.nullable.problems.annotated.field.constructor.parameter.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)field), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{fix});
                    }
                }
            }

            private void assertValidElement(PsiMethod setter, PsiParameter parameter, PsiIdentifier nameIdentifier1) {
                LOG.assertTrue(nameIdentifier1 != null && nameIdentifier1.isPhysical(), (Object)setter.getText());
                LOG.assertTrue(parameter.isPhysical(), (Object)setter.getText());
            }

            public void visitParameter(PsiParameter parameter) {
                if (!PsiUtil.isLanguageLevel5OrHigher((PsiElement)parameter)) {
                    return;
                }
                NullableStuffInspectionBase.check((PsiModifierListOwner)parameter, holder, parameter.getType());
            }
        };
        if (javaElementVisitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "buildVisitor"));
        }
        return javaElementVisitor;
    }

    @NotNull
    private static String getPresentableAnnoName(@NotNull PsiModifierListOwner owner) {
        if (owner == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getPresentableAnnoName"));
        }
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)owner.getProject());
        String anno = manager.getNotNull(owner);
        String string = StringUtil.getShortName((String)(anno != null ? anno : StringUtil.notNullize((String)manager.getNullable(owner), (String)"???")));
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getPresentableAnnoName"));
        }
        return string;
    }

    private static String getPresentableAnnoName(@NotNull PsiAnnotation annotation) {
        if (annotation == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getPresentableAnnoName"));
        }
        return StringUtil.getShortName((String)StringUtil.notNullize((String)annotation.getQualifiedName(), (String)"???"));
    }

    private static Annotated check(PsiModifierListOwner parameter, ProblemsHolder holder, PsiType type) {
        NullableNotNullManager manager = NullableNotNullManager.getInstance((Project)holder.getProject());
        PsiAnnotation isDeclaredNotNull = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (Collection)manager.getNotNulls());
        PsiAnnotation isDeclaredNullable = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (Collection)manager.getNullables());
        if (isDeclaredNullable != null && isDeclaredNotNull != null) {
            NullableStuffInspectionBase.reportNullableNotNullConflict(holder, parameter, isDeclaredNullable, isDeclaredNotNull);
        }
        if ((isDeclaredNotNull != null || isDeclaredNullable != null) && type != null && TypeConversionUtil.isPrimitive((String)type.getCanonicalText())) {
            PsiAnnotation annotation = isDeclaredNotNull == null ? isDeclaredNullable : isDeclaredNotNull;
            NullableStuffInspectionBase.reportPrimitiveType(holder, (PsiElement)annotation, annotation, parameter);
        }
        return new Annotated(isDeclaredNotNull != null, isDeclaredNullable != null);
    }

    private static void reportPrimitiveType(ProblemsHolder holder, PsiElement psiElement, PsiAnnotation annotation, PsiModifierListOwner listOwner) {
        holder.registerProblem(psiElement.isPhysical() ? psiElement : listOwner.getNavigationElement(), InspectionsBundle.message((String)"inspection.nullable.problems.primitive.type.annotation", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(annotation, listOwner)});
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.nullable.problems.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.BUGS_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getShortName() {
        if ("NullableProblems" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "getShortName"));
        }
        return "NullableProblems";
    }

    private void checkNullableStuffForMethod(PsiMethod method, ProblemsHolder holder) {
        Annotated annotated = NullableStuffInspectionBase.check((PsiModifierListOwner)method, holder, method.getReturnType());
        PsiParameter[] parameters = method.getParameterList().getParameters();
        List superMethodSignatures = method.findSuperMethodSignaturesIncludingStatic(true);
        boolean reported_not_annotated_method_overrides_notnull = false;
        boolean reported_nullable_method_overrides_notnull = false;
        boolean[] reported_notnull_parameter_overrides_nullable = new boolean[parameters.length];
        boolean[] reported_not_annotated_parameter_overrides_notnull = new boolean[parameters.length];
        NullableNotNullManager nullableManager = NullableNotNullManager.getInstance((Project)holder.getProject());
        for (MethodSignatureBackedByPsiMethod superMethodSignature : superMethodSignatures) {
            PsiParameter[] superParameters;
            PsiMethod superMethod = superMethodSignature.getMethod();
            if (!reported_nullable_method_overrides_notnull && this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE && annotated.isDeclaredNullable && NullableNotNullManager.isNotNull((PsiModifierListOwner)superMethod)) {
                reported_nullable_method_overrides_notnull = true;
                PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (Collection)nullableManager.getNullables(), (boolean)true);
                holder.registerProblem((PsiElement)(annotation != null ? annotation : method.getNameIdentifier()), InspectionsBundle.message((String)"inspection.nullable.problems.Nullable.method.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)method), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superMethod)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
            }
            if (!reported_not_annotated_method_overrides_notnull && this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL && !annotated.isDeclaredNullable && !annotated.isDeclaredNotNull && NullableNotNullManager.isNotNull((PsiModifierListOwner)superMethod)) {
                reported_not_annotated_method_overrides_notnull = true;
                String defaultNotNull = nullableManager.getDefaultNotNull();
                String[] annotationsToRemove = ArrayUtil.toStringArray((Collection)nullableManager.getNullables());
                LocalQuickFix fix = AnnotationUtil.isAnnotatingApplicable((PsiElement)method, (String)defaultNotNull) ? this.createAnnotateMethodFix(defaultNotNull, annotationsToRemove) : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)superMethod);
                holder.registerProblem((PsiElement)method.getNameIdentifier(), InspectionsBundle.message((String)"inspection.nullable.problems.method.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superMethod)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, NullableStuffInspectionBase.wrapFix(fix));
            }
            if (!this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE && !this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL || (superParameters = superMethod.getParameterList().getParameters()).length != parameters.length) continue;
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                PsiParameter superParameter = superParameters[i];
                if (!reported_notnull_parameter_overrides_nullable[i] && this.REPORT_NOTNULL_PARAMETER_OVERRIDES_NULLABLE && nullableManager.isNotNull((PsiModifierListOwner)parameter, false) && nullableManager.isNullable((PsiModifierListOwner)superParameter, false)) {
                    reported_notnull_parameter_overrides_nullable[i] = true;
                    PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameter, (Collection)nullableManager.getNotNulls(), (boolean)true);
                    holder.registerProblem((PsiElement)(annotation != null ? annotation : parameter.getNameIdentifier()), InspectionsBundle.message((String)"inspection.nullable.problems.NotNull.parameter.overrides.Nullable", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)parameter), NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superParameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[0]);
                }
                if (reported_not_annotated_parameter_overrides_notnull[i] || !this.REPORT_NOT_ANNOTATED_METHOD_OVERRIDES_NOTNULL || nullableManager.hasNullability((PsiModifierListOwner)parameter) || !nullableManager.isNotNull((PsiModifierListOwner)superParameter, false)) continue;
                reported_not_annotated_parameter_overrides_notnull[i] = true;
                AddNotNullAnnotationFix fix = AnnotationUtil.isAnnotatingApplicable((PsiElement)parameter, (String)nullableManager.getDefaultNotNull()) ? new AddNotNullAnnotationFix((PsiModifierListOwner)parameter) : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)superParameter);
                holder.registerProblem((PsiElement)parameter.getNameIdentifier(), InspectionsBundle.message((String)"inspection.nullable.problems.parameter.overrides.NotNull", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName((PsiModifierListOwner)superParameter)}), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, NullableStuffInspectionBase.wrapFix((LocalQuickFix)fix));
            }
        }
        if (this.REPORT_ANNOTATION_NOT_PROPAGATED_TO_OVERRIDERS) {
            boolean[] parameterAnnotated = new boolean[parameters.length];
            boolean[] parameterQuickFixSuggested = new boolean[parameters.length];
            boolean hasAnnotatedParameter = false;
            for (int i = 0; i < parameters.length; ++i) {
                PsiParameter parameter = parameters[i];
                parameterAnnotated[i] = nullableManager.isNotNull((PsiModifierListOwner)parameter, false);
                hasAnnotatedParameter |= parameterAnnotated[i];
            }
            if (hasAnnotatedParameter || annotated.isDeclaredNotNull) {
                PsiManager manager = method.getManager();
                String defaultNotNull = nullableManager.getDefaultNotNull();
                boolean superMethodApplicable = AnnotationUtil.isAnnotatingApplicable((PsiElement)method, (String)defaultNotNull);
                PsiMethod[] overridings = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)GlobalSearchScope.allScope((Project)manager.getProject()), (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY);
                boolean methodQuickFixSuggested = false;
                for (PsiMethod overriding : overridings) {
                    if (!manager.isInProject((PsiElement)overriding)) continue;
                    boolean applicable = AnnotationUtil.isAnnotatingApplicable((PsiElement)overriding, (String)defaultNotNull);
                    if (!(methodQuickFixSuggested || !annotated.isDeclaredNotNull || nullableManager.isNotNull((PsiModifierListOwner)overriding, false) || !nullableManager.isNullable((PsiModifierListOwner)overriding, false) && nullableManager.isNullable((PsiModifierListOwner)overriding, true))) {
                        method.getNameIdentifier();
                        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (Collection)nullableManager.getNotNulls());
                        String[] annotationsToRemove = ArrayUtil.toStringArray((Collection)nullableManager.getNullables());
                        LocalQuickFix fix = applicable ? new MyAnnotateMethodFix(defaultNotNull, annotationsToRemove) : (superMethodApplicable ? null : NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)method));
                        PsiAnnotation psiElement = annotation;
                        if (!annotation.isPhysical() && (psiElement = method.getNameIdentifier()) == null) continue;
                        holder.registerProblem((PsiElement)psiElement, InspectionsBundle.message((String)"nullable.stuff.problems.overridden.methods.are.not.annotated", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, NullableStuffInspectionBase.wrapFix(fix));
                        methodQuickFixSuggested = true;
                    }
                    if (!hasAnnotatedParameter) continue;
                    PsiParameter[] psiParameters = overriding.getParameterList().getParameters();
                    for (int i = 0; i < psiParameters.length; ++i) {
                        PsiAnnotation annotation;
                        if (parameterQuickFixSuggested[i]) continue;
                        PsiParameter parameter = psiParameters[i];
                        if (!parameterAnnotated[i] || nullableManager.isNotNull((PsiModifierListOwner)parameter, false) || nullableManager.isNullable((PsiModifierListOwner)parameter, false)) continue;
                        parameters[i].getNameIdentifier();
                        PsiAnnotation psiElement = annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)parameters[i], (Collection)nullableManager.getNotNulls());
                        if ((annotation == null || !annotation.isPhysical()) && (psiElement = parameters[i].getNameIdentifier()) == null) continue;
                        holder.registerProblem((PsiElement)psiElement, InspectionsBundle.message((String)"nullable.stuff.problems.overridden.method.parameters.are.not.annotated", (Object[])new Object[0]), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, NullableStuffInspectionBase.wrapFix((LocalQuickFix)(!applicable ? NullableStuffInspectionBase.createChangeDefaultNotNullFix(nullableManager, (PsiModifierListOwner)parameters[i]) : new AnnotateOverriddenMethodParameterFix(defaultNotNull, nullableManager.getDefaultNullable()))));
                        parameterQuickFixSuggested[i] = true;
                    }
                }
            }
        }
    }

    @NotNull
    private static LocalQuickFix[] wrapFix(LocalQuickFix fix) {
        if (fix == null) {
            if (LocalQuickFix.EMPTY_ARRAY == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "wrapFix"));
            }
            return LocalQuickFix.EMPTY_ARRAY;
        }
        LocalQuickFix[] localQuickFixArray = new LocalQuickFix[]{fix};
        if (localQuickFixArray == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase", "wrapFix"));
        }
        return localQuickFixArray;
    }

    private static LocalQuickFix createChangeDefaultNotNullFix(NullableNotNullManager nullableManager, PsiModifierListOwner modifierListOwner) {
        PsiJavaCodeReferenceElement referenceElement;
        PsiAnnotation annotation = AnnotationUtil.findAnnotation((PsiModifierListOwner)modifierListOwner, (Collection)nullableManager.getNotNulls());
        if (annotation != null && (referenceElement = annotation.getNameReferenceElement()) != null && referenceElement.resolve() != null) {
            return new ChangeNullableDefaultsFix(annotation.getQualifiedName(), null, nullableManager);
        }
        return null;
    }

    protected AnnotateMethodFix createAnnotateMethodFix(String defaultNotNull, String[] annotationsToRemove) {
        return new AnnotateMethodFix(defaultNotNull, annotationsToRemove);
    }

    private static void reportNullableNotNullConflict(ProblemsHolder holder, PsiModifierListOwner listOwner, PsiAnnotation declaredNullable, PsiAnnotation declaredNotNull) {
        String bothNullableNotNullMessage = InspectionsBundle.message((String)"inspection.nullable.problems.Nullable.NotNull.conflict", (Object[])new Object[]{NullableStuffInspectionBase.getPresentableAnnoName(declaredNullable), NullableStuffInspectionBase.getPresentableAnnoName(declaredNotNull)});
        holder.registerProblem((PsiElement)(declaredNotNull.isPhysical() ? declaredNotNull : listOwner.getNavigationElement()), bothNullableNotNullMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(declaredNotNull, listOwner)});
        holder.registerProblem((PsiElement)(declaredNullable.isPhysical() ? declaredNullable : listOwner.getNavigationElement()), bothNullableNotNullMessage, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, new LocalQuickFix[]{new RemoveAnnotationQuickFix(declaredNullable, listOwner)});
    }

    public JComponent createOptionsPanel() {
        throw new RuntimeException("No UI in headless mode");
    }

    private static class MyAnnotateMethodFix
    extends AnnotateMethodFix {
        public MyAnnotateMethodFix(String defaultNotNull, String[] annotationsToRemove) {
            super(defaultNotNull, annotationsToRemove);
        }

        @Override
        protected boolean annotateOverriddenMethods() {
            return true;
        }

        @Override
        public int shouldAnnotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project) {
            return 1;
        }

        @Override
        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"annotate.overridden.methods.as.notnull", (Object[])new Object[]{ClassUtil.extractClassName((String)this.myAnnotation)});
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/nullable/NullableStuffInspectionBase$MyAnnotateMethodFix", "getName"));
            }
            return string;
        }
    }

    private static class Annotated {
        private final boolean isDeclaredNotNull;
        private final boolean isDeclaredNullable;

        private Annotated(boolean isDeclaredNotNull, boolean isDeclaredNullable) {
            this.isDeclaredNotNull = isDeclaredNotNull;
            this.isDeclaredNullable = isDeclaredNullable;
        }
    }
}

