/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.miscGenerics;

import com.intellij.codeInsight.ExpectedTypeInfo;
import com.intellij.codeInsight.ExpectedTypesProvider;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.miscGenerics.GenericsInspectionToolBase;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaResolveResult;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiCall;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEllipsisType;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiSubstitutor;
import com.intellij.psi.PsiType;
import com.intellij.refactoring.util.InlineUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class RedundantArrayForVarargsCallInspection
extends GenericsInspectionToolBase {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.miscGenerics.RedundantArrayForVarargsCallInspection");
    private static final LocalQuickFix myQuickFixAction = new MyQuickFix();

    @Override
    public ProblemDescriptor[] getDescriptions(@NotNull PsiElement place, final @NotNull InspectionManager manager, final boolean isOnTheFly) {
        if (place == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection", "getDescriptions"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection", "getDescriptions"));
        }
        final ArrayList problems = new ArrayList();
        place.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

            public void visitCallExpression(PsiCallExpression expression) {
                super.visitCallExpression(expression);
                this.checkCall((PsiCall)expression);
            }

            public void visitEnumConstant(PsiEnumConstant enumConstant) {
                super.visitEnumConstant(enumConstant);
                this.checkCall((PsiCall)enumConstant);
            }

            public void visitClass(PsiClass aClass) {
            }

            private void checkCall(PsiCall expression) {
                JavaResolveResult resolveResult = expression.resolveMethodGenerics();
                PsiElement element = resolveResult.getElement();
                PsiSubstitutor substitutor = resolveResult.getSubstitutor();
                if (!(element instanceof PsiMethod)) {
                    return;
                }
                PsiMethod method = (PsiMethod)element;
                if (!method.isVarArgs()) {
                    return;
                }
                PsiParameter[] parameters = method.getParameterList().getParameters();
                PsiExpressionList argumentList = expression.getArgumentList();
                if (argumentList == null) {
                    return;
                }
                PsiExpression[] args = argumentList.getExpressions();
                if (parameters.length != args.length) {
                    return;
                }
                PsiExpression lastArg = args[args.length - 1];
                PsiParameter lastParameter = parameters[args.length - 1];
                PsiType lastParamType = lastParameter.getType();
                LOG.assertTrue(lastParamType instanceof PsiEllipsisType);
                if (!(lastArg instanceof PsiNewExpression) || !substitutor.substitute(((PsiEllipsisType)lastParamType).toArrayType()).equals(lastArg.getType())) {
                    return;
                }
                PsiExpression[] initializers = RedundantArrayForVarargsCallInspection.getInitializers((PsiNewExpression)lastArg);
                if (initializers == null) {
                    return;
                }
                if (!this.isSafeToFlatten(expression, method, initializers)) {
                    return;
                }
                String message = InspectionsBundle.message((String)"inspection.redundant.array.creation.for.varargs.call.descriptor", (Object[])new Object[0]);
                ProblemDescriptor descriptor = manager.createProblemDescriptor((PsiElement)lastArg, message, myQuickFixAction, ProblemHighlightType.GENERIC_ERROR_OR_WARNING, isOnTheFly);
                problems.add(descriptor);
            }

            private boolean isSafeToFlatten(@NotNull PsiCall callExpression, @NotNull PsiMethod oldRefMethod, @NotNull PsiExpression[] arrayElements) {
                PsiType type;
                if (callExpression == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$1", "isSafeToFlatten"));
                }
                if (oldRefMethod == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$1", "isSafeToFlatten"));
                }
                if (arrayElements == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$1", "isSafeToFlatten"));
                }
                if (arrayElements.length == 1 && (PsiType.NULL.equals((Object)(type = arrayElements[0].getType())) || type instanceof PsiArrayType)) {
                    return false;
                }
                PsiCall copy = (PsiCall)callExpression.copy();
                PsiExpressionList copyArgumentList = copy.getArgumentList();
                LOG.assertTrue(copyArgumentList != null);
                PsiExpression[] args = copyArgumentList.getExpressions();
                try {
                    args[args.length - 1].delete();
                    if (arrayElements.length > 0) {
                        copyArgumentList.addRange((PsiElement)arrayElements[0], (PsiElement)arrayElements[arrayElements.length - 1]);
                    }
                    Project project = callExpression.getProject();
                    if (callExpression instanceof PsiEnumConstant) {
                        PsiEnumConstant enumConstant = (PsiEnumConstant)callExpression;
                        PsiClass containingClass = enumConstant.getContainingClass();
                        JavaPsiFacade facade = JavaPsiFacade.getInstance((Project)project);
                        PsiClassType classType = facade.getElementFactory().createType(containingClass);
                        JavaResolveResult resolveResult = facade.getResolveHelper().resolveConstructor(classType, copyArgumentList, (PsiElement)enumConstant);
                        return resolveResult.isValidResult() && resolveResult.getElement() == oldRefMethod;
                    }
                    JavaResolveResult resolveResult = copy.resolveMethodGenerics();
                    if (!resolveResult.isValidResult() || resolveResult.getElement() != oldRefMethod) {
                        return false;
                    }
                    ExpectedTypeInfo[] expectedTypes = ExpectedTypesProvider.getExpectedTypes((PsiExpression)((PsiCallExpression)callExpression), false);
                    PsiType expressionType = ((PsiCallExpression)copy).getType();
                    for (ExpectedTypeInfo expectedType : expectedTypes) {
                        if (expectedType.getType().isAssignableFrom(expressionType)) continue;
                        return false;
                    }
                    return true;
                }
                catch (IncorrectOperationException e) {
                    return false;
                }
            }
        });
        if (problems.isEmpty()) {
            return null;
        }
        return problems.toArray(new ProblemDescriptor[problems.size()]);
    }

    @Nullable
    private static PsiExpression[] getInitializers(PsiNewExpression newExpression) {
        PsiArrayInitializerExpression initializer = newExpression.getArrayInitializer();
        if (initializer != null) {
            return initializer.getInitializers();
        }
        PsiExpression[] dims = newExpression.getArrayDimensions();
        if (dims.length > 0) {
            PsiExpression firstDimension = dims[0];
            Object value = JavaPsiFacade.getInstance((Project)newExpression.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)firstDimension);
            if (value instanceof Integer && (Integer)value == 0) {
                return PsiExpression.EMPTY_ARRAY;
            }
        }
        return null;
    }

    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.VERBOSE_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"inspection.redundant.array.creation.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("RedundantArrayCreation" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection", "getShortName"));
        }
        return "RedundantArrayCreation";
    }

    private static class MyQuickFix
    implements LocalQuickFix {
        private MyQuickFix() {
        }

        public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$MyQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$MyQuickFix", "applyFix"));
            }
            PsiNewExpression arrayCreation = (PsiNewExpression)descriptor.getPsiElement();
            if (arrayCreation == null || !arrayCreation.isValid()) {
                return;
            }
            if (!FileModificationService.getInstance().prepareFileForWrite(arrayCreation.getContainingFile())) {
                return;
            }
            InlineUtil.inlineArrayCreationForVarargs(arrayCreation);
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$MyQuickFix", "getFamilyName"));
            }
            return string;
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"inspection.redundant.array.creation.quickfix", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/miscGenerics/RedundantArrayForVarargsCallInspection$MyQuickFix", "getName"));
            }
            return string;
        }
    }
}

