/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inferNullity;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.BaseAnalysisAction;
import com.intellij.analysis.BaseAnalysisActionDialog;
import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInsight.daemon.QuickFixBundle;
import com.intellij.codeInsight.daemon.impl.quickfix.LocateLibraryDialog;
import com.intellij.codeInsight.daemon.impl.quickfix.OrderEntryFix;
import com.intellij.codeInspection.inferNullity.AnnotateTask;
import com.intellij.codeInspection.inferNullity.NullityInferrer;
import com.intellij.history.LocalHistory;
import com.intellij.history.LocalHistoryAction;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.application.PathManager;
import com.intellij.openapi.application.Result;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.module.Module;
import com.intellij.openapi.module.ModuleUtil;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.progress.Task;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.project.ProjectUtil;
import com.intellij.openapi.roots.ModuleRootModificationUtil;
import com.intellij.openapi.roots.libraries.Library;
import com.intellij.openapi.roots.libraries.LibraryUtil;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.ui.VerticalFlowLayout;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.FileViewProvider;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiManager;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.util.PsiUtil;
import com.intellij.ui.TitledSeparator;
import com.intellij.util.Function;
import com.intellij.util.SequentialModalProgressTask;
import java.awt.Component;
import java.awt.LayoutManager;
import java.util.HashSet;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class InferNullityAnnotationsAction
extends BaseAnalysisAction {
    @NonNls
    private static final String INFER_NULLITY_ANNOTATIONS = "Infer Nullity Annotations";
    private JCheckBox myAnnotateLocalVariablesCb;

    public InferNullityAnnotationsAction() {
        super("Infer Nullity", INFER_NULLITY_ANNOTATIONS);
    }

    @Override
    protected void analyze(final @NotNull Project project, final @NotNull AnalysisScope scope) {
        HashSet modulesWithLL;
        HashSet modulesWithoutAnnotations;
        int totalFiles;
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "analyze"));
        }
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/inferNullity/InferNullityAnnotationsAction", "analyze"));
        }
        ProgressManager progressManager = ProgressManager.getInstance();
        if (!progressManager.runProcessWithProgressSynchronously(new Runnable(totalFiles = scope.getFileCount(), modulesWithoutAnnotations = new HashSet(), modulesWithLL = new HashSet()){
            final /* synthetic */ int val$totalFiles;
            final /* synthetic */ Set val$modulesWithoutAnnotations;
            final /* synthetic */ Set val$modulesWithLL;
            {
                this.val$totalFiles = n;
                this.val$modulesWithoutAnnotations = set;
                this.val$modulesWithLL = set2;
            }

            @Override
            public void run() {
                scope.accept(new PsiElementVisitor(){
                    private int myFileCount = 0;
                    private final Set<Module> processed = new HashSet<Module>();

                    public void visitFile(PsiFile file) {
                        Module module;
                        ++this.myFileCount;
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        if (progressIndicator != null) {
                            VirtualFile virtualFile = file.getVirtualFile();
                            if (virtualFile != null) {
                                progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                            }
                            progressIndicator.setFraction((double)this.myFileCount / (double)val$totalFiles);
                        }
                        if ((module = ModuleUtil.findModuleForPsiElement((PsiElement)file)) != null && !this.processed.contains(module)) {
                            this.processed.add(module);
                            if (JavaPsiFacade.getInstance((Project)project).findClass(NullableNotNullManager.getInstance((Project)project).getDefaultNullable(), GlobalSearchScope.moduleWithDependenciesAndLibrariesScope((Module)module)) == null) {
                                val$modulesWithoutAnnotations.add(module);
                            }
                            if (PsiUtil.getLanguageLevel((PsiElement)file).compareTo((Enum)LanguageLevel.JDK_1_5) < 0) {
                                val$modulesWithLL.add(module);
                            }
                        }
                    }
                });
            }
        }, "Check applicability...", true, project)) {
            return;
        }
        if (!modulesWithLL.isEmpty()) {
            Messages.showErrorDialog((Project)project, (String)"Infer Nullity Annotations requires the project language level be set to 1.5 or greater.", (String)INFER_NULLITY_ANNOTATIONS);
            return;
        }
        if (!modulesWithoutAnnotations.isEmpty()) {
            final Library annotationsLib = LibraryUtil.findLibraryByClass((String)NullableNotNullManager.getInstance((Project)project).getDefaultNullable(), (Project)project);
            if (annotationsLib != null) {
                String message = "Module" + (modulesWithoutAnnotations.size() == 1 ? " " : "s ");
                message = message + StringUtil.join(modulesWithoutAnnotations, (Function)new Function<Module, String>(){

                    public String fun(Module module) {
                        return module.getName();
                    }
                }, (String)", ");
                message = message + (modulesWithoutAnnotations.size() == 1 ? " doesn't" : " don't");
                message = message + " refer to the existing '" + annotationsLib.getName() + "' library with IDEA nullity annotations. Would you like to add the dependenc";
                if (Messages.showOkCancelDialog((Project)project, (String)(message = message + (modulesWithoutAnnotations.size() == 1 ? "y" : "ies") + " now?"), (String)INFER_NULLITY_ANNOTATIONS, (Icon)Messages.getErrorIcon()) == 0) {
                    ApplicationManager.getApplication().runWriteAction(new Runnable(){

                        @Override
                        public void run() {
                            for (Module module : modulesWithoutAnnotations) {
                                ModuleRootModificationUtil.addDependency(module, annotationsLib);
                            }
                        }
                    });
                    this.restartAnalysis(project, scope);
                }
            } else if (Messages.showOkCancelDialog((Project)project, (String)"Infer Nullity Annotations requires that the nullity annotations be available in all your project sources.\n\nYou will need to add annotations.jar as a library. It is possible to configure custom jar in e.g. Constant Conditions & Exceptions inspection or use JetBrains annotations available in installation.  IntelliJ IDEA nullity annotations are freely usable and redistributable under the Apache 2.0 license. Would you like to do it now?", (String)INFER_NULLITY_ANNOTATIONS, (Icon)Messages.getErrorIcon()) == 0) {
                ApplicationManager.getApplication().invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        LocateLibraryDialog dialog = new LocateLibraryDialog((Module)modulesWithoutAnnotations.iterator().next(), PathManager.getLibPath(), "annotations.jar", QuickFixBundle.message("add.library.annotations.description", new Object[0]));
                        dialog.show();
                        if (dialog.isOK()) {
                            final String path = dialog.getResultingLibraryPath();
                            new WriteCommandAction(project, new PsiFile[0]){

                                protected void run(Result result) throws Throwable {
                                    for (Module module : modulesWithoutAnnotations) {
                                        OrderEntryFix.addBundledJarToRoots(project, null, module, null, "org.jetbrains.annotations.NotNull", path);
                                    }
                                }
                            }.execute();
                            InferNullityAnnotationsAction.this.restartAnalysis(project, scope);
                        }
                    }
                });
            }
            return;
        }
        if (scope.checkScopeWritable(project)) {
            return;
        }
        PsiDocumentManager.getInstance((Project)project).commitAllDocuments();
        final NullityInferrer inferrer = new NullityInferrer(this.myAnnotateLocalVariablesCb.isSelected(), project);
        final PsiManager psiManager = PsiManager.getInstance((Project)project);
        if (!progressManager.runProcessWithProgressSynchronously(new Runnable(){

            @Override
            public void run() {
                scope.accept(new PsiElementVisitor(){
                    int myFileCount = 0;

                    public void visitFile(PsiFile file) {
                        Document document;
                        ++this.myFileCount;
                        VirtualFile virtualFile = file.getVirtualFile();
                        FileViewProvider viewProvider = psiManager.findViewProvider(virtualFile);
                        Document document2 = document = viewProvider == null ? null : viewProvider.getDocument();
                        if (document == null || virtualFile.getFileType().isBinary()) {
                            return;
                        }
                        ProgressIndicator progressIndicator = ProgressManager.getInstance().getProgressIndicator();
                        if (progressIndicator != null) {
                            if (virtualFile != null) {
                                progressIndicator.setText2(ProjectUtil.calcRelativeToProjectPath((VirtualFile)virtualFile, (Project)project));
                            }
                            progressIndicator.setFraction((double)this.myFileCount / (double)totalFiles);
                        }
                        if (file instanceof PsiJavaFile) {
                            inferrer.collect(file);
                        }
                    }
                });
            }
        }, INFER_NULLITY_ANNOTATIONS, true, project)) {
            return;
        }
        Runnable applyRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                LocalHistoryAction action = LocalHistory.getInstance().startAction(InferNullityAnnotationsAction.INFER_NULLITY_ANNOTATIONS);
                try {
                    new WriteCommandAction(project, InferNullityAnnotationsAction.INFER_NULLITY_ANNOTATIONS, new PsiFile[0]){

                        protected void run(Result result) throws Throwable {
                            if (!inferrer.nothingFoundMessage(project)) {
                                SequentialModalProgressTask progressTask = new SequentialModalProgressTask(project, InferNullityAnnotationsAction.INFER_NULLITY_ANNOTATIONS, false);
                                progressTask.setMinIterationTime(200L);
                                progressTask.setTask(new AnnotateTask(project, inferrer, progressTask));
                                ProgressManager.getInstance().run((Task)progressTask);
                            }
                        }
                    }.execute();
                }
                finally {
                    action.finish();
                }
            }
        };
        SwingUtilities.invokeLater(applyRunnable);
    }

    private void restartAnalysis(final Project project, final AnalysisScope scope) {
        ApplicationManager.getApplication().invokeLater(new Runnable(){

            @Override
            public void run() {
                InferNullityAnnotationsAction.this.analyze(project, scope);
            }
        });
    }

    @Override
    protected JComponent getAdditionalActionSettings(Project project, BaseAnalysisActionDialog dialog) {
        JPanel panel = new JPanel((LayoutManager)new VerticalFlowLayout());
        panel.add((Component)new TitledSeparator());
        this.myAnnotateLocalVariablesCb = new JCheckBox("Annotate local variables", false);
        panel.add(this.myAnnotateLocalVariablesCb);
        return panel;
    }

    @Override
    protected void canceled() {
        super.canceled();
        this.myAnnotateLocalVariablesCb = null;
    }
}

