/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.inferNullity;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.inferNullity.NullityInferrer;
import com.intellij.openapi.progress.ProgressIndicator;
import com.intellij.openapi.project.Project;
import com.intellij.util.SequentialModalProgressTask;
import com.intellij.util.SequentialTask;

class AnnotateTask
implements SequentialTask {
    private final Project myProject;
    private final NullityInferrer myInferrer;
    private final SequentialModalProgressTask myTask;
    private int myCount = 0;
    private final int myTotal;
    private final NullableNotNullManager myNotNullManager;

    public AnnotateTask(Project project, NullityInferrer inferrer, SequentialModalProgressTask progressTask) {
        this.myProject = project;
        this.myNotNullManager = NullableNotNullManager.getInstance((Project)this.myProject);
        this.myInferrer = inferrer;
        this.myTask = progressTask;
        this.myTotal = this.myInferrer.getCount();
    }

    public void prepare() {
    }

    public boolean isDone() {
        return this.myCount > this.myTotal - 1;
    }

    public boolean iteration() {
        ProgressIndicator indicator = this.myTask.getIndicator();
        if (indicator != null) {
            indicator.setFraction((double)this.myCount / (double)this.myTotal);
        }
        this.myInferrer.apply(this.myCount++, this.myProject, this.myNotNullManager);
        return this.isDone();
    }

    public void stop() {
    }
}

