/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInsight.daemon.impl.analysis.XmlHighlightVisitor;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.XmlQuickFixFactory;
import com.intellij.codeInspection.htmlInspections.AddCustomTagOrAttributeIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlLocalInspectionTool;
import com.intellij.codeInspection.htmlInspections.SwitchToHtml5WithHighPriorityAction;
import com.intellij.codeInspection.htmlInspections.XmlEntitiesInspection;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.JDOMExternalizableStringList;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.impl.source.html.dtd.HtmlElementDescriptorImpl;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlFile;
import com.intellij.psi.xml.XmlTag;
import com.intellij.psi.xml.XmlToken;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlTagUtil;
import com.intellij.xml.util.XmlUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.StringTokenizer;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlUnknownTagInspectionBase
extends HtmlLocalInspectionTool
implements XmlEntitiesInspection {
    public static final Key<HtmlUnknownTagInspectionBase> TAG_KEY = Key.create((String)"HtmlUnknownTag");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.htmlInspections.HtmlUnknownTagInspection");
    public JDOMExternalizableStringList myValues;
    public boolean myCustomValuesEnabled = true;

    public HtmlUnknownTagInspectionBase(String defaultValues) {
        this.myValues = HtmlUnknownTagInspectionBase.reparseProperties(defaultValues);
    }

    public HtmlUnknownTagInspectionBase() {
        this("nobr,noembed,comment,noscript,embed,script");
    }

    protected static JDOMExternalizableStringList reparseProperties(@NotNull String properties) {
        if (properties == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "reparseProperties"));
        }
        JDOMExternalizableStringList result = new JDOMExternalizableStringList();
        StringTokenizer tokenizer = new StringTokenizer(properties, ",");
        while (tokenizer.hasMoreTokens()) {
            result.add((Object)tokenizer.nextToken().toLowerCase().trim());
        }
        return result;
    }

    private static boolean isAbstractDescriptor(XmlElementDescriptor descriptor) {
        return descriptor == null || descriptor instanceof AnyXmlElementDescriptor;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.unknown.tag", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @NonNls
    @NotNull
    public String getShortName() {
        if ("HtmlUnknownTag" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "getShortName"));
        }
        return "HtmlUnknownTag";
    }

    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "getLogger"));
        }
        return logger;
    }

    protected String createPropertiesString() {
        return StringUtil.join((Collection)this.myValues, (String)",");
    }

    @Override
    public String getAdditionalEntries() {
        return this.createPropertiesString();
    }

    protected String getCheckboxTitle() {
        return XmlBundle.message((String)"html.inspections.unknown.tag.checkbox.title", (Object[])new Object[0]);
    }

    public void setAdditionalValues(@NotNull String values) {
        if (values == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "setAdditionalValues"));
        }
        this.myValues = HtmlUnknownTagInspectionBase.reparseProperties(values);
    }

    protected String getPanelTitle() {
        return XmlBundle.message((String)"html.inspections.unknown.tag.title", (Object[])new Object[0]);
    }

    protected boolean isCustomValue(@NotNull String value) {
        if (value == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "isCustomValue"));
        }
        return this.myValues.contains((Object)value.toLowerCase());
    }

    @Override
    public void addEntry(@NotNull String text) {
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "addEntry"));
        }
        String s = text.trim().toLowerCase();
        if (!this.isCustomValue(s)) {
            this.myValues.add((Object)s);
        }
        if (!this.isCustomValuesEnabled()) {
            this.myCustomValuesEnabled = true;
        }
    }

    public boolean isCustomValuesEnabled() {
        return this.myCustomValuesEnabled;
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        XmlElementDescriptor ownDescriptor;
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "checkTag"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/htmlInspections/HtmlUnknownTagInspectionBase", "checkTag"));
        }
        if (!(tag instanceof HtmlTag) || !XmlHighlightVisitor.shouldBeValidated(tag)) {
            return;
        }
        XmlElementDescriptor descriptorFromContext = XmlUtil.getDescriptorFromContext(tag);
        PsiElement parent = tag.getParent();
        XmlElementDescriptor parentDescriptor = parent instanceof XmlTag ? ((XmlTag)parent).getDescriptor() : null;
        XmlElementDescriptor xmlElementDescriptor = ownDescriptor = HtmlUnknownTagInspectionBase.isAbstractDescriptor(descriptorFromContext) ? tag.getDescriptor() : descriptorFromContext;
        if (HtmlUnknownTagInspectionBase.isAbstractDescriptor(ownDescriptor) || parentDescriptor instanceof HtmlElementDescriptorImpl && ownDescriptor instanceof HtmlElementDescriptorImpl && HtmlUnknownTagInspectionBase.isAbstractDescriptor(descriptorFromContext)) {
            String name = tag.getName();
            if (!this.isCustomValuesEnabled() || !this.isCustomValue(name)) {
                ProblemHighlightType highlightType;
                AddCustomTagOrAttributeIntentionAction action = new AddCustomTagOrAttributeIntentionAction(TAG_KEY, name, XmlBundle.message((String)"add.custom.html.tag", (Object[])new Object[]{name}));
                String message = HtmlUnknownTagInspectionBase.isAbstractDescriptor(ownDescriptor) ? XmlErrorMessages.message("unknown.html.tag", name) : XmlErrorMessages.message("element.is.not.allowed.here", name);
                XmlToken startTagName = XmlTagUtil.getStartTagNameElement((XmlTag)tag);
                assert (startTagName != null);
                XmlToken endTagName = XmlTagUtil.getEndTagNameElement((XmlTag)tag);
                ArrayList<Object> quickfixes = new ArrayList<Object>();
                quickfixes.add(action);
                if (isOnTheFly) {
                    LocalQuickFix fix = startTagName.getContainingFile() instanceof XmlFile ? XmlQuickFixFactory.getInstance().createNSDeclarationIntentionFix((PsiElement)startTagName, "", null) : null;
                    ContainerUtil.addIfNotNull(fix, quickfixes);
                }
                if (HtmlUtil.isHtml5Tag(name) && !HtmlUtil.hasNonHtml5Doctype((XmlElement)tag)) {
                    quickfixes.add(new SwitchToHtml5WithHighPriorityAction());
                }
                ProblemHighlightType problemHighlightType = highlightType = tag.getContainingFile().getContext() == null ? ProblemHighlightType.GENERIC_ERROR_OR_WARNING : ProblemHighlightType.INFORMATION;
                if (startTagName.getTextLength() > 0) {
                    holder.registerProblem((PsiElement)startTagName, message, highlightType, quickfixes.toArray(new LocalQuickFix[quickfixes.size()]));
                }
                if (endTagName != null) {
                    holder.registerProblem((PsiElement)endTagName, message, highlightType, quickfixes.toArray(new LocalQuickFix[quickfixes.size()]));
                }
            }
        }
    }
}

