/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.htmlInspections;

import com.intellij.codeInsight.daemon.XmlErrorMessages;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.htmlInspections.AddCustomTagOrAttributeIntentionAction;
import com.intellij.codeInspection.htmlInspections.HtmlUnknownTagInspectionBase;
import com.intellij.codeInspection.htmlInspections.RemoveAttributeIntentionAction;
import com.intellij.codeInspection.htmlInspections.SwitchToHtml5WithHighPriorityAction;
import com.intellij.lang.ASTNode;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.util.Key;
import com.intellij.psi.PsiElement;
import com.intellij.psi.html.HtmlTag;
import com.intellij.psi.xml.XmlAttribute;
import com.intellij.psi.xml.XmlChildRole;
import com.intellij.psi.xml.XmlElement;
import com.intellij.psi.xml.XmlTag;
import com.intellij.xml.XmlAttributeDescriptor;
import com.intellij.xml.XmlBundle;
import com.intellij.xml.XmlElementDescriptor;
import com.intellij.xml.impl.schema.AnyXmlElementDescriptor;
import com.intellij.xml.util.HtmlUtil;
import com.intellij.xml.util.XmlUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;

public class HtmlUnknownAttributeInspectionBase
extends HtmlUnknownTagInspectionBase {
    public static final Key<HtmlUnknownTagInspectionBase> ATTRIBUTE_KEY = Key.create((String)"HtmlUnknownAttribute");
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.htmlInspections.HtmlUnknownAttributeInspection");

    public HtmlUnknownAttributeInspectionBase(String defaultValues) {
        super(defaultValues);
    }

    public HtmlUnknownAttributeInspectionBase() {
    }

    @Override
    @Nls
    @NotNull
    public String getDisplayName() {
        String string = XmlBundle.message((String)"html.inspections.unknown.attribute", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase", "getDisplayName"));
        }
        return string;
    }

    @Override
    @NonNls
    @NotNull
    public String getShortName() {
        if ("HtmlUnknownAttribute" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase", "getShortName"));
        }
        return "HtmlUnknownAttribute";
    }

    @Override
    protected String getCheckboxTitle() {
        return XmlBundle.message((String)"html.inspections.unknown.tag.attribute.checkbox.title", (Object[])new Object[0]);
    }

    @Override
    protected String getPanelTitle() {
        return XmlBundle.message((String)"html.inspections.unknown.tag.attribute.title", (Object[])new Object[0]);
    }

    @Override
    @NotNull
    protected Logger getLogger() {
        Logger logger = LOG;
        if (logger == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase", "getLogger"));
        }
        return logger;
    }

    @Override
    protected void checkTag(@NotNull XmlTag tag, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (tag == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase", "checkTag"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase", "checkTag"));
        }
    }

    @Override
    protected void checkAttribute(@NotNull XmlAttribute attribute, @NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (attribute == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase", "checkAttribute"));
        }
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/htmlInspections/HtmlUnknownAttributeInspectionBase", "checkAttribute"));
        }
        XmlTag tag = attribute.getParent();
        if (tag instanceof HtmlTag) {
            XmlElementDescriptor elementDescriptor = tag.getDescriptor();
            if (elementDescriptor == null || elementDescriptor instanceof AnyXmlElementDescriptor) {
                return;
            }
            XmlAttributeDescriptor attributeDescriptor = elementDescriptor.getAttributeDescriptor(attribute);
            String name = attribute.getName();
            if (!(attributeDescriptor != null || attribute.isNamespaceDeclaration() || XmlUtil.attributeFromTemplateFramework(name, tag) || this.isCustomValuesEnabled() && this.isCustomValue(name))) {
                ASTNode node = attribute.getNode();
                assert (node != null);
                PsiElement nameElement = XmlChildRole.ATTRIBUTE_NAME_FINDER.findChild(node).getPsi();
                boolean maySwitchToHtml5 = HtmlUtil.isCustomHtml5Attribute(name) && !HtmlUtil.hasNonHtml5Doctype((XmlElement)tag);
                LocalQuickFix[] quickfixes = new LocalQuickFix[maySwitchToHtml5 ? 3 : 2];
                quickfixes[0] = new AddCustomTagOrAttributeIntentionAction(ATTRIBUTE_KEY, name, XmlBundle.message((String)"add.custom.html.attribute", (Object[])new Object[]{name}));
                quickfixes[1] = new RemoveAttributeIntentionAction(name);
                if (maySwitchToHtml5) {
                    quickfixes[2] = new SwitchToHtml5WithHighPriorityAction();
                }
                if (nameElement.getTextLength() > 0) {
                    holder.registerProblem(nameElement, XmlErrorMessages.message("attribute.is.not.allowed.here", name), ProblemHighlightType.GENERIC_ERROR_OR_WARNING, quickfixes);
                }
            }
        }
    }
}

