/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.impl.SeverityRegistrar;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ScopeToolState;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.lang.annotation.HighlightSeverity;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Comparing;
import com.intellij.openapi.util.InvalidDataException;
import com.intellij.openapi.util.WriteExternalException;
import com.intellij.packageDependencies.DependencyValidationManager;
import com.intellij.profile.ProfileManager;
import com.intellij.profile.codeInspection.SeverityProvider;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.search.scope.packageSet.CustomScopesProviderEx;
import com.intellij.psi.search.scope.packageSet.NamedScope;
import com.intellij.psi.search.scope.packageSet.NamedScopesHolder;
import com.intellij.psi.search.scope.packageSet.PackageSet;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.jdom.Element;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ToolsImpl
implements Tools {
    @NonNls
    private static final String ENABLED_BY_DEFAULT_ATTRIBUTE = "enabled_by_default";
    @NonNls
    private static final String ENABLED_ATTRIBUTE = "enabled";
    @NonNls
    private static final String LEVEL_ATTRIBUTE = "level";
    private final String myShortName;
    private final ScopeToolState myDefaultState;
    private List<ScopeToolState> myTools;
    private boolean myEnabled;

    public ToolsImpl(@NotNull InspectionToolWrapper toolWrapper, @NotNull HighlightDisplayLevel level, boolean enabled, boolean enabledByDefault) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ToolsImpl", "<init>"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ex/ToolsImpl", "<init>"));
        }
        this.myShortName = toolWrapper.getShortName();
        this.myEnabled = enabled;
        this.myDefaultState = new ScopeToolState(CustomScopesProviderEx.getAllScope(), toolWrapper, enabledByDefault, level);
    }

    public ToolsImpl(@NotNull InspectionToolWrapper toolWrapper, @NotNull HighlightDisplayLevel level, boolean enabled) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ToolsImpl", "<init>"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ex/ToolsImpl", "<init>"));
        }
        this(toolWrapper, level, enabled, enabled);
    }

    @NotNull
    public ScopeToolState addTool(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ToolsImpl", "addTool"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ex/ToolsImpl", "addTool"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/ex/ToolsImpl", "addTool"));
        }
        ScopeToolState scopeToolState = this.insertTool(scope, toolWrapper, enabled, level, this.myTools != null ? this.myTools.size() : 0);
        if (scopeToolState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "addTool"));
        }
        return scopeToolState;
    }

    @NotNull
    public ScopeToolState prependTool(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ToolsImpl", "prependTool"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ex/ToolsImpl", "prependTool"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/ex/ToolsImpl", "prependTool"));
        }
        ScopeToolState scopeToolState = this.insertTool(scope, toolWrapper, enabled, level, 0);
        if (scopeToolState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "prependTool"));
        }
        return scopeToolState;
    }

    @NotNull
    private ScopeToolState insertTool(@NotNull NamedScope scope, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level, int idx) {
        if (scope == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ToolsImpl", "insertTool"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ex/ToolsImpl", "insertTool"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/ex/ToolsImpl", "insertTool"));
        }
        if (this.myTools == null) {
            this.myTools = new ArrayList<ScopeToolState>();
            this.setEnabled(true);
        }
        ScopeToolState scopeToolState = new ScopeToolState(scope, toolWrapper, enabled, level);
        this.myTools.add(idx, scopeToolState);
        ScopeToolState scopeToolState2 = scopeToolState;
        if (scopeToolState2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "insertTool"));
        }
        return scopeToolState2;
    }

    @NotNull
    public InspectionToolWrapper getInspectionTool(PsiElement element) {
        if (this.myTools != null) {
            Project project = element != null ? element.getProject() : null;
            for (ScopeToolState state : this.myTools) {
                PsiFile containingFile;
                PackageSet packageSet;
                if (element == null) {
                    InspectionToolWrapper inspectionToolWrapper = state.getTool();
                    if (inspectionToolWrapper == null) {
                        throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getInspectionTool"));
                    }
                    return inspectionToolWrapper;
                }
                NamedScope scope = state.getScope(project);
                if (scope == null || (packageSet = scope.getValue()) == null || (containingFile = element.getContainingFile()) == null || !packageSet.contains(containingFile, (NamedScopesHolder)DependencyValidationManager.getInstance((Project)project))) continue;
                InspectionToolWrapper inspectionToolWrapper = state.getTool();
                if (inspectionToolWrapper == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getInspectionTool"));
                }
                return inspectionToolWrapper;
            }
        }
        InspectionToolWrapper inspectionToolWrapper = this.myDefaultState.getTool();
        if (inspectionToolWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getInspectionTool"));
        }
        return inspectionToolWrapper;
    }

    @NotNull
    public String getShortName() {
        String string = this.myShortName;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getShortName"));
        }
        return string;
    }

    @NotNull
    public List<InspectionToolWrapper> getAllTools() {
        ArrayList<InspectionToolWrapper> result = new ArrayList<InspectionToolWrapper>();
        for (ScopeToolState state : this.getTools()) {
            InspectionToolWrapper toolWrapper = state.getTool();
            result.add(toolWrapper);
        }
        ArrayList<InspectionToolWrapper> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getAllTools"));
        }
        return arrayList;
    }

    public void writeExternal(Element inspectionElement) throws WriteExternalException {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                Element scopeElement = new Element("scope");
                scopeElement.setAttribute("name", state.getScopeName());
                scopeElement.setAttribute(LEVEL_ATTRIBUTE, state.getLevel().getName());
                scopeElement.setAttribute(ENABLED_ATTRIBUTE, Boolean.toString(state.isEnabled()));
                InspectionToolWrapper toolWrapper = state.getTool();
                if (toolWrapper.isInitialized()) {
                    toolWrapper.getTool().writeSettings(scopeElement);
                }
                inspectionElement.addContent(scopeElement);
            }
        }
        inspectionElement.setAttribute(ENABLED_ATTRIBUTE, Boolean.toString(this.isEnabled()));
        inspectionElement.setAttribute(LEVEL_ATTRIBUTE, this.getLevel().getName());
        inspectionElement.setAttribute(ENABLED_BY_DEFAULT_ATTRIBUTE, Boolean.toString(this.myDefaultState.isEnabled()));
        InspectionToolWrapper toolWrapper = this.myDefaultState.getTool();
        if (toolWrapper.isInitialized()) {
            toolWrapper.getTool().writeSettings(inspectionElement);
        }
    }

    void readExternal(@NotNull Element toolElement, @NotNull InspectionProfile profile) throws InvalidDataException {
        boolean isEnabled;
        HighlightDisplayLevel level;
        if (toolElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ToolsImpl", "readExternal"));
        }
        if (profile == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ex/ToolsImpl", "readExternal"));
        }
        String levelName = toolElement.getAttributeValue(LEVEL_ATTRIBUTE);
        ProfileManager profileManager = profile.getProfileManager();
        SeverityRegistrar registrar = ((SeverityProvider)profileManager).getOwnSeverityRegistrar();
        HighlightDisplayLevel highlightDisplayLevel = level = levelName != null ? HighlightDisplayLevel.find((HighlightSeverity)registrar.getSeverity(levelName)) : null;
        if (level == null || level == HighlightDisplayLevel.DO_NOT_SHOW) {
            level = HighlightDisplayLevel.WARNING;
        }
        this.myDefaultState.setLevel(level);
        String enabled = toolElement.getAttributeValue(ENABLED_ATTRIBUTE);
        this.myEnabled = isEnabled = enabled != null && Boolean.parseBoolean(enabled);
        String enabledTool = toolElement.getAttributeValue(ENABLED_BY_DEFAULT_ATTRIBUTE);
        this.myDefaultState.setEnabled(enabledTool != null ? Boolean.parseBoolean(enabledTool) : isEnabled);
        InspectionToolWrapper toolWrapper = this.myDefaultState.getTool();
        List scopeElements = toolElement.getChildren("scope");
        for (Object sO : scopeElements) {
            HighlightDisplayLevel scopeLevel;
            Element scopeElement = (Element)sO;
            String scopeName = scopeElement.getAttributeValue("name");
            if (scopeName == null) continue;
            NamedScopesHolder scopesHolder = profileManager.getScopesManager();
            NamedScope namedScope = null;
            if (scopesHolder != null) {
                namedScope = scopesHolder.getScope(scopeName);
            }
            String errorLevel = scopeElement.getAttributeValue(LEVEL_ATTRIBUTE);
            String enabledInScope = scopeElement.getAttributeValue(ENABLED_ATTRIBUTE);
            InspectionToolWrapper copyToolWrapper = toolWrapper.createCopy();
            if (scopeElement.getAttributes().size() > 3 || !scopeElement.getChildren().isEmpty()) {
                copyToolWrapper.getTool().readSettings(scopeElement);
            }
            HighlightDisplayLevel highlightDisplayLevel2 = scopeLevel = errorLevel != null ? HighlightDisplayLevel.find((HighlightSeverity)registrar.getSeverity(errorLevel)) : null;
            if (scopeLevel == null) {
                scopeLevel = level;
            }
            if (namedScope != null) {
                this.addTool(namedScope, copyToolWrapper, enabledInScope != null && Boolean.parseBoolean(enabledInScope), scopeLevel);
                continue;
            }
            this.addTool(scopeName, copyToolWrapper, enabledInScope != null && Boolean.parseBoolean(enabledInScope), scopeLevel);
        }
        if (toolElement.getAttributes().size() > 4 || toolElement.getChildren().size() > scopeElements.size()) {
            toolWrapper.getTool().readSettings(toolElement);
        }
    }

    public ScopeToolState addTool(@NotNull String scopeName, @NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (scopeName == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ToolsImpl", "addTool"));
        }
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ex/ToolsImpl", "addTool"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInspection/ex/ToolsImpl", "addTool"));
        }
        if (this.myTools == null) {
            this.myTools = new ArrayList<ScopeToolState>();
            this.setEnabled(true);
        }
        ScopeToolState scopeToolState = new ScopeToolState(scopeName, toolWrapper, enabled, level);
        this.myTools.add(scopeToolState);
        return scopeToolState;
    }

    @NotNull
    public InspectionToolWrapper getTool() {
        if (this.myTools == null) {
            InspectionToolWrapper inspectionToolWrapper = this.myDefaultState.getTool();
            if (inspectionToolWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getTool"));
            }
            return inspectionToolWrapper;
        }
        InspectionToolWrapper inspectionToolWrapper = this.myTools.iterator().next().getTool();
        if (inspectionToolWrapper == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getTool"));
        }
        return inspectionToolWrapper;
    }

    @NotNull
    public List<ScopeToolState> getTools() {
        if (this.myTools == null) {
            List<ScopeToolState> list = Collections.singletonList(this.myDefaultState);
            if (list == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getTools"));
            }
            return list;
        }
        ArrayList<ScopeToolState> result = new ArrayList<ScopeToolState>(this.myTools);
        result.add(this.myDefaultState);
        ArrayList<ScopeToolState> arrayList = result;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getTools"));
        }
        return arrayList;
    }

    @NotNull
    public ScopeToolState getDefaultState() {
        ScopeToolState scopeToolState = this.myDefaultState;
        if (scopeToolState == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getDefaultState"));
        }
        return scopeToolState;
    }

    public void removeScope(int scopeIdx) {
        if (this.myTools != null && scopeIdx >= 0 && this.myTools.size() > scopeIdx) {
            this.myTools.remove(scopeIdx);
            if (this.myTools.isEmpty()) {
                this.myTools = null;
                this.setEnabled(this.myDefaultState.isEnabled());
            }
        }
    }

    public void removeAllScopes() {
        this.myTools = null;
    }

    public void setScope(int idx, NamedScope namedScope) {
        if (this.myTools != null && this.myTools.size() > idx && idx >= 0) {
            ScopeToolState scopeToolState = this.myTools.get(idx);
            InspectionToolWrapper toolWrapper = scopeToolState.getTool();
            this.myTools.remove(idx);
            this.myTools.add(idx, new ScopeToolState(namedScope, toolWrapper, scopeToolState.isEnabled(), scopeToolState.getLevel()));
        }
    }

    public void moveScope(int idx, int dir) {
        if (this.myTools != null && idx >= 0 && idx < this.myTools.size() && idx + dir >= 0 && idx + dir < this.myTools.size()) {
            ScopeToolState state = this.myTools.get(idx);
            this.myTools.set(idx, this.myTools.get(idx + dir));
            this.myTools.set(idx + dir, state);
        }
    }

    public boolean isEnabled(NamedScope namedScope, Project project) {
        if (!this.myEnabled) {
            return false;
        }
        if (namedScope != null && this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal((Object)namedScope, (Object)state.getScope(project))) continue;
                return state.isEnabled();
            }
        }
        return this.myDefaultState.isEnabled();
    }

    public HighlightDisplayLevel getLevel(PsiElement element) {
        if (this.myTools == null || element == null) {
            return this.myDefaultState.getLevel();
        }
        Project project = element.getProject();
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)project);
        for (ScopeToolState state : this.myTools) {
            NamedScope scope = state.getScope(project);
            PackageSet set = scope != null ? scope.getValue() : null;
            if (set == null || !set.contains(element.getContainingFile(), (NamedScopesHolder)manager)) continue;
            return state.getLevel();
        }
        return this.myDefaultState.getLevel();
    }

    public HighlightDisplayLevel getLevel() {
        return this.myDefaultState.getLevel();
    }

    public boolean isEnabled() {
        return this.myEnabled;
    }

    public boolean isEnabled(PsiElement element) {
        if (!this.myEnabled) {
            return false;
        }
        if (this.myTools == null || element == null) {
            return this.myDefaultState.isEnabled();
        }
        Project project = element.getProject();
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)project);
        for (ScopeToolState state : this.myTools) {
            PackageSet set;
            NamedScope scope = state.getScope(project);
            if (scope == null || (set = scope.getValue()) == null || !set.contains(element.getContainingFile(), (NamedScopesHolder)manager)) continue;
            return state.isEnabled();
        }
        return this.myDefaultState.isEnabled();
    }

    @Nullable
    public InspectionToolWrapper getEnabledTool(PsiElement element) {
        if (!this.myEnabled) {
            return null;
        }
        if (this.myTools == null || element == null) {
            return this.myDefaultState.isEnabled() ? this.myDefaultState.getTool() : null;
        }
        Project project = element.getProject();
        DependencyValidationManager manager = DependencyValidationManager.getInstance((Project)project);
        for (ScopeToolState state : this.myTools) {
            PackageSet set;
            NamedScope scope = state.getScope(project);
            if (scope == null || (set = scope.getValue()) == null || !set.contains(element.getContainingFile(), (NamedScopesHolder)manager)) continue;
            return state.isEnabled() ? state.getTool() : null;
        }
        return this.myDefaultState.isEnabled() ? this.myDefaultState.getTool() : null;
    }

    public void setEnabled(boolean enabled) {
        this.myEnabled = enabled;
    }

    public void enableTool(NamedScope namedScope, Project project) {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal((Object)state.getScope(project), (Object)namedScope)) continue;
                state.setEnabled(true);
            }
        }
        this.setEnabled(true);
    }

    public void disableTool(NamedScope namedScope, Project project) {
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal((Object)state.getScope(project), (Object)namedScope)) continue;
                state.setEnabled(false);
            }
        }
    }

    public void disableTool(@NotNull PsiElement element) {
        if (element == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ToolsImpl", "disableTool"));
        }
        Project project = element.getProject();
        DependencyValidationManager validationManager = DependencyValidationManager.getInstance((Project)project);
        if (this.myTools != null) {
            for (ScopeToolState state : this.myTools) {
                PackageSet packageSet;
                NamedScope scope = state.getScope(project);
                if (scope == null || (packageSet = scope.getValue()) == null || !packageSet.contains(element.getContainingFile(), (NamedScopesHolder)validationManager)) continue;
                state.setEnabled(false);
                return;
            }
            this.myDefaultState.setEnabled(false);
        } else {
            this.myDefaultState.setEnabled(false);
            this.setEnabled(false);
        }
    }

    @NotNull
    public HighlightDisplayLevel getLevel(NamedScope scope, Project project) {
        if (this.myTools != null && scope != null) {
            for (ScopeToolState state : this.myTools) {
                if (!Comparing.equal((Object)state.getScope(project), (Object)scope)) continue;
                HighlightDisplayLevel highlightDisplayLevel = state.getLevel();
                if (highlightDisplayLevel == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getLevel"));
                }
                return highlightDisplayLevel;
            }
        }
        HighlightDisplayLevel highlightDisplayLevel = this.myDefaultState.getLevel();
        if (highlightDisplayLevel == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/ToolsImpl", "getLevel"));
        }
        return highlightDisplayLevel;
    }

    public boolean equals(Object o) {
        ToolsImpl tools = (ToolsImpl)o;
        if (this.myEnabled != tools.myEnabled) {
            return false;
        }
        if (this.getTools().size() != tools.getTools().size()) {
            return false;
        }
        for (int i = 0; i < this.getTools().size(); ++i) {
            ScopeToolState toolState;
            ScopeToolState state = this.getTools().get(i);
            if (state.equalTo(toolState = tools.getTools().get(i))) continue;
            return false;
        }
        return true;
    }

    public void setLevel(@NotNull HighlightDisplayLevel level, int idx, Project project) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ToolsImpl", "setLevel"));
        }
        if (this.myTools != null && this.myTools.size() > idx && idx >= 0) {
            ScopeToolState scopeToolState = this.myTools.get(idx);
            this.myTools.remove(idx);
            NamedScope scope = scopeToolState.getScope(project);
            InspectionToolWrapper toolWrapper = scopeToolState.getTool();
            if (scope != null) {
                this.myTools.add(idx, new ScopeToolState(scope, toolWrapper, scopeToolState.isEnabled(), level));
            } else {
                this.myTools.add(idx, new ScopeToolState(scopeToolState.getScopeName(), toolWrapper, scopeToolState.isEnabled(), level));
            }
        } else if (idx == -1) {
            this.myDefaultState.setLevel(level);
        }
    }

    public void setDefaultState(@NotNull InspectionToolWrapper toolWrapper, boolean enabled, @NotNull HighlightDisplayLevel level) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ToolsImpl", "setDefaultState"));
        }
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/ex/ToolsImpl", "setDefaultState"));
        }
        this.myDefaultState.setTool(toolWrapper);
        this.myDefaultState.setLevel(level);
        this.myDefaultState.setEnabled(enabled);
    }

    public void setLevel(@NotNull HighlightDisplayLevel level) {
        if (level == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/ToolsImpl", "setLevel"));
        }
        this.myDefaultState.setLevel(level);
    }

    @Nullable
    public List<ScopeToolState> getNonDefaultTools() {
        return this.myTools;
    }
}

