/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.GlobalInspectionTool;
import com.intellij.codeInspection.InspectionEP;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.InspectionToolProvider;
import com.intellij.codeInspection.InspectionToolsFactory;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalInspectionEP;
import com.intellij.codeInspection.LocalInspectionTool;
import com.intellij.codeInspection.ex.GlobalInspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.InspectionToolsRegistrarCore;
import com.intellij.codeInspection.ex.LocalInspectionToolWrapper;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.extensions.ExtensionPointName;
import com.intellij.openapi.extensions.Extensions;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.util.Factory;
import com.intellij.util.containers.ContainerUtil;
import gnu.trove.THashSet;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.atomic.AtomicBoolean;
import org.jetbrains.annotations.NotNull;

public class InspectionToolRegistrar {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.ex.InspectionToolRegistrar");
    private final List<Factory<InspectionToolWrapper>> myInspectionToolFactories = new ArrayList<Factory<InspectionToolWrapper>>();
    private final AtomicBoolean myInspectionComponentsLoaded = new AtomicBoolean(false);

    public void ensureInitialized() {
        if (!this.myInspectionComponentsLoaded.getAndSet(true)) {
            THashSet providers = new THashSet();
            ContainerUtil.addAll((Collection)providers, (Object[])ApplicationManager.getApplication().getComponents(InspectionToolProvider.class));
            ContainerUtil.addAll((Collection)providers, (Object[])Extensions.getExtensions((ExtensionPointName)InspectionToolProvider.EXTENSION_POINT_NAME));
            this.registerTools(providers.toArray(new InspectionToolProvider[providers.size()]));
            for (final LocalInspectionEP localInspectionEP : (LocalInspectionEP[])Extensions.getExtensions((ExtensionPointName)LocalInspectionEP.LOCAL_INSPECTION)) {
                this.myInspectionToolFactories.add(new Factory<InspectionToolWrapper>(){

                    public InspectionToolWrapper create() {
                        return new LocalInspectionToolWrapper(localInspectionEP);
                    }
                });
            }
            for (LocalInspectionEP localInspectionEP : (InspectionEP[])Extensions.getExtensions((ExtensionPointName)InspectionEP.GLOBAL_INSPECTION)) {
                this.myInspectionToolFactories.add(new Factory<InspectionToolWrapper>((InspectionEP)localInspectionEP){
                    final /* synthetic */ InspectionEP val$ep;
                    {
                        this.val$ep = inspectionEP;
                    }

                    public InspectionToolWrapper create() {
                        return new GlobalInspectionToolWrapper(this.val$ep);
                    }
                });
            }
            for (LocalInspectionEP localInspectionEP : (InspectionToolsFactory[])Extensions.getExtensions((ExtensionPointName)InspectionToolsFactory.EXTENSION_POINT_NAME)) {
                for (final InspectionProfileEntry profileEntry : localInspectionEP.createTools()) {
                    this.myInspectionToolFactories.add(new Factory<InspectionToolWrapper>(){

                        public InspectionToolWrapper create() {
                            return InspectionToolRegistrar.wrapTool(profileEntry);
                        }
                    });
                }
            }
        }
    }

    @NotNull
    public static InspectionToolWrapper wrapTool(@NotNull InspectionProfileEntry profileEntry) {
        if (profileEntry == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "wrapTool"));
        }
        if (profileEntry instanceof LocalInspectionTool) {
            LocalInspectionToolWrapper localInspectionToolWrapper = new LocalInspectionToolWrapper((LocalInspectionTool)profileEntry);
            if (localInspectionToolWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "wrapTool"));
            }
            return localInspectionToolWrapper;
        }
        if (profileEntry instanceof GlobalInspectionTool) {
            GlobalInspectionToolWrapper globalInspectionToolWrapper = new GlobalInspectionToolWrapper((GlobalInspectionTool)profileEntry);
            if (globalInspectionToolWrapper == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "wrapTool"));
            }
            return globalInspectionToolWrapper;
        }
        throw new RuntimeException("unknown inspection class: " + profileEntry + "; " + profileEntry.getClass());
    }

    public void registerTools(@NotNull InspectionToolProvider[] providers) {
        if (providers == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "registerTools"));
        }
        for (InspectionToolProvider provider : providers) {
            Class[] classes;
            for (Class aClass : classes = provider.getInspectionClasses()) {
                this.registerInspectionTool(aClass);
            }
        }
    }

    @NotNull
    private Factory<InspectionToolWrapper> registerInspectionTool(@NotNull Class aClass) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "registerInspectionTool"));
        }
        if (LocalInspectionTool.class.isAssignableFrom(aClass)) {
            Factory<InspectionToolWrapper> factory = this.registerLocalInspection(aClass, true);
            if (factory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "registerInspectionTool"));
            }
            return factory;
        }
        if (GlobalInspectionTool.class.isAssignableFrom(aClass)) {
            Factory<InspectionToolWrapper> factory = this.registerGlobalInspection(aClass, true);
            if (factory == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "registerInspectionTool"));
            }
            return factory;
        }
        throw new RuntimeException("unknown inspection class: " + aClass);
    }

    public static InspectionToolRegistrar getInstance() {
        return (InspectionToolRegistrar)ServiceManager.getService(InspectionToolRegistrar.class);
    }

    @NotNull
    public Factory<InspectionToolWrapper> registerInspectionToolFactory(@NotNull Factory<InspectionToolWrapper> factory, boolean store) {
        if (factory == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "registerInspectionToolFactory"));
        }
        if (store) {
            this.myInspectionToolFactories.add(factory);
        }
        Factory<InspectionToolWrapper> factory2 = factory;
        if (factory2 == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "registerInspectionToolFactory"));
        }
        return factory2;
    }

    @NotNull
    private Factory<InspectionToolWrapper> registerLocalInspection(final Class toolClass, boolean store) {
        Factory<InspectionToolWrapper> factory = this.registerInspectionToolFactory(new Factory<InspectionToolWrapper>(){

            public InspectionToolWrapper create() {
                return new LocalInspectionToolWrapper((LocalInspectionTool)InspectionToolsRegistrarCore.instantiateTool((Class)toolClass));
            }
        }, store);
        if (factory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "registerLocalInspection"));
        }
        return factory;
    }

    @NotNull
    private Factory<InspectionToolWrapper> registerGlobalInspection(final @NotNull Class aClass, boolean store) {
        if (aClass == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "registerGlobalInspection"));
        }
        Factory<InspectionToolWrapper> factory = this.registerInspectionToolFactory(new Factory<InspectionToolWrapper>(){

            public InspectionToolWrapper create() {
                return new GlobalInspectionToolWrapper((GlobalInspectionTool)InspectionToolsRegistrarCore.instantiateTool((Class)aClass));
            }
        }, store);
        if (factory == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "registerGlobalInspection"));
        }
        return factory;
    }

    @NotNull
    public List<InspectionToolWrapper> createTools() {
        this.ensureInitialized();
        ArrayList tools = ContainerUtil.newArrayListWithCapacity((int)this.myInspectionToolFactories.size());
        HashSet broken = ContainerUtil.newHashSet();
        for (Factory<InspectionToolWrapper> factory : this.myInspectionToolFactories) {
            ProgressManager.checkCanceled();
            InspectionToolWrapper toolWrapper = (InspectionToolWrapper)factory.create();
            if (toolWrapper != null && InspectionToolRegistrar.checkTool(toolWrapper) == null) {
                tools.add(toolWrapper);
                continue;
            }
            broken.add(factory);
        }
        this.myInspectionToolFactories.removeAll(broken);
        ArrayList arrayList = tools;
        if (arrayList == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "createTools"));
        }
        return arrayList;
    }

    private static String checkTool(@NotNull InspectionToolWrapper toolWrapper) {
        if (toolWrapper == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/InspectionToolRegistrar", "checkTool"));
        }
        if (!(toolWrapper instanceof LocalInspectionToolWrapper)) {
            return null;
        }
        String message = null;
        try {
            String id = ((LocalInspectionToolWrapper)toolWrapper).getID();
            if (id == null || !LocalInspectionTool.isValidID((String)id)) {
                message = InspectionsBundle.message((String)"inspection.disabled.wrong.id", (Object[])new Object[]{toolWrapper.getShortName(), id, "[a-zA-Z_0-9.-]+"});
            }
        }
        catch (Throwable t) {
            message = InspectionsBundle.message((String)"inspection.disabled.error", (Object[])new Object[]{toolWrapper.getShortName(), t.getMessage()});
        }
        if (message != null) {
            LOG.error(message);
        }
        return message;
    }
}

