/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.ex;

import com.intellij.codeInspection.BatchSuppressableTool;
import com.intellij.codeInspection.CustomSuppressableInspectionTool;
import com.intellij.codeInspection.HintAction;
import com.intellij.codeInspection.InspectionManagerBase;
import com.intellij.codeInspection.InspectionProfileEntry;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.ProblemHighlightType;
import com.intellij.codeInspection.SuppressIntentionAction;
import com.intellij.codeInspection.SuppressIntentionActionFromFix;
import com.intellij.codeInspection.SuppressQuickFix;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionToolRegistrar;
import com.intellij.codeInspection.ex.InspectionToolWrapper;
import com.intellij.codeInspection.ex.ProblemDescriptorImpl;
import com.intellij.icons.AllIcons;
import com.intellij.ide.impl.ContentManagerWatcher;
import com.intellij.ide.ui.search.SearchableOptionsRegistrar;
import com.intellij.openapi.Disposable;
import com.intellij.openapi.application.Application;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.NotNullLazyValue;
import com.intellij.openapi.wm.ToolWindow;
import com.intellij.openapi.wm.ToolWindowAnchor;
import com.intellij.openapi.wm.ToolWindowId;
import com.intellij.openapi.wm.ToolWindowManager;
import com.intellij.psi.PsiElement;
import com.intellij.ui.content.ContentFactory;
import com.intellij.ui.content.ContentManager;
import com.intellij.ui.content.ContentUI;
import com.intellij.ui.content.TabbedPaneContentUI;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.regex.Pattern;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class InspectionManagerEx
extends InspectionManagerBase {
    private GlobalInspectionContextImpl myGlobalInspectionContext = null;
    private final NotNullLazyValue<ContentManager> myContentManager;
    private final Set<GlobalInspectionContextImpl> myRunningContexts = new HashSet<GlobalInspectionContextImpl>();
    private final AtomicBoolean myToolsAreInitialized = new AtomicBoolean(false);
    private static final Pattern HTML_PATTERN = Pattern.compile("<[^<>]*>");

    public InspectionManagerEx(final Project project) {
        super(project);
        this.myContentManager = ApplicationManager.getApplication().isHeadlessEnvironment() ? new NotNullLazyValue<ContentManager>(){

            @NotNull
            protected ContentManager compute() {
                ContentManager contentManager = ContentFactory.SERVICE.getInstance().createContentManager((ContentUI)new TabbedPaneContentUI(), true, project);
                if (contentManager == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionManagerEx$1", "compute"));
                }
                return contentManager;
            }
        } : new NotNullLazyValue<ContentManager>(){

            @NotNull
            protected ContentManager compute() {
                ToolWindowManager toolWindowManager = ToolWindowManager.getInstance((Project)project);
                ToolWindow toolWindow = toolWindowManager.registerToolWindow(ToolWindowId.INSPECTION, true, ToolWindowAnchor.BOTTOM, (Disposable)project);
                ContentManager contentManager = toolWindow.getContentManager();
                toolWindow.setIcon(AllIcons.Toolwindows.ToolWindowInspection);
                new ContentManagerWatcher(toolWindow, contentManager);
                ContentManager contentManager2 = contentManager;
                if (contentManager2 == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionManagerEx$2", "compute"));
                }
                return contentManager2;
            }
        };
    }

    @Nullable
    public static SuppressIntentionAction[] getSuppressActions(@NotNull InspectionProfileEntry tool) {
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/InspectionManagerEx", "getSuppressActions"));
        }
        if (tool instanceof CustomSuppressableInspectionTool) {
            return ((CustomSuppressableInspectionTool)tool).getSuppressActions(null);
        }
        if (tool instanceof BatchSuppressableTool) {
            Object[] actions = ((BatchSuppressableTool)tool).getBatchSuppressActions(null);
            return (SuppressIntentionAction[])ContainerUtil.map2Array((Object[])actions, SuppressIntentionAction.class, (Function)new Function<LocalQuickFix, SuppressIntentionAction>(){

                public SuppressIntentionAction fun(LocalQuickFix fix) {
                    return SuppressIntentionActionFromFix.convertBatchToSuppressIntentionAction((SuppressQuickFix)fix);
                }
            });
        }
        return null;
    }

    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, @NotNull ProblemHighlightType highlightType, @Nullable HintAction hintAction, boolean onTheFly, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/InspectionManagerEx", "createProblemDescriptor"));
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ex/InspectionManagerEx", "createProblemDescriptor"));
        }
        if (highlightType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/ex/InspectionManagerEx", "createProblemDescriptor"));
        }
        ProblemDescriptorImpl problemDescriptorImpl = new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, null, hintAction, onTheFly);
        if (problemDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionManagerEx", "createProblemDescriptor"));
        }
        return problemDescriptorImpl;
    }

    @NotNull
    public GlobalInspectionContextImpl createNewGlobalContext(boolean reuse) {
        GlobalInspectionContextImpl inspectionContext;
        if (reuse) {
            if (this.myGlobalInspectionContext == null) {
                this.myGlobalInspectionContext = inspectionContext = new GlobalInspectionContextImpl(this.getProject(), this.myContentManager);
            } else {
                inspectionContext = this.myGlobalInspectionContext;
            }
        } else {
            inspectionContext = new GlobalInspectionContextImpl(this.getProject(), this.myContentManager);
        }
        this.myRunningContexts.add(inspectionContext);
        GlobalInspectionContextImpl globalInspectionContextImpl = inspectionContext;
        if (globalInspectionContextImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionManagerEx", "createNewGlobalContext"));
        }
        return globalInspectionContextImpl;
    }

    public void setProfile(String name) {
        this.myCurrentProfileName = name;
    }

    public void closeRunningContext(GlobalInspectionContextImpl globalInspectionContext) {
        this.myRunningContexts.remove((Object)globalInspectionContext);
    }

    public Set<GlobalInspectionContextImpl> getRunningContexts() {
        return this.myRunningContexts;
    }

    @Deprecated
    @NotNull
    public ProblemDescriptor createProblemDescriptor(@NotNull PsiElement psiElement, @NotNull String descriptionTemplate, @NotNull ProblemHighlightType highlightType, @Nullable HintAction hintAction, LocalQuickFix ... fixes) {
        if (psiElement == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/InspectionManagerEx", "createProblemDescriptor"));
        }
        if (descriptionTemplate == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ex/InspectionManagerEx", "createProblemDescriptor"));
        }
        if (highlightType == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/ex/InspectionManagerEx", "createProblemDescriptor"));
        }
        ProblemDescriptorImpl problemDescriptorImpl = new ProblemDescriptorImpl(psiElement, psiElement, descriptionTemplate, fixes, highlightType, false, null, hintAction, true);
        if (problemDescriptorImpl == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/ex/InspectionManagerEx", "createProblemDescriptor"));
        }
        return problemDescriptorImpl;
    }

    public NotNullLazyValue<ContentManager> getContentManager() {
        return this.myContentManager;
    }

    public void buildInspectionSearchIndexIfNecessary() {
        if (!this.myToolsAreInitialized.getAndSet(true)) {
            final SearchableOptionsRegistrar myOptionsRegistrar = SearchableOptionsRegistrar.getInstance();
            final InspectionToolRegistrar toolRegistrar = InspectionToolRegistrar.getInstance();
            Application app = ApplicationManager.getApplication();
            if (app.isUnitTestMode() || app.isHeadlessEnvironment()) {
                return;
            }
            app.executeOnPooledThread(new Runnable(){

                @Override
                public void run() {
                    List<InspectionToolWrapper> tools = toolRegistrar.createTools();
                    for (InspectionToolWrapper toolWrapper : tools) {
                        InspectionManagerEx.processText(toolWrapper.getDisplayName().toLowerCase(), toolWrapper, myOptionsRegistrar);
                        String description = toolWrapper.loadDescription();
                        if (description == null) continue;
                        String descriptionText = HTML_PATTERN.matcher(description).replaceAll(" ");
                        InspectionManagerEx.processText(descriptionText, toolWrapper, myOptionsRegistrar);
                    }
                }
            });
        }
    }

    private static void processText(@NotNull @NonNls String descriptionText, @NotNull InspectionToolWrapper tool, @NotNull SearchableOptionsRegistrar myOptionsRegistrar) {
        if (descriptionText == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/ex/InspectionManagerEx", "processText"));
        }
        if (tool == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/ex/InspectionManagerEx", "processText"));
        }
        if (myOptionsRegistrar == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInspection/ex/InspectionManagerEx", "processText"));
        }
        if (ApplicationManager.getApplication().isDisposed()) {
            return;
        }
        Set words = myOptionsRegistrar.getProcessedWordsWithoutStemming(descriptionText);
        for (String word : words) {
            myOptionsRegistrar.addOption(word, tool.getShortName(), tool.getDisplayName(), "Errors", "Inspections");
        }
    }
}

