/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.defaultFileTemplateUsage;

import com.intellij.codeInspection.BaseJavaLocalInspectionTool;
import com.intellij.codeInspection.CommonProblemDescriptor;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.codeInspection.defaultFileTemplateUsage.FileHeaderChecker;
import com.intellij.codeInspection.defaultFileTemplateUsage.ReplaceWithFileTemplateFix;
import com.intellij.ide.fileTemplates.FileTemplate;
import com.intellij.ide.fileTemplates.impl.FileTemplateConfigurable;
import com.intellij.openapi.command.WriteCommandAction;
import com.intellij.openapi.options.Configurable;
import com.intellij.openapi.options.ShowSettingsUtil;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaToken;
import com.intellij.psi.PsiWhiteSpace;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class DefaultFileTemplateUsageInspection
extends BaseJavaLocalInspectionTool {
    @Deprecated
    public boolean CHECK_FILE_HEADER = true;
    @Deprecated
    public boolean CHECK_TRY_CATCH_SECTION = true;
    @Deprecated
    public boolean CHECK_METHOD_BODY = true;

    @NotNull
    public String getGroupDisplayName() {
        String string = GENERAL_GROUP_NAME;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @NotNull
    public String getDisplayName() {
        String string = InspectionsBundle.message((String)"default.file.template.display.name", (Object[])new Object[0]);
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection", "getDisplayName"));
        }
        return string;
    }

    @NotNull
    @NonNls
    public String getShortName() {
        if ("DefaultFileTemplate" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection", "getShortName"));
        }
        return "DefaultFileTemplate";
    }

    static Pair<? extends PsiElement, ? extends PsiElement> getInteriorRange(PsiCodeBlock codeBlock) {
        PsiElement child;
        int end;
        PsiElement child2;
        int start;
        PsiElement[] children = codeBlock.getChildren();
        if (children.length == 0) {
            return Pair.create((Object)codeBlock, (Object)codeBlock);
        }
        for (start = 0; start < children.length && ((child2 = children[start]) instanceof PsiWhiteSpace || child2 instanceof PsiJavaToken && ((PsiJavaToken)child2).getTokenType() == JavaTokenType.LBRACE); ++start) {
        }
        for (end = children.length - 1; end > start && ((child = children[end]) instanceof PsiWhiteSpace || child instanceof PsiJavaToken && ((PsiJavaToken)child).getTokenType() == JavaTokenType.RBRACE); --end) {
        }
        return Pair.create((Object)children[start], (Object)children[end]);
    }

    @Nullable
    public ProblemDescriptor[] checkFile(@NotNull PsiFile file, @NotNull InspectionManager manager, boolean isOnTheFly) {
        ProblemDescriptor[] problemDescriptorArray;
        if (file == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection", "checkFile"));
        }
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection", "checkFile"));
        }
        ProblemDescriptor descriptor = FileHeaderChecker.checkFileHeader(file, manager, isOnTheFly);
        if (descriptor == null) {
            problemDescriptorArray = null;
        } else {
            ProblemDescriptor[] problemDescriptorArray2 = new ProblemDescriptor[1];
            problemDescriptorArray = problemDescriptorArray2;
            problemDescriptorArray2[0] = descriptor;
        }
        return problemDescriptorArray;
    }

    public boolean isEnabledByDefault() {
        return true;
    }

    public static LocalQuickFix createEditFileTemplateFix(FileTemplate templateToEdit, ReplaceWithFileTemplateFix replaceTemplateFix) {
        return new MyLocalQuickFix(templateToEdit, replaceTemplateFix);
    }

    private static class MyLocalQuickFix
    implements LocalQuickFix {
        private final FileTemplate myTemplateToEdit;
        private final ReplaceWithFileTemplateFix myReplaceTemplateFix;

        public MyLocalQuickFix(FileTemplate templateToEdit, ReplaceWithFileTemplateFix replaceTemplateFix) {
            this.myTemplateToEdit = templateToEdit;
            this.myReplaceTemplateFix = replaceTemplateFix;
        }

        @NotNull
        public String getName() {
            String string = InspectionsBundle.message((String)"default.file.template.edit.template", (Object[])new Object[0]);
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection$MyLocalQuickFix", "getName"));
            }
            return string;
        }

        @NotNull
        public String getFamilyName() {
            String string = this.getName();
            if (string == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection$MyLocalQuickFix", "getFamilyName"));
            }
            return string;
        }

        public void applyFix(final @NotNull Project project, final @NotNull ProblemDescriptor descriptor) {
            if (project == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection$MyLocalQuickFix", "applyFix"));
            }
            if (descriptor == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/defaultFileTemplateUsage/DefaultFileTemplateUsageInspection$MyLocalQuickFix", "applyFix"));
            }
            final FileTemplateConfigurable configurable = new FileTemplateConfigurable();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    configurable.setTemplate(MyLocalQuickFix.this.myTemplateToEdit, null);
                    boolean ok = ShowSettingsUtil.getInstance().editConfigurable(project, (Configurable)configurable);
                    if (ok) {
                        WriteCommandAction.runWriteCommandAction((Project)project, (Runnable)new Runnable(){

                            @Override
                            public void run() {
                                MyLocalQuickFix.this.myReplaceTemplateFix.applyFix(project, (CommonProblemDescriptor)descriptor);
                            }
                        });
                    }
                }
            });
        }
    }
}

