/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow.instructions;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.PropertyUtil;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class MethodCallInstruction
extends Instruction {
    @Nullable
    private final PsiCallExpression myCall;
    @Nullable
    private final PsiType myType;
    @NotNull
    private final PsiExpression[] myArgs;
    private final boolean myShouldFlushFields;
    @NotNull
    private final PsiExpression myContext;
    private final MethodType myMethodType;
    @Nullable
    private final DfaValue myPrecalculatedReturnValue;

    public MethodCallInstruction(@NotNull PsiExpression context, MethodType methodType, @Nullable PsiType resultType) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction", "<init>"));
        }
        this.myContext = context;
        this.myMethodType = methodType;
        this.myCall = null;
        this.myArgs = PsiExpression.EMPTY_ARRAY;
        this.myType = resultType;
        this.myShouldFlushFields = false;
        this.myPrecalculatedReturnValue = null;
    }

    public MethodCallInstruction(@NotNull PsiCallExpression call, @Nullable DfaValue precalculatedReturnValue) {
        if (call == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction", "<init>"));
        }
        this.myContext = call;
        this.myMethodType = MethodType.REGULAR_METHOD_CALL;
        this.myCall = call;
        PsiExpressionList argList = call.getArgumentList();
        this.myArgs = argList != null ? argList.getExpressions() : PsiExpression.EMPTY_ARRAY;
        this.myType = this.myCall.getType();
        this.myShouldFlushFields = (!(this.myCall instanceof PsiNewExpression) || this.myType == null || this.myType.getArrayDimensions() <= 0) && !MethodCallInstruction.isPureCall(call);
        this.myPrecalculatedReturnValue = precalculatedReturnValue;
    }

    private static boolean isPureCall(PsiCallExpression call) {
        PsiMethod method = call.resolveMethod();
        if (method == null) {
            return false;
        }
        PsiAnnotation anno = ControlFlowAnalyzer.findContractAnnotation(method);
        if (anno != null && Boolean.TRUE.equals(AnnotationUtil.getBooleanAttributeValue((PsiAnnotation)anno, (String)"pure"))) {
            return true;
        }
        return PropertyUtil.isSimplePropertyGetter((PsiMethod)method);
    }

    @Nullable
    public PsiType getResultType() {
        return this.myType;
    }

    @NotNull
    public PsiExpression[] getArgs() {
        if (this.myArgs == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction", "getArgs"));
        }
        return this.myArgs;
    }

    public MethodType getMethodType() {
        return this.myMethodType;
    }

    public boolean shouldFlushFields() {
        return this.myShouldFlushFields;
    }

    @Override
    public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
        return visitor.visitMethodCall(this, runner, stateBefore);
    }

    @Nullable
    public PsiCallExpression getCallExpression() {
        return this.myCall;
    }

    @NotNull
    public PsiExpression getContext() {
        PsiExpression psiExpression = this.myContext;
        if (psiExpression == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/instructions/MethodCallInstruction", "getContext"));
        }
        return psiExpression;
    }

    @Nullable
    public DfaValue getPrecalculatedReturnValue() {
        return this.myPrecalculatedReturnValue;
    }

    public String toString() {
        return this.myMethodType == MethodType.UNBOXING ? "UNBOX" : (this.myMethodType == MethodType.BOXING ? "BOX" : "CALL_METHOD: " + (this.myCall == null ? "null" : this.myCall.getText()));
    }

    public static enum MethodType {
        BOXING,
        UNBOXING,
        REGULAR_METHOD_CALL,
        CAST;

    }
}

