/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.NullableNotNullManager;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.psi.LambdaUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiType;
import java.util.HashSet;
import java.util.Set;
import org.jetbrains.annotations.NotNull;

public class StandardDataFlowRunner
extends DataFlowRunner {
    private final Set<Instruction> myCCEInstructions = new HashSet<Instruction>();
    private boolean myInNullableMethod = false;
    private boolean myInNotNullMethod = false;
    private boolean myIsInMethod = false;

    public StandardDataFlowRunner(PsiElement block) {
        super(block);
    }

    @Override
    protected void prepareAnalysis(@NotNull PsiElement psiBlock, Iterable<DfaMemoryState> initialStates) {
        PsiMethod method;
        if (psiBlock == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/dataFlow/StandardDataFlowRunner", "prepareAnalysis"));
        }
        PsiElement parent = psiBlock.getParent();
        this.myIsInMethod = parent instanceof PsiMethod;
        if (this.myIsInMethod) {
            PsiMethod method2 = (PsiMethod)parent;
            PsiType returnType = method2.getReturnType();
            this.myInNullableMethod = NullableNotNullManager.isNullable((PsiModifierListOwner)method2) || returnType != null && returnType.equalsToText("java.lang.Void");
            this.myInNotNullMethod = NullableNotNullManager.isNotNull((PsiModifierListOwner)method2);
        } else if (parent instanceof PsiLambdaExpression && (method = LambdaUtil.getFunctionalInterfaceMethod((PsiType)((PsiLambdaExpression)parent).getFunctionalInterfaceType())) != null) {
            this.myIsInMethod = true;
            PsiType returnType = method.getReturnType();
            this.myInNullableMethod = NullableNotNullManager.isNullable((PsiModifierListOwner)method) || returnType != null && returnType.equalsToText("java.lang.Void");
            this.myInNotNullMethod = NullableNotNullManager.isNotNull((PsiModifierListOwner)method);
        }
        this.myCCEInstructions.clear();
    }

    public void onInstructionProducesCCE(Instruction instruction) {
        this.myCCEInstructions.add(instruction);
    }

    @NotNull
    public Set<Instruction> getCCEInstructions() {
        Set<Instruction> set = this.myCCEInstructions;
        if (set == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardDataFlowRunner", "getCCEInstructions"));
        }
        return set;
    }

    public boolean isInNotNullMethod() {
        return this.myInNotNullMethod;
    }

    public boolean isInNullableMethod() {
        return this.myInNullableMethod;
    }

    public boolean isInMethod() {
        return this.myIsInMethod;
    }

    @NotNull
    public static Set<Instruction> getRedundantInstanceofs(DataFlowRunner runner, StandardInstructionVisitor visitor) {
        HashSet<Instruction> result = new HashSet<Instruction>(1);
        for (Instruction instruction : runner.getInstructions()) {
            if (!(instruction instanceof InstanceofInstruction) || !visitor.isInstanceofRedundant((InstanceofInstruction)instruction)) continue;
            result.add(instruction);
        }
        HashSet<Instruction> hashSet = result;
        if (hashSet == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/StandardDataFlowRunner", "getRedundantInstanceofs"));
        }
        return hashSet;
    }
}

