/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.dataFlow;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.ConditionCheckManager;
import com.intellij.codeInsight.ConditionChecker;
import com.intellij.codeInspection.dataFlow.ControlFlow;
import com.intellij.codeInspection.dataFlow.DataFlowRunner;
import com.intellij.codeInspection.dataFlow.DfaInstructionState;
import com.intellij.codeInspection.dataFlow.DfaMemoryState;
import com.intellij.codeInspection.dataFlow.DfaPsiUtil;
import com.intellij.codeInspection.dataFlow.InstructionVisitor;
import com.intellij.codeInspection.dataFlow.MethodContract;
import com.intellij.codeInspection.dataFlow.Nullness;
import com.intellij.codeInspection.dataFlow.StandardInstructionVisitor;
import com.intellij.codeInspection.dataFlow.instructions.AssignInstruction;
import com.intellij.codeInspection.dataFlow.instructions.BinopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.CheckReturnValueInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ConditionalGotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.DupInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyInstruction;
import com.intellij.codeInspection.dataFlow.instructions.EmptyStackInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FieldReferenceInstruction;
import com.intellij.codeInspection.dataFlow.instructions.FlushVariableInstruction;
import com.intellij.codeInspection.dataFlow.instructions.GotoInstruction;
import com.intellij.codeInspection.dataFlow.instructions.InstanceofInstruction;
import com.intellij.codeInspection.dataFlow.instructions.Instruction;
import com.intellij.codeInspection.dataFlow.instructions.LambdaInstruction;
import com.intellij.codeInspection.dataFlow.instructions.MethodCallInstruction;
import com.intellij.codeInspection.dataFlow.instructions.NotInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PopInstruction;
import com.intellij.codeInspection.dataFlow.instructions.PushInstruction;
import com.intellij.codeInspection.dataFlow.instructions.ReturnInstruction;
import com.intellij.codeInspection.dataFlow.instructions.SwapInstruction;
import com.intellij.codeInspection.dataFlow.instructions.TypeCastInstruction;
import com.intellij.codeInspection.dataFlow.value.DfaConstValue;
import com.intellij.codeInspection.dataFlow.value.DfaUnknownValue;
import com.intellij.codeInspection.dataFlow.value.DfaValue;
import com.intellij.codeInspection.dataFlow.value.DfaValueFactory;
import com.intellij.codeInspection.dataFlow.value.DfaVariableValue;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.JavaCodeFragment;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.JavaRecursiveElementWalkingVisitor;
import com.intellij.psi.JavaTokenType;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiArrayAccessExpression;
import com.intellij.psi.PsiArrayInitializerExpression;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiAssertStatement;
import com.intellij.psi.PsiAssignmentExpression;
import com.intellij.psi.PsiBlockStatement;
import com.intellij.psi.PsiBreakStatement;
import com.intellij.psi.PsiCallExpression;
import com.intellij.psi.PsiCatchSection;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassObjectAccessExpression;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiConditionalExpression;
import com.intellij.psi.PsiContinueStatement;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDisjunctionType;
import com.intellij.psi.PsiDoWhileStatement;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiEmptyStatement;
import com.intellij.psi.PsiEnumConstant;
import com.intellij.psi.PsiErrorElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionCodeFragment;
import com.intellij.psi.PsiExpressionList;
import com.intellij.psi.PsiExpressionListStatement;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiForStatement;
import com.intellij.psi.PsiForeachStatement;
import com.intellij.psi.PsiIfStatement;
import com.intellij.psi.PsiInstanceOfExpression;
import com.intellij.psi.PsiLabeledStatement;
import com.intellij.psi.PsiLambdaExpression;
import com.intellij.psi.PsiLiteralExpression;
import com.intellij.psi.PsiLoopStatement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.PsiMember;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiMethodCallExpression;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNewExpression;
import com.intellij.psi.PsiParameter;
import com.intellij.psi.PsiParenthesizedExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.psi.PsiPostfixExpression;
import com.intellij.psi.PsiPrefixExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiReferenceExpression;
import com.intellij.psi.PsiResourceList;
import com.intellij.psi.PsiResourceVariable;
import com.intellij.psi.PsiReturnStatement;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiSuperExpression;
import com.intellij.psi.PsiSwitchLabelStatement;
import com.intellij.psi.PsiSwitchStatement;
import com.intellij.psi.PsiSynchronizedStatement;
import com.intellij.psi.PsiThisExpression;
import com.intellij.psi.PsiThrowStatement;
import com.intellij.psi.PsiTryStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiTypeCastExpression;
import com.intellij.psi.PsiTypeElement;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.PsiWhileStatement;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.tree.IElementType;
import com.intellij.psi.util.CachedValueProvider;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.psi.util.PropertyUtil;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.psi.util.PsiUtil;
import com.intellij.psi.util.TypeConversionUtil;
import com.intellij.util.IncorrectOperationException;
import com.intellij.util.SmartList;
import com.intellij.util.containers.ContainerUtil;
import com.intellij.util.containers.Stack;
import com.siyeh.ig.numeric.UnnecessaryExplicitNumericCastInspection;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ControlFlowAnalyzer
extends JavaElementVisitor {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.dataFlow.ControlFlowAnalyzer");
    public static final String ORG_JETBRAINS_ANNOTATIONS_CONTRACT = Contract.class.getName();
    private boolean myIgnoreAssertions;
    private final DfaValueFactory myFactory;
    private ControlFlow myCurrentFlow;
    private Stack<CatchDescriptor> myCatchStack;
    private DfaValue myRuntimeException;
    private DfaValue myError;
    private DfaValue myString;
    private PsiType myNpe;
    private PsiType myAssertionError;
    private Stack<PsiElement> myElementStack = new Stack();
    private DfaVariableValue myExceptionHolder;

    ControlFlowAnalyzer(DfaValueFactory valueFactory) {
        this.myFactory = valueFactory;
    }

    public ControlFlow buildControlFlow(@NotNull PsiElement codeFragment, boolean ignoreAssertions) {
        if (codeFragment == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer", "buildControlFlow"));
        }
        this.myIgnoreAssertions = ignoreAssertions;
        PsiManager manager = codeFragment.getManager();
        GlobalSearchScope scope = codeFragment.getResolveScope();
        this.myRuntimeException = this.myFactory.createTypeValue((PsiType)ControlFlowAnalyzer.createClassType(manager, scope, "java.lang.RuntimeException"), Nullness.NOT_NULL);
        this.myError = this.myFactory.createTypeValue((PsiType)ControlFlowAnalyzer.createClassType(manager, scope, "java.lang.Error"), Nullness.NOT_NULL);
        this.myNpe = ControlFlowAnalyzer.createClassType(manager, scope, "java.lang.NullPointerException");
        this.myAssertionError = ControlFlowAnalyzer.createClassType(manager, scope, "java.lang.AssertionError");
        this.myString = this.myFactory.createTypeValue((PsiType)ControlFlowAnalyzer.createClassType(manager, scope, "java.lang.String"), Nullness.NOT_NULL);
        PsiParameter mockVar = JavaPsiFacade.getElementFactory((Project)manager.getProject()).createParameterFromText("java.lang.Object $exception$", null);
        this.myExceptionHolder = this.myFactory.getVarFactory().createVariableValue((PsiVariable)mockVar, false);
        this.myCatchStack = new Stack();
        this.myCurrentFlow = new ControlFlow(this.myFactory);
        try {
            codeFragment.accept((PsiElementVisitor)this);
        }
        catch (CannotAnalyzeException e) {
            return null;
        }
        PsiElement parent = codeFragment.getParent();
        if (parent instanceof PsiLambdaExpression && codeFragment instanceof PsiExpression) {
            this.addInstruction(new CheckReturnValueInstruction(codeFragment));
        }
        this.addInstruction(new ReturnInstruction(false));
        return this.myCurrentFlow;
    }

    private static PsiClassType createClassType(PsiManager manager, GlobalSearchScope scope, String fqn) {
        PsiClass aClass = JavaPsiFacade.getInstance((Project)manager.getProject()).findClass(fqn, scope);
        if (aClass != null) {
            return JavaPsiFacade.getElementFactory((Project)manager.getProject()).createType(aClass);
        }
        return JavaPsiFacade.getElementFactory((Project)manager.getProject()).createTypeByFQClassName(fqn, scope);
    }

    private <T extends Instruction> T addInstruction(T i) {
        this.myCurrentFlow.addInstruction(i);
        return i;
    }

    private ControlFlow.ControlFlowOffset getEndOffset(PsiElement element) {
        return this.myCurrentFlow.getEndOffset(element);
    }

    private ControlFlow.ControlFlowOffset getStartOffset(PsiElement element) {
        return this.myCurrentFlow.getStartOffset(element);
    }

    private void startElement(PsiElement element) {
        this.myCurrentFlow.startElement(element);
        this.myElementStack.push((Object)element);
    }

    private void finishElement(PsiElement element) {
        this.myCurrentFlow.finishElement(element);
        PsiElement popped = (PsiElement)this.myElementStack.pop();
        if (element != popped) {
            throw new AssertionError((Object)("Expected " + element + ", popped " + popped));
        }
    }

    public void visitErrorElement(PsiErrorElement element) {
        throw new CannotAnalyzeException();
    }

    public void visitAssignmentExpression(PsiAssignmentExpression expression) {
        PsiExpression lExpr = expression.getLExpression();
        PsiExpression rExpr = expression.getRExpression();
        this.startElement((PsiElement)expression);
        if (rExpr == null) {
            this.pushUnknown();
            this.finishElement((PsiElement)expression);
            return;
        }
        IElementType op = expression.getOperationTokenType();
        PsiType type = expression.getType();
        boolean isBoolean = PsiType.BOOLEAN.equals((Object)type);
        if (op == JavaTokenType.EQ) {
            lExpr.accept((PsiElementVisitor)this);
            rExpr.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(rExpr, type);
        } else if (op == JavaTokenType.ANDEQ) {
            if (isBoolean) {
                this.generateBooleanAssignmentExpression(true, lExpr, rExpr, type);
            } else {
                this.generateDefaultAssignmentBinOp(lExpr, rExpr, type);
            }
        } else if (op == JavaTokenType.OREQ) {
            if (isBoolean) {
                this.generateBooleanAssignmentExpression(false, lExpr, rExpr, type);
            } else {
                this.generateDefaultAssignmentBinOp(lExpr, rExpr, type);
            }
        } else if (op == JavaTokenType.XOREQ) {
            if (isBoolean) {
                this.generateXorExpression((PsiExpression)expression, new PsiExpression[]{lExpr, rExpr}, type, true);
            } else {
                this.generateDefaultAssignmentBinOp(lExpr, rExpr, type);
            }
        } else if (op == JavaTokenType.PLUSEQ && type != null && type.equalsToText("java.lang.String")) {
            lExpr.accept((PsiElementVisitor)this);
            this.addInstruction(new DupInstruction());
            rExpr.accept((PsiElementVisitor)this);
            this.addInstruction(new BinopInstruction(JavaTokenType.PLUS, null, lExpr.getProject()));
        } else {
            this.generateDefaultAssignmentBinOp(lExpr, rExpr, type);
        }
        this.addInstruction(new AssignInstruction(rExpr));
        this.finishElement((PsiElement)expression);
    }

    private void generateDefaultAssignmentBinOp(PsiExpression lExpr, PsiExpression rExpr, PsiType exprType) {
        lExpr.accept((PsiElementVisitor)this);
        this.addInstruction(new DupInstruction());
        this.generateBoxingUnboxingInstructionFor(lExpr, exprType);
        rExpr.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(rExpr, exprType);
        this.addInstruction(new BinopInstruction(null, null, lExpr.getProject()));
    }

    public void visitAssertStatement(PsiAssertStatement statement) {
        if (this.myIgnoreAssertions) {
            return;
        }
        this.startElement((PsiElement)statement);
        PsiExpression condition = statement.getAssertCondition();
        PsiExpression description = statement.getAssertDescription();
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition, (PsiType)PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), false, (PsiElement)condition));
            if (description != null) {
                description.accept((PsiElementVisitor)this);
            }
            this.initException(this.myAssertionError);
            this.addThrowCode(false);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitDeclarationStatement(PsiDeclarationStatement statement) {
        PsiElement[] elements;
        this.startElement((PsiElement)statement);
        for (PsiElement element : elements = statement.getDeclaredElements()) {
            PsiVariable variable;
            PsiExpression initializer;
            if (element instanceof PsiClass) {
                this.addInstruction(new EmptyInstruction(element));
                continue;
            }
            if (!(element instanceof PsiVariable) || (initializer = (variable = (PsiVariable)element).getInitializer()) == null) continue;
            this.initializeVariable(variable, initializer);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitField(PsiField field) {
        PsiExpression initializer = field.getInitializer();
        if (initializer != null) {
            this.initializeVariable((PsiVariable)field, initializer);
        }
    }

    private void initializeVariable(PsiVariable variable, PsiExpression initializer) {
        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue(variable, false);
        this.addInstruction(new PushInstruction(dfaVariable, initializer));
        initializer.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(initializer, variable.getType());
        this.addInstruction(new AssignInstruction(initializer));
        this.addInstruction(new PopInstruction());
    }

    public void visitCodeFragment(JavaCodeFragment codeFragment) {
        PsiExpression expression;
        this.startElement((PsiElement)codeFragment);
        if (codeFragment instanceof PsiExpressionCodeFragment && (expression = ((PsiExpressionCodeFragment)codeFragment).getExpression()) != null) {
            expression.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)codeFragment);
    }

    public void visitCodeBlock(PsiCodeBlock block) {
        this.startElement((PsiElement)block);
        for (PsiStatement statement : block.getStatements()) {
            statement.accept((PsiElementVisitor)this);
        }
        this.flushCodeBlockVariables(block);
        this.finishElement((PsiElement)block);
    }

    private void flushCodeBlockVariables(PsiCodeBlock block) {
        block6: {
            PsiResourceList list;
            PsiElement parent;
            block8: {
                block7: {
                    block5: {
                        for (PsiStatement statement : block.getStatements()) {
                            if (!(statement instanceof PsiDeclarationStatement)) continue;
                            for (PsiElement declaration : ((PsiDeclarationStatement)statement).getDeclaredElements()) {
                                if (!(declaration instanceof PsiVariable)) continue;
                                this.myCurrentFlow.removeVariable((PsiVariable)declaration);
                            }
                        }
                        parent = block.getParent();
                        if (!(parent instanceof PsiCatchSection)) break block5;
                        this.myCurrentFlow.removeVariable((PsiVariable)((PsiCatchSection)parent).getParameter());
                        break block6;
                    }
                    if (!(parent instanceof PsiForeachStatement)) break block7;
                    this.myCurrentFlow.removeVariable((PsiVariable)((PsiForeachStatement)parent).getIterationParameter());
                    break block6;
                }
                if (!(parent instanceof PsiForStatement)) break block8;
                PsiStatement statement = ((PsiForStatement)parent).getInitialization();
                if (!(statement instanceof PsiDeclarationStatement)) break block6;
                for (PsiElement declaration : ((PsiDeclarationStatement)statement).getDeclaredElements()) {
                    if (!(declaration instanceof PsiVariable)) continue;
                    this.myCurrentFlow.removeVariable((PsiVariable)declaration);
                }
                break block6;
            }
            if (parent instanceof PsiTryStatement && (list = ((PsiTryStatement)parent).getResourceList()) != null) {
                for (PsiResourceVariable variable : list.getResourceVariables()) {
                    this.myCurrentFlow.removeVariable((PsiVariable)variable);
                }
            }
        }
    }

    public void visitBlockStatement(PsiBlockStatement statement) {
        this.startElement((PsiElement)statement);
        statement.getCodeBlock().accept((PsiElementVisitor)this);
        this.finishElement((PsiElement)statement);
    }

    public void visitBreakStatement(PsiBreakStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement exitedStatement = statement.findExitedStatement();
        if (exitedStatement != null) {
            this.flushVariablesOnControlTransfer((PsiElement)exitedStatement);
            this.addInstruction(new GotoInstruction(this.getEndOffset((PsiElement)exitedStatement)));
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitContinueStatement(PsiContinueStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement continuedStatement = statement.findContinuedStatement();
        if (continuedStatement instanceof PsiLoopStatement) {
            PsiStatement body = ((PsiLoopStatement)continuedStatement).getBody();
            this.flushVariablesOnControlTransfer((PsiElement)body);
            this.addInstruction(new GotoInstruction(this.getEndOffset((PsiElement)body)));
        } else {
            this.addInstruction(new EmptyInstruction(null));
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitDoWhileStatement(PsiDoWhileStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept((PsiElementVisitor)this);
            PsiExpression condition = statement.getCondition();
            if (condition != null) {
                condition.accept((PsiElementVisitor)this);
                this.generateBoxingUnboxingInstructionFor(condition, (PsiType)PsiType.BOOLEAN);
                this.addInstruction(new ConditionalGotoInstruction(this.getStartOffset((PsiElement)statement), false, (PsiElement)condition));
            }
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitEmptyStatement(PsiEmptyStatement statement) {
        this.startElement((PsiElement)statement);
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionStatement(PsiExpressionStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression expr = statement.getExpression();
        expr.accept((PsiElementVisitor)this);
        this.addInstruction(new PopInstruction());
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionListStatement(PsiExpressionListStatement statement) {
        PsiExpression[] expressions;
        this.startElement((PsiElement)statement);
        for (PsiExpression expr : expressions = statement.getExpressionList().getExpressions()) {
            expr.accept((PsiElementVisitor)this);
            this.addInstruction(new PopInstruction());
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitForeachStatement(PsiForeachStatement statement) {
        this.startElement((PsiElement)statement);
        PsiParameter parameter = statement.getIterationParameter();
        PsiExpression iteratedValue = statement.getIteratedValue();
        if (iteratedValue != null) {
            iteratedValue.accept((PsiElementVisitor)this);
            this.addInstruction(new FieldReferenceInstruction(iteratedValue, "Collection iterator or array.length"));
        }
        ControlFlow.ControlFlowOffset offset = this.myCurrentFlow.getNextOffset();
        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue((PsiVariable)parameter, false);
        this.addInstruction(new FlushVariableInstruction(dfaVariable));
        this.pushUnknown();
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), true, null));
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept((PsiElementVisitor)this);
        }
        this.addInstruction(new GotoInstruction(offset));
        this.finishElement((PsiElement)statement);
        this.myCurrentFlow.removeVariable((PsiVariable)parameter);
    }

    public void visitForStatement(PsiForStatement statement) {
        PsiStatement update;
        PsiExpression condition;
        this.startElement((PsiElement)statement);
        final ArrayList declaredVariables = new ArrayList();
        PsiStatement initialization = statement.getInitialization();
        if (initialization != null) {
            initialization.accept((PsiElementVisitor)this);
            initialization.accept((PsiElementVisitor)new JavaRecursiveElementWalkingVisitor(){

                public void visitReferenceExpression(PsiReferenceExpression expression) {
                    this.visitElement((PsiElement)expression);
                }

                public void visitDeclarationStatement(PsiDeclarationStatement statement) {
                    PsiElement[] declaredElements;
                    for (PsiElement element : declaredElements = statement.getDeclaredElements()) {
                        if (!(element instanceof PsiVariable)) continue;
                        declaredVariables.add(element);
                    }
                }
            });
        }
        if ((condition = statement.getCondition()) != null) {
            condition.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition, (PsiType)PsiType.BOOLEAN);
        } else {
            this.addInstruction(new PushInstruction(statement.getRParenth() == null ? null : this.myFactory.getConstFactory().getTrue(), null));
        }
        this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), true, (PsiElement)condition));
        PsiStatement body = statement.getBody();
        if (body != null) {
            body.accept((PsiElementVisitor)this);
        }
        if ((update = statement.getUpdate()) != null) {
            update.accept((PsiElementVisitor)this);
        }
        ControlFlow.ControlFlowOffset offset = initialization != null ? this.getEndOffset((PsiElement)initialization) : this.getStartOffset((PsiElement)statement);
        this.addInstruction(new GotoInstruction(offset));
        this.finishElement((PsiElement)statement);
        for (PsiElement declaredVariable : declaredVariables) {
            PsiVariable psiVariable = (PsiVariable)declaredVariable;
            this.myCurrentFlow.removeVariable(psiVariable);
        }
    }

    public void visitIfStatement(PsiIfStatement statement) {
        ControlFlow.ControlFlowOffset offset;
        this.startElement((PsiElement)statement);
        PsiExpression condition = statement.getCondition();
        PsiStatement thenStatement = statement.getThenBranch();
        PsiStatement elseStatement = statement.getElseBranch();
        ControlFlow.ControlFlowOffset controlFlowOffset = offset = elseStatement != null ? this.getStartOffset((PsiElement)elseStatement) : this.getEndOffset((PsiElement)statement);
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition, (PsiType)PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(offset, true, (PsiElement)condition));
        }
        if (thenStatement != null) {
            thenStatement.accept((PsiElementVisitor)this);
        }
        if (elseStatement != null) {
            offset = this.getEndOffset((PsiElement)statement);
            GotoInstruction instruction = new GotoInstruction(offset);
            this.addInstruction(instruction);
            elseStatement.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitStatement(PsiStatement statement) {
        this.startElement((PsiElement)statement);
        this.finishElement((PsiElement)statement);
    }

    public void visitLabeledStatement(PsiLabeledStatement statement) {
        this.startElement((PsiElement)statement);
        PsiStatement childStatement = statement.getStatement();
        if (childStatement != null) {
            childStatement.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitLambdaExpression(PsiLambdaExpression expression) {
        this.startElement((PsiElement)expression);
        DfaValue dfaValue = this.myFactory.createValue((PsiExpression)expression);
        this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression));
        this.addInstruction(new LambdaInstruction(expression));
        this.finishElement((PsiElement)expression);
    }

    public void visitReturnStatement(PsiReturnStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression returnValue = statement.getReturnValue();
        if (returnValue != null) {
            returnValue.accept((PsiElementVisitor)this);
            PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)statement, PsiMethod.class, (boolean)true, (Class[])new Class[]{PsiMember.class});
            if (method != null) {
                this.generateBoxingUnboxingInstructionFor(returnValue, method.getReturnType());
            }
            this.addInstruction(new CheckReturnValueInstruction((PsiElement)returnValue));
        }
        this.returnCheckingFinally();
        this.finishElement((PsiElement)statement);
    }

    private void returnCheckingFinally() {
        ControlFlow.ControlFlowOffset finallyOffset = this.getFinallyOffset();
        if (finallyOffset != null) {
            this.addInstruction(new PushInstruction(this.myExceptionHolder, null));
            this.addInstruction(new PushInstruction(this.myString, null));
            this.addInstruction(new AssignInstruction(null));
            this.addInstruction(new PopInstruction());
            this.addInstruction(new GotoInstruction(finallyOffset));
        } else {
            this.addInstruction(new ReturnInstruction(false));
        }
    }

    public void visitSwitchLabelStatement(PsiSwitchLabelStatement statement) {
        this.startElement((PsiElement)statement);
        this.finishElement((PsiElement)statement);
    }

    public void visitSwitchStatement(PsiSwitchStatement switchStmt) {
        PsiCodeBlock body;
        this.startElement((PsiElement)switchStmt);
        PsiExpression caseExpression = switchStmt.getExpression();
        HashSet<PsiEnumConstant> enumValues = null;
        if (caseExpression != null) {
            caseExpression.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(caseExpression, (PsiType)PsiType.INT);
            PsiClass psiClass = PsiUtil.resolveClassInType((PsiType)caseExpression.getType());
            if (psiClass != null && psiClass.isEnum()) {
                this.addInstruction(new FieldReferenceInstruction(caseExpression, "switch statement expression"));
                enumValues = new HashSet<PsiEnumConstant>();
                for (PsiField f : psiClass.getFields()) {
                    if (!(f instanceof PsiEnumConstant)) continue;
                    enumValues.add((PsiEnumConstant)f);
                }
            } else {
                this.addInstruction(new PopInstruction());
            }
        }
        if ((body = switchStmt.getBody()) != null) {
            PsiStatement[] statements = body.getStatements();
            PsiSwitchLabelStatement defaultLabel = null;
            for (PsiStatement statement : statements) {
                if (!(statement instanceof PsiSwitchLabelStatement)) continue;
                PsiSwitchLabelStatement psiLabelStatement = (PsiSwitchLabelStatement)statement;
                if (psiLabelStatement.isDefaultCase()) {
                    defaultLabel = psiLabelStatement;
                    continue;
                }
                try {
                    ControlFlow.ControlFlowOffset offset = this.getStartOffset((PsiElement)statement);
                    PsiExpression caseValue = psiLabelStatement.getCaseValue();
                    if (caseValue != null && caseExpression instanceof PsiReferenceExpression && ((PsiReferenceExpression)caseExpression).getQualifierExpression() == null && JavaPsiFacade.getInstance((Project)body.getProject()).getConstantEvaluationHelper().computeConstantExpression((PsiElement)caseValue) != null) {
                        this.addInstruction(new PushInstruction(this.getExpressionDfaValue((PsiReferenceExpression)caseExpression), caseExpression));
                        caseValue.accept((PsiElementVisitor)this);
                        this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, caseExpression.getProject()));
                    } else {
                        this.pushUnknown();
                    }
                    this.addInstruction(new ConditionalGotoInstruction(offset, false, (PsiElement)statement));
                    if (enumValues == null || !(caseValue instanceof PsiReferenceExpression)) continue;
                    enumValues.remove(((PsiReferenceExpression)caseValue).resolve());
                }
                catch (IncorrectOperationException e) {
                    LOG.error((Throwable)e);
                }
            }
            if (enumValues == null || !enumValues.isEmpty()) {
                ControlFlow.ControlFlowOffset offset = defaultLabel != null ? this.getStartOffset((PsiElement)defaultLabel) : this.getEndOffset((PsiElement)body);
                this.addInstruction(new GotoInstruction(offset));
            }
            body.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)switchStmt);
    }

    public void visitSynchronizedStatement(PsiSynchronizedStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression lock = statement.getLockExpression();
        if (lock != null) {
            lock.accept((PsiElementVisitor)this);
            this.addInstruction(new FieldReferenceInstruction(lock, "Synchronized value"));
        }
        this.addInstruction(new FlushVariableInstruction(null));
        PsiCodeBlock body = statement.getBody();
        if (body != null) {
            body.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitThrowStatement(PsiThrowStatement statement) {
        this.startElement((PsiElement)statement);
        PsiExpression exception = statement.getException();
        if (exception != null) {
            exception.accept((PsiElementVisitor)this);
            if (this.myCatchStack.isEmpty()) {
                this.addInstruction(new ReturnInstruction(true));
                this.finishElement((PsiElement)statement);
                return;
            }
            this.addConditionalRuntimeThrow();
            this.addInstruction(new DupInstruction());
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getNull(), null));
            this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, statement.getProject()));
            ConditionalGotoInstruction gotoInstruction = new ConditionalGotoInstruction(null, true, null);
            this.addInstruction(gotoInstruction);
            this.addInstruction(new PopInstruction());
            this.initException(this.myNpe);
            this.addThrowCode(false);
            gotoInstruction.setOffset(this.myCurrentFlow.getInstructionCount());
            this.addInstruction(new PushInstruction(this.myExceptionHolder, null));
            this.addInstruction(new SwapInstruction());
            this.addInstruction(new AssignInstruction(null));
            this.addInstruction(new PopInstruction());
            this.addThrowCode(false);
        }
        this.finishElement((PsiElement)statement);
    }

    private void addConditionalRuntimeThrow() {
        if (this.myCatchStack.isEmpty()) {
            return;
        }
        this.pushUnknown();
        ConditionalGotoInstruction ifNoException = this.addInstruction(new ConditionalGotoInstruction(null, false, null));
        this.addInstruction(new EmptyStackInstruction());
        this.addInstruction(new PushInstruction(this.myExceptionHolder, null));
        this.pushUnknown();
        ConditionalGotoInstruction ifError = this.addInstruction(new ConditionalGotoInstruction(null, false, null));
        this.addInstruction(new PushInstruction(this.myRuntimeException, null));
        GotoInstruction ifRuntime = this.addInstruction(new GotoInstruction(null));
        ifError.setOffset(this.myCurrentFlow.getInstructionCount());
        this.addInstruction(new PushInstruction(this.myError, null));
        ifRuntime.setOffset(this.myCurrentFlow.getInstructionCount());
        this.addInstruction(new AssignInstruction(null));
        this.addInstruction(new PopInstruction());
        this.addThrowCode(false);
        ifNoException.setOffset(this.myCurrentFlow.getInstructionCount());
    }

    private void flushVariablesOnControlTransfer(PsiElement stopWhenAncestorOf) {
        PsiElement scope;
        for (int i = this.myElementStack.size() - 1; i >= 0 && !PsiTreeUtil.isAncestor((PsiElement)(scope = (PsiElement)this.myElementStack.get(i)), (PsiElement)stopWhenAncestorOf, (boolean)true); --i) {
            if (!(scope instanceof PsiCodeBlock)) continue;
            this.flushCodeBlockVariables((PsiCodeBlock)scope);
        }
    }

    private void addThrowCode(boolean catchRethrow) {
        if (this.myCatchStack.isEmpty()) {
            this.addInstruction(new ReturnInstruction(true));
            return;
        }
        PsiElement currentElement = (PsiElement)this.myElementStack.peek();
        CatchDescriptor cd = (CatchDescriptor)this.myCatchStack.get(this.myCatchStack.size() - 1);
        if (!cd.isFinally() && PsiTreeUtil.isAncestor((PsiElement)cd.getBlock().getParent(), (PsiElement)currentElement, (boolean)false)) {
            int i;
            for (i = this.myCatchStack.size() - 2; !catchRethrow && i >= 0 && !((CatchDescriptor)this.myCatchStack.get(i)).isFinally() && ((CatchDescriptor)this.myCatchStack.get(i)).getTryStatement() == cd.getTryStatement(); --i) {
            }
            if (i < 0) {
                this.addInstruction(new ReturnInstruction(true));
                return;
            }
            cd = (CatchDescriptor)this.myCatchStack.get(i);
        }
        this.flushVariablesOnControlTransfer((PsiElement)cd.getBlock());
        this.addInstruction(new GotoInstruction(cd.getJumpOffset(this)));
    }

    @Nullable
    private ControlFlow.ControlFlowOffset getFinallyOffset() {
        for (int i = this.myCatchStack.size() - 1; i >= 0; --i) {
            CatchDescriptor cd = (CatchDescriptor)this.myCatchStack.get(i);
            if (!cd.isFinally()) continue;
            return cd.getJumpOffset(this);
        }
        return null;
    }

    public void visitTryStatement(PsiTryStatement statement) {
        ControlFlow.ControlFlowOffset endOffset;
        this.startElement((PsiElement)statement);
        PsiResourceList resourceList = statement.getResourceList();
        PsiCodeBlock tryBlock = statement.getTryBlock();
        PsiCodeBlock finallyBlock = statement.getFinallyBlock();
        if (finallyBlock != null) {
            this.myCatchStack.push((Object)new CatchDescriptor(finallyBlock));
        }
        PsiCatchSection[] sections = statement.getCatchSections();
        for (int i = sections.length - 1; i >= 0; --i) {
            PsiType type;
            PsiCatchSection section = sections[i];
            PsiCodeBlock catchBlock = section.getCatchBlock();
            PsiParameter parameter = section.getParameter();
            if (parameter == null || catchBlock == null || !((type = parameter.getType()) instanceof PsiClassType) && !(type instanceof PsiDisjunctionType)) {
                throw new CannotAnalyzeException();
            }
            this.myCatchStack.push((Object)new CatchDescriptor(parameter, catchBlock));
        }
        ControlFlow.ControlFlowOffset controlFlowOffset = endOffset = finallyBlock == null ? this.getEndOffset((PsiElement)statement) : this.getStartOffset((PsiElement)finallyBlock);
        if (resourceList != null) {
            resourceList.accept((PsiElementVisitor)this);
        }
        if (tryBlock != null) {
            tryBlock.accept((PsiElementVisitor)this);
        }
        this.addInstruction(new GotoInstruction(endOffset));
        for (PsiCatchSection section : sections) {
            section.accept((PsiElementVisitor)this);
            this.addInstruction(new GotoInstruction(endOffset));
            this.myCatchStack.pop();
        }
        if (finallyBlock != null) {
            this.myCatchStack.pop();
            finallyBlock.accept((PsiElementVisitor)this);
            this.addInstruction(new PushInstruction(this.myExceptionHolder, null));
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getNull(), null));
            this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, statement.getProject()));
            this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), false, null));
            this.addThrowCode(false);
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitCatchSection(PsiCatchSection section) {
        this.startElement((PsiElement)section);
        PsiCodeBlock catchBlock = section.getCatchBlock();
        if (catchBlock != null) {
            PsiType declaredType = section.getCatchType();
            List flattened = declaredType instanceof PsiDisjunctionType ? ((PsiDisjunctionType)declaredType).getDisjunctions() : ContainerUtil.createMaybeSingletonList((Object)declaredType);
            for (PsiType catchType : flattened) {
                this.addInstruction(new PushInstruction(this.myExceptionHolder, null));
                this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(catchType, Nullness.UNKNOWN), null));
                this.addInstruction(new BinopInstruction(JavaTokenType.INSTANCEOF_KEYWORD, null, section.getProject()));
                this.addInstruction(new ConditionalGotoInstruction(ControlFlow.deltaOffset(this.getStartOffset((PsiElement)catchBlock), -5), false, null));
            }
            this.addThrowCode(true);
            this.addInstruction(new PushInstruction(this.myFactory.getVarFactory().createVariableValue((PsiVariable)section.getParameter(), false), null));
            this.addInstruction(new PushInstruction(this.myExceptionHolder, null));
            this.addInstruction(new AssignInstruction(null));
            this.addInstruction(new PopInstruction());
            this.addInstruction(new FlushVariableInstruction(this.myExceptionHolder));
            catchBlock.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)section);
    }

    public void visitResourceList(PsiResourceList resourceList) {
        for (PsiResourceVariable variable : resourceList.getResourceVariables()) {
            PsiMethod closer;
            PsiExpression initializer = variable.getInitializer();
            if (initializer != null) {
                this.initializeVariable((PsiVariable)variable, initializer);
            }
            if ((closer = PsiUtil.getResourceCloserMethod((PsiResourceVariable)variable)) == null) continue;
            this.addMethodThrows(closer);
        }
    }

    public void visitWhileStatement(PsiWhileStatement statement) {
        PsiStatement body;
        this.startElement((PsiElement)statement);
        PsiExpression condition = statement.getCondition();
        if (condition != null) {
            condition.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition, (PsiType)PsiType.BOOLEAN);
            this.addInstruction(new ConditionalGotoInstruction(this.getEndOffset((PsiElement)statement), true, (PsiElement)condition));
        }
        if ((body = statement.getBody()) != null) {
            body.accept((PsiElementVisitor)this);
        }
        if (condition != null) {
            this.addInstruction(new GotoInstruction(this.getStartOffset((PsiElement)statement)));
        }
        this.finishElement((PsiElement)statement);
    }

    public void visitExpressionList(PsiExpressionList list) {
        PsiExpression[] expressions;
        this.startElement((PsiElement)list);
        for (PsiExpression expression : expressions = list.getExpressions()) {
            expression.accept((PsiElementVisitor)this);
        }
        this.finishElement((PsiElement)list);
    }

    public void visitExpression(PsiExpression expression) {
        this.startElement((PsiElement)expression);
        DfaValue dfaValue = this.myFactory.createValue(expression);
        this.addInstruction(new PushInstruction(dfaValue, expression));
        this.finishElement((PsiElement)expression);
    }

    public void visitArrayAccessExpression(PsiArrayAccessExpression expression) {
        this.startElement((PsiElement)expression);
        PsiExpression arrayExpression = expression.getArrayExpression();
        arrayExpression.accept((PsiElementVisitor)this);
        this.addInstruction(new FieldReferenceInstruction((PsiExpression)expression, null));
        PsiExpression indexExpression = expression.getIndexExpression();
        if (indexExpression != null) {
            indexExpression.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(indexExpression, (PsiType)PsiType.INT);
            this.addInstruction(new PopInstruction());
        }
        this.pushTypeOrUnknown(arrayExpression);
        this.finishElement((PsiElement)expression);
    }

    public void visitArrayInitializerExpression(PsiArrayInitializerExpression expression) {
        PsiExpression[] initializers;
        this.startElement((PsiElement)expression);
        PsiType type = expression.getType();
        for (PsiExpression initializer : initializers = expression.getInitializers()) {
            initializer.accept((PsiElementVisitor)this);
            if (type instanceof PsiArrayType) {
                this.generateBoxingUnboxingInstructionFor(initializer, ((PsiArrayType)type).getComponentType());
            }
            this.addInstruction(new PopInstruction());
        }
        this.pushUnknown();
        this.finishElement((PsiElement)expression);
    }

    public void visitPolyadicExpression(PsiPolyadicExpression expression) {
        this.startElement((PsiElement)expression);
        DfaValue dfaValue = this.myFactory.createValue((PsiExpression)expression);
        if (dfaValue != null) {
            this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression));
            this.finishElement((PsiElement)expression);
            return;
        }
        IElementType op = expression.getOperationTokenType();
        PsiExpression[] operands = expression.getOperands();
        if (operands.length <= 1) {
            this.pushUnknown();
            this.finishElement((PsiElement)expression);
            return;
        }
        PsiType type = expression.getType();
        if (op == JavaTokenType.ANDAND) {
            this.generateAndExpression(operands, type, true);
        } else if (op == JavaTokenType.OROR) {
            this.generateOrExpression(operands, type, true);
        } else if (op == JavaTokenType.XOR && PsiType.BOOLEAN.equals((Object)type)) {
            this.generateXorExpression((PsiExpression)expression, operands, type, false);
        } else if (op == JavaTokenType.AND && PsiType.BOOLEAN.equals((Object)type)) {
            this.generateAndExpression(operands, type, false);
        } else if (op == JavaTokenType.OR && PsiType.BOOLEAN.equals((Object)type)) {
            this.generateOrExpression(operands, type, false);
        } else {
            this.generateOther(expression, op, operands, type);
        }
        this.finishElement((PsiElement)expression);
    }

    private void generateOther(PsiPolyadicExpression expression, IElementType op, PsiExpression[] operands, PsiType type) {
        op = ControlFlowAnalyzer.substituteBinaryOperation(op, type);
        PsiExpression lExpr = operands[0];
        lExpr.accept((PsiElementVisitor)this);
        PsiType lType = lExpr.getType();
        for (int i = 1; i < operands.length; ++i) {
            PsiExpression rExpr = operands[i];
            PsiType rType = rExpr.getType();
            this.acceptBinaryRightOperand(op, type, lExpr, lType, rExpr, rType);
            this.addInstruction(new BinopInstruction(op, (PsiElement)(expression.isPhysical() ? expression : null), expression.getProject()));
            lExpr = rExpr;
            lType = rType;
        }
    }

    @Nullable
    private static IElementType substituteBinaryOperation(IElementType op, PsiType type) {
        if (!(JavaTokenType.PLUS != op || type != null && type.equalsToText("java.lang.String"))) {
            return null;
        }
        return op;
    }

    private void acceptBinaryRightOperand(@Nullable IElementType op, PsiType type, PsiExpression lExpr, PsiType lType, PsiExpression rExpr, PsiType rType) {
        PsiType castType;
        boolean comparingPrimitiveNumeric;
        boolean comparing = op == JavaTokenType.EQEQ || op == JavaTokenType.NE;
        boolean comparingRef = comparing && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lType) && !TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rType);
        boolean bl = comparingPrimitiveNumeric = comparing && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)lType) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)rType) && TypeConversionUtil.isNumericType((PsiType)lType) && TypeConversionUtil.isNumericType((PsiType)rType);
        Object object = comparingPrimitiveNumeric ? (TypeConversionUtil.isFloatOrDoubleType((PsiType)lType) ? PsiType.DOUBLE : PsiType.LONG) : (castType = type);
        if (!comparingRef) {
            this.generateBoxingUnboxingInstructionFor(lExpr, castType);
        }
        rExpr.accept((PsiElementVisitor)this);
        if (!comparingRef) {
            this.generateBoxingUnboxingInstructionFor(rExpr, castType);
        }
    }

    private void generateBoxingUnboxingInstructionFor(PsiExpression expression, PsiType expectedType) {
        PsiType exprType = expression.getType();
        if (TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType) && TypeConversionUtil.isPrimitiveWrapper((PsiType)exprType)) {
            this.addInstruction(new MethodCallInstruction(expression, MethodCallInstruction.MethodType.UNBOXING, expectedType));
        } else if (TypeConversionUtil.isAssignableFromPrimitiveWrapper((PsiType)expectedType) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)exprType)) {
            this.addConditionalRuntimeThrow();
            this.addInstruction(new MethodCallInstruction(expression, MethodCallInstruction.MethodType.BOXING, expectedType));
        } else if (exprType != expectedType && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)exprType) && TypeConversionUtil.isPrimitiveAndNotNull((PsiType)expectedType) && TypeConversionUtil.isNumericType((PsiType)exprType) && TypeConversionUtil.isNumericType((PsiType)expectedType)) {
            this.addInstruction(new MethodCallInstruction(expression, MethodCallInstruction.MethodType.CAST, expectedType){

                @Override
                public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState stateBefore, InstructionVisitor visitor) {
                    return visitor.visitCast(this, runner, stateBefore);
                }
            });
        }
    }

    private void generateXorExpression(PsiExpression expression, PsiExpression[] operands, PsiType exprType, boolean forAssignment) {
        PsiExpression operand = operands[0];
        operand.accept((PsiElementVisitor)this);
        if (forAssignment) {
            this.addInstruction(new DupInstruction());
        }
        this.generateBoxingUnboxingInstructionFor(operand, exprType);
        for (int i = 1; i < operands.length; ++i) {
            operand = operands[i];
            operand.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand, exprType);
            PsiExpression psiAnchor = expression.isPhysical() ? expression : null;
            this.addInstruction(new BinopInstruction(JavaTokenType.NE, (PsiElement)psiAnchor, expression.getProject()));
        }
    }

    private void generateOrExpression(PsiExpression[] operands, PsiType exprType, boolean shortCircuit) {
        for (int i = 0; i < operands.length; ++i) {
            PsiExpression nextOperand;
            PsiExpression operand = operands[i];
            operand.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand, exprType);
            if (!shortCircuit) {
                if (i <= 0) continue;
                this.combineStackBooleans(false, operand);
                continue;
            }
            PsiExpression psiExpression = nextOperand = i == operands.length - 1 ? null : operands[i + 1];
            if (nextOperand == null) continue;
            this.addInstruction(new ConditionalGotoInstruction(this.getStartOffset((PsiElement)nextOperand), true, (PsiElement)operand));
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
            this.addInstruction(new GotoInstruction(this.getEndOffset((PsiElement)operands[operands.length - 1])));
        }
    }

    private void generateBooleanAssignmentExpression(boolean and, PsiExpression lExpression, PsiExpression rExpression, PsiType exprType) {
        lExpression.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(lExpression, exprType);
        this.addInstruction(new DupInstruction());
        rExpression.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(rExpression, exprType);
        this.addInstruction(new SwapInstruction());
        this.combineStackBooleans(and, lExpression);
    }

    private void combineStackBooleans(boolean and, PsiExpression anchor) {
        ConditionalGotoInstruction toPopAndPushSuccess = new ConditionalGotoInstruction(null, and, (PsiElement)anchor);
        this.addInstruction(toPopAndPushSuccess);
        GotoInstruction overPushSuccess = new GotoInstruction(null);
        this.addInstruction(overPushSuccess);
        PopInstruction pop = new PopInstruction();
        this.addInstruction(pop);
        DfaConstValue constValue = and ? this.myFactory.getConstFactory().getFalse() : this.myFactory.getConstFactory().getTrue();
        PushInstruction pushSuccess = new PushInstruction(constValue, null);
        this.addInstruction(pushSuccess);
        toPopAndPushSuccess.setOffset(pop.getIndex());
        overPushSuccess.setOffset(pushSuccess.getIndex() + 1);
    }

    private void generateAndExpression(PsiExpression[] operands, PsiType exprType, boolean shortCircuit) {
        ArrayList<ConditionalGotoInstruction> branchToFail = new ArrayList<ConditionalGotoInstruction>();
        for (int i = 0; i < operands.length; ++i) {
            PsiExpression operand = operands[i];
            operand.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand, exprType);
            if (!shortCircuit) {
                if (i <= 0) continue;
                this.combineStackBooleans(true, operand);
                continue;
            }
            ConditionalGotoInstruction onFail = new ConditionalGotoInstruction(null, true, (PsiElement)operand);
            branchToFail.add(onFail);
            this.addInstruction(onFail);
        }
        if (!shortCircuit) {
            return;
        }
        this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
        GotoInstruction toSuccess = new GotoInstruction(null);
        this.addInstruction(toSuccess);
        PushInstruction pushFalse = new PushInstruction(this.myFactory.getConstFactory().getFalse(), null);
        this.addInstruction(pushFalse);
        for (ConditionalGotoInstruction toFail : branchToFail) {
            toFail.setOffset(pushFalse.getIndex());
        }
        toSuccess.setOffset(pushFalse.getIndex() + 1);
    }

    public void visitClassObjectAccessExpression(PsiClassObjectAccessExpression expression) {
        PsiElement[] children;
        this.startElement((PsiElement)expression);
        for (PsiElement child : children = expression.getChildren()) {
            child.accept((PsiElementVisitor)this);
        }
        this.pushUnknown();
        this.finishElement((PsiElement)expression);
    }

    public void visitConditionalExpression(PsiConditionalExpression expression) {
        ControlFlow.ControlFlowOffset elseOffset;
        this.startElement((PsiElement)expression);
        PsiExpression condition = expression.getCondition();
        PsiExpression thenExpression = expression.getThenExpression();
        PsiExpression elseExpression = expression.getElseExpression();
        ControlFlow.ControlFlowOffset controlFlowOffset = elseOffset = elseExpression == null ? ControlFlow.deltaOffset(this.getEndOffset((PsiElement)expression), -1) : this.getStartOffset((PsiElement)elseExpression);
        if (thenExpression != null) {
            condition.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(condition, (PsiType)PsiType.BOOLEAN);
            PsiType type = expression.getType();
            this.addInstruction(new ConditionalGotoInstruction(elseOffset, true, (PsiElement)condition));
            thenExpression.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(thenExpression, type);
            this.addInstruction(new GotoInstruction(this.getEndOffset((PsiElement)expression)));
            if (elseExpression != null) {
                elseExpression.accept((PsiElementVisitor)this);
                this.generateBoxingUnboxingInstructionFor(elseExpression, type);
            } else {
                this.pushUnknown();
            }
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression);
    }

    private void pushUnknown() {
        this.addInstruction(new PushInstruction(DfaUnknownValue.getInstance(), null));
    }

    public void visitInstanceOfExpression(PsiInstanceOfExpression expression) {
        this.startElement((PsiElement)expression);
        PsiExpression operand = expression.getOperand();
        PsiTypeElement checkType = expression.getCheckType();
        if (checkType != null) {
            operand.accept((PsiElementVisitor)this);
            PsiType type = checkType.getType();
            if (type instanceof PsiClassType) {
                type = ((PsiClassType)type).rawType();
            }
            this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(type, Nullness.UNKNOWN), null));
            this.addInstruction(new InstanceofInstruction((PsiElement)expression, expression.getProject(), operand, type));
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression);
    }

    private void addMethodThrows(PsiMethod method) {
        if (method != null) {
            PsiClassType[] refs;
            for (PsiClassType ref : refs = method.getThrowsList().getReferencedTypes()) {
                this.pushUnknown();
                ConditionalGotoInstruction cond = new ConditionalGotoInstruction(null, false, null);
                this.addInstruction(cond);
                this.addInstruction(new EmptyStackInstruction());
                this.initException((PsiType)ref);
                this.addThrowCode(false);
                cond.setOffset(this.myCurrentFlow.getInstructionCount());
            }
        }
    }

    private void initException(PsiType ref) {
        this.addInstruction(new PushInstruction(this.myExceptionHolder, null));
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(ref, Nullness.NOT_NULL), null));
        this.addInstruction(new AssignInstruction(null));
        this.addInstruction(new PopInstruction());
    }

    public void visitMethodCallExpression(PsiMethodCallExpression expression) {
        this.startElement((PsiElement)expression);
        if (this.handleContracts(expression, ControlFlowAnalyzer.getCallContracts(expression))) {
            this.finishElement((PsiElement)expression);
            return;
        }
        PsiReferenceExpression methodExpression = expression.getMethodExpression();
        PsiExpression qualifierExpression = methodExpression.getQualifierExpression();
        if (qualifierExpression != null) {
            qualifierExpression.accept((PsiElementVisitor)this);
        } else {
            this.pushUnknown();
        }
        PsiExpression[] expressions = expression.getArgumentList().getExpressions();
        PsiElement method = methodExpression.resolve();
        PsiParameter[] parameters = method instanceof PsiMethod ? ((PsiMethod)method).getParameterList().getParameters() : null;
        boolean isEqualsCall = expressions.length == 1 && method instanceof PsiMethod && "equals".equals(((PsiMethod)method).getName()) && parameters.length == 1 && parameters[0].getType().equalsToText("java.lang.Object") && PsiType.BOOLEAN.equals((Object)((PsiMethod)method).getReturnType());
        for (int i = 0; i < expressions.length; ++i) {
            PsiExpression paramExpr = expressions[i];
            paramExpr.accept((PsiElementVisitor)this);
            if (parameters != null && i < parameters.length) {
                this.generateBoxingUnboxingInstructionFor(paramExpr, parameters[i].getType());
            }
            if (i != 0 || !isEqualsCall) continue;
            this.addInstruction(new SwapInstruction());
            this.addInstruction(new DupInstruction(2, 1));
            this.addInstruction(new PopInstruction());
        }
        this.addConditionalRuntimeThrow();
        this.addInstruction(new MethodCallInstruction((PsiCallExpression)expression, this.createChainedVariableValue((PsiExpression)expression)));
        if (!this.myCatchStack.isEmpty()) {
            this.addMethodThrows(expression.resolveMethod());
        }
        if (isEqualsCall) {
            ConditionalGotoInstruction ifFalse = this.addInstruction(new ConditionalGotoInstruction(null, true, null));
            this.addInstruction(new ApplyNotNullInstruction(expression));
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
            this.addInstruction(new GotoInstruction(this.getEndOffset((PsiElement)expression)));
            ifFalse.setOffset(this.myCurrentFlow.getInstructionCount());
            this.addInstruction(new PopInstruction());
            this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getFalse(), null));
        }
        this.finishElement((PsiElement)expression);
    }

    private boolean handleContracts(PsiMethodCallExpression expression, List<MethodContract> _contracts) {
        if (_contracts.isEmpty()) {
            return false;
        }
        PsiMethod method = expression.resolveMethod();
        if (method == null) {
            return false;
        }
        final int paramCount = method.getParameterList().getParametersCount();
        boolean varArgs = method.isVarArgs();
        PsiExpression[] args = expression.getArgumentList().getExpressions();
        if (varArgs && args.length < paramCount - 1 || !varArgs && args.length != paramCount) {
            return false;
        }
        List contracts = ContainerUtil.findAll(_contracts, (Condition)new Condition<MethodContract>(){

            public boolean value(MethodContract contract) {
                return paramCount == contract.arguments.length;
            }
        });
        if (contracts.isEmpty()) {
            return false;
        }
        for (PsiExpression arg : args) {
            arg.accept((PsiElementVisitor)this);
        }
        if (varArgs) {
            for (int i = 0; i < args.length - paramCount + 1; ++i) {
                this.addInstruction(new PopInstruction());
            }
            this.pushUnknown();
        }
        if (contracts.size() > 1) {
            this.addInstruction(new DupInstruction(args.length, contracts.size() - 1));
        }
        for (int i = 0; i < contracts.size(); ++i) {
            this.handleContract(expression, (MethodContract)contracts.get(i), contracts.size() - 1 - i, paramCount);
        }
        this.pushUnknownReturnValue(expression);
        return true;
    }

    private void handleContract(PsiMethodCallExpression expression, MethodContract contract, int remainingContracts, int paramCount) {
        ControlFlow.ControlFlowOffset exitPoint = this.getEndOffset((PsiElement)expression);
        SmartList gotoContractFalse = new SmartList();
        for (int i = paramCount - 1; i >= 0; --i) {
            MethodContract.ValueConstraint arg = contract.arguments[i];
            if (arg == MethodContract.ValueConstraint.NULL_VALUE || arg == MethodContract.ValueConstraint.NOT_NULL_VALUE) {
                this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getNull(), null));
                this.addInstruction(new BinopInstruction(JavaTokenType.EQEQ, null, expression.getProject()));
            } else if (arg != MethodContract.ValueConstraint.TRUE_VALUE && arg != MethodContract.ValueConstraint.FALSE_VALUE) {
                this.addInstruction(new PopInstruction());
                continue;
            }
            boolean expectingTrueOnStack = arg == MethodContract.ValueConstraint.NULL_VALUE || arg == MethodContract.ValueConstraint.TRUE_VALUE;
            ConditionalGotoInstruction continueCheckingContract = this.addInstruction(new ConditionalGotoInstruction(null, !expectingTrueOnStack, null));
            for (int j = 0; j < i; ++j) {
                this.addInstruction(new PopInstruction());
            }
            gotoContractFalse.add(this.addInstruction(new GotoInstruction(null)));
            continueCheckingContract.setOffset(this.myCurrentFlow.getInstructionCount());
        }
        for (int j = 0; j < remainingContracts * paramCount; ++j) {
            this.addInstruction(new PopInstruction());
        }
        switch (contract.returnValue) {
            case ANY_VALUE: {
                this.pushUnknownReturnValue(expression);
                this.addInstruction(new GotoInstruction(exitPoint));
                break;
            }
            case NULL_VALUE: {
                this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getNull(), null));
                this.addInstruction(new GotoInstruction(exitPoint));
                break;
            }
            case NOT_NULL_VALUE: {
                PsiType type = expression.getType();
                this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(type, Nullness.NOT_NULL), null));
                this.addInstruction(new GotoInstruction(exitPoint));
                break;
            }
            case TRUE_VALUE: {
                this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getTrue(), null));
                this.addInstruction(new GotoInstruction(exitPoint));
                break;
            }
            case FALSE_VALUE: {
                this.addInstruction(new PushInstruction(this.myFactory.getConstFactory().getFalse(), null));
                this.addInstruction(new GotoInstruction(exitPoint));
                break;
            }
            case THROW_EXCEPTION: {
                this.returnCheckingFinally();
            }
        }
        for (GotoInstruction instruction : gotoContractFalse) {
            instruction.setOffset(this.myCurrentFlow.getInstructionCount());
        }
    }

    private void pushUnknownReturnValue(PsiMethodCallExpression expression) {
        PsiMethod method = expression.resolveMethod();
        if (method != null) {
            PsiType type = expression.getType();
            this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(type, DfaPsiUtil.getElementNullability(type, (PsiModifierListOwner)method)), null));
        } else {
            this.pushUnknown();
        }
    }

    private static List<MethodContract> getCallContracts(PsiMethodCallExpression expression) {
        PsiMethod resolved = expression.resolveMethod();
        if (resolved != null) {
            ConditionChecker checker;
            final PsiAnnotation contractAnno = ControlFlowAnalyzer.findContractAnnotation(resolved);
            if (contractAnno != null) {
                return (List)CachedValuesManager.getCachedValue((PsiElement)contractAnno, (CachedValueProvider)new CachedValueProvider<List<MethodContract>>(){

                    @Nullable
                    public CachedValueProvider.Result<List<MethodContract>> compute() {
                        String text = AnnotationUtil.getStringAttributeValue((PsiAnnotation)contractAnno, null);
                        if (text != null) {
                            try {
                                return CachedValueProvider.Result.create(ControlFlowAnalyzer.parseContract(text), (Object[])new Object[]{contractAnno});
                            }
                            catch (Exception exception) {
                                // empty catch block
                            }
                        }
                        return CachedValueProvider.Result.create(Collections.emptyList(), (Object[])new Object[]{contractAnno});
                    }
                });
            }
            String methodName = resolved.getName();
            PsiExpression[] params = expression.getArgumentList().getExpressions();
            PsiClass owner = resolved.getContainingClass();
            if (owner != null) {
                String className = owner.getQualifiedName();
                if ("java.lang.System".equals(className)) {
                    if ("exit".equals(methodName)) {
                        return Collections.singletonList(new MethodContract(ControlFlowAnalyzer.getAnyArgConstraints(params), MethodContract.ValueConstraint.THROW_EXCEPTION));
                    }
                } else if ("junit.framework.Assert".equals(className) || "org.junit.Assert".equals(className) || "junit.framework.TestCase".equals(className) || "org.testng.Assert".equals(className) || "org.testng.AssertJUnit".equals(className)) {
                    boolean testng = className.startsWith("org.testng.");
                    if ("fail".equals(methodName)) {
                        return Collections.singletonList(new MethodContract(ControlFlowAnalyzer.getAnyArgConstraints(params), MethodContract.ValueConstraint.THROW_EXCEPTION));
                    }
                    int checkedParam = testng ? 0 : params.length - 1;
                    MethodContract.ValueConstraint[] constraints = ControlFlowAnalyzer.getAnyArgConstraints(params);
                    if ("assertTrue".equals(methodName)) {
                        constraints[checkedParam] = MethodContract.ValueConstraint.FALSE_VALUE;
                        return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
                    }
                    if ("assertFalse".equals(methodName)) {
                        constraints[checkedParam] = MethodContract.ValueConstraint.TRUE_VALUE;
                        return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
                    }
                    if ("assertNull".equals(methodName)) {
                        constraints[checkedParam] = MethodContract.ValueConstraint.NOT_NULL_VALUE;
                        return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
                    }
                    if ("assertNotNull".equals(methodName)) {
                        constraints[checkedParam] = MethodContract.ValueConstraint.NULL_VALUE;
                        return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
                    }
                    return Collections.emptyList();
                }
            }
            if ((checker = ConditionCheckManager.findConditionChecker(resolved)) != null) {
                MethodContract.ValueConstraint[] constraints = ControlFlowAnalyzer.getAnyArgConstraints(params);
                int checkedParam = checker.getCheckedParameterIndex();
                if (checkedParam >= constraints.length) {
                    return Collections.emptyList();
                }
                ConditionChecker.Type type = checker.getConditionCheckType();
                if (type == ConditionChecker.Type.ASSERT_IS_NULL_METHOD || type == ConditionChecker.Type.ASSERT_IS_NOT_NULL_METHOD) {
                    constraints[checkedParam] = type == ConditionChecker.Type.ASSERT_IS_NOT_NULL_METHOD ? MethodContract.ValueConstraint.NULL_VALUE : MethodContract.ValueConstraint.NOT_NULL_VALUE;
                    return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
                }
                if (type == ConditionChecker.Type.IS_NOT_NULL_METHOD || type == ConditionChecker.Type.IS_NULL_METHOD) {
                    constraints[checkedParam] = MethodContract.ValueConstraint.NULL_VALUE;
                    return Collections.singletonList(new MethodContract(constraints, type == ConditionChecker.Type.IS_NULL_METHOD ? MethodContract.ValueConstraint.TRUE_VALUE : MethodContract.ValueConstraint.FALSE_VALUE));
                }
                constraints[checkedParam] = type == ConditionChecker.Type.ASSERT_FALSE_METHOD ? MethodContract.ValueConstraint.TRUE_VALUE : MethodContract.ValueConstraint.FALSE_VALUE;
                return Collections.singletonList(new MethodContract(constraints, MethodContract.ValueConstraint.THROW_EXCEPTION));
            }
        }
        return Collections.emptyList();
    }

    @Nullable
    public static PsiAnnotation findContractAnnotation(PsiMethod method) {
        return AnnotationUtil.findAnnotation((PsiModifierListOwner)method, (String[])new String[]{ORG_JETBRAINS_ANNOTATIONS_CONTRACT});
    }

    public static List<MethodContract> parseContract(String text) throws ParseException {
        ArrayList result = ContainerUtil.newArrayList();
        for (String clause : StringUtil.replace((String)text, (String)" ", (String)"").split(";")) {
            String arrow = "->";
            int arrowIndex = clause.indexOf(arrow);
            if (arrowIndex < 0) {
                throw new ParseException("A contract clause must be in form arg1, ..., argN -> return-value");
            }
            String[] argStrings = clause.substring(0, arrowIndex).split(",");
            MethodContract.ValueConstraint[] args = new MethodContract.ValueConstraint[argStrings.length];
            for (int i = 0; i < args.length; ++i) {
                args[i] = ControlFlowAnalyzer.parseConstraint(argStrings[i]);
            }
            result.add(new MethodContract(args, ControlFlowAnalyzer.parseConstraint(clause.substring(arrowIndex + arrow.length()))));
        }
        return result;
    }

    private static MethodContract.ValueConstraint parseConstraint(String name) throws ParseException {
        if (StringUtil.isEmpty((String)name)) {
            throw new ParseException("Constraint should not be empty");
        }
        if ("null".equals(name)) {
            return MethodContract.ValueConstraint.NULL_VALUE;
        }
        if ("!null".equals(name)) {
            return MethodContract.ValueConstraint.NOT_NULL_VALUE;
        }
        if ("true".equals(name)) {
            return MethodContract.ValueConstraint.TRUE_VALUE;
        }
        if ("false".equals(name)) {
            return MethodContract.ValueConstraint.FALSE_VALUE;
        }
        if ("fail".equals(name)) {
            return MethodContract.ValueConstraint.THROW_EXCEPTION;
        }
        if ("_".equals(name)) {
            return MethodContract.ValueConstraint.ANY_VALUE;
        }
        throw new ParseException("Constraint should be one of: null, !null, true, false, fail, _. Found: " + name);
    }

    private static MethodContract.ValueConstraint[] getAnyArgConstraints(PsiExpression[] params) {
        MethodContract.ValueConstraint[] args = new MethodContract.ValueConstraint[params.length];
        for (int i = 0; i < args.length; ++i) {
            args[i] = MethodContract.ValueConstraint.ANY_VALUE;
        }
        return args;
    }

    private void pushTypeOrUnknown(PsiExpression expr) {
        PsiType type = expr.getType();
        DfaValue dfaValue = type instanceof PsiClassType ? this.myFactory.createTypeValue(type, Nullness.UNKNOWN) : null;
        this.addInstruction(new PushInstruction(dfaValue, null));
    }

    public void visitNewExpression(PsiNewExpression expression) {
        this.startElement((PsiElement)expression);
        this.pushUnknown();
        if (expression.getType() instanceof PsiArrayType) {
            PsiExpression[] dimensions;
            for (PsiExpression dimension : dimensions = expression.getArrayDimensions()) {
                dimension.accept((PsiElementVisitor)this);
            }
            for (PsiExpression ignored : dimensions) {
                this.addInstruction(new PopInstruction());
            }
            PsiArrayInitializerExpression arrayInitializer = expression.getArrayInitializer();
            if (arrayInitializer != null) {
                for (PsiExpression initializer : arrayInitializer.getInitializers()) {
                    initializer.accept((PsiElementVisitor)this);
                    this.addInstruction(new PopInstruction());
                }
            }
            this.addConditionalRuntimeThrow();
            this.addInstruction(new MethodCallInstruction((PsiCallExpression)expression, null));
        } else {
            PsiExpressionList args = expression.getArgumentList();
            PsiMethod ctr = expression.resolveConstructor();
            if (args != null) {
                PsiExpression[] params = args.getExpressions();
                PsiParameter[] parameters = ctr == null ? null : ctr.getParameterList().getParameters();
                for (int i = 0; i < params.length; ++i) {
                    PsiExpression param = params[i];
                    param.accept((PsiElementVisitor)this);
                    if (parameters == null || i >= parameters.length) continue;
                    this.generateBoxingUnboxingInstructionFor(param, parameters[i].getType());
                }
            }
            this.addConditionalRuntimeThrow();
            this.addInstruction(new MethodCallInstruction((PsiCallExpression)expression, null));
            if (!this.myCatchStack.isEmpty()) {
                this.addMethodThrows(ctr);
            }
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitParenthesizedExpression(PsiParenthesizedExpression expression) {
        this.startElement((PsiElement)expression);
        PsiExpression inner = expression.getExpression();
        if (inner != null) {
            inner.accept((PsiElementVisitor)this);
        } else {
            this.pushUnknown();
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitPostfixExpression(PsiPostfixExpression expression) {
        PsiVariable psiVariable;
        this.startElement((PsiElement)expression);
        PsiExpression operand = expression.getOperand();
        operand.accept((PsiElementVisitor)this);
        this.generateBoxingUnboxingInstructionFor(operand, (PsiType)PsiType.INT);
        this.addInstruction(new PopInstruction());
        this.pushUnknown();
        if (operand instanceof PsiReferenceExpression && (psiVariable = DfaValueFactory.resolveUnqualifiedVariable((PsiReferenceExpression)expression.getOperand())) != null) {
            DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue(psiVariable, false);
            this.addInstruction(new FlushVariableInstruction(dfaVariable));
            if (psiVariable instanceof PsiField) {
                this.addInstruction(new FlushVariableInstruction(null));
            }
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitPrefixExpression(PsiPrefixExpression expression) {
        this.startElement((PsiElement)expression);
        DfaValue dfaValue = this.myFactory.createValue((PsiExpression)expression);
        if (dfaValue == null) {
            PsiExpression operand = expression.getOperand();
            if (operand == null) {
                this.pushUnknown();
            } else {
                operand.accept((PsiElementVisitor)this);
                PsiType type = expression.getType();
                PsiPrimitiveType unboxed = PsiPrimitiveType.getUnboxedType((PsiType)type);
                this.generateBoxingUnboxingInstructionFor(operand, (PsiType)(unboxed == null ? type : unboxed));
                if (expression.getOperationTokenType() == JavaTokenType.EXCL) {
                    this.addInstruction(new NotInstruction());
                } else {
                    PsiVariable psiVariable;
                    this.addInstruction(new PopInstruction());
                    this.pushUnknown();
                    if (operand instanceof PsiReferenceExpression && (psiVariable = DfaValueFactory.resolveUnqualifiedVariable((PsiReferenceExpression)operand)) != null) {
                        DfaVariableValue dfaVariable = this.myFactory.getVarFactory().createVariableValue(psiVariable, false);
                        this.addInstruction(new FlushVariableInstruction(dfaVariable));
                        if (psiVariable instanceof PsiField) {
                            this.addInstruction(new FlushVariableInstruction(null));
                        }
                    }
                }
            }
        } else {
            this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression));
        }
        this.finishElement((PsiElement)expression);
    }

    public void visitReferenceExpression(PsiReferenceExpression expression) {
        this.startElement((PsiElement)expression);
        PsiExpression qualifierExpression = expression.getQualifierExpression();
        if (qualifierExpression != null) {
            qualifierExpression.accept((PsiElementVisitor)this);
            this.addInstruction(expression.resolve() instanceof PsiField ? new FieldReferenceInstruction((PsiExpression)expression, null) : new PopInstruction());
        }
        boolean referenceRead = PsiUtil.isAccessedForReading((PsiExpression)expression) && !PsiUtil.isAccessedForWriting((PsiExpression)expression);
        this.addInstruction(new PushInstruction(this.getExpressionDfaValue(expression), (PsiExpression)expression, referenceRead));
        this.finishElement((PsiElement)expression);
    }

    @Nullable
    private DfaValue getExpressionDfaValue(PsiReferenceExpression expression) {
        PsiElement resolved;
        DfaValue dfaValue = this.myFactory.createReferenceValue(expression);
        if (dfaValue == null && (resolved = expression.resolve()) instanceof PsiField) {
            dfaValue = this.createDfaValueForAnotherInstanceMemberAccess(expression, (PsiField)resolved);
        }
        return dfaValue;
    }

    @NotNull
    private DfaValue createDfaValueForAnotherInstanceMemberAccess(PsiReferenceExpression expression, PsiField field) {
        DfaVariableValue dfaValue = null;
        if (expression.getQualifierExpression() != null) {
            dfaValue = this.createChainedVariableValue((PsiExpression)expression);
        }
        if (dfaValue == null) {
            PsiType type = expression.getType();
            DfaValue dfaValue2 = this.myFactory.createTypeValue(type, DfaPsiUtil.getElementNullability(type, (PsiModifierListOwner)field));
            if (dfaValue2 == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer", "createDfaValueForAnotherInstanceMemberAccess"));
            }
            return dfaValue2;
        }
        DfaVariableValue dfaVariableValue = dfaValue;
        if (dfaVariableValue == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/dataFlow/ControlFlowAnalyzer", "createDfaValueForAnotherInstanceMemberAccess"));
        }
        return dfaVariableValue;
    }

    @Nullable
    private DfaVariableValue createChainedVariableValue(@Nullable PsiExpression expression) {
        DfaVariableValue qualifierValue;
        PsiReferenceExpression refExpr;
        if (expression instanceof PsiParenthesizedExpression) {
            return this.createChainedVariableValue(((PsiParenthesizedExpression)expression).getExpression());
        }
        if (expression instanceof PsiMethodCallExpression) {
            refExpr = ((PsiMethodCallExpression)expression).getMethodExpression();
        } else if (expression instanceof PsiReferenceExpression) {
            refExpr = (PsiReferenceExpression)expression;
        } else {
            return null;
        }
        PsiElement target = refExpr.resolve();
        PsiModifierListOwner var = ControlFlowAnalyzer.getAccessedVariable(target);
        if (var == null) {
            return null;
        }
        if (DfaValueFactory.isEffectivelyUnqualified(refExpr)) {
            return this.myFactory.getVarFactory().createVariableValue(var, refExpr.getType(), false, null);
        }
        if (!(var instanceof PsiField && (var.hasModifierProperty("transient") || var.hasModifierProperty("volatile")) || (qualifierValue = this.createChainedVariableValue(refExpr.getQualifierExpression())) == null)) {
            return this.myFactory.getVarFactory().createVariableValue(var, refExpr.getType(), false, qualifierValue);
        }
        return null;
    }

    @Nullable
    private static PsiModifierListOwner getAccessedVariable(PsiElement target) {
        if (target instanceof PsiVariable) {
            return (PsiVariable)target;
        }
        if (target instanceof PsiMethod && PropertyUtil.isSimplePropertyGetter((PsiMethod)((PsiMethod)target))) {
            return (PsiMethod)target;
        }
        return null;
    }

    public void visitSuperExpression(PsiSuperExpression expression) {
        this.startElement((PsiElement)expression);
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression.getType(), Nullness.NOT_NULL), null));
        this.finishElement((PsiElement)expression);
    }

    public void visitThisExpression(PsiThisExpression expression) {
        this.startElement((PsiElement)expression);
        this.addInstruction(new PushInstruction(this.myFactory.createTypeValue(expression.getType(), Nullness.NOT_NULL), null));
        this.finishElement((PsiElement)expression);
    }

    public void visitLiteralExpression(PsiLiteralExpression expression) {
        this.startElement((PsiElement)expression);
        DfaValue dfaValue = this.myFactory.createLiteralValue(expression);
        this.addInstruction(new PushInstruction(dfaValue, (PsiExpression)expression));
        this.finishElement((PsiElement)expression);
    }

    public void visitTypeCastExpression(PsiTypeCastExpression castExpression) {
        this.startElement((PsiElement)castExpression);
        PsiExpression operand = castExpression.getOperand();
        if (operand != null) {
            operand.accept((PsiElementVisitor)this);
            this.generateBoxingUnboxingInstructionFor(operand, castExpression.getType());
        } else {
            this.pushTypeOrUnknown((PsiExpression)castExpression);
        }
        PsiTypeElement typeElement = castExpression.getCastType();
        if (typeElement != null && operand != null && operand.getType() != null) {
            if (typeElement.getType() instanceof PsiPrimitiveType && UnnecessaryExplicitNumericCastInspection.isPrimitiveNumericCastNecessary(castExpression)) {
                this.addInstruction(new PopInstruction());
                this.pushUnknown();
            } else {
                this.addInstruction(new TypeCastInstruction(castExpression, operand, typeElement.getType()));
            }
        }
        this.finishElement((PsiElement)castExpression);
    }

    public void visitClass(PsiClass aClass) {
    }

    public static class ParseException
    extends Exception {
        private ParseException(String message) {
            super(message);
        }
    }

    private static class CatchDescriptor {
        private final PsiType myType;
        private final PsiParameter myParameter;
        private final PsiCodeBlock myBlock;
        private final boolean myIsFinally;

        public CatchDescriptor(PsiCodeBlock finallyBlock) {
            this.myType = null;
            this.myParameter = null;
            this.myBlock = finallyBlock;
            this.myIsFinally = true;
        }

        public CatchDescriptor(PsiParameter parameter, PsiCodeBlock catchBlock) {
            this.myType = parameter.getType();
            this.myParameter = parameter;
            this.myBlock = catchBlock;
            this.myIsFinally = false;
        }

        public PsiCodeBlock getBlock() {
            return this.myBlock;
        }

        public PsiTryStatement getTryStatement() {
            return (PsiTryStatement)(this.isFinally() ? this.myBlock.getParent() : this.myBlock.getParent().getParent());
        }

        public PsiType getType() {
            return this.myType;
        }

        public boolean isFinally() {
            return this.myIsFinally;
        }

        public ControlFlow.ControlFlowOffset getJumpOffset(ControlFlowAnalyzer analyzer) {
            return analyzer.getStartOffset((PsiElement)(this.isFinally() ? this.myBlock : this.myBlock.getParent()));
        }

        public PsiParameter getParameter() {
            return this.myParameter;
        }
    }

    private static class ApplyNotNullInstruction
    extends Instruction {
        private PsiMethodCallExpression myCall;

        private ApplyNotNullInstruction(PsiMethodCallExpression call) {
            this.myCall = call;
        }

        @Override
        public DfaInstructionState[] accept(DataFlowRunner runner, DfaMemoryState state, InstructionVisitor visitor) {
            DfaValue value = state.pop();
            DfaValueFactory factory = runner.getFactory();
            if (state.applyCondition(factory.getRelationFactory().createRelation(value, factory.getConstFactory().getNull(), JavaTokenType.EQEQ, true))) {
                return this.nextInstruction(runner, state);
            }
            if (visitor instanceof StandardInstructionVisitor) {
                ((StandardInstructionVisitor)visitor).skipConstantConditionReporting((PsiElement)this.myCall);
            }
            return DfaInstructionState.EMPTY_ARRAY;
        }
    }

    private static class CannotAnalyzeException
    extends RuntimeException {
        private CannotAnalyzeException() {
        }
    }
}

