/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.concurrencyAnnotations;

import com.intellij.codeInsight.daemon.GroupNames;
import com.intellij.codeInspection.BaseJavaBatchLocalInspectionTool;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemsHolder;
import com.intellij.codeInspection.concurrencyAnnotations.JCiPUtil;
import com.intellij.psi.JavaElementVisitor;
import com.intellij.psi.PsiAnnotation;
import com.intellij.psi.PsiAnnotationMemberValue;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementVisitor;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMember;
import com.intellij.psi.javadoc.PsiDocTag;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.Nls;
import org.jetbrains.annotations.NotNull;

public class StaticGuardedByInstanceInspection
extends BaseJavaBatchLocalInspectionTool {
    @NotNull
    public String getGroupDisplayName() {
        String string = GroupNames.CONCURRENCY_ANNOTATION_ISSUES;
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/StaticGuardedByInstanceInspection", "getGroupDisplayName"));
        }
        return string;
    }

    @Nls
    @NotNull
    public String getDisplayName() {
        if ("Static member guarded by instance field or this" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/StaticGuardedByInstanceInspection", "getDisplayName"));
        }
        return "Static member guarded by instance field or this";
    }

    @NotNull
    public String getShortName() {
        if ("StaticGuardedByInstance" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/StaticGuardedByInstanceInspection", "getShortName"));
        }
        return "StaticGuardedByInstance";
    }

    @NotNull
    public PsiElementVisitor buildVisitor(@NotNull ProblemsHolder holder, boolean isOnTheFly) {
        if (holder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/concurrencyAnnotations/StaticGuardedByInstanceInspection", "buildVisitor"));
        }
        Visitor visitor = new Visitor(holder);
        if (visitor == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/concurrencyAnnotations/StaticGuardedByInstanceInspection", "buildVisitor"));
        }
        return visitor;
    }

    private static class Visitor
    extends JavaElementVisitor {
        private final ProblemsHolder myHolder;

        public Visitor(ProblemsHolder holder) {
            this.myHolder = holder;
        }

        public void visitAnnotation(PsiAnnotation annotation) {
            PsiClass containingClass;
            super.visitAnnotation(annotation);
            if (!JCiPUtil.isGuardedByAnnotation(annotation)) {
                return;
            }
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiMember.class);
            if (member == null) {
                return;
            }
            if (!member.hasModifierProperty("static")) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(annotation);
            if (guardValue == null) {
                return;
            }
            PsiAnnotationMemberValue guardRef = annotation.findAttributeValue("value");
            if (guardRef == null) {
                return;
            }
            if ("this".equals(guardValue)) {
                this.registerError((PsiElement)guardRef);
            }
            if ((containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)annotation, PsiClass.class)) == null) {
                return;
            }
            PsiField guardField = containingClass.findFieldByName(guardValue, true);
            if (guardField == null) {
                return;
            }
            if (guardField.hasModifierProperty("static")) {
                return;
            }
            this.registerError((PsiElement)guardRef);
        }

        public void visitDocTag(PsiDocTag psiDocTag) {
            PsiClass containingClass;
            super.visitDocTag(psiDocTag);
            if (!JCiPUtil.isGuardedByTag(psiDocTag)) {
                return;
            }
            PsiMember member = (PsiMember)PsiTreeUtil.getParentOfType((PsiElement)psiDocTag, PsiMember.class);
            if (member == null) {
                return;
            }
            if (!member.hasModifierProperty("static")) {
                return;
            }
            String guardValue = JCiPUtil.getGuardValue(psiDocTag);
            if ("this".equals(guardValue)) {
                this.registerError((PsiElement)psiDocTag);
            }
            if ((containingClass = (PsiClass)PsiTreeUtil.getParentOfType((PsiElement)psiDocTag, PsiClass.class)) == null) {
                return;
            }
            PsiField guardField = containingClass.findFieldByName(guardValue, true);
            if (guardField == null) {
                return;
            }
            if (guardField.hasModifierProperty("static")) {
                return;
            }
            this.myHolder.registerProblem((PsiElement)psiDocTag, "Static member guarded by instance \"" + guardValue + "\" #loc", new LocalQuickFix[0]);
        }

        private void registerError(PsiElement element) {
            this.myHolder.registerProblem(element, "Static member guarded by instance #ref #loc", new LocalQuickFix[0]);
        }
    }
}

