/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.canBeFinal;

import com.intellij.codeInsight.daemon.impl.analysis.JavaHighlightUtil;
import com.intellij.codeInspection.reference.RefClass;
import com.intellij.codeInspection.reference.RefClassImpl;
import com.intellij.codeInspection.reference.RefElement;
import com.intellij.codeInspection.reference.RefElementImpl;
import com.intellij.codeInspection.reference.RefField;
import com.intellij.codeInspection.reference.RefFieldImpl;
import com.intellij.codeInspection.reference.RefGraphAnnotatorEx;
import com.intellij.codeInspection.reference.RefManager;
import com.intellij.codeInspection.reference.RefMethod;
import com.intellij.codeInspection.reference.RefMethodImpl;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassInitializer;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiField;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.controlFlow.AnalysisCanceledException;
import com.intellij.psi.controlFlow.ControlFlow;
import com.intellij.psi.controlFlow.ControlFlowFactory;
import com.intellij.psi.controlFlow.ControlFlowUtil;
import com.intellij.psi.controlFlow.LocalsOrMyInstanceFieldsControlFlowPolicy;
import com.intellij.util.containers.ContainerUtil;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class CanBeFinalAnnotator
extends RefGraphAnnotatorEx {
    private final RefManager myManager;
    public static int CAN_BE_FINAL_MASK;

    public CanBeFinalAnnotator(@NotNull RefManager manager) {
        if (manager == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/canBeFinal/CanBeFinalAnnotator", "<init>"));
        }
        this.myManager = manager;
    }

    public void initialize(RefManager refManager) {
        CAN_BE_FINAL_MASK = refManager.getLastUsedMask();
    }

    public void onInitialize(RefElement refElement) {
        RefMethod refMethod;
        PsiModifierListOwner element;
        ((RefElementImpl)refElement).setFlag(true, CAN_BE_FINAL_MASK);
        if (refElement instanceof RefClass) {
            RefClass refClass = (RefClass)refElement;
            PsiClass psiClass = refClass.getElement();
            if (refClass.isEntry()) {
                ((RefClassImpl)refClass).setFlag(false, CAN_BE_FINAL_MASK);
                return;
            }
            if (psiClass != null && !refClass.isSelfInheritor(psiClass)) {
                for (PsiClass psiSuperClass : psiClass.getSupers()) {
                    RefClass refSuperClass;
                    if (!this.myManager.belongsToScope((PsiElement)psiSuperClass) || (refSuperClass = (RefClass)this.myManager.getReference((PsiElement)psiSuperClass)) == null) continue;
                    ((RefClassImpl)refSuperClass).setFlag(false, CAN_BE_FINAL_MASK);
                }
            }
            if (refClass.isAbstract() || refClass.isAnonymous() || refClass.isInterface()) {
                ((RefClassImpl)refClass).setFlag(false, CAN_BE_FINAL_MASK);
            }
        } else if (refElement instanceof RefMethod && (element = (refMethod = (RefMethod)refElement).getElement()) instanceof PsiMethod) {
            PsiMethod psiMethod = (PsiMethod)element;
            if (refMethod.isConstructor() || refMethod.isAbstract() || refMethod.isStatic() || "private".equals(refMethod.getAccessModifier()) || refMethod.getOwnerClass().isAnonymous() || refMethod.getOwnerClass().isInterface()) {
                ((RefMethodImpl)refMethod).setFlag(false, CAN_BE_FINAL_MASK);
            }
            if ("private".equals(refMethod.getAccessModifier()) && refMethod.getOwner() != null && !(refMethod.getOwnerClass().getOwner() instanceof RefElement)) {
                ((RefMethodImpl)refMethod).setFlag(false, CAN_BE_FINAL_MASK);
            }
            for (PsiMethod psiSuperMethod : psiMethod.findSuperMethods()) {
                RefMethod refSuperMethod;
                if (!this.myManager.belongsToScope((PsiElement)psiSuperMethod) || (refSuperMethod = (RefMethod)this.myManager.getReference((PsiElement)psiSuperMethod)) == null) continue;
                ((RefMethodImpl)refSuperMethod).setFlag(false, CAN_BE_FINAL_MASK);
            }
        }
    }

    public void onMarkReferenced(RefElement refWhat, RefElement refFrom, boolean referencedFromClassInitializer, boolean forReading, boolean forWriting) {
        if (!(refWhat instanceof RefField)) {
            return;
        }
        if ((!(refFrom instanceof RefMethod) || !((RefMethod)refFrom).isConstructor() || ((PsiField)refWhat.getElement()).hasInitializer() || ((RefMethod)refFrom).getOwnerClass() != ((RefField)refWhat).getOwnerClass() || ((RefField)refWhat).isStatic()) && !referencedFromClassInitializer && forWriting) {
            ((RefFieldImpl)refWhat).setFlag(false, CAN_BE_FINAL_MASK);
        }
    }

    public void onReferencesBuild(RefElement refElement) {
        RefMethod refMethod;
        if (refElement instanceof RefClass) {
            PsiClass psiClass = (PsiClass)refElement.getElement();
            if (psiClass != null) {
                Collection<PsiVariable> writtenVariables;
                ControlFlow flow;
                PsiCodeBlock body;
                if (refElement.isEntry()) {
                    ((RefClassImpl)refElement).setFlag(false, CAN_BE_FINAL_MASK);
                }
                PsiMethod[] psiMethods = psiClass.getMethods();
                Object[] psiFields = psiClass.getFields();
                HashSet allFields = new HashSet();
                ContainerUtil.addAll(allFields, (Object[])psiFields);
                ArrayList<PsiVariable> instanceInitializerInitializedFields = new ArrayList<PsiVariable>();
                boolean hasInitializers = false;
                for (PsiClassInitializer psiClassInitializer : psiClass.getInitializers()) {
                    body = psiClassInitializer.getBody();
                    hasInitializers = true;
                    try {
                        flow = ControlFlowFactory.getInstance(body.getProject()).getControlFlow((PsiElement)body, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                    }
                    catch (AnalysisCanceledException e) {
                        flow = ControlFlow.EMPTY;
                    }
                    writtenVariables = new ArrayList<PsiVariable>();
                    ControlFlowUtil.getWrittenVariables(flow, 0, flow.getSize(), false, writtenVariables);
                    for (PsiVariable psiVariable : writtenVariables) {
                        if (!allFields.contains(psiVariable)) continue;
                        if (instanceInitializerInitializedFields.contains(psiVariable)) {
                            allFields.remove(psiVariable);
                            instanceInitializerInitializedFields.remove(psiVariable);
                            continue;
                        }
                        instanceInitializerInitializedFields.add(psiVariable);
                    }
                    for (PsiVariable psiVariable : writtenVariables) {
                        if (instanceInitializerInitializedFields.contains(psiVariable)) continue;
                        allFields.remove(psiVariable);
                    }
                }
                for (PsiMethod psiMethod : psiMethods) {
                    if (!psiMethod.isConstructor() || (body = psiMethod.getBody()) == null) continue;
                    hasInitializers = true;
                    try {
                        flow = ControlFlowFactory.getInstance(body.getProject()).getControlFlow((PsiElement)body, LocalsOrMyInstanceFieldsControlFlowPolicy.getInstance(), false);
                    }
                    catch (AnalysisCanceledException e) {
                        flow = ControlFlow.EMPTY;
                    }
                    writtenVariables = ControlFlowUtil.getWrittenVariables(flow, 0, flow.getSize(), false);
                    for (PsiVariable psiVariable : writtenVariables) {
                        if (!instanceInitializerInitializedFields.contains(psiVariable)) continue;
                        allFields.remove(psiVariable);
                        instanceInitializerInitializedFields.remove(psiVariable);
                    }
                    List<PsiMethod> redirectedConstructors = JavaHighlightUtil.getChainedConstructors(psiMethod);
                    if (redirectedConstructors == null || redirectedConstructors.isEmpty()) {
                        List<PsiVariable> ssaVariables = ControlFlowUtil.getSSAVariables(flow);
                        ArrayList<PsiVariable> good = new ArrayList<PsiVariable>(ssaVariables);
                        good.addAll(instanceInitializerInitializedFields);
                        allFields.retainAll(good);
                        continue;
                    }
                    allFields.removeAll(writtenVariables);
                }
                for (Object object : psiFields) {
                    RefFieldImpl refField;
                    if (hasInitializers && allFields.contains(object) || object.getInitializer() != null || (refField = (RefFieldImpl)this.myManager.getReference((PsiElement)object)) == null) continue;
                    refField.setFlag(false, CAN_BE_FINAL_MASK);
                }
            }
        } else if (refElement instanceof RefMethod && (refMethod = (RefMethod)refElement).isEntry()) {
            ((RefMethodImpl)refMethod).setFlag(false, CAN_BE_FINAL_MASK);
        }
    }
}

