/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection.actions;

import com.intellij.analysis.AnalysisScope;
import com.intellij.analysis.PerformAnalysisInBackgroundOption;
import com.intellij.codeHighlighting.HighlightDisplayLevel;
import com.intellij.codeInsight.daemon.HighlightDisplayKey;
import com.intellij.codeInspection.InspectionManager;
import com.intellij.codeInspection.InspectionProfile;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.ex.GlobalInspectionContextImpl;
import com.intellij.codeInspection.ex.InspectionManagerEx;
import com.intellij.codeInspection.ex.InspectionProfileImpl;
import com.intellij.codeInspection.ex.Tools;
import com.intellij.codeInspection.offline.OfflineProblemDescriptor;
import com.intellij.codeInspection.offlineViewer.OfflineInspectionRVContentProvider;
import com.intellij.codeInspection.offlineViewer.OfflineViewParseUtil;
import com.intellij.codeInspection.reference.RefManagerImpl;
import com.intellij.codeInspection.ui.InspectionResultsView;
import com.intellij.icons.AllIcons;
import com.intellij.openapi.actionSystem.AnAction;
import com.intellij.openapi.actionSystem.AnActionEvent;
import com.intellij.openapi.actionSystem.CommonDataKeys;
import com.intellij.openapi.actionSystem.Presentation;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.fileChooser.FileChooser;
import com.intellij.openapi.fileChooser.FileChooserDescriptor;
import com.intellij.openapi.fileEditor.impl.LoadTextUtil;
import com.intellij.openapi.fileTypes.StdFileTypes;
import com.intellij.openapi.progress.PerformInBackgroundOption;
import com.intellij.openapi.progress.ProcessCanceledException;
import com.intellij.openapi.progress.ProgressManager;
import com.intellij.openapi.project.DumbAware;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.ui.Messages;
import com.intellij.openapi.util.Computable;
import com.intellij.openapi.vfs.VirtualFile;
import com.intellij.profile.Profile;
import com.intellij.profile.codeInspection.InspectionProfileManager;
import com.intellij.profile.codeInspection.InspectionProjectProfileManager;
import com.intellij.psi.PsiElement;
import com.intellij.util.PlatformUtils;
import com.intellij.util.ui.tree.TreeUtil;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import javax.swing.Icon;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import org.jetbrains.annotations.NonNls;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ViewOfflineResultsAction
extends AnAction
implements DumbAware {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.actions.ViewOfflineResultsAction");
    @NonNls
    private static final String XML_EXTENSION = "xml";

    public void update(AnActionEvent event) {
        Presentation presentation = event.getPresentation();
        Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        presentation.setEnabled(project != null);
        presentation.setVisible("MainMenu".equals(event.getPlace()) && !PlatformUtils.isCidr());
    }

    public void actionPerformed(AnActionEvent event) {
        final Project project = (Project)event.getData(CommonDataKeys.PROJECT);
        LOG.assertTrue(project != null);
        FileChooserDescriptor descriptor = new FileChooserDescriptor(false, true, false, false, false, false){

            public Icon getIcon(VirtualFile file) {
                if (file.isDirectory() && file.findChild(".descriptions." + StdFileTypes.XML.getDefaultExtension()) != null) {
                    return AllIcons.Nodes.InspectionResults;
                }
                return super.getIcon(file);
            }
        };
        descriptor.setTitle("Select Path");
        descriptor.setDescription("Select directory which contains exported inspections results");
        final VirtualFile virtualFile = FileChooser.chooseFile((FileChooserDescriptor)descriptor, (Project)project, null);
        if (virtualFile == null || !virtualFile.isDirectory()) {
            return;
        }
        final HashMap resMap = new HashMap();
        final String[] profileName = new String[1];
        Runnable process = new Runnable(){

            @Override
            public void run() {
                VirtualFile[] files = virtualFile.getChildren();
                try {
                    for (final VirtualFile inspectionFile : files) {
                        if (inspectionFile.isDirectory()) continue;
                        String shortName = inspectionFile.getNameWithoutExtension();
                        String extension = inspectionFile.getExtension();
                        if (shortName.equals(".descriptions")) {
                            profileName[0] = (String)ApplicationManager.getApplication().runReadAction((Computable)new Computable<String>(){

                                @Nullable
                                public String compute() {
                                    return OfflineViewParseUtil.parseProfileName(((Object)LoadTextUtil.loadText(inspectionFile)).toString());
                                }
                            });
                            continue;
                        }
                        if (!ViewOfflineResultsAction.XML_EXTENSION.equals(extension)) continue;
                        resMap.put(shortName, ApplicationManager.getApplication().runReadAction((Computable)new Computable<Map<String, Set<OfflineProblemDescriptor>>>(){

                            public Map<String, Set<OfflineProblemDescriptor>> compute() {
                                return OfflineViewParseUtil.parse(((Object)LoadTextUtil.loadText(inspectionFile)).toString());
                            }
                        }));
                    }
                }
                catch (Exception e) {
                    SwingUtilities.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            Messages.showInfoMessage((String)e.getMessage(), (String)InspectionsBundle.message((String)"offline.view.parse.exception.title", (Object[])new Object[0]));
                        }
                    });
                    throw new ProcessCanceledException();
                }
            }
        };
        ProgressManager.getInstance().runProcessWithProgressAsynchronously(project, InspectionsBundle.message((String)"parsing.inspections.dump.progress.title", (Object[])new Object[0]), process, new Runnable(){

            @Override
            public void run() {
                SwingUtilities.invokeLater(new Runnable(){

                    @Override
                    public void run() {
                        String name = profileName[0];
                        ViewOfflineResultsAction.showOfflineView(project, name, resMap, InspectionsBundle.message((String)"offline.view.title", (Object[])new Object[0]) + " (" + (name != null ? name : InspectionsBundle.message((String)"offline.view.editor.settings.title", (Object[])new Object[0])) + ")");
                    }
                });
            }
        }, null, (PerformInBackgroundOption)new PerformAnalysisInBackgroundOption(project));
    }

    public static InspectionResultsView showOfflineView(Project project, @Nullable String profileName, final Map<String, Map<String, Set<OfflineProblemDescriptor>>> resMap, String title) {
        Profile profile;
        if (profileName != null) {
            profile = InspectionProjectProfileManager.getInstance(project).getProfile(profileName, false);
            if (profile == null) {
                profile = InspectionProfileManager.getInstance().getProfile(profileName, false);
            }
        } else {
            profile = null;
        }
        Object inspectionProfile = profile != null ? (InspectionProfile)profile : new InspectionProfileImpl(profileName != null ? profileName : "Server Side"){

            @Override
            public boolean isToolEnabled(HighlightDisplayKey key, PsiElement element) {
                return resMap.containsKey(key.toString());
            }

            @Override
            public HighlightDisplayLevel getErrorLevel(@NotNull HighlightDisplayKey key, PsiElement element) {
                if (key == null) {
                    throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/actions/ViewOfflineResultsAction$4", "getErrorLevel"));
                }
                return ((InspectionProfile)InspectionProfileManager.getInstance().getRootProfile()).getErrorLevel(key, element);
            }

            @Override
            public boolean isEditable() {
                return false;
            }

            @Override
            @NotNull
            public String getDisplayName() {
                String string = this.getName();
                if (string == null) {
                    throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/ViewOfflineResultsAction$4", "getDisplayName"));
                }
                return string;
            }
        };
        return ViewOfflineResultsAction.showOfflineView(project, resMap, inspectionProfile, title);
    }

    @NotNull
    public static InspectionResultsView showOfflineView(@NotNull Project project, @NotNull Map<String, Map<String, Set<OfflineProblemDescriptor>>> resMap, InspectionProfile inspectionProfile, String title) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/actions/ViewOfflineResultsAction", "showOfflineView"));
        }
        if (resMap == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/actions/ViewOfflineResultsAction", "showOfflineView"));
        }
        AnalysisScope scope = new AnalysisScope(project);
        InspectionManagerEx managerEx = (InspectionManagerEx)InspectionManager.getInstance((Project)project);
        GlobalInspectionContextImpl context = managerEx.createNewGlobalContext(false);
        context.setExternalProfile(inspectionProfile);
        context.setCurrentScope(scope);
        context.initializeTools(new ArrayList<Tools>(), new ArrayList<Tools>(), new ArrayList<Tools>());
        InspectionResultsView view = new InspectionResultsView(project, inspectionProfile, scope, context, new OfflineInspectionRVContentProvider(resMap, project));
        ((RefManagerImpl)context.getRefManager()).inspectionReadActionStarted();
        view.update();
        TreeUtil.selectFirstNode((JTree)((Object)view.getTree()));
        if (context.getContentManager() != null) {
            context.addView(view, title);
        }
        InspectionResultsView inspectionResultsView = view;
        if (inspectionResultsView == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/actions/ViewOfflineResultsAction", "showOfflineView"));
        }
        return inspectionResultsView;
    }
}

