/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInspection;

import com.intellij.codeInsight.AnnotationUtil;
import com.intellij.codeInsight.FileModificationService;
import com.intellij.codeInsight.intention.AddAnnotationPsiFix;
import com.intellij.codeInspection.InspectionsBundle;
import com.intellij.codeInspection.LocalQuickFix;
import com.intellij.codeInspection.ProblemDescriptor;
import com.intellij.openapi.command.undo.UndoUtil;
import com.intellij.openapi.diagnostic.Logger;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiMethod;
import com.intellij.psi.PsiModifierListOwner;
import com.intellij.psi.PsiNameValuePair;
import com.intellij.psi.search.GlobalSearchScope;
import com.intellij.psi.search.SearchScope;
import com.intellij.psi.search.searches.OverridingMethodsSearch;
import com.intellij.psi.util.ClassUtil;
import com.intellij.psi.util.MethodSignatureBackedByPsiMethod;
import com.intellij.psi.util.PsiTreeUtil;
import com.intellij.util.IncorrectOperationException;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class AnnotateMethodFix
implements LocalQuickFix {
    private static final Logger LOG = Logger.getInstance((String)"#com.intellij.codeInspection.AnnotateMethodFix");
    protected final String myAnnotation;
    private final String[] myAnnotationsToRemove;

    public AnnotateMethodFix(@NotNull String fqn, String ... annotationsToRemove) {
        if (fqn == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/AnnotateMethodFix", "<init>"));
        }
        if (annotationsToRemove == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/AnnotateMethodFix", "<init>"));
        }
        this.myAnnotation = fqn;
        this.myAnnotationsToRemove = annotationsToRemove;
    }

    @NotNull
    public String getName() {
        String string = InspectionsBundle.message((String)"inspection.annotate.method.quickfix.name", (Object[])new Object[]{ClassUtil.extractClassName((String)this.myAnnotation)});
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnnotateMethodFix", "getName"));
        }
        return string;
    }

    public void applyFix(@NotNull Project project, @NotNull ProblemDescriptor descriptor) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/AnnotateMethodFix", "applyFix"));
        }
        if (descriptor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInspection/AnnotateMethodFix", "applyFix"));
        }
        PsiElement psiElement = descriptor.getPsiElement();
        PsiMethod method = (PsiMethod)PsiTreeUtil.getParentOfType((PsiElement)psiElement, PsiMethod.class);
        if (method == null) {
            return;
        }
        ArrayList<PsiMethod> toAnnotate = new ArrayList<PsiMethod>();
        toAnnotate.add(method);
        List superMethodSignatures = method.findSuperMethodSignaturesIncludingStatic(true);
        for (MethodSignatureBackedByPsiMethod superMethodSignature : superMethodSignatures) {
            PsiMethod superMethod = superMethodSignature.getMethod();
            if (AnnotationUtil.isAnnotated((PsiModifierListOwner)superMethod, (String)this.myAnnotation, (boolean)false, (boolean)false) || !superMethod.getManager().isInProject((PsiElement)superMethod)) continue;
            int ret = this.shouldAnnotateBaseMethod(method, superMethod, project);
            if (ret != 0 && ret != 1) {
                return;
            }
            if (ret != 0) continue;
            toAnnotate.add(superMethod);
        }
        if (this.annotateOverriddenMethods()) {
            PsiMethod[] methods;
            for (PsiMethod psiMethod : methods = (PsiMethod[])OverridingMethodsSearch.search((PsiMethod)method, (SearchScope)GlobalSearchScope.allScope((Project)project), (boolean)true).toArray((Object[])PsiMethod.EMPTY_ARRAY)) {
                if (!AnnotationUtil.isAnnotatingApplicable((PsiElement)psiMethod, (String)this.myAnnotation) || AnnotationUtil.isAnnotated((PsiModifierListOwner)psiMethod, (String)this.myAnnotation, (boolean)false, (boolean)false) || !psiMethod.getManager().isInProject((PsiElement)psiMethod)) continue;
                toAnnotate.add(psiMethod);
            }
        }
        FileModificationService.getInstance().preparePsiElementsForWrite(toAnnotate);
        for (PsiMethod psiMethod : toAnnotate) {
            this.annotateMethod(psiMethod);
        }
        UndoUtil.markPsiFileForUndo((PsiFile)method.getContainingFile());
    }

    public int shouldAnnotateBaseMethod(PsiMethod method, PsiMethod superMethod, Project project) {
        return 0;
    }

    protected boolean annotateOverriddenMethods() {
        return false;
    }

    @NotNull
    public String getFamilyName() {
        String string = this.getName();
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInspection/AnnotateMethodFix", "getFamilyName"));
        }
        return string;
    }

    private void annotateMethod(@NotNull PsiMethod method) {
        if (method == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInspection/AnnotateMethodFix", "annotateMethod"));
        }
        try {
            AddAnnotationPsiFix fix = new AddAnnotationPsiFix(this.myAnnotation, (PsiModifierListOwner)method, PsiNameValuePair.EMPTY_ARRAY, this.myAnnotationsToRemove);
            fix.invoke(method.getProject(), method.getContainingFile(), (PsiElement)method, (PsiElement)method);
        }
        catch (IncorrectOperationException e) {
            LOG.error((Throwable)e);
        }
    }
}

