/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.unwrap;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.unwrap.JavaUnwrapper;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPolyadicExpression;
import com.intellij.util.IncorrectOperationException;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaPolyadicExpressionUnwrapper
extends JavaUnwrapper {
    public JavaPolyadicExpressionUnwrapper() {
        super("");
    }

    @Override
    public String getDescription(PsiElement e) {
        return CodeInsightBundle.message((String)"unwrap.with.placeholder", (Object[])new Object[]{e.getText()});
    }

    @Override
    public boolean isApplicableTo(PsiElement e) {
        if (!(e.getParent() instanceof PsiPolyadicExpression)) {
            return false;
        }
        PsiPolyadicExpression expression = (PsiPolyadicExpression)e.getParent();
        PsiExpression operand = JavaPolyadicExpressionUnwrapper.findOperand(e, expression);
        return operand != null;
    }

    @Override
    protected void doUnwrap(PsiElement element, JavaUnwrapper.Context context) throws IncorrectOperationException {
        PsiPolyadicExpression parent = (PsiPolyadicExpression)element.getParent();
        PsiExpression operand = JavaPolyadicExpressionUnwrapper.findOperand(element, parent);
        if (operand == null) {
            return;
        }
        context.extractElement((PsiElement)operand, (PsiElement)parent);
        context.delete((PsiElement)parent);
    }

    @Nullable
    private static PsiExpression findOperand(@NotNull PsiElement e, @NotNull PsiPolyadicExpression expression) {
        if (e == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/unwrap/JavaPolyadicExpressionUnwrapper", "findOperand"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/unwrap/JavaPolyadicExpressionUnwrapper", "findOperand"));
        }
        TextRange elementTextRange = e.getTextRange();
        for (PsiExpression operand : expression.getOperands()) {
            TextRange operandTextRange = operand.getTextRange();
            if (operandTextRange == null || !operandTextRange.contains(elementTextRange)) continue;
            return operand;
        }
        return null;
    }
}

