/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.util;

import com.intellij.codeInsight.generation.surroundWith.JavaExpressionSurrounder;
import com.intellij.codeInsight.generation.surroundWith.JavaWithIfExpressionSurrounder;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiArrayType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiPrimitiveType;
import com.intellij.psi.PsiStatement;
import com.intellij.psi.PsiType;
import com.intellij.psi.util.InheritanceUtil;
import com.intellij.refactoring.util.CommonRefactoringUtil;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class PostfixTemplatesUtils {
    private PostfixTemplatesUtils() {
    }

    public static void showErrorHint(Project project, Editor editor) {
        CommonRefactoringUtil.showErrorHint((Project)project, (Editor)editor, (String)"Can't expand postfix template", (String)"Can't expand postfix template", (String)"");
    }

    public static void createSimpleStatement(@NotNull PsiElement context, @NotNull Editor editor, @NotNull String text) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "createSimpleStatement"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "createSimpleStatement"));
        }
        if (text == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "createSimpleStatement"));
        }
        PostfixTemplatesUtils.createStatement(context, editor, text + " ", "");
    }

    public static void createStatement(@NotNull PsiElement context, @NotNull Editor editor, @NotNull String prefix, @NotNull String suffix) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "createStatement"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "createStatement"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "createStatement"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "createStatement"));
        }
        PostfixTemplatesUtils.createStatement(context, editor, prefix, suffix, 0);
    }

    public static void createStatement(@NotNull PsiElement context, @NotNull Editor editor, @NotNull String prefix, @NotNull String suffix, int offset) {
        PsiElement parent;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "createStatement"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "createStatement"));
        }
        if (prefix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "createStatement"));
        }
        if (suffix == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "createStatement"));
        }
        PsiExpression expr = PostfixTemplate.getTopmostExpression(context);
        PsiElement psiElement = parent = expr != null ? expr.getParent() : null;
        assert (parent instanceof PsiStatement);
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)context.getProject()).getElementFactory();
        PsiStatement statement = factory.createStatementFromText(prefix + expr.getText() + suffix + ";", parent);
        PsiElement replace = parent.replace((PsiElement)statement);
        editor.getCaretModel().moveToOffset(replace.getTextRange().getEndOffset() + offset);
    }

    @Contract(value="null -> false")
    public static boolean isNotPrimitiveTypeExpression(@Nullable PsiExpression expression) {
        return expression != null && !(expression.getType() instanceof PsiPrimitiveType);
    }

    @Contract(value="null -> false")
    public static boolean isIterable(@Nullable PsiType type) {
        return type != null && InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.Iterable");
    }

    @Contract(value="null -> false")
    public static boolean isThrowable(@Nullable PsiType type) {
        return type != null && InheritanceUtil.isInheritor((PsiType)type, (String)"java.lang.Throwable");
    }

    @Contract(value="null -> false")
    public static boolean isArray(@Nullable PsiType type) {
        return type != null && type instanceof PsiArrayType;
    }

    @Contract(value="null -> false")
    public static boolean isBoolean(@Nullable PsiType type) {
        return type != null && (PsiType.BOOLEAN.equals((Object)type) || PsiType.BOOLEAN.equals((Object)PsiPrimitiveType.getUnboxedType((PsiType)type)));
    }

    @Contract(value="null -> false")
    public static boolean isNonVoid(@Nullable PsiType type) {
        return type != null && !PsiType.VOID.equals((Object)type);
    }

    @Contract(value="null -> false")
    public static boolean isNumber(@Nullable PsiType type) {
        if (type == null) {
            return false;
        }
        if (PsiType.INT.equals((Object)type) || PsiType.BYTE.equals((Object)type) || PsiType.LONG.equals((Object)type)) {
            return true;
        }
        PsiPrimitiveType unboxedType = PsiPrimitiveType.getUnboxedType((PsiType)type);
        return PsiType.INT.equals((Object)unboxedType) || PsiType.BYTE.equals((Object)unboxedType) || PsiType.LONG.equals((Object)unboxedType);
    }

    @Nullable
    public static TextRange ifStatement(@NotNull Project project, @NotNull Editor editor, @NotNull PsiExpression expr) {
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "ifStatement"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "ifStatement"));
        }
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "ifStatement"));
        }
        JavaWithIfExpressionSurrounder surrounder = new JavaWithIfExpressionSurrounder();
        PsiElement[] elements = new PsiElement[]{expr};
        if (surrounder.isApplicable(elements)) {
            return surrounder.surroundElements(project, editor, elements);
        }
        PostfixTemplatesUtils.showErrorHint(project, editor);
        return null;
    }

    @Nullable
    public static TextRange apply(@NotNull JavaExpressionSurrounder surrounder, @NotNull Project project, @NotNull Editor editor, @NotNull PsiExpression expr) {
        if (surrounder == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "apply"));
        }
        if (project == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "apply"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "apply"));
        }
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "3", "com/intellij/codeInsight/template/postfix/util/PostfixTemplatesUtils", "apply"));
        }
        PsiElement[] elements = new PsiElement[]{expr};
        if (surrounder.isApplicable(elements)) {
            return surrounder.surroundElements(project, editor, elements);
        }
        PostfixTemplatesUtils.showErrorHint(project, editor);
        return null;
    }
}

