/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.StatementPostfixTemplateBase;
import com.intellij.openapi.application.ApplicationManager;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.pom.java.LanguageLevel;
import com.intellij.psi.PsiClass;
import com.intellij.psi.PsiClassType;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiJavaFile;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class SwitchStatementPostfixTemplate
extends StatementPostfixTemplateBase {
    public SwitchStatementPostfixTemplate() {
        super("switch", "Produces switch over integral/enum/string values", "switch (expr)");
    }

    private static boolean isSwitchCompatibleType(@Nullable PsiType type, @NotNull PsiElement context) {
        PsiClass psiClass;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/SwitchStatementPostfixTemplate", "isSwitchCompatibleType"));
        }
        if (type == null) {
            return false;
        }
        if (PsiType.INT.isAssignableFrom(type)) {
            return true;
        }
        if (type instanceof PsiClassType && (psiClass = ((PsiClassType)type).resolve()) != null && psiClass.isEnum()) {
            return true;
        }
        if (type.equalsToText("java.lang.String")) {
            LanguageLevel level;
            if (ApplicationManager.getApplication().isUnitTestMode()) {
                return true;
            }
            PsiFile containingFile = context.getContainingFile();
            if (containingFile instanceof PsiJavaFile && (level = ((PsiJavaFile)containingFile).getLanguageLevel()).isAtLeast(LanguageLevel.JDK_1_7)) {
                return true;
            }
        }
        return false;
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/SwitchStatementPostfixTemplate", "isApplicable"));
        }
        if (copyDocument == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/SwitchStatementPostfixTemplate", "isApplicable"));
        }
        PsiExpression expr = SwitchStatementPostfixTemplate.getTopmostExpression(context);
        return expr != null && SwitchStatementPostfixTemplate.isSwitchCompatibleType(expr.getType(), context);
    }

    @Override
    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/SwitchStatementPostfixTemplate", "expand"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/SwitchStatementPostfixTemplate", "expand"));
        }
        this.surroundWith(context, editor, "switch");
    }
}

