/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.CodeInsightUtilCore;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.TextRange;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiCodeBlock;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.codeStyle.CodeStyleManager;
import com.intellij.psi.util.PsiTreeUtil;

public abstract class StatementPostfixTemplateBase
extends PostfixTemplate {
    protected StatementPostfixTemplateBase(String name, String description, String example) {
        super(name, description, example);
    }

    protected void surroundWith(PsiElement context, Editor editor, String text) {
        PsiElement parent;
        PsiExpression expr = StatementPostfixTemplateBase.getTopmostExpression(context);
        PsiElement psiElement = parent = expr != null ? expr.getParent() : null;
        if (!(parent instanceof PsiExpressionStatement)) {
            return;
        }
        Project project = context.getProject();
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)project).getElementFactory();
        CodeStyleManager codeStyleManager = CodeStyleManager.getInstance((Project)project);
        PsiElement statement = codeStyleManager.reformat((PsiElement)factory.createStatementFromText(text + " (" + expr.getText() + ") {\nst;\n}", context));
        statement = parent.replace(statement);
        PsiCodeBlock block = (PsiCodeBlock)CodeInsightUtilCore.forcePsiPostprocessAndRestoreElement(PsiTreeUtil.getChildOfType((PsiElement)statement, PsiCodeBlock.class));
        TextRange range = block.getStatements()[0].getTextRange();
        editor.getDocument().deleteString(range.getStartOffset(), range.getEndOffset());
        editor.getCaretModel().moveToOffset(range.getStartOffset());
    }
}

