/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.NonVoidPostfixTemplate;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.project.Project;
import com.intellij.psi.JavaPsiFacade;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiElementFactory;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiExpressionStatement;
import com.intellij.psi.PsiReturnStatement;
import org.jetbrains.annotations.NotNull;

public class ReturnStatementPostfixTemplate
extends NonVoidPostfixTemplate {
    public ReturnStatementPostfixTemplate() {
        super("return", "Returns value from containing method", "return expr;");
    }

    @Override
    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        PsiElement parent;
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ReturnStatementPostfixTemplate", "expand"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/ReturnStatementPostfixTemplate", "expand"));
        }
        PsiExpression expr = ReturnStatementPostfixTemplate.getTopmostExpression(context);
        PsiElement psiElement = parent = expr != null ? expr.getParent() : null;
        if (!(parent instanceof PsiExpressionStatement)) {
            return;
        }
        PsiElementFactory factory = JavaPsiFacade.getInstance((Project)expr.getProject()).getElementFactory();
        PsiReturnStatement returnStatement = (PsiReturnStatement)factory.createStatementFromText("return " + expr.getText() + ";", parent);
        parent.replace((PsiElement)returnStatement);
    }
}

