/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.CodeInsightServicesUtil;
import com.intellij.codeInsight.template.postfix.templates.ExpressionPostfixTemplateWithChooser;
import com.intellij.codeInsight.template.postfix.util.Aliases;
import com.intellij.codeInsight.template.postfix.util.PostfixTemplatesUtils;
import com.intellij.openapi.editor.Editor;
import com.intellij.openapi.util.Condition;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import org.jetbrains.annotations.NotNull;

@Aliases(value={"!"})
public class NotExpressionPostfixTemplate
extends ExpressionPostfixTemplateWithChooser {
    private static final Condition<PsiExpression> BOOLEAN_TYPE_CONDITION = new Condition<PsiExpression>(){

        public boolean value(PsiExpression expression) {
            return PostfixTemplatesUtils.isBoolean(expression.getType());
        }
    };

    public NotExpressionPostfixTemplate() {
        super("not", "Negates boolean expression", "!expr");
    }

    @Override
    protected void doIt(@NotNull Editor editor, @NotNull PsiExpression expression) {
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/NotExpressionPostfixTemplate", "doIt"));
        }
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/NotExpressionPostfixTemplate", "doIt"));
        }
        expression.replace((PsiElement)CodeInsightServicesUtil.invertCondition((PsiExpression)expression));
    }

    @Override
    @NotNull
    protected Condition<PsiExpression> getTypeCondition() {
        Condition<PsiExpression> condition = BOOLEAN_TYPE_CONDITION;
        if (condition == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/NotExpressionPostfixTemplate", "getTypeCondition"));
        }
        return condition;
    }
}

