/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.PostfixTemplatesUtils;
import com.intellij.openapi.editor.Document;
import com.intellij.openapi.editor.Editor;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import org.jetbrains.annotations.NotNull;

public class FormatPostfixTemplate
extends PostfixTemplate {
    public FormatPostfixTemplate() {
        super("format", "Creates String.format call", "String.format(expr);");
    }

    @Override
    public void expand(@NotNull PsiElement context, @NotNull Editor editor) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/FormatPostfixTemplate", "expand"));
        }
        if (editor == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/FormatPostfixTemplate", "expand"));
        }
        PostfixTemplatesUtils.createStatement(context, editor, "String.format(", ", )", -2);
    }

    @Override
    public boolean isApplicable(@NotNull PsiElement context, @NotNull Document copyDocument, int newOffset) {
        if (context == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/FormatPostfixTemplate", "isApplicable"));
        }
        if (copyDocument == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/postfix/templates/FormatPostfixTemplate", "isApplicable"));
        }
        PsiExpression expr = FormatPostfixTemplate.getTopmostExpression(context);
        PsiType type = expr != null ? expr.getType() : null;
        return expr != null && type != null && "java.lang.String".equals(type.getCanonicalText());
    }
}

