/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.templates;

import com.intellij.codeInsight.template.postfix.templates.ForIndexedPostfixTemplate;
import com.intellij.codeInsight.template.postfix.util.PostfixTemplatesUtils;
import com.intellij.openapi.util.Pair;
import com.intellij.psi.PsiExpression;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class ForDescendingPostfixTemplate
extends ForIndexedPostfixTemplate {
    public ForDescendingPostfixTemplate() {
        super("forr", "Iterates with index in reverse order", "for (int i = expr.length-1; i >= 0; i--)");
    }

    @Override
    @NotNull
    protected String getOperator() {
        if ("--" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/ForDescendingPostfixTemplate", "getOperator"));
        }
        return "--";
    }

    @Override
    @NotNull
    protected String getComparativeSign(@NotNull PsiExpression expr) {
        if (expr == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ForDescendingPostfixTemplate", "getComparativeSign"));
        }
        String string = PostfixTemplatesUtils.isNumber(expr.getType()) ? ">" : ">=";
        if (string == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/postfix/templates/ForDescendingPostfixTemplate", "getComparativeSign"));
        }
        return string;
    }

    @Override
    @Nullable
    protected Pair<String, String> calculateBounds(@NotNull PsiExpression expression) {
        if (expression == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/templates/ForDescendingPostfixTemplate", "calculateBounds"));
        }
        String bound = ForDescendingPostfixTemplate.getExpressionBound(expression);
        if (bound == null) {
            return null;
        }
        return PostfixTemplatesUtils.isNumber(expression.getType()) ? Pair.create((Object)bound, (Object)"0") : Pair.create((Object)(bound + " - 1"), (Object)"0");
    }
}

