/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.postfix.completion;

import com.intellij.codeInsight.completion.CompletionParameters;
import com.intellij.codeInsight.completion.CompletionProvider;
import com.intellij.codeInsight.completion.CompletionResultSet;
import com.intellij.codeInsight.lookup.LookupElement;
import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.impl.LiveTemplateCompletionContributor;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateCompletionContributor;
import com.intellij.codeInsight.template.postfix.completion.PostfixTemplateLookupElement;
import com.intellij.codeInsight.template.postfix.settings.PostfixTemplatesSettings;
import com.intellij.codeInsight.template.postfix.templates.PostfixLiveTemplate;
import com.intellij.codeInsight.template.postfix.templates.PostfixTemplate;
import com.intellij.patterns.ElementPattern;
import com.intellij.patterns.StandardPatterns;
import com.intellij.psi.PsiFile;
import com.intellij.util.ProcessingContext;
import org.jetbrains.annotations.NotNull;

class PostfixTemplatesCompletionProvider
extends CompletionProvider<CompletionParameters> {
    PostfixTemplatesCompletionProvider() {
    }

    protected void addCompletions(@NotNull CompletionParameters parameters, ProcessingContext context, @NotNull CompletionResultSet result) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplatesCompletionProvider", "addCompletions"));
        }
        if (result == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "2", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplatesCompletionProvider", "addCompletions"));
        }
        if (!PostfixTemplatesCompletionProvider.isCompletionEnabled(parameters) || LiveTemplateCompletionContributor.shouldShowAllTemplates() || parameters.getEditor().getCaretModel().getCaretCount() != 1) {
            return;
        }
        PostfixLiveTemplate postfixLiveTemplate = PostfixTemplateCompletionContributor.getPostfixLiveTemplate(parameters.getOriginalFile(), parameters.getEditor());
        if (postfixLiveTemplate != null) {
            CharSequence documentContent;
            String possibleKey;
            PostfixTemplate template;
            PsiFile file = parameters.getPosition().getContainingFile();
            CustomTemplateCallback callback = new CustomTemplateCallback(parameters.getEditor(), file, false);
            String computedKey = postfixLiveTemplate.computeTemplateKey(callback);
            if (computedKey != null && (template = postfixLiveTemplate.getTemplateByKey(computedKey)) != null) {
                result = result.withPrefixMatcher(computedKey);
                result.addElement((LookupElement)new PostfixTemplateLookupElement(postfixLiveTemplate, template, computedKey, true));
            }
            if ((possibleKey = postfixLiveTemplate.computeTemplateKeyWithoutContextChecking(documentContent = parameters.getEditor().getDocument().getCharsSequence(), parameters.getOffset())) != null) {
                result = result.withPrefixMatcher(possibleKey);
                result.restartCompletionOnPrefixChange((ElementPattern)StandardPatterns.string().oneOf(postfixLiveTemplate.getAllTemplateKeys()));
            }
        }
    }

    private static boolean isCompletionEnabled(@NotNull CompletionParameters parameters) {
        if (parameters == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/postfix/completion/PostfixTemplatesCompletionProvider", "isCompletionEnabled"));
        }
        if (!parameters.isAutoPopup()) {
            return false;
        }
        PostfixTemplatesSettings settings = PostfixTemplatesSettings.getInstance();
        return settings != null && settings.isPostfixTemplatesEnabled() && settings.isTemplatesCompletionEnabled();
    }
}

