/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.JavaCodeContextType;
import com.intellij.codeInsight.template.Macro;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TemplateContextType;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroUtil;
import com.intellij.openapi.project.Project;
import com.intellij.psi.PsiDeclarationStatement;
import com.intellij.psi.PsiDocumentManager;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiFile;
import com.intellij.psi.PsiIdentifier;
import com.intellij.psi.PsiLocalVariable;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.util.PsiTreeUtil;
import org.jetbrains.annotations.NotNull;

public class SuggestIndexNameMacro
extends Macro {
    public String getName() {
        return "suggestIndexName";
    }

    public String getPresentableName() {
        return CodeInsightBundle.message((String)"macro.suggest.index.name", (Object[])new Object[0]);
    }

    @NotNull
    public String getDefaultValue() {
        if ("a" == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/macro/SuggestIndexNameMacro", "getDefaultValue"));
        }
        return "a";
    }

    public Result calculateResult(@NotNull Expression[] params, ExpressionContext context) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/macro/SuggestIndexNameMacro", "calculateResult"));
        }
        if (params.length != 0) {
            return null;
        }
        Project project = context.getProject();
        int offset = context.getStartOffset();
        PsiFile file = PsiDocumentManager.getInstance((Project)project).getPsiFile(context.getEditor().getDocument());
        PsiElement place = file.findElementAt(offset);
        PsiVariable[] vars = MacroUtil.getVariablesVisibleAt(place, "");
        block0: for (char letter = 'i'; letter <= 'z'; letter = (char)(letter + '\u0001')) {
            for (PsiVariable var : vars) {
                String name;
                PsiElement parent;
                PsiIdentifier identifier = var.getNameIdentifier();
                if (identifier != null && !place.equals(identifier) && (!(var instanceof PsiLocalVariable) || !((parent = var.getParent()) instanceof PsiDeclarationStatement) || !PsiTreeUtil.isAncestor((PsiElement)parent, (PsiElement)place, (boolean)false) || var.getTextRange().getStartOffset() <= place.getTextRange().getStartOffset()) && (name = identifier.getText()).length() == 1 && name.charAt(0) == letter) continue block0;
            }
            return new TextResult("" + letter);
        }
        return null;
    }

    public boolean isAcceptableInContext(TemplateContextType context) {
        return context instanceof JavaCodeContextType;
    }
}

