/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.macro;

import com.google.common.annotations.VisibleForTesting;
import com.intellij.codeInsight.CodeInsightBundle;
import com.intellij.codeInsight.template.Expression;
import com.intellij.codeInsight.template.ExpressionContext;
import com.intellij.codeInsight.template.Result;
import com.intellij.codeInsight.template.TextResult;
import com.intellij.codeInsight.template.macro.MacroBase;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.codeStyle.NameUtil;
import org.jetbrains.annotations.NotNull;

public class CapitalizeAndUnderscoreMacro
extends MacroBase {
    public CapitalizeAndUnderscoreMacro() {
        super("capitalizeAndUnderscore", CodeInsightBundle.message((String)"macro.capitalizeAndUnderscore.string", (Object[])new Object[0]));
    }

    protected CapitalizeAndUnderscoreMacro(String name, String description) {
        super(name, description);
    }

    @Override
    protected Result calculateResult(@NotNull Expression[] params, ExpressionContext context, boolean quick) {
        if (params == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/macro/CapitalizeAndUnderscoreMacro", "calculateResult"));
        }
        String text = CapitalizeAndUnderscoreMacro.getTextResult(params, context, true);
        if (StringUtil.isNotEmpty((String)text)) {
            return new TextResult(this.convertString(text));
        }
        return null;
    }

    @VisibleForTesting
    public String convertString(String text) {
        String[] words = NameUtil.nameToWords((String)text);
        boolean insertUnderscore = false;
        StringBuilder buf = new StringBuilder();
        for (String word : words) {
            if (!Character.isLetterOrDigit(word.charAt(0))) {
                buf.append("_");
                insertUnderscore = false;
                continue;
            }
            if (insertUnderscore) {
                buf.append("_");
            } else {
                insertUnderscore = true;
            }
            buf.append(this.convertCase(word));
        }
        return buf.toString();
    }

    protected String convertCase(String word) {
        return StringUtil.toUpperCase((String)word);
    }
}

