/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.impl;

import com.intellij.codeInsight.template.impl.LiveTemplateLookupElementImpl;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import com.intellij.codeInsight.template.impl.TemplateSettings;
import com.intellij.lang.documentation.AbstractDocumentationProvider;
import com.intellij.navigation.ItemPresentation;
import com.intellij.openapi.util.text.StringUtil;
import com.intellij.psi.PsiElement;
import com.intellij.psi.PsiManager;
import com.intellij.psi.impl.FakePsiElement;
import com.intellij.psi.impl.source.DummyHolder;
import com.intellij.psi.impl.source.DummyHolderFactory;
import javax.swing.Icon;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class LiveTemplateDocumentationProvider
extends AbstractDocumentationProvider {
    public PsiElement getDocumentationElementForLookupItem(PsiManager psiManager, Object object, PsiElement element) {
        if (object instanceof LiveTemplateLookupElementImpl) {
            TemplateImpl template = ((LiveTemplateLookupElementImpl)((Object)object)).getTemplate();
            TemplateImpl templateFromSettings = TemplateSettings.getInstance().getTemplate(template.getKey(), template.getGroupName());
            if (templateFromSettings != null) {
                return new LiveTemplateElement(templateFromSettings, psiManager);
            }
        }
        return null;
    }

    public String generateDoc(PsiElement element, @Nullable PsiElement originalElement) {
        if (!(element instanceof LiveTemplateElement)) {
            return null;
        }
        TemplateImpl template = ((LiveTemplateElement)element).getTemplate();
        StringBuilder doc = new StringBuilder("<h2>").append(template.getKey()).append("</h2>");
        String description = template.getDescription();
        if (StringUtil.isNotEmpty((String)description)) {
            doc.append("<pre>").append(StringUtil.escapeXml((String)description)).append("</pre><h2>template text</h2>");
        }
        return doc.append("<pre>").append(StringUtil.escapeXml((String)template.getString())).append("</pre>").toString();
    }

    private static class LiveTemplateElement
    extends FakePsiElement {
        @NotNull
        private final TemplateImpl myTemplate;
        @NotNull
        private final PsiManager myPsiManager;
        @NotNull
        private DummyHolder myDummyHolder;

        public LiveTemplateElement(@NotNull TemplateImpl template, @NotNull PsiManager psiManager) {
            if (template == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/impl/LiveTemplateDocumentationProvider$LiveTemplateElement", "<init>"));
            }
            if (psiManager == null) {
                throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "1", "com/intellij/codeInsight/template/impl/LiveTemplateDocumentationProvider$LiveTemplateElement", "<init>"));
            }
            this.myTemplate = template;
            this.myPsiManager = psiManager;
            this.myDummyHolder = DummyHolderFactory.createHolder(this.myPsiManager, null);
        }

        @NotNull
        public TemplateImpl getTemplate() {
            TemplateImpl templateImpl = this.myTemplate;
            if (templateImpl == null) {
                throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/impl/LiveTemplateDocumentationProvider$LiveTemplateElement", "getTemplate"));
            }
            return templateImpl;
        }

        public PsiElement getParent() {
            return this.myDummyHolder;
        }

        @Override
        public ItemPresentation getPresentation() {
            return new ItemPresentation(){

                @Nullable
                public String getPresentableText() {
                    return LiveTemplateElement.this.myTemplate.getKey();
                }

                @Nullable
                public String getLocationString() {
                    return null;
                }

                @Nullable
                public Icon getIcon(boolean unused) {
                    return null;
                }
            };
        }

        @Override
        public PsiManager getManager() {
            return this.myPsiManager;
        }
    }
}

