/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.codeInsight.template.emmet.nodes;

import com.intellij.codeInsight.template.CustomTemplateCallback;
import com.intellij.codeInsight.template.emmet.ZenCodingUtil;
import com.intellij.codeInsight.template.emmet.nodes.GenerationNode;
import com.intellij.codeInsight.template.emmet.nodes.ZenCodingNode;
import com.intellij.codeInsight.template.emmet.tokens.TemplateToken;
import com.intellij.codeInsight.template.emmet.tokens.TextToken;
import com.intellij.codeInsight.template.impl.TemplateImpl;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.NotNull;

public class TextNode
extends ZenCodingNode {
    private final String myText;

    public TextNode(@NotNull TextToken textToken) {
        if (textToken == null) {
            throw new IllegalArgumentException(String.format("Argument %s for @NotNull parameter of %s.%s must not be null", "0", "com/intellij/codeInsight/template/emmet/nodes/TextNode", "<init>"));
        }
        String text = textToken.getText();
        this.myText = text.substring(1, text.length() - 1);
    }

    public String getText() {
        return this.myText;
    }

    @Override
    @NotNull
    public List<GenerationNode> expand(int numberInIteration, int totalIterations, String surroundedText, CustomTemplateCallback callback, boolean insertSurroundedTextAtTheEnd, GenerationNode parent) {
        TemplateToken templateToken = new TemplateToken("");
        boolean containsSurroundedTextMarker = ZenCodingUtil.containsSurroundedTextMarker(this.myText);
        String text = ZenCodingUtil.replaceMarkers(this.myText.replace("${nl}", "\n"), numberInIteration, totalIterations, surroundedText);
        TemplateImpl template = new TemplateImpl("", text, "");
        templateToken.setTemplate(template, callback);
        GenerationNode node = new GenerationNode(templateToken, numberInIteration, totalIterations, containsSurroundedTextMarker ? null : surroundedText, insertSurroundedTextAtTheEnd, parent);
        List<GenerationNode> list = Collections.singletonList(node);
        if (list == null) {
            throw new IllegalStateException(String.format("@NotNull method %s.%s must not return null", "com/intellij/codeInsight/template/emmet/nodes/TextNode", "expand"));
        }
        return list;
    }

    public String toString() {
        return "Text(" + this.myText + ")";
    }
}

